/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.actions;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.InstancesDistribution;
import com.amazonaws.services.autoscaling.model.LaunchTemplate;
import com.amazonaws.services.autoscaling.model.LaunchTemplateOverrides;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.MixedInstancesPolicy;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateVersion;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ModifyServerGroupLaunchTemplateDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.ModifyServerGroupLaunchTemplateAtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.services.LaunchTemplateService;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.event.EventMetadata;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaAction;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdateAutoScalingGroup
implements SagaAction<UpdateAutoScalingGroupCommand> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateAutoScalingGroup.class);
    private final RegionScopedProviderFactory regionScopedProviderFactory;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;

    public UpdateAutoScalingGroup(RegionScopedProviderFactory regionScopedProviderFactory, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        this.regionScopedProviderFactory = regionScopedProviderFactory;
        this.credentialsRepository = credentialsRepository;
    }

    @NotNull
    public SagaAction.Result apply(@NotNull UpdateAutoScalingGroupCommand command, @NotNull Saga saga) {
        ModifyServerGroupLaunchTemplateDescription description = command.description;
        NetflixAmazonCredentials credentials = (NetflixAmazonCredentials)this.credentialsRepository.getOne(description.getAccount());
        RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider = this.regionScopedProviderFactory.forRegion(credentials, description.getRegion());
        saga.log("[SAGA_ACTION] Updating EC2 Auto Scaling Group " + description.getAsgName());
        UpdateAutoScalingGroupRequest updateReq = new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(description.getAsgName());
        AutoScalingGroup autoScalingGroup = this.getAutoScalingGroup(description.getAsgName(), regionScopedProvider);
        boolean isAsgBackedByMip = autoScalingGroup.getMixedInstancesPolicy() != null;
        String ltId = command.launchTemplateVersion.getLaunchTemplateId();
        String ltVersion = String.valueOf(command.launchTemplateVersion.getVersionNumber());
        if (isAsgBackedByMip || command.isReqToUpgradeAsgToMixedInstancesPolicy.booleanValue()) {
            MixedInstancesPolicy mip = new MixedInstancesPolicy().withLaunchTemplate(new LaunchTemplate().withLaunchTemplateSpecification(new LaunchTemplateSpecification().withLaunchTemplateId(ltId).withVersion(ltVersion)).withOverrides(command.launchTemplateOverrides)).withInstancesDistribution(new InstancesDistribution().withOnDemandAllocationStrategy(description.getOnDemandAllocationStrategy()).withOnDemandBaseCapacity(description.getOnDemandBaseCapacity()).withOnDemandPercentageAboveBaseCapacity(description.getOnDemandPercentageAboveBaseCapacity()).withSpotAllocationStrategy(description.getSpotAllocationStrategy()).withSpotInstancePools(description.getSpotInstancePools()).withSpotMaxPrice(description.getSpotPrice()));
            updateReq.withMixedInstancesPolicy(mip);
        } else {
            updateReq.withLaunchTemplate(new LaunchTemplateSpecification().withLaunchTemplateId(ltId).withVersion(ltVersion));
        }
        try {
            regionScopedProvider.getAutoScaling().updateAutoScalingGroup(updateReq);
        }
        catch (Exception e) {
            StringBuilder exceptionMsg = new StringBuilder(String.format("Failed to update server group %s.", description.getAsgName()));
            if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                exceptionMsg.append(String.format("Error: %s\n", e.getMessage()));
            }
            try {
                if (command.getNewLaunchTemplateVersionNumber() != null) {
                    saga.log("[SAGA_ACTION] Cleaning up to keep the operation atomic.");
                    this.cleanUpOnFailure(regionScopedProvider.getLaunchTemplateService(), command.getLaunchTemplateVersion().getLaunchTemplateId(), command.getNewLaunchTemplateVersionNumber());
                }
            }
            catch (Exception ex) {
                exceptionMsg.append("Failed to clean up launch template version! Error: " + ex.getMessage());
            }
            throw new ModifyServerGroupLaunchTemplateAtomicOperation.LaunchTemplateException(exceptionMsg.toString(), e);
        }
        return new SagaAction.Result();
    }

    private AutoScalingGroup getAutoScalingGroup(String autoScalingGroupName, RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider) {
        try {
            return regionScopedProvider.getAsgService().getAutoScalingGroup(autoScalingGroupName);
        }
        catch (Exception e) {
            throw new ModifyServerGroupLaunchTemplateAtomicOperation.LaunchTemplateException(String.format("Failed to get server group %s.", autoScalingGroupName), e);
        }
    }

    private void cleanUpOnFailure(LaunchTemplateService ltService, String launchTemplateId, Long ltVersionToDelete) {
        ltService.deleteLaunchTemplateVersion(launchTemplateId, ltVersionToDelete);
    }

    @JsonDeserialize(builder=UpdateAutoScalingGroupCommandBuilder.class)
    @JsonTypeName(value="updateAutoScalingGroupCommand")
    public static final class UpdateAutoScalingGroupCommand
    implements SagaCommand {
        @Nonnull
        private final ModifyServerGroupLaunchTemplateDescription description;
        @Nonnull
        private final LaunchTemplateVersion launchTemplateVersion;
        @Nullable
        private final Long newLaunchTemplateVersionNumber;
        @Nullable
        private final List<LaunchTemplateOverrides> launchTemplateOverrides;
        @Nonnull
        private final Boolean isReqToUpgradeAsgToMixedInstancesPolicy;
        private EventMetadata metadata;

        public void setMetadata(@NotNull EventMetadata metadata) {
            this.metadata = metadata;
        }

        @Generated
        UpdateAutoScalingGroupCommand(@Nonnull ModifyServerGroupLaunchTemplateDescription description, @Nonnull LaunchTemplateVersion launchTemplateVersion, @Nullable Long newLaunchTemplateVersionNumber, @Nullable List<LaunchTemplateOverrides> launchTemplateOverrides, @Nonnull Boolean isReqToUpgradeAsgToMixedInstancesPolicy, EventMetadata metadata) {
            if (description == null) {
                throw new IllegalArgumentException("description is marked non-null but is null");
            }
            if (launchTemplateVersion == null) {
                throw new IllegalArgumentException("launchTemplateVersion is marked non-null but is null");
            }
            if (isReqToUpgradeAsgToMixedInstancesPolicy == null) {
                throw new IllegalArgumentException("isReqToUpgradeAsgToMixedInstancesPolicy is marked non-null but is null");
            }
            this.description = description;
            this.launchTemplateVersion = launchTemplateVersion;
            this.newLaunchTemplateVersionNumber = newLaunchTemplateVersionNumber;
            this.launchTemplateOverrides = launchTemplateOverrides;
            this.isReqToUpgradeAsgToMixedInstancesPolicy = isReqToUpgradeAsgToMixedInstancesPolicy;
            this.metadata = metadata;
        }

        @Generated
        public static UpdateAutoScalingGroupCommandBuilder builder() {
            return new UpdateAutoScalingGroupCommandBuilder();
        }

        @Generated
        public UpdateAutoScalingGroupCommandBuilder toBuilder() {
            return new UpdateAutoScalingGroupCommandBuilder().description(this.description).launchTemplateVersion(this.launchTemplateVersion).newLaunchTemplateVersionNumber(this.newLaunchTemplateVersionNumber).launchTemplateOverrides(this.launchTemplateOverrides).isReqToUpgradeAsgToMixedInstancesPolicy(this.isReqToUpgradeAsgToMixedInstancesPolicy).metadata(this.metadata);
        }

        @Nonnull
        @Generated
        public ModifyServerGroupLaunchTemplateDescription getDescription() {
            return this.description;
        }

        @Nonnull
        @Generated
        public LaunchTemplateVersion getLaunchTemplateVersion() {
            return this.launchTemplateVersion;
        }

        @Nullable
        @Generated
        public Long getNewLaunchTemplateVersionNumber() {
            return this.newLaunchTemplateVersionNumber;
        }

        @Nullable
        @Generated
        public List<LaunchTemplateOverrides> getLaunchTemplateOverrides() {
            return this.launchTemplateOverrides;
        }

        @Nonnull
        @Generated
        public Boolean getIsReqToUpgradeAsgToMixedInstancesPolicy() {
            return this.isReqToUpgradeAsgToMixedInstancesPolicy;
        }

        @Generated
        public EventMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateAutoScalingGroupCommand)) {
                return false;
            }
            UpdateAutoScalingGroupCommand other = (UpdateAutoScalingGroupCommand)o;
            Long this$newLaunchTemplateVersionNumber = this.getNewLaunchTemplateVersionNumber();
            Long other$newLaunchTemplateVersionNumber = other.getNewLaunchTemplateVersionNumber();
            if (this$newLaunchTemplateVersionNumber == null ? other$newLaunchTemplateVersionNumber != null : !((Object)this$newLaunchTemplateVersionNumber).equals(other$newLaunchTemplateVersionNumber)) {
                return false;
            }
            Boolean this$isReqToUpgradeAsgToMixedInstancesPolicy = this.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            Boolean other$isReqToUpgradeAsgToMixedInstancesPolicy = other.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            if (this$isReqToUpgradeAsgToMixedInstancesPolicy == null ? other$isReqToUpgradeAsgToMixedInstancesPolicy != null : !((Object)this$isReqToUpgradeAsgToMixedInstancesPolicy).equals(other$isReqToUpgradeAsgToMixedInstancesPolicy)) {
                return false;
            }
            ModifyServerGroupLaunchTemplateDescription this$description = this.getDescription();
            ModifyServerGroupLaunchTemplateDescription other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            LaunchTemplateVersion this$launchTemplateVersion = this.getLaunchTemplateVersion();
            LaunchTemplateVersion other$launchTemplateVersion = other.getLaunchTemplateVersion();
            if (this$launchTemplateVersion == null ? other$launchTemplateVersion != null : !this$launchTemplateVersion.equals(other$launchTemplateVersion)) {
                return false;
            }
            List<LaunchTemplateOverrides> this$launchTemplateOverrides = this.getLaunchTemplateOverrides();
            List<LaunchTemplateOverrides> other$launchTemplateOverrides = other.getLaunchTemplateOverrides();
            if (this$launchTemplateOverrides == null ? other$launchTemplateOverrides != null : !((Object)this$launchTemplateOverrides).equals(other$launchTemplateOverrides)) {
                return false;
            }
            EventMetadata this$metadata = this.getMetadata();
            EventMetadata other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $newLaunchTemplateVersionNumber = this.getNewLaunchTemplateVersionNumber();
            result = result * 59 + ($newLaunchTemplateVersionNumber == null ? 43 : ((Object)$newLaunchTemplateVersionNumber).hashCode());
            Boolean $isReqToUpgradeAsgToMixedInstancesPolicy = this.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            result = result * 59 + ($isReqToUpgradeAsgToMixedInstancesPolicy == null ? 43 : ((Object)$isReqToUpgradeAsgToMixedInstancesPolicy).hashCode());
            ModifyServerGroupLaunchTemplateDescription $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            LaunchTemplateVersion $launchTemplateVersion = this.getLaunchTemplateVersion();
            result = result * 59 + ($launchTemplateVersion == null ? 43 : $launchTemplateVersion.hashCode());
            List<LaunchTemplateOverrides> $launchTemplateOverrides = this.getLaunchTemplateOverrides();
            result = result * 59 + ($launchTemplateOverrides == null ? 43 : ((Object)$launchTemplateOverrides).hashCode());
            EventMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpdateAutoScalingGroup.UpdateAutoScalingGroupCommand(description=" + String.valueOf(this.getDescription()) + ", launchTemplateVersion=" + String.valueOf(this.getLaunchTemplateVersion()) + ", newLaunchTemplateVersionNumber=" + this.getNewLaunchTemplateVersionNumber() + ", launchTemplateOverrides=" + String.valueOf(this.getLaunchTemplateOverrides()) + ", isReqToUpgradeAsgToMixedInstancesPolicy=" + this.getIsReqToUpgradeAsgToMixedInstancesPolicy() + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class UpdateAutoScalingGroupCommandBuilder {
            @Generated
            private ModifyServerGroupLaunchTemplateDescription description;
            @Generated
            private LaunchTemplateVersion launchTemplateVersion;
            @Generated
            private Long newLaunchTemplateVersionNumber;
            @Generated
            private List<LaunchTemplateOverrides> launchTemplateOverrides;
            @Generated
            private Boolean isReqToUpgradeAsgToMixedInstancesPolicy;
            @Generated
            private EventMetadata metadata;

            @Generated
            UpdateAutoScalingGroupCommandBuilder() {
            }

            @Generated
            public UpdateAutoScalingGroupCommandBuilder description(@Nonnull ModifyServerGroupLaunchTemplateDescription description) {
                if (description == null) {
                    throw new IllegalArgumentException("description is marked non-null but is null");
                }
                this.description = description;
                return this;
            }

            @Generated
            public UpdateAutoScalingGroupCommandBuilder launchTemplateVersion(@Nonnull LaunchTemplateVersion launchTemplateVersion) {
                if (launchTemplateVersion == null) {
                    throw new IllegalArgumentException("launchTemplateVersion is marked non-null but is null");
                }
                this.launchTemplateVersion = launchTemplateVersion;
                return this;
            }

            @Generated
            public UpdateAutoScalingGroupCommandBuilder newLaunchTemplateVersionNumber(@Nullable Long newLaunchTemplateVersionNumber) {
                this.newLaunchTemplateVersionNumber = newLaunchTemplateVersionNumber;
                return this;
            }

            @Generated
            public UpdateAutoScalingGroupCommandBuilder launchTemplateOverrides(@Nullable List<LaunchTemplateOverrides> launchTemplateOverrides) {
                this.launchTemplateOverrides = launchTemplateOverrides;
                return this;
            }

            @Generated
            public UpdateAutoScalingGroupCommandBuilder isReqToUpgradeAsgToMixedInstancesPolicy(@Nonnull Boolean isReqToUpgradeAsgToMixedInstancesPolicy) {
                if (isReqToUpgradeAsgToMixedInstancesPolicy == null) {
                    throw new IllegalArgumentException("isReqToUpgradeAsgToMixedInstancesPolicy is marked non-null but is null");
                }
                this.isReqToUpgradeAsgToMixedInstancesPolicy = isReqToUpgradeAsgToMixedInstancesPolicy;
                return this;
            }

            @Generated
            public UpdateAutoScalingGroupCommandBuilder metadata(EventMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public UpdateAutoScalingGroupCommand build() {
                return new UpdateAutoScalingGroupCommand(this.description, this.launchTemplateVersion, this.newLaunchTemplateVersionNumber, this.launchTemplateOverrides, this.isReqToUpgradeAsgToMixedInstancesPolicy, this.metadata);
            }

            @Generated
            public String toString() {
                return "UpdateAutoScalingGroup.UpdateAutoScalingGroupCommand.UpdateAutoScalingGroupCommandBuilder(description=" + String.valueOf(this.description) + ", launchTemplateVersion=" + String.valueOf(this.launchTemplateVersion) + ", newLaunchTemplateVersionNumber=" + this.newLaunchTemplateVersionNumber + ", launchTemplateOverrides=" + String.valueOf(this.launchTemplateOverrides) + ", isReqToUpgradeAsgToMixedInstancesPolicy=" + this.isReqToUpgradeAsgToMixedInstancesPolicy + ", metadata=" + String.valueOf(this.metadata) + ")";
            }
        }
    }
}

