/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings;
import com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.services.shield.model.CreateProtectionRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerClassicDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.handlers.LoadBalancerUpsertHandler;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.IngressLoadBalancerBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup.SecurityGroupLookupFactory;
import com.netflix.spinnaker.clouddriver.aws.model.SubnetTarget;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.config.AwsConfiguration;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertAmazonLoadBalancerAtomicOperation
implements AtomicOperation<UpsertAmazonLoadBalancerResult>,
GroovyObject {
    private static final String BASE_PHASE = "CREATE_ELB";
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    @Autowired
    private RegionScopedProviderFactory regionScopedProviderFactory;
    @Autowired
    private SecurityGroupLookupFactory securityGroupLookupFactory;
    @Autowired
    private IngressLoadBalancerBuilder ingressLoadBalancerBuilder;
    @Autowired
    private AwsConfiguration.DeployDefaults deployDefaults;
    private final UpsertAmazonLoadBalancerClassicDescription description;
    private ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public UpsertAmazonLoadBalancerAtomicOperation(UpsertAmazonLoadBalancerDescription description) {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ObjectMapper.class);
        this.objectMapper = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, description);
        this.description = callSite2;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public UpsertAmazonLoadBalancerResult operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Initializing load balancer creation...");
        CallSite operationResult = IndyInterface.bootstrap("init", "<init>", 0, UpsertAmazonLoadBalancerResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancers", ScriptBytecodeAdapter.createMap((Object[])new Object[0])}));
        CallSite entry = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "availabilityZones", 4, this.description)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                entry = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite region = IndyInterface.bootstrap("getProperty", "key", 0, entry);
                CallSite availabilityZones = IndyInterface.bootstrap("getProperty", "value", 0, entry);
                CallSite regionScopedProvider = IndyInterface.bootstrap("invoke", "forRegion", 0, this.regionScopedProviderFactory, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region);
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "name", 4, this.description);
                CallSite loadBalancerName = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "clusterName", 4, this.description)}, new String[]{"", "-frontend"}));
                boolean isInternal = DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getIsInternal", 0, this.description), null) ? IndyInterface.bootstrap("invoke", "getIsInternal", 0, this.description) : IndyInterface.bootstrap("invoke", "contains", 1, IndyInterface.bootstrap("getProperty", "subnetType", 4, this.description), "internal")));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{region, availabilityZones, loadBalancerName}, new String[]{"Beginning deployment to ", " in ", " for ", ""}));
                CallSite loadBalancing = IndyInterface.bootstrap("invoke", "getAmazonElasticLoadBalancing", 0, this.amazonClientProvider, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region, true);
                CallSite loadBalancer = null;
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Setting up listeners for ", " in ", "..."}));
                Reference listeners = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _operate_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference listeners;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _operate_closure1(Object _outerInstance, Object _thisObject, Reference listeners) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.listeners = reference = listeners;
                    }

                    public Object doCall(UpsertAmazonLoadBalancerClassicDescription.Listener listener) {
                        CallSite awsListener = IndyInterface.bootstrap("init", "<init>", 0, Listener.class);
                        IndyInterface.bootstrap("invoke", "withInstancePort", 0, IndyInterface.bootstrap("invoke", "withLoadBalancerPort", 0, awsListener, IndyInterface.bootstrap("getProperty", "externalPort", 0, listener)), IndyInterface.bootstrap("getProperty", "internalPort", 0, listener));
                        IndyInterface.bootstrap("invoke", "withProtocol", 0, awsListener, IndyInterface.bootstrap("invoke", "name", 0, IndyInterface.bootstrap("getProperty", "externalProtocol", 0, listener)));
                        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "internalProtocol", 0, listener)) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "externalProtocol", 0, listener), (Object)IndyInterface.bootstrap("getProperty", "internalProtocol", 0, listener))) {
                            IndyInterface.bootstrap("invoke", "withInstanceProtocol", 0, awsListener, IndyInterface.bootstrap("invoke", "name", 0, IndyInterface.bootstrap("getProperty", "internalProtocol", 0, listener)));
                        } else {
                            IndyInterface.bootstrap("invoke", "withInstanceProtocol", 0, awsListener, IndyInterface.bootstrap("invoke", "name", 0, IndyInterface.bootstrap("getProperty", "externalProtocol", 0, listener)));
                        }
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "sslCertificateId", 0, listener)) != false) {
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "sslCertificateId", 0, listener)}, new String[]{"Attaching listener with SSL ServerCertificate: ", ""}));
                            IndyInterface.bootstrap("invoke", "withSSLCertificateId", 0, awsListener, IndyInterface.bootstrap("getProperty", "sslCertificateId", 0, listener));
                        }
                        IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.listeners.get()), awsListener);
                        return IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "protocol", 0, awsListener), IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, awsListener), IndyInterface.bootstrap("getProperty", "instanceProtocol", 0, awsListener), IndyInterface.bootstrap("getProperty", "instancePort", 0, awsListener)}, new String[]{"Appending listener ", ":", " -> ", ":", ""}));
                    }

                    @Generated
                    public Object call(UpsertAmazonLoadBalancerClassicDescription.Listener listener) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, listener);
                    }

                    @Generated
                    public List getListeners() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.listeners.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "listeners", 4, this.description), new _operate_closure1(this, this, listeners));
                try {
                    loadBalancer = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("getProperty", "loadBalancerDescriptions", 1, IndyInterface.bootstrap("invoke", "describeLoadBalancers", 0, loadBalancing, IndyInterface.bootstrap("init", "<init>", 0, DescribeLoadBalancersRequest.class, ScriptBytecodeAdapter.createList((Object[])new Object[]{loadBalancerName})))), false));
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Found existing load balancer named ", " in ", "... Using that."}));
                }
                catch (AmazonServiceException ignore) {
                }
                public final class _operate_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _operate_closure2(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("getProperty", "value", 0, it);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite securityGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getSecurityGroupIds", 0, IndyInterface.bootstrap("getProperty", "securityGroupService", 0, regionScopedProvider), IndyInterface.bootstrap("getProperty", "securityGroups", 4, this.description), IndyInterface.bootstrap("getProperty", "vpcId", 4, this.description)), new _operate_closure2(this, this)));
                CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, "security groups on {} {}", IndyInterface.bootstrap("getProperty", "name", 4, this.description), securityGroups) : null;
                CallSite dnsName = null;
                if (IndyInterface.bootstrap("cast", "()", 0, loadBalancer) == false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), region}, new String[]{"Creating ", " in ", ":", "..."}));
                    Object subnetIds = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetType", 4, this.description)) != false) {
                        subnetIds = IndyInterface.bootstrap("invoke", "getSubnetIdsForZones", 0, IndyInterface.bootstrap("getProperty", "subnetAnalyzer", 0, regionScopedProvider), availabilityZones, IndyInterface.bootstrap("getProperty", "subnetType", 4, this.description), IndyInterface.bootstrap("getProperty", "ELB", 0, SubnetTarget.class), true);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "createLoadBalancerIngressPermissions", 4, this.deployDefaults)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "addAppGroupToServerGroup", 4, this.deployDefaults))) {
                        CallSite application = null;
                        try {
                            CallSite callSite4 = IndyInterface.bootstrap("invoke", "getApp", 0, IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, IndyInterface.bootstrap("getProperty", "name", 4, this.description)));
                            application = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite4) != false ? callSite4 : IndyInterface.bootstrap("invoke", "getApp", 0, IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, IndyInterface.bootstrap("getProperty", "clusterName", 4, this.description))));
                            public final class _operate_closure3
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _operate_closure3(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object l) {
                                    return IndyInterface.bootstrap("invoke", "getInstancePort", 0, l);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            CallSite ports = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, (List)listeners.get(), new _operate_closure3(this, this)));
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheckPort", 4, this.description)) != false) {
                                IndyInterface.bootstrap("invoke", "add", 0, ports, IndyInterface.bootstrap("getProperty", "healthCheckPort", 4, this.description));
                            }
                            CallSite ingressLoadBalancerResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ingressApplicationLoadBalancerGroup", 0, this.ingressLoadBalancerBuilder, application, region, IndyInterface.bootstrap("getProperty", "account", 4, this.description), IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), IndyInterface.bootstrap("getProperty", "vpcId", 4, this.description), ports, this.securityGroupLookupFactory));
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{ingressLoadBalancerResult}, new String[]{"Authorized app ELB Security Group ", ""}));
                            IndyInterface.bootstrap("invoke", "add", 0, securityGroups, IndyInterface.bootstrap("getProperty", "groupId", 0, ingressLoadBalancerResult));
                        }
                        catch (Exception e) {
                            IndyInterface.bootstrap("invoke", "error", 0, log, "Failed to authorize app ELB security group {}-elb on application security group", application, e);
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{application}, new String[]{"Failed to authorize app ELB security group ", "-elb on application security group"}));
                        }
                    }
                    dnsName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createLoadBalancer", 0, LoadBalancerUpsertHandler.class, loadBalancing, loadBalancerName, isInternal, availabilityZones, subnetIds, (List)listeners.get(), securityGroups));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "isInternal", 4, this.description)) == false && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "shieldEnabled", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "shieldProtectionEnabled", 4, this.description))) {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Configuring AWS Shield for ", " in ", "..."}));
                        try {
                            CallSite shieldClient = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAmazonShield", 0, this.amazonClientProvider, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region));
                            IndyInterface.bootstrap("invoke", "createProtection", 0, shieldClient, IndyInterface.bootstrap("invoke", "withResourceArn", 0, IndyInterface.bootstrap("invoke", "withName", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateProtectionRequest.class), loadBalancerName), IndyInterface.bootstrap("invoke", "loadBalancerArn", 0, UpsertAmazonLoadBalancerAtomicOperation.class, IndyInterface.bootstrap("getProperty", "accountId", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), region, loadBalancerName)));
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"AWS Shield configured for ", " in ", "."}));
                        }
                        catch (Exception e) {
                            CallSite callSite5 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "error", 0, log, new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Failed to enable AWS Shield protection on ", ""}), e) : null;
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Failed to configure AWS Shield for ", " in ", "."}));
                        }
                    }
                } else {
                    dnsName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DNSName", 0, loadBalancer));
                    IndyInterface.bootstrap("invoke", "updateLoadBalancer", 0, LoadBalancerUpsertHandler.class, loadBalancing, loadBalancer, (List)listeners.get(), securityGroups);
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)) != false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Configuring healthcheck for ", " in ", "..."}));
                    CallSite healthCheck = IndyInterface.bootstrap("init", "<init>", 0, ConfigureHealthCheckRequest.class, loadBalancerName, IndyInterface.bootstrap("invoke", "withHealthyThreshold", 0, IndyInterface.bootstrap("invoke", "withUnhealthyThreshold", 0, IndyInterface.bootstrap("invoke", "withTimeout", 0, IndyInterface.bootstrap("invoke", "withInterval", 0, IndyInterface.bootstrap("invoke", "withTarget", 0, IndyInterface.bootstrap("init", "<init>", 0, HealthCheck.class), IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)), IndyInterface.bootstrap("getProperty", "healthInterval", 4, this.description)), IndyInterface.bootstrap("getProperty", "healthTimeout", 4, this.description)), IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 4, this.description)), IndyInterface.bootstrap("getProperty", "healthyThreshold", 4, this.description)));
                    IndyInterface.bootstrap("invoke", "configureHealthCheck", 0, loadBalancing, healthCheck);
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Healthcheck configured.");
                }
                CallSite crossZoneLoadBalancing = null;
                CallSite connectionDraining = null;
                CallSite connectionSettings = null;
                if (IndyInterface.bootstrap("cast", "()", 0, loadBalancer) != false) {
                    CallSite currentAttributes = IndyInterface.bootstrap("getProperty", "loadBalancerAttributes", 0, IndyInterface.bootstrap("invoke", "describeLoadBalancerAttributes", 0, loadBalancing, IndyInterface.bootstrap("invoke", "withLoadBalancerName", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeLoadBalancerAttributesRequest.class), loadBalancerName)));
                    CallSite crossZoneBalancingEnabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "crossZoneBalancing", 4, this.description), IndyInterface.bootstrap("getProperty", "enabled", 1, IndyInterface.bootstrap("getProperty", "crossZoneLoadBalancing", 1, currentAttributes)), IndyInterface.bootstrap("getProperty", "crossZoneBalancingDefault", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, this.deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class)));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)crossZoneBalancingEnabled, (Object)IndyInterface.bootstrap("getProperty", "enabled", 1, IndyInterface.bootstrap("getProperty", "crossZoneLoadBalancing", 1, currentAttributes)))) {
                        crossZoneLoadBalancing = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CrossZoneLoadBalancing.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", crossZoneBalancingEnabled})));
                    }
                    CallSite connectionDrainingEnabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "connectionDraining", 4, this.description), IndyInterface.bootstrap("getProperty", "enabled", 1, IndyInterface.bootstrap("getProperty", "connectionDraining", 1, currentAttributes)), IndyInterface.bootstrap("getProperty", "connectionDrainingDefault", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, this.deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class)));
                    CallSite deregistrationDelay = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "deregistrationDelay", 4, this.description), IndyInterface.bootstrap("getProperty", "timeout", 1, IndyInterface.bootstrap("getProperty", "connectionDraining", 1, currentAttributes)), IndyInterface.bootstrap("getProperty", "deregistrationDelayDefault", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, this.deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class)));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)connectionDrainingEnabled, (Object)IndyInterface.bootstrap("getProperty", "enabled", 1, IndyInterface.bootstrap("getProperty", "connectionDraining", 1, currentAttributes))) || ScriptBytecodeAdapter.compareNotEqual((Object)deregistrationDelay, (Object)IndyInterface.bootstrap("getProperty", "timeout", 1, IndyInterface.bootstrap("getProperty", "connectionDraining", 1, currentAttributes)))) {
                        connectionDraining = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ConnectionDraining.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", connectionDrainingEnabled, "timeout", deregistrationDelay})));
                    }
                    CallSite idleTimeout = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "idleTimeout", 4, this.description), IndyInterface.bootstrap("getProperty", "idleTimeout", 1, IndyInterface.bootstrap("getProperty", "connectionSettings", 1, currentAttributes)), IndyInterface.bootstrap("getProperty", "idleTimeout", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, this.deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class)));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)idleTimeout, (Object)IndyInterface.bootstrap("getProperty", "idleTimeout", 1, IndyInterface.bootstrap("getProperty", "connectionSettings", 1, currentAttributes)))) {
                        connectionSettings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ConnectionSettings.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"idleTimeout", idleTimeout})));
                    }
                } else {
                    crossZoneLoadBalancing = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CrossZoneLoadBalancing.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "crossZoneBalancing", 4, this.description), IndyInterface.bootstrap("getProperty", "crossZoneBalancingDefault", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, this.deployDefaults))}), IndyInterface.bootstrap("getProperty", "TRUE", 0, Boolean.class), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class))})));
                    connectionDraining = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ConnectionDraining.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "connectionDraining", 4, this.description), IndyInterface.bootstrap("getProperty", "connectionDrainingDefault", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, this.deployDefaults))}), IndyInterface.bootstrap("getProperty", "FALSE", 0, Boolean.class), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class)), "timeout", IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "deregistrationDelay", 4, this.description), IndyInterface.bootstrap("getProperty", "deregistrationDelayDefault", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, this.deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class))})));
                    connectionSettings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ConnectionSettings.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"idleTimeout", IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "idleTimeout", 4, this.description), IndyInterface.bootstrap("getProperty", "idleTimeout", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, this.deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class))})));
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)crossZoneLoadBalancing, null) || ScriptBytecodeAdapter.compareNotEqual((Object)connectionDraining, null) || ScriptBytecodeAdapter.compareNotEqual((Object)connectionSettings, null)) {
                    CallSite attributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerAttributes.class));
                    if (IndyInterface.bootstrap("cast", "()", 0, crossZoneLoadBalancing) != false) {
                        IndyInterface.bootstrap("invoke", "setCrossZoneLoadBalancing", 0, attributes, crossZoneLoadBalancing);
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, connectionDraining) != false) {
                        IndyInterface.bootstrap("invoke", "setConnectionDraining", 0, attributes, connectionDraining);
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, connectionSettings) != false) {
                        IndyInterface.bootstrap("invoke", "setConnectionSettings", 0, attributes, connectionSettings);
                    }
                    IndyInterface.bootstrap("invoke", "modifyLoadBalancerAttributes", 0, loadBalancing, IndyInterface.bootstrap("invoke", "withLoadBalancerAttributes", 0, IndyInterface.bootstrap("init", "<init>", 0, ModifyLoadBalancerAttributesRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerName", loadBalancerName})), attributes));
                }
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), region}, new String[]{"Done deploying ", " to ", " in ", "."}));
                CallSite callSite6 = IndyInterface.bootstrap("init", "<init>", 0, UpsertAmazonLoadBalancerResult.LoadBalancer.class, loadBalancerName, dnsName);
                IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, operationResult), region, callSite6);
            }
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Done deploying load balancers.");
        return IndyInterface.bootstrap("cast", "()", 0, operationResult);
    }

    private static String loadBalancerArn(String accountId, String region, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{accountId, region, name}, new String[]{"arn:aws:elasticloadbalancing:", ":", ":loadbalancer/", ""}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertAmazonLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerAtomicOperation");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }

    @Generated
    public RegionScopedProviderFactory getRegionScopedProviderFactory() {
        return this.regionScopedProviderFactory;
    }

    @Generated
    public void setRegionScopedProviderFactory(RegionScopedProviderFactory regionScopedProviderFactory) {
        this.regionScopedProviderFactory = regionScopedProviderFactory;
    }

    @Generated
    public SecurityGroupLookupFactory getSecurityGroupLookupFactory() {
        return this.securityGroupLookupFactory;
    }

    @Generated
    public void setSecurityGroupLookupFactory(SecurityGroupLookupFactory securityGroupLookupFactory) {
        this.securityGroupLookupFactory = securityGroupLookupFactory;
    }

    @Generated
    public IngressLoadBalancerBuilder getIngressLoadBalancerBuilder() {
        return this.ingressLoadBalancerBuilder;
    }

    @Generated
    public void setIngressLoadBalancerBuilder(IngressLoadBalancerBuilder ingressLoadBalancerBuilder) {
        this.ingressLoadBalancerBuilder = ingressLoadBalancerBuilder;
    }

    @Generated
    public AwsConfiguration.DeployDefaults getDeployDefaults() {
        return this.deployDefaults;
    }

    @Generated
    public void setDeployDefaults(AwsConfiguration.DeployDefaults deployDefaults) {
        this.deployDefaults = deployDefaults;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

