/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeleteSecurityGroupDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteSecurityGroupAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final String BASE_PHASE = "DELETE_SECURITY_GROUP";
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    private final DeleteSecurityGroupDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DeleteSecurityGroupAtomicOperation(DeleteSecurityGroupDescription description) {
        DeleteSecurityGroupDescription deleteSecurityGroupDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = deleteSecurityGroupDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    private void generateDependencyError(AmazonServiceException e, Task task, Map<SecurityGroup, List<IpPermission>> securityGroupToRevokeIngressPermissions) {
        public final class _generateDependencyError_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateDependencyError_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "groupName", 0, IndyInterface.bootstrap("getProperty", "key", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateDependencyError_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite dependentSecurityGroupsWithIngress = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, securityGroupToRevokeIngressPermissions, new _generateDependencyError_closure1(this, this)));
        Object message = "Failed deleting security group because of existing dependencies. ";
        message = ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, dependentSecurityGroupsWithIngress), (Object)0) ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, message, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, dependentSecurityGroupsWithIngress, ", ")}, new String[]{"Ingress rules still exist on security group(s): ", "."}))) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, message, "Unknown dependencies; instances and/or load balancers may still have the security group associated."));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, task, BASE_PHASE, message);
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, Exception.class, message, e));
    }

    public Void operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Initializing Delete Security Group Operation...");
        Object region = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "regions", 4, this.description)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                region = callSite.next();
                CallSite ec2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, this.amazonClientProvider, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region, true);
                CallSite result = IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, ec2);
                CallSite securityGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "securityGroups", 0, result));
                public final class _operate_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _operate_closure2(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "vpcId", 0, it), (Object)IndyInterface.bootstrap("getProperty", "vpcId", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "groupName", 0, it), (Object)IndyInterface.bootstrap("getProperty", "securityGroupName", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)));
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference securityGroup = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, securityGroups, new _operate_closure2(this, this))));
                CallSite vpcText = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "vpcId", 4, this.description)) != false ? new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "vpcId", 4, this.description)}, new String[]{"", " "}) : "");
                CallSite securityGroupDescription = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "securityGroupName", 4, this.description), region, vpcText, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description))}, new String[]{"", " in ", " ", "for ", ""}));
                if (IndyInterface.bootstrap("cast", "()", 0, (SecurityGroup)securityGroup.get()) != false) {
                    CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DeleteSecurityGroupRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", IndyInterface.bootstrap("getProperty", "groupId", 0, (SecurityGroup)securityGroup.get())})));
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{securityGroupDescription}, new String[]{"Deleting ", "."}));
                    try {
                        IndyInterface.bootstrap("invoke", "deleteSecurityGroup", 0, ec2, request);
                    }
                    catch (AmazonServiceException e) {
                        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "errorCode", 0, e), (Object)"DependencyViolation")) {
                            Reference securityGroupToRevokeIngressPermissions = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class)));
                            public final class _operate_closure3
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference securityGroup;
                                private /* synthetic */ Reference securityGroupToRevokeIngressPermissions;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _operate_closure3(Object _outerInstance, Object _thisObject, Reference securityGroup, Reference securityGroupToRevokeIngressPermissions) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    Reference reference2;
                                    this.securityGroup = reference2 = securityGroup;
                                    this.securityGroupToRevokeIngressPermissions = reference = securityGroupToRevokeIngressPermissions;
                                }

                                public Object doCall(Object sg) {
                                    Reference sg2 = new Reference(sg);
                                    public final class _closure4
                                    extends Closure
                                    implements GeneratedClosure {
                                        private /* synthetic */ Reference securityGroup;
                                        private /* synthetic */ Reference securityGroupToRevokeIngressPermissions;
                                        private /* synthetic */ Reference sg;
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;

                                        public _closure4(Object _outerInstance, Object _thisObject, Reference securityGroup, Reference securityGroupToRevokeIngressPermissions, Reference sg) {
                                            super(_outerInstance, _thisObject);
                                            Reference reference;
                                            Reference reference2;
                                            Reference reference3;
                                            this.securityGroup = reference3 = securityGroup;
                                            this.securityGroupToRevokeIngressPermissions = reference2 = securityGroupToRevokeIngressPermissions;
                                            this.sg = reference = sg;
                                        }

                                        public Object doCall(Object ipPerm) {
                                            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "userIdGroupPairs", 0, ipPerm), null)) {
                                                public final class _closure5
                                                extends Closure
                                                implements GeneratedClosure {
                                                    private /* synthetic */ Reference securityGroup;
                                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                                    public static transient /* synthetic */ boolean __$stMC;

                                                    public _closure5(Object _outerInstance, Object _thisObject, Reference securityGroup) {
                                                        super(_outerInstance, _thisObject);
                                                        Reference reference;
                                                        this.securityGroup = reference = securityGroup;
                                                    }

                                                    public Object doCall(Object it) {
                                                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "groupId", 0, it), (Object)IndyInterface.bootstrap("getProperty", "groupId", 0, IndyInterface.bootstrap("cast", "()", 0, this.securityGroup.get())));
                                                    }

                                                    @Generated
                                                    public SecurityGroup getSecurityGroup() {
                                                        return IndyInterface.bootstrap("cast", "()", 0, this.securityGroup.get());
                                                    }

                                                    @Generated
                                                    public Object doCall() {
                                                        return this.doCall(null);
                                                    }

                                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                        }
                                                        ClassInfo classInfo = $staticClassInfo;
                                                        if (classInfo == null) {
                                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                        }
                                                        return classInfo.getMetaClass();
                                                    }

                                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                                        return MethodHandles.lookup();
                                                    }
                                                }
                                                CallSite pair = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "userIdGroupPairs", 0, ipPerm), new _closure5((Object)this, this.getThisObject(), this.securityGroup)));
                                                if (ScriptBytecodeAdapter.compareNotEqual((Object)pair, null)) {
                                                    CallSite ipPermissions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.securityGroupToRevokeIngressPermissions.get()), this.sg.get()));
                                                    if (ScriptBytecodeAdapter.compareEqual((Object)ipPermissions, null)) {
                                                        ipPermissions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                                                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.securityGroupToRevokeIngressPermissions.get()), this.sg.get(), ipPermissions);
                                                    }
                                                    CallSite permission = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, ipPerm));
                                                    IndyInterface.bootstrap("invoke", "setIpRanges", 0, permission, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                                                    IndyInterface.bootstrap("invoke", "setIpv4Ranges", 0, permission, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                                                    IndyInterface.bootstrap("invoke", "setIpv6Ranges", 0, permission, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                                                    List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{pair});
                                                    ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)permission, (String)"userIdGroupPairs");
                                                    return IndyInterface.bootstrap("invoke", "push", 0, ipPermissions, permission);
                                                }
                                            }
                                            return null;
                                        }

                                        @Generated
                                        public SecurityGroup getSecurityGroup() {
                                            return IndyInterface.bootstrap("cast", "()", 0, this.securityGroup.get());
                                        }

                                        @Generated
                                        public Map getSecurityGroupToRevokeIngressPermissions() {
                                            return IndyInterface.bootstrap("cast", "()", 0, this.securityGroupToRevokeIngressPermissions.get());
                                        }

                                        @Generated
                                        public Object getSg() {
                                            return this.sg.get();
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _closure4.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                            return MethodHandles.lookup();
                                        }
                                    }
                                    return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "ipPermissions", 0, sg2.get()), new _closure4((Object)this, this.getThisObject(), this.securityGroup, this.securityGroupToRevokeIngressPermissions, sg2));
                                }

                                @Generated
                                public SecurityGroup getSecurityGroup() {
                                    return IndyInterface.bootstrap("cast", "()", 0, this.securityGroup.get());
                                }

                                @Generated
                                public Map getSecurityGroupToRevokeIngressPermissions() {
                                    return IndyInterface.bootstrap("cast", "()", 0, this.securityGroupToRevokeIngressPermissions.get());
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            IndyInterface.bootstrap("invoke", "each", 0, securityGroups, new _operate_closure3(this, this, securityGroup, securityGroupToRevokeIngressPermissions));
                            IndyInterface.bootstrap("invoke", "generateDependencyError", 2, this, e, IndyInterface.bootstrap("getProperty", "task", 12, this), (Map)securityGroupToRevokeIngressPermissions.get());
                        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "errorCode", 0, e), (Object)"InvalidGroup.NotFound")) {
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("getProperty", "errorMessage", 0, e));
                            throw (Throwable)e;
                        }
                    }
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{securityGroupDescription}, new String[]{"Done deleting ", "."}));
                    continue;
                }
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{securityGroupDescription}, new String[]{"There is no ", "."}));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeleteSecurityGroupAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }
}

