/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup;

import com.amazonaws.AmazonServiceException;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertSecurityGroupDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup.SecurityGroupIngressConverter;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup.SecurityGroupLookupFactory;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertSecurityGroupAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final String BASE_PHASE = "UPSERT_SG";
    private static final int MAX_RULES_FOR_STATUS = 50;
    private final UpsertSecurityGroupDescription description;
    @Autowired
    private SecurityGroupLookupFactory securityGroupLookupFactory;
    @Autowired
    private DynamicConfigService dynamicConfigService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public UpsertSecurityGroupAtomicOperation(UpsertSecurityGroupDescription description) {
        UpsertSecurityGroupDescription upsertSecurityGroupDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertSecurityGroupDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        Object existingIpPermissions;
        CallSite securityGroupUpdater;
        CallSite ipPermissionsFromDescription;
        CallSite securityGroupLookup;
        block23: {
            securityGroupLookup = IndyInterface.bootstrap("invoke", "getInstance", 0, this.securityGroupLookupFactory, IndyInterface.bootstrap("getProperty", "region", 4, this.description));
            ipPermissionsFromDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertDescriptionToIngress", 2, this, securityGroupLookup, this.description, true));
            securityGroupUpdater = IndyInterface.bootstrap("invoke", "getSecurityGroupByName", 0, securityGroupLookup, IndyInterface.bootstrap("getProperty", "account", 4, this.description), IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "vpcId", 4, this.description));
            existingIpPermissions = null;
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "present", 0, securityGroupUpdater)) != false) {
                securityGroupUpdater = IndyInterface.bootstrap("invoke", "get", 0, securityGroupUpdater);
                existingIpPermissions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "flattenPermissions", 0, SecurityGroupIngressConverter.class, IndyInterface.bootstrap("getProperty", "securityGroup", 0, securityGroupUpdater)));
            } else {
                try {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Creating Security Group ", ""}));
                    securityGroupUpdater = IndyInterface.bootstrap("invoke", "createSecurityGroup", 0, securityGroupLookup, this.description);
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "securityGroup", 0, securityGroupUpdater)}, new String[]{"Created Security Group ", ""}));
                    existingIpPermissions = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                }
                catch (AmazonServiceException e) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "errorCode", 0, e), (Object)"InvalidGroup.Duplicate")) {
                        securityGroupUpdater = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "getSecurityGroupByName", 0, securityGroupLookup, IndyInterface.bootstrap("getProperty", "account", 4, this.description), IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "vpcId", 4, this.description)));
                        existingIpPermissions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "flattenPermissions", 0, SecurityGroupIngressConverter.class, IndyInterface.bootstrap("getProperty", "securityGroup", 0, securityGroupUpdater)));
                        break block23;
                    }
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "account", 4, this.description), IndyInterface.bootstrap("getProperty", "errorMessage", 0, e)}, new String[]{"Failed to create security group '", "' in ", ": ", ""}));
                    throw (Throwable)e;
                }
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "selfReferencing", 0, IndyInterface.bootstrap("getProperty", "missingSecurityGroups", 4, ipPermissionsFromDescription)))) == false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Extracting ip permissions");
            ipPermissionsFromDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertDescriptionToIngress", 2, this, securityGroupLookup, this.description, false));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{ipPermissionsFromDescription}, new String[]{"Extracted ip permissions (", ")"}));
        }
        CallSite ipRuleDelta = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "computeIpRuleDelta", 0, SecurityGroupIngressConverter.class, IndyInterface.bootstrap("getProperty", "converted", 4, ipPermissionsFromDescription), existingIpPermissions));
        CallSite ipPermissionsToAdd = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "toAdd", 4, ipRuleDelta));
        CallSite userIdGroupPairsDelta = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "computeUserIdGroupPairsDelta", 0, SecurityGroupIngressConverter.class, IndyInterface.bootstrap("getProperty", "converted", 4, ipPermissionsFromDescription), existingIpPermissions));
        ipPermissionsToAdd = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, ipPermissionsToAdd, IndyInterface.bootstrap("getProperty", "toAdd", 4, userIdGroupPairsDelta)));
        CallSite ipPermissionsToRemove = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "toRemove", 4, ipRuleDelta));
        ipPermissionsToRemove = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, ipPermissionsToRemove, IndyInterface.bootstrap("getProperty", "toRemove", 4, userIdGroupPairsDelta)));
        CallSite tobeUpdated = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "toUpdate", 4, ipRuleDelta), IndyInterface.bootstrap("getProperty", "toUpdate", 4, userIdGroupPairsDelta)));
        if (IndyInterface.bootstrap("cast", "()", 0, tobeUpdated) != false) {
            CallSite status = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Permissions updated to '", "'"}));
            status = ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, tobeUpdated), (Object)MAX_RULES_FOR_STATUS) ? IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{status, IndyInterface.bootstrap("invoke", "size", 0, tobeUpdated)}, new String[]{"", " (", " rules updated)."})) : IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{status, tobeUpdated}, new String[]{"", " (", ")."}));
            try {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{tobeUpdated}, new String[]{"Updating Ingress (", ")"}));
                IndyInterface.bootstrap("invoke", "updateIngress", 0, securityGroupUpdater, tobeUpdated);
                IndyInterface.bootstrap("invoke", "updateTags", 0, securityGroupUpdater, this.description, this.dynamicConfigService);
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, status);
            }
            catch (AmazonServiceException e) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "errorMessage", 0, e)}, new String[]{"Error updating ingress to '", "' - ", ""}));
                throw (Throwable)e;
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, ipPermissionsToAdd) != false) {
            CallSite status = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Permissions added to '", "'"}));
            status = ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, ipPermissionsToAdd), (Object)MAX_RULES_FOR_STATUS) ? IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{status, IndyInterface.bootstrap("invoke", "size", 0, ipPermissionsToAdd)}, new String[]{"", " (", " rules added)."})) : IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{status, ipPermissionsToAdd}, new String[]{"", " (", ")."}));
            try {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{ipPermissionsToAdd}, new String[]{"Adding Ingress (", ")"}));
                IndyInterface.bootstrap("invoke", "addIngress", 0, securityGroupUpdater, ipPermissionsToAdd);
                IndyInterface.bootstrap("invoke", "updateTags", 0, securityGroupUpdater, this.description, this.dynamicConfigService);
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, status);
            }
            catch (AmazonServiceException e) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "errorMessage", 0, e)}, new String[]{"Error adding ingress to '", "' - ", ""}));
                throw (Throwable)e;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)ipPermissionsToRemove) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ingressAppendOnly", 4, this.description)) == false) {
            CallSite status = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Permissions removed from '", "'"}));
            status = ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, ipPermissionsToRemove), (Object)MAX_RULES_FOR_STATUS) ? IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{status, IndyInterface.bootstrap("invoke", "size", 0, ipPermissionsToRemove)}, new String[]{"", " (", " rules removed)."})) : IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{status, ipPermissionsToRemove}, new String[]{"", " (", ")."}));
            try {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{ipPermissionsToRemove}, new String[]{"Removing Ingress (", ")"}));
                IndyInterface.bootstrap("invoke", "removeIngress", 0, securityGroupUpdater, ipPermissionsToRemove);
                IndyInterface.bootstrap("invoke", "updateTags", 0, securityGroupUpdater, this.description, this.dynamicConfigService);
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, status);
            }
            catch (AmazonServiceException e) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "errorMessage", 0, e)}, new String[]{"Error removing ingress from ", ": ", ""}));
                throw (Throwable)e;
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private SecurityGroupIngressConverter.ConvertedIngress convertDescriptionToIngress(SecurityGroupLookupFactory.SecurityGroupLookup securityGroupLookup, UpsertSecurityGroupDescription description, boolean ignoreSelfReferencingRules) {
        Reference description2 = new Reference((Object)description);
        CallSite ipPermissionsFromDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertIngressToIpPermissions", 0, SecurityGroupIngressConverter.class, securityGroupLookup, (UpsertSecurityGroupDescription)description2.get()));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "anyMissing", 0, IndyInterface.bootstrap("getProperty", "missingSecurityGroups", 4, ipPermissionsFromDescription), ignoreSelfReferencingRules)) != false) {
            public final class _convertDescriptionToIngress_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference description;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _convertDescriptionToIngress_closure1(Object _outerInstance, Object _thisObject, Reference description) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.description = reference = description;
                }

                public Object doCall(Object it) {
                    CallSite callSite;
                    Object[] objectArray = new Object[3];
                    CallSite callSite2 = IndyInterface.bootstrap("getProperty", "name", 0, it);
                    objectArray[0] = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : IndyInterface.bootstrap("getProperty", "id", 0, it);
                    CallSite callSite3 = IndyInterface.bootstrap("getProperty", "accountName", 0, it);
                    objectArray[1] = IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : IndyInterface.bootstrap("getProperty", "account", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()));
                    CallSite callSite4 = IndyInterface.bootstrap("getProperty", "vpcId", 0, it);
                    objectArray[2] = IndyInterface.bootstrap("cast", "()", 0, callSite4) != false ? callSite4 : (IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("getProperty", "vpcId", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))) != false ? callSite : "EC2-classic");
                    return new GStringImpl(objectArray, new String[]{"'", "' in '", "' ", ""});
                }

                @Generated
                public UpsertSecurityGroupDescription getDescription() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.description.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _convertDescriptionToIngress_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite missingSecurityGroupDescriptions = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "all", 0, IndyInterface.bootstrap("getProperty", "missingSecurityGroups", 4, ipPermissionsFromDescription)), new _convertDescriptionToIngress_closure1(this, this, description2));
            GStringImpl securityGroupsDoNotExistErrorMessage = new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, missingSecurityGroupDescriptions, ", "), ignoreSelfReferencingRules}, new String[]{"The following security groups do not exist: ", " (ignoreSelfReferencingRules: ", ")"});
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, securityGroupsDoNotExistErrorMessage);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, securityGroupsDoNotExistErrorMessage));
        }
        return ipPermissionsFromDescription;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertSecurityGroupAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup.UpsertSecurityGroupAtomicOperation");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final UpsertSecurityGroupDescription getDescription() {
        return this.description;
    }

    @Generated
    public SecurityGroupLookupFactory getSecurityGroupLookupFactory() {
        return this.securityGroupLookupFactory;
    }

    @Generated
    public void setSecurityGroupLookupFactory(SecurityGroupLookupFactory securityGroupLookupFactory) {
        this.securityGroupLookupFactory = securityGroupLookupFactory;
    }

    @Generated
    public DynamicConfigService getDynamicConfigService() {
        return this.dynamicConfigService;
    }

    @Generated
    public void setDynamicConfigService(DynamicConfigService dynamicConfigService) {
        this.dynamicConfigService = dynamicConfigService;
    }
}

