/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.userdata;

import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataInput;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataProvider;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataTokenizer;
import com.netflix.spinnaker.kork.exceptions.UserException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UserDataProviderAggregator {
    private final List<UserDataProvider> providers;
    private final List<UserDataTokenizer> tokenizers;

    public UserDataProviderAggregator(List<UserDataProvider> providers, List<UserDataTokenizer> tokenizers) {
        this.providers = providers;
        this.tokenizers = tokenizers;
    }

    public String aggregate(UserDataInput userDataInput) {
        byte[] bytes = Base64.getDecoder().decode(Optional.ofNullable(userDataInput.getBase64UserData()).orElse(""));
        String userDataDecoded = new String(bytes, StandardCharsets.UTF_8);
        if (userDataInput.getUserDataOverride().isEnabled()) {
            List udts = this.tokenizers.stream().filter(it -> it.supports(userDataInput.getUserDataOverride().getTokenizerName())).collect(Collectors.toList());
            if (udts.isEmpty()) {
                throw new UserException("Unable to find supporting user data tokenizer for {}", userDataInput.getUserDataOverride().getTokenizerName());
            }
            for (UserDataTokenizer t : udts) {
                userDataDecoded = t.replaceTokens(Names.parseName((String)userDataInput.getAsgName()), userDataInput, userDataDecoded, Boolean.valueOf(false));
            }
            return this.result(Collections.singletonList(userDataDecoded));
        }
        List<Object> allUserData = new ArrayList();
        if (this.providers != null && !userDataInput.getUserDataOverride().isEnabled()) {
            allUserData = this.providers.stream().map(p -> p.getUserData(userDataInput)).collect(Collectors.toList());
        }
        String data = String.join((CharSequence)"\n", allUserData);
        return this.result(Arrays.asList(data, userDataDecoded));
    }

    private String result(List<String> parts) {
        String result = String.join((CharSequence)"\n", parts);
        if (result.startsWith("\n")) {
            result = result.trim();
        }
        if (result.isEmpty()) {
            return null;
        }
        return Base64.getEncoder().encodeToString(result.getBytes(StandardCharsets.UTF_8));
    }
}

