/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.event;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.google.common.collect.Lists;
import com.netflix.spinnaker.clouddriver.aws.event.AfterResizeEvent;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface AfterResizeEventHandler {
    public static final int MAX_SIMULTANEOUS_TERMINATIONS = 100;
    public static final String PHASE = "RESIZE";

    public void handle(AfterResizeEvent var1);

    default public void terminateInstancesInAutoScalingGroup(Task task, AmazonEC2 amazonEC2, AutoScalingGroup autoScalingGroup) {
        String serverGroupName = autoScalingGroup.getAutoScalingGroupName();
        List instanceIds = autoScalingGroup.getInstances().stream().map(Instance::getInstanceId).collect(Collectors.toList());
        int terminatedCount = 0;
        for (List partition : Lists.partition(instanceIds, (int)100)) {
            try {
                task.updateStatus(PHASE, String.format("Terminating %d of %d instances in %s", terminatedCount += partition.size(), instanceIds.size(), serverGroupName));
                amazonEC2.terminateInstances(new TerminateInstancesRequest().withInstanceIds((Collection)partition));
            }
            catch (Exception e) {
                task.updateStatus(PHASE, String.format("Unable to terminate instances, reason: '%s'", e.getMessage()));
            }
        }
    }
}

