/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterCleanupAgent
implements CachingAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractClusterCleanupAgent.class);

    public String getAgentType() {
        return this.getCloudProviderId() + "/" + this.getClass().getSimpleName();
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.singleton(AgentDataType.Authority.INFORMATIVE.forType(Namespace.CLUSTERS.ns));
    }

    protected abstract String getCloudProviderId();

    public CacheResult loadData(ProviderCache providerCache) {
        Collection serverGroups = providerCache.filterIdentifiers(Namespace.SERVER_GROUPS.ns, AbstractClusterCleanupAgent.buildMatchAllGlob(this.getCloudProviderId(), Namespace.SERVER_GROUPS.ns));
        HashSet clusters = new HashSet(providerCache.filterIdentifiers(Namespace.CLUSTERS.ns, AbstractClusterCleanupAgent.buildMatchAllGlob(this.getCloudProviderId(), Namespace.CLUSTERS.ns)));
        for (String sgId : serverGroups) {
            Map<String, String> parts = this.parseServerGroupId(sgId);
            if (parts == null || !parts.containsKey("cluster") || !parts.containsKey("application") || !parts.containsKey("account")) continue;
            String clusterId = this.buildClusterId(parts.get("cluster"), parts.get("application"), parts.get("account"));
            clusters.remove(clusterId);
        }
        if (clusters.isEmpty()) {
            return new DefaultCacheResult(Collections.emptyMap());
        }
        if (log.isDebugEnabled()) {
            log.debug("Evicting {} clusters. Count: {}, keys: {}", new Object[]{this.getCloudProviderId(), clusters.size(), clusters});
        } else {
            log.info("Evicting {} clusters. Count: {}", (Object)this.getCloudProviderId(), (Object)clusters.size());
        }
        return new DefaultCacheResult(Collections.emptyMap(), Map.of(Namespace.CLUSTERS.ns, clusters));
    }

    protected abstract Map<String, String> parseServerGroupId(String var1);

    protected abstract String buildClusterId(String var1, String var2, String var3);

    protected static String buildMatchAllGlob(String cloudProviderId, String type) {
        return cloudProviderId + ":" + type + ":*";
    }
}

