/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.services.autoscaling.model.ScalingPolicy;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetTypeEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.frigga.Names;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.data.ArnUtils;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonCachingAgentFilter;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.DriftMetric;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.EddaTimeoutConfig;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupport;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterCachingAgent
implements CachingAgent,
OnDemandAgent,
AccountAware,
DriftMetric,
GroovyObject {
    private final Logger log;
    private static final TypeReference<Map<String, Object>> ATTRIBUTES;
    private static final Set<AgentDataType> types;
    private final AmazonCloudProvider amazonCloudProvider;
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final String region;
    private final ObjectMapper objectMapper;
    private final Registry registry;
    private final EddaTimeoutConfig eddaTimeoutConfig;
    private final AmazonCachingAgentFilter amazonCachingAgentFilter;
    private final OnDemandMetricsSupport metricsSupport;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ClusterCachingAgent(AmazonCloudProvider amazonCloudProvider, AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, ObjectMapper objectMapper, Registry registry, EddaTimeoutConfig eddaTimeoutConfig, AmazonCachingAgentFilter amazonCachingAgentFilter) {
        AmazonCachingAgentFilter amazonCachingAgentFilter2;
        EddaTimeoutConfig eddaTimeoutConfig2;
        Registry registry2;
        String string;
        NetflixAmazonCredentials netflixAmazonCredentials;
        AmazonClientProvider amazonClientProvider2;
        AmazonCloudProvider amazonCloudProvider2;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, IndyInterface.bootstrap("invoke", "getClass", 2, this));
        this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonCloudProvider = amazonCloudProvider2 = amazonCloudProvider;
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        this.account = netflixAmazonCredentials = account;
        this.region = string = region;
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "enable", 0, objectMapper, IndyInterface.bootstrap("getProperty", "WRITE_DATES_AS_TIMESTAMPS", 0, SerializationFeature.class));
        this.objectMapper = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        this.registry = registry2 = registry;
        this.eddaTimeoutConfig = eddaTimeoutConfig2 = eddaTimeoutConfig;
        CallSite callSite3 = IndyInterface.bootstrap("init", "<init>", 0, OnDemandMetricsSupport.class, registry, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "id", 4, amazonCloudProvider), IndyInterface.bootstrap("getProperty", "ServerGroup", 0, OnDemandType.class)}, new String[]{"", ":", ""}));
        this.metricsSupport = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        this.amazonCachingAgentFilter = amazonCachingAgentFilter2 = amazonCachingAgentFilter;
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, AwsProvider.class));
    }

    @Override
    public String getAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, IndyInterface.bootstrap("getProperty", "simpleName", 0, ClusterCachingAgent.class)}, new String[]{"", "/", "/", ""}));
    }

    public String getAccountName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, this.account));
    }

    public String getOnDemandAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAgentType", 2, this)}, new String[]{"", "-OnDemand"}));
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    public Optional<Map<String, String>> getCacheKeyPatterns() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, Optional.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, "*", "*", IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region)})));
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return ScriptBytecodeAdapter.compareEqual((Object)type, (Object)IndyInterface.bootstrap("getProperty", "ServerGroup", 0, OnDemandType.class)) && ScriptBytecodeAdapter.compareEqual((Object)cloudProvider, (Object)IndyInterface.bootstrap("getProperty", "id", 4, this.amazonCloudProvider));
    }

    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ? extends Object> data) {
        Reference providerCache2 = new Reference((Object)providerCache);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, data, "serverGroupName")) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, data, "account")) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, data, "region")) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, this.account), (Object)IndyInterface.bootstrap("getProperty", "account", 0, data))) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.region, (Object)IndyInterface.bootstrap("getProperty", "region", 0, data))) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Reference serverGroupName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "serverGroupName", 0, data))));
        public final class _handle_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure1(Object _outerInstance, Object _thisObject, Reference serverGroupName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroupName = reference = serverGroupName;
            }

            public Object doCall(Object it) {
                CallSite asg = IndyInterface.bootstrap("invoke", "loadAutoScalingGroup", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get()), true);
                CallSite clients = IndyInterface.bootstrap("init", "<init>", 0, AmazonClients.class, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("getProperty", "account", 12, this), IndyInterface.bootstrap("getProperty", "region", 12, this), true);
                CallSite scalingPolicies = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, asg) != false ? IndyInterface.bootstrap("invoke", "loadScalingPolicies", 2, this, clients, IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get())) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                CallSite scheduledActions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, asg) != false ? IndyInterface.bootstrap("invoke", "loadScheduledActions", 2, this, clients, IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get())) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                Map subnetMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getVPCZoneIdentifier", 1, asg)) != false) {
                    IndyInterface.bootstrap("invoke", "putAll", 0, subnetMap, IndyInterface.bootstrap("invoke", "getSubnetToVpcIdMap", 2, this, clients, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getVPCZoneIdentifier", 0, asg), ",")));
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"asgs", IndyInterface.bootstrap("cast", "()", 0, asg) != false ? ScriptBytecodeAdapter.createList((Object[])new Object[]{asg}) : ScriptBytecodeAdapter.createList((Object[])new Object[0]), "scalingPolicies", scalingPolicies, "scheduledActions", scheduledActions, "subnetMap", subnetMap});
            }

            @Generated
            public String getServerGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference onDemandData = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readData", 0, this.metricsSupport, new _handle_closure1(this, this, serverGroupName))));
        public final class _handle_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference onDemandData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure2(Object _outerInstance, Object _thisObject, Reference onDemandData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.onDemandData = reference = onDemandData;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "buildCacheResult", 2, this, IndyInterface.bootstrap("getProperty", "asgs", 0, IndyInterface.bootstrap("cast", "()", 0, this.onDemandData.get())), IndyInterface.bootstrap("getProperty", "scalingPolicies", 0, IndyInterface.bootstrap("cast", "()", 0, this.onDemandData.get())), IndyInterface.bootstrap("getProperty", "scheduledActions", 0, IndyInterface.bootstrap("cast", "()", 0, this.onDemandData.get())), IndyInterface.bootstrap("getProperty", "subnetMap", 0, IndyInterface.bootstrap("cast", "()", 0, this.onDemandData.get())), ScriptBytecodeAdapter.createMap((Object[])new Object[0]), ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            }

            @Generated
            public Map getOnDemandData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.onDemandData.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite cacheResult = IndyInterface.bootstrap("invoke", "transformData", 0, this.metricsSupport, new _handle_closure2(this, this, onDemandData));
        Reference cacheResultAsJson = new Reference((Object)IndyInterface.bootstrap("invoke", "writeValueAsString", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "cacheResults", 0, cacheResult)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("getProperty", "cacheResults", 0, cacheResult))))) != false) {
            IndyInterface.bootstrap("invoke", "evictDeletedItems", 0, (ProviderCache)providerCache2.get(), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, (String)serverGroupName.get(), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region)}));
        } else {
            public final class _handle_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroupName;
                private /* synthetic */ Reference cacheResultAsJson;
                private /* synthetic */ Reference providerCache;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure3(Object _outerInstance, Object _thisObject, Reference serverGroupName, Reference cacheResultAsJson, Reference providerCache) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.serverGroupName = reference3 = serverGroupName;
                    this.cacheResultAsJson = reference2 = cacheResultAsJson;
                    this.providerCache = reference = providerCache;
                }

                public Object doCall(Object it) {
                    CallSite cacheData = IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get()), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this)), IndyInterface.bootstrap("invoke", "multiply", 0, 10, 60), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"cacheTime", IndyInterface.bootstrap("init", "<init>", 0, Date.class), "cacheResults", this.cacheResultAsJson.get()}), ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                    return IndyInterface.bootstrap("invoke", "putCacheData", 0, IndyInterface.bootstrap("cast", "()", 0, this.providerCache.get()), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), cacheData);
                }

                @Generated
                public String getServerGroupName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get());
                }

                @Generated
                public Object getCacheResultAsJson() {
                    return this.cacheResultAsJson.get();
                }

                @Generated
                public ProviderCache getProviderCache() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.providerCache.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _handle_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "onDemandStore", 0, this.metricsSupport, new _handle_closure3(this, this, serverGroupName, cacheResultAsJson, providerCache2));
        }
        Map evictions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "asgs", 0, (Map)onDemandData.get())) != false ? ScriptBytecodeAdapter.createMap((Object[])new Object[0]) : ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, (String)serverGroupName.get(), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region)})});
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{data, evictions, cacheResultAsJson.get()}, new String[]{"onDemand cache refresh (data: ", ", evictions: ", ", cacheResult: ", ")"}));
        public final class _handle_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "authority", 0, it), (Object)IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _handle_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "typeName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, OnDemandAgent.OnDemandResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceAgentType", IndyInterface.bootstrap("invoke", "getOnDemandAgentType", 2, this), "cacheResult", cacheResult, "evictions", evictions, "authoritativeTypes", IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, types, new _handle_closure4(this, this)), new _handle_closure5(this, this))})));
    }

    private Map<String, CacheData> cache() {
        public final class _cache_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cache_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String id) {
                return IndyInterface.bootstrap("init", "<init>", 0, MutableCacheData.class, id);
            }

            @Generated
            public Object call(String id) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, id);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cache_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _cache_closure6(this, this)));
    }

    public Map<String, String> getSubnetToVpcIdMap(AmazonClients clients, String ... subnetIds) {
        Map subnetMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        CallSite request = IndyInterface.bootstrap("init", "<init>", 0, DescribeSubnetsRequest.class);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "length", 0, subnetIds), (Object)0)) {
            IndyInterface.bootstrap("invoke", "withSubnetIds", 0, request, subnetIds);
        }
        CallSite subnet = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "subnets", 0, IndyInterface.bootstrap("invoke", "describeSubnets", 0, IndyInterface.bootstrap("getProperty", "amazonEC2", 4, clients), request))));
        if (callSite != null) {
            while (callSite.hasNext()) {
                subnet = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite existing = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "put", 0, subnetMap, IndyInterface.bootstrap("getProperty", "subnetId", 0, subnet), IndyInterface.bootstrap("getProperty", "vpcId", 0, subnet)));
                if (!(ScriptBytecodeAdapter.compareNotEqual((Object)existing, null) && ScriptBytecodeAdapter.compareNotEqual((Object)existing, (Object)IndyInterface.bootstrap("getProperty", "vpcId", 0, subnet)))) continue;
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, "Unexpected non unique subnetId to vpcId mapping"));
            }
        }
        return subnetMap;
    }

    private AutoScalingGroupsResults loadAutoScalingGroups(AmazonClients clients) {
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing auto scaling groups in ", ""}));
        CallSite request = IndyInterface.bootstrap("invoke", "withMaxRecords", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeAutoScalingGroupsRequest.class), 100);
        CallSite start = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "eddaEnabled", 0, this.account)) != false ? null : IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
        Object asgs = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (true) {
            CallSite resp = IndyInterface.bootstrap("invoke", "describeAutoScalingGroups", 0, IndyInterface.bootstrap("getProperty", "autoScaling", 4, clients), request);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "eddaEnabled", 0, this.account)) != false) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "lastModified", 0, this.amazonClientProvider);
                start = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0));
            }
            IndyInterface.bootstrap("invoke", "addAll", 0, asgs, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, resp));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextToken", 0, resp)) == false) break;
            IndyInterface.bootstrap("invoke", "withNextToken", 0, request, IndyInterface.bootstrap("getProperty", "nextToken", 0, resp));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, start) == false) {
            if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "eddaEnabled", 0, this.account)) && DefaultTypeTransformation.booleanUnbox((Object)asgs)) {
                IndyInterface.bootstrap("invoke", "warn", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"", " did not receive lastModified value in response metadata"}));
            }
            start = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
        }
        public final class _loadAutoScalingGroups_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadAutoScalingGroups_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "status", 0, it), null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadAutoScalingGroups_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        asgs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, asgs, new _loadAutoScalingGroups_closure7(this, this)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTagFilter", 0, this.amazonCachingAgentFilter)) != false) {
            public final class _loadAutoScalingGroups_closure8
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadAutoScalingGroups_closure8(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object asg) {
                    public final class _closure32
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure32(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("init", "<init>", 0, AmazonCachingAgentFilter.ResourceTag.class, IndyInterface.bootstrap("getProperty", "key", 0, it), IndyInterface.bootstrap("getProperty", "value", 0, it));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure32.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite asgTags = IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("getProperty", "tags", 0, asg), new _closure32((Object)this, this.getThisObject()));
                    return IndyInterface.bootstrap("invoke", "shouldRetainResource", 0, IndyInterface.bootstrap("getProperty", "amazonCachingAgentFilter", 12, this), asgTags);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadAutoScalingGroups_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            asgs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, asgs, new _loadAutoScalingGroups_closure8(this, this)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AutoScalingGroupsResults.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"start", start, "asgs", asgs})));
    }

    private Map<String, List<Map>> loadScalingPolicies(AmazonClients clients) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadScalingPolicies", 2, this, clients, null));
    }

    private Map<String, List<Map>> loadScalingPolicies(AmazonClients clients, String asgName) {
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing scaling policies in ", ""}));
        CallSite request = IndyInterface.bootstrap("init", "<init>", 0, DescribePoliciesRequest.class);
        if (IndyInterface.bootstrap("cast", "()", 0, asgName) != false) {
            IndyInterface.bootstrap("invoke", "withAutoScalingGroupName", 0, request, asgName);
        }
        List scalingPolicies = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (true) {
            CallSite resp = IndyInterface.bootstrap("invoke", "describePolicies", 0, IndyInterface.bootstrap("getProperty", "autoScaling", 4, clients), request);
            IndyInterface.bootstrap("invoke", "addAll", 0, scalingPolicies, IndyInterface.bootstrap("getProperty", "scalingPolicies", 0, resp));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextToken", 0, resp)) == false) break;
            IndyInterface.bootstrap("invoke", "withNextToken", 0, request, IndyInterface.bootstrap("getProperty", "nextToken", 0, resp));
        }
        Object alarmNames = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, asgName) != false) {
            public final class _loadScalingPolicies_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadScalingPolicies_closure9(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    public final class _closure33
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure33(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "alarmName", 0, it);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure33.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "findResults", 0, IndyInterface.bootstrap("getProperty", "alarms", 0, it), new _closure33((Object)this, this.getThisObject()));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadScalingPolicies_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            alarmNames = IndyInterface.bootstrap("invoke", "unique", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "findResults", 0, scalingPolicies, new _loadScalingPolicies_closure9(this, this))));
        }
        Reference alarms = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        if (IndyInterface.bootstrap("cast", "()", 0, asgName) == false || DefaultTypeTransformation.booleanUnbox((Object)alarmNames)) {
            alarms.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadAlarms", 2, this, clients, alarmNames)));
        }
        public final class _loadScalingPolicies_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference alarms;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadScalingPolicies_closure10(Object _outerInstance, Object _thisObject, Reference alarms) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.alarms = reference = alarms;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "buildScalingPolicy", 2, this, it, IndyInterface.bootstrap("cast", "()", 0, this.alarms.get()));
            }

            @Generated
            public Map getAlarms() {
                return IndyInterface.bootstrap("cast", "()", 0, this.alarms.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadScalingPolicies_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _loadScalingPolicies_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadScalingPolicies_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadScalingPolicies_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, IndyInterface.bootstrap("invoke", "findResults", 0, scalingPolicies, new _loadScalingPolicies_closure10(this, this, alarms)), new _loadScalingPolicies_closure11(this, this)));
    }

    private Map<String, List<Map>> loadScheduledActions(AmazonClients clients) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadScheduledActions", 2, this, clients, null));
    }

    private Map<String, List<Map>> loadScheduledActions(AmazonClients clients, String asgName) {
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing scheduled actions in ", ""}));
        CallSite request = IndyInterface.bootstrap("init", "<init>", 0, DescribeScheduledActionsRequest.class);
        if (IndyInterface.bootstrap("cast", "()", 0, asgName) != false) {
            IndyInterface.bootstrap("invoke", "withAutoScalingGroupName", 0, request, asgName);
        }
        List scheduledActions = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (true) {
            CallSite resp = IndyInterface.bootstrap("invoke", "describeScheduledActions", 0, IndyInterface.bootstrap("getProperty", "autoScaling", 4, clients), request);
            IndyInterface.bootstrap("invoke", "addAll", 0, scheduledActions, IndyInterface.bootstrap("getProperty", "scheduledUpdateGroupActions", 0, resp));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextToken", 0, resp)) == false) break;
            IndyInterface.bootstrap("invoke", "withNextToken", 0, request, IndyInterface.bootstrap("getProperty", "nextToken", 0, resp));
        }
        public final class _loadScheduledActions_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadScheduledActions_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "toMap", 2, this, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadScheduledActions_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _loadScheduledActions_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadScheduledActions_closure13(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadScheduledActions_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, IndyInterface.bootstrap("invoke", "findResults", 0, scheduledActions, new _loadScheduledActions_closure12(this, this)), new _loadScheduledActions_closure13(this, this)));
    }

    private Map<String, Object> toMap(Object obj) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, obj, Map.class));
    }

    private Map<String, Map> loadAlarms(AmazonClients clients, List alarmNames) {
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing alarms in ", ""}));
        CallSite request = IndyInterface.bootstrap("invoke", "withMaxRecords", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeAlarmsRequest.class), 100);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "size", 0, alarmNames)) != false) {
            IndyInterface.bootstrap("invoke", "withAlarmNames", 0, request, alarmNames);
        }
        List alarms = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (true) {
            CallSite resp = IndyInterface.bootstrap("invoke", "describeAlarms", 0, IndyInterface.bootstrap("getProperty", "amazonCloudWatch", 4, clients), request);
            IndyInterface.bootstrap("invoke", "addAll", 0, alarms, IndyInterface.bootstrap("getProperty", "metricAlarms", 0, resp));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextToken", 0, resp)) == false) break;
            IndyInterface.bootstrap("invoke", "withNextToken", 0, request, IndyInterface.bootstrap("getProperty", "nextToken", 0, resp));
        }
        public final class _loadAlarms_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadAlarms_closure14(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "alarmArn", 0, it), IndyInterface.bootstrap("invoke", "toMap", 2, this, it)});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadAlarms_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, alarms, new _loadAlarms_closure14(this, this)));
    }

    public CacheResult loadData(ProviderCache providerCache) {
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing items in ", ""}));
        CallSite clients = IndyInterface.bootstrap("init", "<init>", 0, AmazonClients.class, this.amazonClientProvider, this.account, this.region, false);
        CallSite autoScalingGroupsResult = IndyInterface.bootstrap("invoke", "loadAutoScalingGroups", 2, this, clients);
        CallSite scalingPolicies = IndyInterface.bootstrap("invoke", "loadScalingPolicies", 2, this, clients);
        CallSite scheduledActions = IndyInterface.bootstrap("invoke", "loadScheduledActions", 2, this, clients);
        Reference start = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "start", 0, autoScalingGroupsResult)));
        Reference asgs = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "asgs", 0, autoScalingGroupsResult)));
        Reference evictableOnDemandCacheDatas = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Reference usableOnDemandCacheDatas = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _loadData_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadData_closure15(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, it), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference serverGroupKeys = new Reference((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, (List)asgs.get(), new _loadData_closure15(this, this)), Set.class))));
        public final class _loadData_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroupKeys;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadData_closure16(Object _outerInstance, Object _thisObject, Reference serverGroupKeys) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroupKeys = reference = serverGroupKeys;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "contains", 0, this.serverGroupKeys.get(), it);
            }

            @Generated
            public Object getServerGroupKeys() {
                return this.serverGroupKeys.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite pendingOnDemandRequestKeys = IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, "*", "*", IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region)), new _loadData_closure16(this, this, serverGroupKeys));
        CallSite pendingOnDemandRequestsForServerGroups = IndyInterface.bootstrap("invoke", "getAll", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), pendingOnDemandRequestKeys);
        public final class _loadData_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference start;
            private /* synthetic */ Reference asgs;
            private /* synthetic */ Reference evictableOnDemandCacheDatas;
            private /* synthetic */ Reference usableOnDemandCacheDatas;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadData_closure17(Object _outerInstance, Object _thisObject, Reference start, Reference asgs, Reference evictableOnDemandCacheDatas, Reference usableOnDemandCacheDatas) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.start = reference4 = start;
                this.asgs = reference3 = asgs;
                this.evictableOnDemandCacheDatas = reference2 = evictableOnDemandCacheDatas;
                this.usableOnDemandCacheDatas = reference = usableOnDemandCacheDatas;
            }

            public Object doCall(Object it) {
                Reference it2 = new Reference(it);
                if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("getProperty", "cacheTime", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it2.get())), (Object)IndyInterface.bootstrap("cast", "()", 0, this.start.get())) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "processedCount", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it2.get())), (Object)0)) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "eddaEnabled", 0, IndyInterface.bootstrap("getProperty", "account", 12, this))) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "disabledRegions", 0, IndyInterface.bootstrap("getProperty", "eddaTimeoutConfig", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this))) == false) {
                        public final class _closure34
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference it;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure34(Object _outerInstance, Object _thisObject, Reference it) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.it = reference = it;
                            }

                            public Object doCall(Object asg) {
                                return IndyInterface.bootstrap("invoke", "endsWith", 0, IndyInterface.bootstrap("getProperty", "id", 0, this.it.get()), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asg)}, new String[]{":", ""}));
                            }

                            @Generated
                            public Object getIt() {
                                return this.it.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure34.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite asgFromEdda = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.asgs.get()), new _closure34((Object)this, this.getThisObject(), it2));
                        CallSite asgFromAws = IndyInterface.bootstrap("invoke", "loadAutoScalingGroup", 2, this, IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asgFromEdda), true);
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "areSimilarAutoScalingGroups", 2, this, asgFromEdda, asgFromAws)) != false) {
                            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asgFromEdda), IndyInterface.bootstrap("getProperty", "processedCount", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it2.get())), IndyInterface.bootstrap("invoke", "flattenAutoScalingGroup", 2, this, asgFromEdda), IndyInterface.bootstrap("invoke", "flattenAutoScalingGroup", 2, this, asgFromAws)}, new String[]{"Evicting previous onDemand value for ", " (processedCount: ", " ... ", " vs ", ""}));
                            return IndyInterface.bootstrap("invoke", "leftShift", 0, this.evictableOnDemandCacheDatas.get(), it2.get());
                        }
                        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asgFromEdda), IndyInterface.bootstrap("invoke", "flattenAutoScalingGroup", 2, this, asgFromEdda), IndyInterface.bootstrap("invoke", "flattenAutoScalingGroup", 2, this, asgFromAws)}, new String[]{"Preserving previous onDemand value for ", " (", " vs ", ""}));
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, this.usableOnDemandCacheDatas.get(), it2.get());
                    }
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, this.evictableOnDemandCacheDatas.get(), it2.get());
                }
                return IndyInterface.bootstrap("invoke", "leftShift", 0, this.usableOnDemandCacheDatas.get(), it2.get());
            }

            @Generated
            public Long getStart() {
                return IndyInterface.bootstrap("cast", "()", 0, this.start.get());
            }

            @Generated
            public List getAsgs() {
                return IndyInterface.bootstrap("cast", "()", 0, this.asgs.get());
            }

            @Generated
            public Object getEvictableOnDemandCacheDatas() {
                return this.evictableOnDemandCacheDatas.get();
            }

            @Generated
            public Object getUsableOnDemandCacheDatas() {
                return this.usableOnDemandCacheDatas.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, pendingOnDemandRequestsForServerGroups, new _loadData_closure17(this, this, start, asgs, evictableOnDemandCacheDatas, usableOnDemandCacheDatas));
        public final class _loadData_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadData_closure18(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, it), it});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildCacheResult", 2, this, (List)asgs.get(), scalingPolicies, scheduledActions, IndyInterface.bootstrap("invoke", "getSubnetToVpcIdMap", 2, this, clients), IndyInterface.bootstrap("invoke", "collectEntries", 0, usableOnDemandCacheDatas.get(), new _loadData_closure18(this, this)), ScriptBytecodeAdapter.getPropertySpreadSafe(ClusterCachingAgent.class, (Object)evictableOnDemandCacheDatas.get(), (String)"id")));
        IndyInterface.bootstrap("invoke", "recordDrift", 2, this, (Long)start.get());
        CallSite cacheResults = IndyInterface.bootstrap("getProperty", "cacheResults", 0, result);
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "APPLICATIONS", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " applications in ", ""}));
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " clusters in ", ""}));
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " server groups in ", ""}));
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " load balancers in ", ""}));
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " target groups in ", ""}));
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " launch configs in ", ""}));
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " instances in ", ""}));
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " launch templates in ", ""}));
        if (IndyInterface.bootstrap("cast", "()", 0, evictableOnDemandCacheDatas.get()) != false) {
            public final class _loadData_closure19
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference start;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadData_closure19(Object _outerInstance, Object _thisObject, Reference start) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.start = reference = start;
                }

                public Object doCall(Object it) {
                    return new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, it), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("cast", "()", 0, this.start.get()), IndyInterface.bootstrap("getProperty", "cacheTime", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)))}, new String[]{"", "/", "ms"});
                }

                @Generated
                public Long getStart() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.start.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadData_closure19.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "collect", 0, evictableOnDemandCacheDatas.get(), new _loadData_closure19(this, this, start)), ", ")}, new String[]{"Evicting onDemand cache keys (", ")"}));
        }
        public final class _loadData_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadData_closure20(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class);
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 0, it), (String)"processedTime");
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "processedCount", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it));
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : Integer.valueOf(0), true);
                ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 0, it), (String)"processedCount");
                return callSite3;
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class))), new _loadData_closure20(this, this));
        return result;
    }

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        CallSite keys = IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, "*", "*", IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchPendingOnDemandRequests", 2, this, providerCache, keys));
    }

    public Map pendingOnDemandRequest(ProviderCache providerCache, String id) {
        CallSite pendingOnDemandRequests = IndyInterface.bootstrap("invoke", "fetchPendingOnDemandRequests", 2, this, providerCache, ScriptBytecodeAdapter.createList((Object[])new Object[]{id}));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 1, pendingOnDemandRequests, false));
    }

    private Collection<Map> fetchPendingOnDemandRequests(ProviderCache providerCache, Collection<String> keys) {
        public final class _fetchPendingOnDemandRequests_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fetchPendingOnDemandRequests_closure21(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite details = IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, it));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", IndyInterface.bootstrap("getProperty", "id", 0, it), "details", details, "moniker", IndyInterface.bootstrap("invoke", "convertOnDemandDetails", 2, this, details), "cacheTime", IndyInterface.bootstrap("getProperty", "cacheTime", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), "cacheExpiry", IndyInterface.bootstrap("getProperty", "cacheExpiry", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), "processedCount", IndyInterface.bootstrap("getProperty", "processedCount", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), "processedTime", IndyInterface.bootstrap("getProperty", "processedTime", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it))});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fetchPendingOnDemandRequests_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getAll", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), keys, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)), new _fetchPendingOnDemandRequests_closure21(this, this)));
    }

    private CacheResult buildCacheResult(Collection<AutoScalingGroup> asgs, Map<String, List<Map>> scalingPolicies, Map<String, List<Map>> scheduledActions, Map<String, String> subnetMap, Map<String, CacheData> onDemandCacheDataByAsg, Collection<String> evictableOnDemandCacheDataIdentifiers) {
        CallSite applications = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 2, this));
        CallSite clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 2, this));
        CallSite serverGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 2, this));
        CallSite loadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 2, this));
        CallSite targetGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 2, this));
        CallSite launchConfigs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 2, this));
        CallSite instances = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 2, this));
        CallSite launchTemplates = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 2, this));
        CallSite asg = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, asgs));
        if (callSite != null) {
            while (callSite.hasNext()) {
                asg = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite onDemandCacheData = IndyInterface.bootstrap("cast", "()", 0, onDemandCacheDataByAsg) != false ? IndyInterface.bootstrap("invoke", "getAt", 0, onDemandCacheDataByAsg, IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asg), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region)) : null;
                if (IndyInterface.bootstrap("cast", "()", 0, onDemandCacheData) != false) {
                    IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, onDemandCacheData), IndyInterface.bootstrap("getProperty", "cacheResults", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, onDemandCacheData))}, new String[]{"Using onDemand cache value (id: ", ", json: ", ")"}));
                    CallSite cacheResults = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readValue", 0, this.objectMapper, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "cacheResults", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, onDemandCacheData)), String.class))), String.class), new GroovyObject(this){
                        final /* synthetic */ ClusterCachingAgent this$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private transient /* synthetic */ MetaClass metaClass;
                        {
                            MetaClass metaClass;
                            ClusterCachingAgent clusterCachingAgent;
                            this.this$0 = clusterCachingAgent = p0;
                            this.metaClass = metaClass = this.$getStaticMetaClass();
                        }

                        public /* synthetic */ Object methodMissing(String name, Object args) {
                            try {
                                return this.this$0.this$dist$invoke$1(name, args);
                            }
                            catch (MissingMethodException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
                            }
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                            if (!(args instanceof Object[] == false)) ** GOTO lbl8
                            var2_2 = ScriptBytecodeAdapter.invokeMethodN(2.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                            return var2_2;
lbl8:
                            // 1 sources

                            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
                            var3_3 = ScriptBytecodeAdapter.invokeMethodN(2.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
                            return var3_3;
lbl14:
                            // 1 sources

                            var4_4 = ScriptBytecodeAdapter.invokeMethodN(2.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                            try {
                                return var4_4;
                            }
                            catch (MissingMethodException notFound) {
                                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
                            }
                        }

                        public /* synthetic */ void propertyMissing(String name, Object value) {
                            try {
                                this.this$0.this$dist$set$1(name, value);
                                return;
                            }
                            catch (MissingPropertyException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                            }
                        }

                        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                            try {
                                Object object = value;
                                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                            }
                            catch (MissingPropertyException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                            }
                        }

                        public /* synthetic */ Object propertyMissing(String name) {
                            try {
                                return this.this$0.this$dist$get$1(name);
                            }
                            catch (MissingPropertyException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                            }
                        }

                        public static /* synthetic */ Object $static_propertyMissing(String name) {
                            Object object = ScriptBytecodeAdapter.getProperty(2.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                            try {
                                return object;
                            }
                            catch (MissingPropertyException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                            }
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != 2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        @Generated
                        @Internal
                        @Transient
                        public MetaClass getMetaClass() {
                            MetaClass metaClass = this.metaClass;
                            if (metaClass != null) {
                                return metaClass;
                            }
                            this.metaClass = this.$getStaticMetaClass();
                            return this.metaClass;
                        }

                        @Generated
                        @Internal
                        public void setMetaClass(MetaClass metaClass) {
                            this.metaClass = metaClass;
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }));
                    IndyInterface.bootstrap("invoke", "cache", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "applications"), applications);
                    IndyInterface.bootstrap("invoke", "cache", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "clusters"), clusters);
                    IndyInterface.bootstrap("invoke", "cache", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "serverGroups"), serverGroups);
                    IndyInterface.bootstrap("invoke", "cache", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "loadBalancers"), loadBalancers);
                    IndyInterface.bootstrap("invoke", "cache", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "targetGroups"), targetGroups);
                    IndyInterface.bootstrap("invoke", "cache", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "launchConfigs"), launchConfigs);
                    IndyInterface.bootstrap("invoke", "cache", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "instances"), instances);
                    IndyInterface.bootstrap("invoke", "cache", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "launchTemplates"), launchTemplates);
                    continue;
                }
                try {
                    CallSite data = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AsgData.class, asg, IndyInterface.bootstrap("invoke", "getAt", 0, scalingPolicies, IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asg)), IndyInterface.bootstrap("invoke", "getAt", 0, scheduledActions, IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asg)), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, subnetMap));
                    IndyInterface.bootstrap("invoke", "cacheApplication", 2, this, data, applications);
                    IndyInterface.bootstrap("invoke", "cacheCluster", 2, this, data, clusters);
                    IndyInterface.bootstrap("invoke", "cacheServerGroup", 2, this, data, serverGroups);
                    IndyInterface.bootstrap("invoke", "cacheLaunchConfig", 2, this, data, launchConfigs);
                    IndyInterface.bootstrap("invoke", "cacheInstances", 2, this, data, instances);
                    IndyInterface.bootstrap("invoke", "cacheLoadBalancers", 2, this, data, loadBalancers);
                    IndyInterface.bootstrap("invoke", "cacheTargetGroups", 2, this, data, targetGroups);
                    IndyInterface.bootstrap("invoke", "cacheLaunchTemplate", 2, this, data, launchTemplates);
                }
                catch (Exception ex) {
                    IndyInterface.bootstrap("invoke", "warn", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asg), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region}, new String[]{"Failed to cache ", " in ", "/", ""}), ex);
                }
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "APPLICATIONS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, applications), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, clusters), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, serverGroups), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, loadBalancers), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, targetGroups), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, launchConfigs), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, instances), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, launchTemplates), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, onDemandCacheDataByAsg)}), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), evictableOnDemandCacheDataIdentifiers})));
    }

    private void cache(List<CacheData> data, Map<String, CacheData> cacheDataById) {
        Reference cacheDataById2 = new Reference(cacheDataById);
        public final class _cache_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cacheDataById;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cache_closure22(Object _outerInstance, Object _thisObject, Reference cacheDataById) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.cacheDataById = reference = cacheDataById;
            }

            public Object doCall(Object it) {
                Reference existingCacheData = new Reference((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.cacheDataById.get()), IndyInterface.bootstrap("getProperty", "id", 0, it)));
                if (IndyInterface.bootstrap("cast", "()", 0, existingCacheData.get()) == false) {
                    Object object = it;
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.cacheDataById.get()), IndyInterface.bootstrap("getProperty", "id", 0, it), object);
                    return object;
                }
                IndyInterface.bootstrap("invoke", "putAll", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, existingCacheData.get()), IndyInterface.bootstrap("getProperty", "attributes", 0, it));
                CallSite application = IndyInterface.bootstrap("invoke", "getApplicationForKey", 2, this, it);
                if (IndyInterface.bootstrap("cast", "()", 0, application) != false) {
                    IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, existingCacheData.get()), "application", application);
                }
                public final class _closure35
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference existingCacheData;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure35(Object _outerInstance, Object _thisObject, Reference existingCacheData) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.existingCacheData = reference = existingCacheData;
                    }

                    public Object doCall(String relationshipName, Collection<String> relationships) {
                        return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, this.existingCacheData.get()), relationshipName), relationships);
                    }

                    @Generated
                    public Object call(String relationshipName, Collection<String> relationships) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, relationshipName, relationships);
                    }

                    @Generated
                    public Object getExistingCacheData() {
                        return this.existingCacheData.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, it), new _closure35((Object)this, this.getThisObject(), existingCacheData));
            }

            @Generated
            public Map getCacheDataById() {
                return IndyInterface.bootstrap("cast", "()", 0, this.cacheDataById.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cache_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, data, new _cache_closure22(this, this, cacheDataById2));
    }

    private String getApplicationForKey(CacheData item) {
        CallSite application = null;
        application = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, item)), "application"));
        if (ScriptBytecodeAdapter.compareEqual((Object)application, null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, item), "serverGroups"))) {
            application = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "serverGroups", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, item)), false)), "application"));
        }
        CallSite callSite = application;
        try {
            return callSite;
        }
        catch (Exception e) {
            IndyInterface.bootstrap("invoke", "error", 0, this.log, "Failed determining application for {}", IndyInterface.bootstrap("getProperty", "id", 0, item), e);
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, null);
            return callSite2;
        }
    }

    private void cacheApplication(AsgData data, Map<String, CacheData> applications) {
        Reference data2 = new Reference((Object)data);
        public final class _cacheApplication_closure23
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference data;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cacheApplication_closure23(Object _outerInstance, Object _thisObject, Reference data) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.data = reference = data;
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "app", 0, IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"name");
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "cluster", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "serverGroup", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "loadBalancerNames", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "targetGroupKeys", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
            }

            @Generated
            public AsgData getData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cacheApplication_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, applications, IndyInterface.bootstrap("getProperty", "appName", 4, (AsgData)data2.get())), new _cacheApplication_closure23(this, this, data2));
    }

    private void cacheCluster(AsgData data, Map<String, CacheData> clusters) {
        Reference data2 = new Reference((Object)data);
        public final class _cacheCluster_closure24
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference data;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cacheCluster_closure24(Object _outerInstance, Object _thisObject, Reference data) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.data = reference = data;
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "cluster", 0, IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"name");
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "app", 0, IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"application");
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "APPLICATIONS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "appName", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "serverGroup", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "loadBalancerNames", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "targetGroupKeys", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
            }

            @Generated
            public AsgData getData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cacheCluster_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, clusters, IndyInterface.bootstrap("getProperty", "cluster", 4, (AsgData)data2.get())), new _cacheCluster_closure24(this, this, data2));
    }

    private void cacheServerGroup(AsgData data, Map<String, CacheData> serverGroups) {
        Reference data2 = new Reference((Object)data);
        public final class _cacheServerGroup_closure25
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference data;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cacheServerGroup_closure25(Object _outerInstance, Object _thisObject, Reference data) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.data = reference = data;
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "app", 0, IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"application");
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "asg", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())), IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 12, this));
                ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"asg");
                CallSite callSite3 = IndyInterface.bootstrap("getProperty", "region", 12, this);
                ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"region");
                CallSite callSite4 = IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, IndyInterface.bootstrap("getProperty", "asg", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"name");
                CallSite callSite5 = IndyInterface.bootstrap("getProperty", "launchConfigurationName", 0, IndyInterface.bootstrap("getProperty", "asg", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"launchConfigName");
                CallSite callSite6 = IndyInterface.bootstrap("getProperty", "availabilityZones", 0, IndyInterface.bootstrap("getProperty", "asg", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"zones");
                CallSite callSite7 = IndyInterface.bootstrap("getProperty", "instances", 0, IndyInterface.bootstrap("getProperty", "asg", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"instances");
                CallSite callSite8 = IndyInterface.bootstrap("getProperty", "vpcId", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get()));
                ScriptBytecodeAdapter.setProperty((Object)callSite8, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"vpcId");
                CallSite callSite9 = IndyInterface.bootstrap("getProperty", "scalingPolicies", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get()));
                ScriptBytecodeAdapter.setProperty((Object)callSite9, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"scalingPolicies");
                CallSite callSite10 = IndyInterface.bootstrap("getProperty", "scheduledActions", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get()));
                ScriptBytecodeAdapter.setProperty((Object)callSite10, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"scheduledActions");
                CallSite callSite11 = IndyInterface.bootstrap("getProperty", "targetGroupNames", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get()));
                ScriptBytecodeAdapter.setProperty((Object)callSite11, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 12, this), (String)"targetGroups");
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "APPLICATIONS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "appName", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "cluster", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "loadBalancerNames", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "targetGroupKeys", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "launchConfig", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "launchTemplate", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "instanceIds", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
            }

            @Generated
            public AsgData getData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cacheServerGroup_closure25.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, serverGroups, IndyInterface.bootstrap("getProperty", "serverGroup", 4, (AsgData)data2.get())), new _cacheServerGroup_closure25(this, this, data2));
    }

    private void cacheLaunchConfig(AsgData data, Map<String, CacheData> launchConfigs) {
        Reference data2 = new Reference((Object)data);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 4, (AsgData)data2.get())) != false) {
            public final class _cacheLaunchConfig_closure26
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference data;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _cacheLaunchConfig_closure26(Object _outerInstance, Object _thisObject, Reference data) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.data = reference = data;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "serverGroup", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                }

                @Generated
                public AsgData getData() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _cacheLaunchConfig_closure26.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, launchConfigs, IndyInterface.bootstrap("getProperty", "launchConfig", 4, (AsgData)data2.get())), new _cacheLaunchConfig_closure26(this, this, data2));
        }
    }

    private void cacheInstances(AsgData data, Map<String, CacheData> instances) {
        Reference data2 = new Reference((Object)data);
        CallSite instance = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "instances", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (AsgData)data2.get()))));
        if (callSite != null) {
            while (callSite.hasNext()) {
                instance = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                public final class _cacheInstances_closure27
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference data;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _cacheInstances_closure27(Object _outerInstance, Object _thisObject, Reference data) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.data = reference = data;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "serverGroup", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                    }

                    @Generated
                    public AsgData getData() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _cacheInstances_closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, instances, IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 0, instance), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region)), new _cacheInstances_closure27(this, this, data2));
            }
        }
    }

    private void cacheLoadBalancers(AsgData data, Map<String, CacheData> loadBalancers) {
        Reference data2 = new Reference((Object)data);
        CallSite loadBalancerName = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "loadBalancerNames", 4, (AsgData)data2.get())));
        if (callSite != null) {
            while (callSite.hasNext()) {
                loadBalancerName = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                public final class _cacheLoadBalancers_closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference data;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _cacheLoadBalancers_closure28(Object _outerInstance, Object _thisObject, Reference data) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.data = reference = data;
                    }

                    public Object doCall(Object it) {
                        IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "APPLICATIONS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "appName", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "serverGroup", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                    }

                    @Generated
                    public AsgData getData() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _cacheLoadBalancers_closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, loadBalancers, loadBalancerName), new _cacheLoadBalancers_closure28(this, this, data2));
            }
        }
    }

    private void cacheTargetGroups(AsgData data, Map<String, CacheData> targetGroups) {
        Reference data2 = new Reference((Object)data);
        CallSite targetGroupKey = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "targetGroupKeys", 4, (AsgData)data2.get())));
        if (callSite != null) {
            while (callSite.hasNext()) {
                targetGroupKey = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                public final class _cacheTargetGroups_closure29
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference data;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _cacheTargetGroups_closure29(Object _outerInstance, Object _thisObject, Reference data) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.data = reference = data;
                    }

                    public Object doCall(Object it) {
                        IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "APPLICATIONS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "appName", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "serverGroup", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                    }

                    @Generated
                    public AsgData getData() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _cacheTargetGroups_closure29.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, targetGroups, targetGroupKey), new _cacheTargetGroups_closure29(this, this, data2));
            }
        }
    }

    private void cacheLaunchTemplate(AsgData data, Map<String, CacheData> launchTemplates) {
        Reference data2 = new Reference((Object)data);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchTemplate", 4, (AsgData)data2.get())) != false) {
            public final class _cacheLaunchTemplate_closure30
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference data;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _cacheLaunchTemplate_closure30(Object _outerInstance, Object _thisObject, Reference data) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.data = reference = data;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "serverGroup", 4, IndyInterface.bootstrap("cast", "()", 0, this.data.get())));
                }

                @Generated
                public AsgData getData() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _cacheLaunchTemplate_closure30.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, launchTemplates, IndyInterface.bootstrap("getProperty", "launchTemplate", 4, (AsgData)data2.get())), new _cacheLaunchTemplate_closure30(this, this, data2));
        }
    }

    private AutoScalingGroup loadAutoScalingGroup(String autoScalingGroupName, boolean skipEdda) {
        CallSite autoScaling = IndyInterface.bootstrap("invoke", "getAutoScaling", 0, this.amazonClientProvider, this.account, this.region, skipEdda);
        CallSite result = IndyInterface.bootstrap("invoke", "describeAutoScalingGroups", 0, autoScaling, IndyInterface.bootstrap("invoke", "withAutoScalingGroupNames", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeAutoScalingGroupsRequest.class), autoScalingGroupName));
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, result)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, result))) == false) {
            CallSite asg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, result), false));
            return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "status", 0, asg), null) ? asg : null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Map buildScalingPolicy(ScalingPolicy scalingPolicy, Map<String, Map> metricAlarms) {
        Reference metricAlarms2 = new Reference(metricAlarms);
        CallSite policy = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, scalingPolicy, Map.class));
        public final class _buildScalingPolicy_closure31
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference metricAlarms;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildScalingPolicy_closure31(Object _outerInstance, Object _thisObject, Reference metricAlarms) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.metricAlarms = reference = metricAlarms;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.metricAlarms.get()), IndyInterface.bootstrap("getProperty", "alarmARN", 0, it));
            }

            @Generated
            public Map getMetricAlarms() {
                return IndyInterface.bootstrap("cast", "()", 0, this.metricAlarms.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildScalingPolicy_closure31.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "findResults", 0, IndyInterface.bootstrap("getProperty", "alarms", 0, scalingPolicy), new _buildScalingPolicy_closure31(this, this, metricAlarms2));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)policy, (String)"alarms");
        return policy;
    }

    private static Map flattenAutoScalingGroup(AutoScalingGroup asg) {
        if (IndyInterface.bootstrap("cast", "()", 0, asg) == false) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"desiredCapacity", IndyInterface.bootstrap("getProperty", "desiredCapacity", 0, asg), "minSize", IndyInterface.bootstrap("getProperty", "minSize", 0, asg), "maxSize", IndyInterface.bootstrap("getProperty", "maxSize", 0, asg), "suspendedProcesses", IndyInterface.bootstrap("invoke", "sort", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(ClusterCachingAgent.class, (Object)IndyInterface.bootstrap("getProperty", "suspendedProcesses", 0, asg), (String)"processName"))});
    }

    private static boolean areSimilarAutoScalingGroups(AutoScalingGroup asg1, AutoScalingGroup asg2) {
        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "flattenAutoScalingGroup", 0, ClusterCachingAgent.class, asg1), (Object)IndyInterface.bootstrap("invoke", "flattenAutoScalingGroup", 0, ClusterCachingAgent.class, asg2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ClusterCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ClusterCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ClusterCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ClusterCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ClusterCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ClusterCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        1 var0;
        ATTRIBUTES = var0 = new 1();
        CallSite callSite = IndyInterface.bootstrap("invoke", "unmodifiableSet", 0, Collections.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "INFORMATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "INFORMATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "APPLICATIONS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "INFORMATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "INFORMATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "INFORMATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "INFORMATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "INFORMATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)))}), Set.class))), Set.class));
        types = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Override
    @Generated
    public final Logger getLog() {
        return this.log;
    }

    @Generated
    public static Set<AgentDataType> getTypes() {
        return types;
    }

    @Generated
    public final AmazonCloudProvider getAmazonCloudProvider() {
        return this.amazonCloudProvider;
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Override
    @Generated
    public final NetflixAmazonCredentials getAccount() {
        return this.account;
    }

    @Override
    @Generated
    public final String getRegion() {
        return this.region;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @Generated
    public final Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public final EddaTimeoutConfig getEddaTimeoutConfig() {
        return this.eddaTimeoutConfig;
    }

    @Generated
    public final AmazonCachingAgentFilter getAmazonCachingAgentFilter() {
        return this.amazonCachingAgentFilter;
    }

    @Generated
    public final OnDemandMetricsSupport getMetricsSupport() {
        return this.metricsSupport;
    }

    public /* synthetic */ Optional super$1$getCacheKeyPatterns() {
        return super.getCacheKeyPatterns();
    }

    public /* synthetic */ Map super$1$pendingOnDemandRequest(ProviderCache providerCache, String string) {
        return super.pendingOnDemandRequest(providerCache, string);
    }

    public static class AmazonClients
    implements GroovyObject {
        private final AmazonAutoScaling autoScaling;
        private final AmazonEC2 amazonEC2;
        private final AmazonCloudWatch amazonCloudWatch;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public AmazonClients(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, boolean skipEdda) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            CallSite callSite = IndyInterface.bootstrap("invoke", "getAutoScaling", 0, amazonClientProvider, account, region, skipEdda);
            this.autoScaling = IndyInterface.bootstrap("cast", "()", 0, callSite);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, amazonClientProvider, account, region, skipEdda);
            this.amazonEC2 = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            CallSite callSite3 = IndyInterface.bootstrap("invoke", "getAmazonCloudWatch", 0, amazonClientProvider, account, region, skipEdda);
            this.amazonCloudWatch = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AmazonClients.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AmazonClients.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AmazonClients.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(AmazonClients.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AmazonClients.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AmazonClients.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AmazonClients.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AmazonClients.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AmazonClients.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AmazonClients.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AmazonClients.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AmazonClients.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final AmazonAutoScaling getAutoScaling() {
            return this.autoScaling;
        }

        @Generated
        public final AmazonEC2 getAmazonEC2() {
            return this.amazonEC2;
        }

        @Generated
        public final AmazonCloudWatch getAmazonCloudWatch() {
            return this.amazonCloudWatch;
        }
    }

    private static class AutoScalingGroupsResults
    implements GroovyObject {
        private Long start;
        private List<AutoScalingGroup> asgs;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public AutoScalingGroupsResults() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AutoScalingGroupsResults.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AutoScalingGroupsResults.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AutoScalingGroupsResults.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(AutoScalingGroupsResults.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AutoScalingGroupsResults.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AutoScalingGroupsResults.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AutoScalingGroupsResults.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AutoScalingGroupsResults.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AutoScalingGroupsResults.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AutoScalingGroupsResults.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AutoScalingGroupsResults.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AutoScalingGroupsResults.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Long getStart() {
            return this.start;
        }

        @Generated
        public void setStart(Long l) {
            this.start = l;
        }

        @Generated
        public List<AutoScalingGroup> getAsgs() {
            return this.asgs;
        }

        @Generated
        public void setAsgs(List<AutoScalingGroup> list) {
            this.asgs = list;
        }
    }

    private static class AsgData
    implements GroovyObject {
        private final AutoScalingGroup asg;
        private final Names name;
        private final String appName;
        private final String cluster;
        private final String serverGroup;
        private final String vpcId;
        private final String launchConfig;
        private final String launchTemplate;
        private final Set<String> loadBalancerNames;
        private final Set<String> targetGroupKeys;
        private final Set<String> targetGroupNames;
        private final Set<String> instanceIds;
        private final List<Map> scalingPolicies;
        private final List<Map> scheduledActions;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public AsgData(AutoScalingGroup asg, List<Map> scalingPolicies, List<Map> scheduledActions, String account, String region, Map<String, String> subnetMap) {
            String string;
            List list;
            List list2;
            AutoScalingGroup autoScalingGroup;
            MetaClass metaClass;
            Reference account2 = new Reference((Object)account);
            Reference region2 = new Reference((Object)region);
            Reference subnetMap2 = new Reference(subnetMap);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.asg = autoScalingGroup = asg;
            List list3 = scalingPolicies;
            this.scalingPolicies = list2 = IndyInterface.bootstrap("cast", "()", 0, list3) != false ? list3 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            List list4 = scheduledActions;
            this.scheduledActions = list = IndyInterface.bootstrap("cast", "()", 0, list4) != false ? list4 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            CallSite callSite = IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asg));
            this.name = IndyInterface.bootstrap("cast", "()", 0, callSite);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "getApplicationKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "app", 0, this.name));
            this.appName = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            CallSite callSite3 = IndyInterface.bootstrap("invoke", "getClusterKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "cluster", 0, this.name), IndyInterface.bootstrap("getProperty", "app", 0, this.name), (String)account2.get());
            this.cluster = IndyInterface.bootstrap("cast", "()", 0, callSite3);
            CallSite callSite4 = IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asg), (String)account2.get(), (String)region2.get());
            this.serverGroup = IndyInterface.bootstrap("cast", "()", 0, callSite4);
            Reference vpcId = new Reference(null);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getVPCZoneIdentifier", 0, asg)) != false) {
                CallSite subnets = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("invoke", "getVPCZoneIdentifier", 0, asg), ","));
                CallSite vpcIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResults", 0, subnets, new _closure1(this, this, subnetMap2)));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, vpcIds), (Object)1)) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{vpcIds, subnets, IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, asg), (String)account2.get(), (String)region2.get()}, new String[]{"failed to resolve only one vpc (found ", ") for subnets ", " in ASG ", " account ", " region ", ""})));
                }
                vpcId.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "first", 0, vpcIds)));
            }
            this.vpcId = string = (String)vpcId.get();
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchTemplate", 0, asg)) != false) {
                CallSite callSite5 = IndyInterface.bootstrap("invoke", "getLaunchTemplateKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "launchTemplateName", 0, IndyInterface.bootstrap("getProperty", "launchTemplate", 0, asg)), (String)account2.get(), (String)region2.get());
                this.launchTemplate = IndyInterface.bootstrap("cast", "()", 0, callSite5);
            } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 0, asg)) != false) {
                CallSite callSite6 = IndyInterface.bootstrap("invoke", "getLaunchTemplateKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "launchTemplateName", 0, IndyInterface.bootstrap("getProperty", "launchTemplateSpecification", 0, IndyInterface.bootstrap("getProperty", "launchTemplate", 0, IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 0, asg)))), (String)account2.get(), (String)region2.get());
                this.launchTemplate = IndyInterface.bootstrap("cast", "()", 0, callSite6);
            } else {
                CallSite callSite7 = IndyInterface.bootstrap("invoke", "getLaunchConfigKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "launchConfigurationName", 0, asg), (String)account2.get(), (String)region2.get());
                this.launchConfig = IndyInterface.bootstrap("cast", "()", 0, callSite7);
            }
            CallSite callSite8 = IndyInterface.bootstrap("invoke", "asImmutable", 0, (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "loadBalancerNames", 0, asg), new _closure2(this, this, account2, region2, vpcId)), Set.class)));
            this.loadBalancerNames = IndyInterface.bootstrap("cast", "()", 0, callSite8);
            CallSite callSite9 = IndyInterface.bootstrap("invoke", "asImmutable", 0, (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "targetGroupARNs", 0, asg), new _closure3(this, this)), Set.class)));
            this.targetGroupNames = IndyInterface.bootstrap("cast", "()", 0, callSite9);
            CallSite callSite10 = IndyInterface.bootstrap("invoke", "asImmutable", 0, (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, this.targetGroupNames, new _closure4(this, this, account2, region2, vpcId)), Set.class)));
            this.targetGroupKeys = IndyInterface.bootstrap("cast", "()", 0, callSite10);
            CallSite callSite11 = IndyInterface.bootstrap("invoke", "asImmutable", 0, (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "instanceId", 0, IndyInterface.bootstrap("getProperty", "instances", 0, asg)), new _closure5(this, this, account2, region2)), Set.class)));
            this.instanceIds = IndyInterface.bootstrap("cast", "()", 0, callSite11);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AsgData.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AsgData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AsgData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(AsgData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AsgData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AsgData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AsgData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AsgData.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AsgData.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AsgData.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AsgData.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AsgData.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final AutoScalingGroup getAsg() {
            return this.asg;
        }

        @Generated
        public final Names getName() {
            return this.name;
        }

        @Generated
        public final String getAppName() {
            return this.appName;
        }

        @Generated
        public final String getCluster() {
            return this.cluster;
        }

        @Generated
        public final String getServerGroup() {
            return this.serverGroup;
        }

        @Generated
        public final String getVpcId() {
            return this.vpcId;
        }

        @Generated
        public final String getLaunchConfig() {
            return this.launchConfig;
        }

        @Generated
        public final String getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Generated
        public final Set<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Generated
        public final Set<String> getTargetGroupKeys() {
            return this.targetGroupKeys;
        }

        @Generated
        public final Set<String> getTargetGroupNames() {
            return this.targetGroupNames;
        }

        @Generated
        public final Set<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Generated
        public final List<Map> getScalingPolicies() {
            return this.scalingPolicies;
        }

        @Generated
        public final List<Map> getScheduledActions() {
            return this.scheduledActions;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference subnetMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject, Reference subnetMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.subnetMap = reference = subnetMap;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.subnetMap.get()), it);
            }

            @Generated
            public Map getSubnetMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.subnetMap.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }

        public final class _closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference vpcId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure2(Object _outerInstance, Object _thisObject, Reference account, Reference region, Reference vpcId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.account = reference3 = account;
                this.region = reference2 = region;
                this.vpcId = reference = vpcId;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, it, IndyInterface.bootstrap("cast", "()", 0, this.account.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get()), IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get()), null);
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            @Generated
            public String getVpcId() {
                return IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }

        public final class _closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "extractTargetGroupName", 0, ArnUtils.class, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }

        public final class _closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference vpcId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure4(Object _outerInstance, Object _thisObject, Reference account, Reference region, Reference vpcId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.account = reference3 = account;
                this.region = reference2 = region;
                this.vpcId = reference = vpcId;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getTargetGroupKey", 0, Keys.class, it, IndyInterface.bootstrap("cast", "()", 0, this.account.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get()), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "Instance", 0, TargetTypeEnum.class)), IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get()));
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            @Generated
            public String getVpcId() {
                return IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }

        public final class _closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference region;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure5(Object _outerInstance, Object _thisObject, Reference account, Reference region) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.account = reference2 = account;
                this.region = reference = region;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, it, IndyInterface.bootstrap("cast", "()", 0, this.account.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get()));
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
    }

    public class 1
    extends TypeReference<Map<String, Object>>
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 1() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(1.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(1.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(1.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }

    public static class MutableCacheData
    implements CacheData,
    GroovyObject {
        private final String id;
        private int ttlSeconds;
        private final Map<String, Object> attributes;
        private final Map<String, Collection<String>> relationships;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public MutableCacheData(String id) {
            String string;
            MetaClass metaClass;
            Map map;
            int n;
            this.ttlSeconds = n = -1;
            this.attributes = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            CallSite callSite = IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _closure1(this, this));
            this.relationships = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.id = string = id;
        }

        @JsonCreator
        public MutableCacheData(@JsonProperty(value="id") String id, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="relationships") Map<String, Collection<String>> relationships) {
            this(id);
            IndyInterface.bootstrap("invoke", "putAll", 0, this.attributes, attributes);
            IndyInterface.bootstrap("invoke", "putAll", 0, this.relationships, relationships);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != MutableCacheData.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ClusterCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), MutableCacheData.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), MutableCacheData.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(MutableCacheData.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(MutableCacheData.class, ClusterCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), MutableCacheData.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final String getId() {
            return this.id;
        }

        @Generated
        public int getTtlSeconds() {
            return this.ttlSeconds;
        }

        @Generated
        public void setTtlSeconds(int n) {
            this.ttlSeconds = n;
        }

        @Generated
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Generated
        public final Map<String, Collection<String>> getRelationships() {
            return this.relationships;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
    }
}

