/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonReservationReport;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonReservationReportBuilder;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonS3DataProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToDoubleFunction;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ReservationReportCachingAgent
implements CachingAgent,
CustomScheduledAgent,
GroovyObject {
    private static final long DEFAULT_POLL_INTERVAL_MILLIS;
    private static final long DEFAULT_TIMEOUT_MILLIS;
    private final Collection<AgentDataType> types;
    private final ExecutorService reservationReportPool;
    private final ApplicationContext ctx;
    private Cache cacheView;
    private final AmazonClientProvider amazonClientProvider;
    private final AmazonS3DataProvider amazonS3DataProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final ObjectMapper objectMapper;
    private final AccountReservationDetailSerializer accountReservationDetailSerializer;
    private final MetricsSupport metricsSupport;
    private final Registry registry;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ReservationReportCachingAgent(Registry registry, AmazonClientProvider amazonClientProvider, AmazonS3DataProvider amazonS3DataProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, ObjectMapper objectMapper, ExecutorService reservationReportPool, ApplicationContext ctx) {
        Registry registry2;
        ApplicationContext applicationContext;
        ExecutorService executorService;
        AmazonS3DataProvider amazonS3DataProvider2;
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("invoke", "unmodifiableCollection", 0, Collections.class, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "RESERVATION_REPORTS", 0, Namespace.class)))}));
        this.types = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        this.amazonS3DataProvider = amazonS3DataProvider2 = amazonS3DataProvider;
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository2 = credentialsRepository;
        this.credentialsRepository = credentialsRepository2;
        CallSite module = IndyInterface.bootstrap("init", "<init>", 0, SimpleModule.class);
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, AccountReservationDetailSerializer.class);
        this.accountReservationDetailSerializer = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        IndyInterface.bootstrap("invoke", "addSerializer", 0, module, AmazonReservationReport.AccountReservationDetail.class, this.accountReservationDetailSerializer);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "registerModule", 0, IndyInterface.bootstrap("invoke", "enable", 0, IndyInterface.bootstrap("invoke", "copy", 0, objectMapper), IndyInterface.bootstrap("getProperty", "WRITE_DATES_AS_TIMESTAMPS", 0, SerializationFeature.class)), module);
        this.objectMapper = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        this.reservationReportPool = executorService = reservationReportPool;
        this.ctx = applicationContext = ctx;
        CallSite callSite4 = IndyInterface.bootstrap("init", "<init>", 0, MetricsSupport.class, objectMapper, registry, new _closure1(this, this));
        this.metricsSupport = IndyInterface.bootstrap("cast", "()", 0, callSite4);
        this.registry = registry2 = registry;
    }

    public long getPollIntervalMillis() {
        return DEFAULT_POLL_INTERVAL_MILLIS;
    }

    public long getTimeoutMillis() {
        return DEFAULT_TIMEOUT_MILLIS;
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, AwsProvider.class));
    }

    public String getAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "simpleName", 0, ReservationReportCachingAgent.class)}, new String[]{"", ""}));
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.types;
    }

    public Collection<NetflixAmazonCredentials> getAccounts() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.credentialsRepository));
    }

    public CacheResult loadData(ProviderCache providerCache) {
        long startTime = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing items in ", ""})) : null;
        Reference reservations = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ConcurrentHashMap.class)));
        Reference errorsByRegion = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ConcurrentHashMap.class)));
        public final class _loadData_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference reservations;
            private /* synthetic */ Reference errorsByRegion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadData_closure2(Object _outerInstance, Object _thisObject, Reference reservations, Reference errorsByRegion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.reservations = reference2 = reservations;
                this.errorsByRegion = reference = errorsByRegion;
            }

            public Object doCall(NetflixAmazonCredentials credential) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "extractReservations", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.reservations.get()), IndyInterface.bootstrap("cast", "()", 0, this.errorsByRegion.get()), credential);
                try {
                    return callSite;
                }
                catch (Exception e) {
                    CallSite callSite2 = IndyInterface.bootstrap("invoke", "recordError", 2, this, IndyInterface.bootstrap("getProperty", "registry", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.errorsByRegion.get()), credential, "*", e);
                    return callSite2;
                }
            }

            @Generated
            public Object call(NetflixAmazonCredentials credential) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, credential);
            }

            @Generated
            public ConcurrentHashMap getReservations() {
                return IndyInterface.bootstrap("cast", "()", 0, this.reservations.get());
            }

            @Generated
            public ConcurrentHashMap getErrorsByRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.errorsByRegion.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "accounts", 12, this), new _loadData_closure2(this, this, reservations, errorsByRegion));
        Reference amazonReservationReport = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, AmazonReservationReport.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"start", IndyInterface.bootstrap("init", "<init>", 0, Date.class, startTime), "end", IndyInterface.bootstrap("init", "<init>", 0, Date.class)})));
        public final class _loadData_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference amazonReservationReport;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadData_closure3(Object _outerInstance, Object _thisObject, Reference amazonReservationReport) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.amazonReservationReport = reference = amazonReservationReport;
            }

            public Object doCall(NetflixAmazonCredentials credentials) {
                return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "accounts", 0, this.amazonReservationReport.get()), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"accountId", IndyInterface.bootstrap("getProperty", "accountId", 0, credentials), "name", IndyInterface.bootstrap("getProperty", "name", 0, credentials), "regions", ScriptBytecodeAdapter.getPropertySpreadSafe(_loadData_closure3.class, (Object)IndyInterface.bootstrap("getProperty", "regions", 0, credentials), (String)"name")}));
            }

            @Generated
            public Object call(NetflixAmazonCredentials credentials) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, credentials);
            }

            @Generated
            public Object getAmazonReservationReport() {
                return this.amazonReservationReport.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "accounts", 12, this), new _loadData_closure3(this, this, amazonReservationReport));
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "values", 0, (ConcurrentHashMap)reservations.get()), false, IndyInterface.bootstrap("init", "<init>", 0, AmazonReservationReport.DescendingOverallReservationDetailComparator.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)amazonReservationReport.get(), (String)"reservations");
        CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, (ConcurrentHashMap)reservations.get()), IndyInterface.bootstrap("getProperty", "agentType", 12, this), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class), startTime)}, new String[]{"Caching ", " items in ", " took ", "ms"})) : null;
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)errorsByRegion.get();
        ScriptBytecodeAdapter.setProperty((Object)concurrentHashMap, null, (Object)amazonReservationReport.get(), (String)"errorsByRegion");
        public final class _loadData_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference errorsByRegion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadData_closure4(Object _outerInstance, Object _thisObject, Reference errorsByRegion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.errorsByRegion = reference = errorsByRegion;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.errorsByRegion.get()), IndyInterface.bootstrap("invoke", "region", 0, it))) == false;
            }

            @Generated
            public ConcurrentHashMap getErrorsByRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.errorsByRegion.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite4 = IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "reservations", 0, amazonReservationReport.get()), new _loadData_closure4(this, this, errorsByRegion));
        ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)amazonReservationReport.get(), (String)"reservations");
        boolean bl = false;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, ReservationReportCachingAgent.class, (GroovyObject)this.accountReservationDetailSerializer, (String)"mergeVpcReservations");
        CallSite v2 = IndyInterface.bootstrap("invoke", "readValue", 0, this.objectMapper, IndyInterface.bootstrap("invoke", "writeValueAsString", 0, IndyInterface.bootstrap("invoke", "writerWithView", 0, this.objectMapper, AmazonReservationReport.Views.V2.class), amazonReservationReport.get()), Map.class);
        CallSite v3 = IndyInterface.bootstrap("invoke", "readValue", 0, this.objectMapper, IndyInterface.bootstrap("invoke", "writeValueAsString", 0, IndyInterface.bootstrap("invoke", "writerWithView", 0, this.objectMapper, AmazonReservationReport.Views.V3.class), IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonReservationReportBuilder.V3.class), this.registry, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, v2, AmazonReservationReport.class))), Map.class);
        Object v4 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        try {
            v4 = IndyInterface.bootstrap("invoke", "readValue", 0, this.objectMapper, IndyInterface.bootstrap("invoke", "writeValueAsString", 0, IndyInterface.bootstrap("invoke", "writerWithView", 0, this.objectMapper, AmazonReservationReport.Views.V4.class), IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonReservationReportBuilder.V4.class), this.amazonS3DataProvider, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, v3, AmazonReservationReport.class))), Map.class);
        }
        catch (Exception e) {
            IndyInterface.bootstrap("invoke", "recordErrorMetric", 0, ReservationReportCachingAgent.class, this.registry, null, null);
            IndyInterface.bootstrap("invoke", "error", 0, log, "Failed to build 'v4' reservation report", e);
        }
        IndyInterface.bootstrap("invoke", "registerMetrics", 0, this.metricsSupport, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, v3, AmazonReservationReport.class));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "RESERVATION_REPORTS", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("init", "<init>", 0, MutableCacheData.class, "v2", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"report", v2}), ScriptBytecodeAdapter.createMap((Object[])new Object[0])), IndyInterface.bootstrap("init", "<init>", 0, MutableCacheData.class, "v2_5", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"report", v3}), ScriptBytecodeAdapter.createMap((Object[])new Object[0])), IndyInterface.bootstrap("init", "<init>", 0, MutableCacheData.class, "v3", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"report", v4}), ScriptBytecodeAdapter.createMap((Object[])new Object[0])), IndyInterface.bootstrap("init", "<init>", 0, MutableCacheData.class, "v4", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"report", v4}), ScriptBytecodeAdapter.createMap((Object[])new Object[0]))})})));
    }

    /*
     * WARNING - void declaration
     */
    public void extractReservations(ConcurrentHashMap<String, AmazonReservationReport.OverallReservationDetail> reservations, ConcurrentHashMap<String, Collection<String>> errorsByRegion, NetflixAmazonCredentials credentials) {
        void var3_3;
        void var2_2;
        Reference reservations2 = new Reference(reservations);
        Reference errorsByRegion2 = new Reference((Object)var2_2);
        Reference credentials2 = new Reference((Object)var3_3);
        public final class _extractReservations_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference reservations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractReservations_closure5(Object _outerInstance, Object _thisObject, Reference reservations) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.reservations = reference = reservations;
            }

            public Object doCall(String region, String availabilityZone, String operatingSystemType, String instanceType) {
                CallSite key = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareEqual((Object)availabilityZone, null) ? IndyInterface.bootstrap("invoke", "join", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{region, operatingSystemType, instanceType}), ":") : IndyInterface.bootstrap("invoke", "join", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{availabilityZone, operatingSystemType, instanceType}), ":"));
                CallSite newOverallReservationDetail = IndyInterface.bootstrap("init", "<init>", 0, AmazonReservationReport.OverallReservationDetail.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"region", region, "availabilityZone", availabilityZone, "os", IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("invoke", "valueOf", 0, AmazonReservationReport.OperatingSystemType.class, ScriptBytecodeAdapter.createPojoWrapper((Object)operatingSystemType, String.class))), "instanceType", instanceType}));
                CallSite existingOverallReservationDetail = IndyInterface.bootstrap("invoke", "putIfAbsent", 0, IndyInterface.bootstrap("cast", "()", 0, this.reservations.get()), key, newOverallReservationDetail);
                if (IndyInterface.bootstrap("cast", "()", 0, existingOverallReservationDetail) != false) {
                    return existingOverallReservationDetail;
                }
                return newOverallReservationDetail;
            }

            @Generated
            public Object call(String region, String availabilityZone, String operatingSystemType, String instanceType) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, region, availabilityZone, operatingSystemType, instanceType);
            }

            @Generated
            public ConcurrentHashMap getReservations() {
                return IndyInterface.bootstrap("cast", "()", 0, this.reservations.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractReservations_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference getReservation = new Reference((Object)new _extractReservations_closure5(this, this, reservations2));
        public final class _extractReservations_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference getReservation;
            private /* synthetic */ Reference errorsByRegion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractReservations_closure6(Object _outerInstance, Object _thisObject, Reference credentials, Reference getReservation, Reference errorsByRegion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.credentials = reference3 = credentials;
                this.getReservation = reference2 = getReservation;
                this.errorsByRegion = reference = errorsByRegion;
            }

            public Object doCall(AmazonCredentials.AWSRegion region) {
                Reference region2 = new Reference((Object)region);
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get())}, new String[]{"Fetching reservation report for ", ":", ""})) : null;
                long startTime = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
                try {
                    CallSite amazonEC2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.credentials.get()), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get()));
                    CallSite cacheView = IndyInterface.bootstrap("invoke", "getCacheView", 2, this);
                    public final class _closure7
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure7(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, it), ReservedInstanceDetails.class);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite reservedInstances = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getAll", 0, cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "RESERVED_INSTANCES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "RESERVED_INSTANCES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getReservedInstancesKey", 0, Keys.class, "*", IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get()))), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)), new _closure7((Object)this, this.getThisObject()));
                    CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class), startTime), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get())}, new String[]{"Took ", "ms to describe reserved instances for ", "/", ""})) : null;
                    public final class _closure8
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure8(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("getProperty", "state", 0, it), "active")) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"Heavy Utilization", "Partial Upfront", "All Upfront", "No Upfront"}), IndyInterface.bootstrap("getProperty", "offeringType", 0, it)));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    public final class _closure9
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference getReservation;
                        private /* synthetic */ Reference region;
                        private /* synthetic */ Reference credentials;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure9(Object _outerInstance, Object _thisObject, Reference getReservation, Reference region, Reference credentials) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.getReservation = reference3 = getReservation;
                            this.region = reference2 = region;
                            this.credentials = reference = credentials;
                        }

                        public Object doCall(Object it) {
                            CallSite osType = IndyInterface.bootstrap("invoke", "operatingSystemType", 2, this, IndyInterface.bootstrap("getProperty", "productDescription", 0, it));
                            CallSite reservation = IndyInterface.bootstrap("invoke", "call", 0, this.getReservation.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.region.get())), IndyInterface.bootstrap("getProperty", "availabilityZone", 0, it), IndyInterface.bootstrap("getProperty", "name", 0, osType), IndyInterface.bootstrap("getProperty", "instanceType", 0, it));
                            IndyInterface.bootstrap("invoke", "addAndGet", 0, IndyInterface.bootstrap("getProperty", "totalReserved", 0, reservation), IndyInterface.bootstrap("getProperty", "instanceCount", 0, it));
                            return IndyInterface.bootstrap("invoke", "addAndGet", 0, IndyInterface.bootstrap("getProperty", "reservedVpc", 0, IndyInterface.bootstrap("invoke", "getAccount", 0, reservation, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())))), IndyInterface.bootstrap("getProperty", "instanceCount", 0, it));
                        }

                        @Generated
                        public Object getGetReservation() {
                            return this.getReservation.get();
                        }

                        @Generated
                        public AmazonCredentials.AWSRegion getRegion() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                        }

                        @Generated
                        public NetflixAmazonCredentials getCredentials() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure9.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "findAll", 0, reservedInstances, new _closure8((Object)this, this.getThisObject())), new _closure9((Object)this, this.getThisObject(), this.getReservation, region2, this.credentials));
                    startTime = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
                    Reference fetchedInstanceCount = new Reference((Object)0);
                    CallSite describeInstancesRequest = IndyInterface.bootstrap("invoke", "withMaxResults", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeInstancesRequest.class), 500);
                    Reference allowedStates = new Reference((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"pending", "running"}), Set.class))));
                    while (true) {
                        CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get())}, new String[]{"Describing instances for ", "/", ""})) : null;
                        CallSite result = IndyInterface.bootstrap("invoke", "describeInstances", 0, amazonEC2, describeInstancesRequest);
                        CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get())}, new String[]{"Described instances for ", "/", ""})) : null;
                        public final class _closure10
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference allowedStates;
                            private /* synthetic */ Reference getReservation;
                            private /* synthetic */ Reference credentials;
                            private /* synthetic */ Reference fetchedInstanceCount;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure10(Object _outerInstance, Object _thisObject, Reference allowedStates, Reference getReservation, Reference credentials, Reference fetchedInstanceCount) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                this.allowedStates = reference4 = allowedStates;
                                this.getReservation = reference3 = getReservation;
                                this.credentials = reference2 = credentials;
                                this.fetchedInstanceCount = reference = fetchedInstanceCount;
                            }

                            public Object doCall(Object it) {
                                public final class _closure11
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference allowedStates;
                                    private /* synthetic */ Reference getReservation;
                                    private /* synthetic */ Reference credentials;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure11(Object _outerInstance, Object _thisObject, Reference allowedStates, Reference getReservation, Reference credentials) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        Reference reference3;
                                        this.allowedStates = reference3 = allowedStates;
                                        this.getReservation = reference2 = getReservation;
                                        this.credentials = reference = credentials;
                                    }

                                    public Object doCall(Object it) {
                                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.allowedStates.get(), IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "state", 0, it))))) == false) {
                                            return null;
                                        }
                                        CallSite osTypeName = IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("invoke", "operatingSystemType", 2, this, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "platform", 0, it)) != false ? "Windows" : "Linux/UNIX"));
                                        CallSite reservation = IndyInterface.bootstrap("invoke", "call", 0, this.getReservation.get(), IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "availabilityZone", 0, IndyInterface.bootstrap("getProperty", "placement", 0, it)), ScriptBytecodeAdapter.createRange((Object)0, (Object)-2, (boolean)false, (boolean)false)), IndyInterface.bootstrap("getProperty", "availabilityZone", 0, IndyInterface.bootstrap("getProperty", "placement", 0, it)), osTypeName, IndyInterface.bootstrap("getProperty", "instanceType", 0, it));
                                        IndyInterface.bootstrap("invoke", "incrementAndGet", 0, IndyInterface.bootstrap("getProperty", "totalUsed", 0, reservation));
                                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "vpcId", 0, it)) != false) {
                                            return IndyInterface.bootstrap("invoke", "incrementAndGet", 0, IndyInterface.bootstrap("getProperty", "usedVpc", 0, IndyInterface.bootstrap("invoke", "getAccount", 0, reservation, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())))));
                                        }
                                        return IndyInterface.bootstrap("invoke", "incrementAndGet", 0, IndyInterface.bootstrap("getProperty", "used", 0, IndyInterface.bootstrap("invoke", "getAccount", 0, reservation, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())))));
                                    }

                                    @Generated
                                    public Object getAllowedStates() {
                                        return this.allowedStates.get();
                                    }

                                    @Generated
                                    public Object getGetReservation() {
                                        return this.getReservation.get();
                                    }

                                    @Generated
                                    public NetflixAmazonCredentials getCredentials() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
                                    }

                                    @Generated
                                    public Object doCall() {
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getInstances", 0, it), new _closure11((Object)this, this.getThisObject(), this.allowedStates, this.getReservation, this.credentials));
                                CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, this.fetchedInstanceCount.get(), IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "getInstances", 0, it)));
                                this.fetchedInstanceCount.set((Object)callSite);
                                return callSite;
                            }

                            @Generated
                            public Object getAllowedStates() {
                                return this.allowedStates.get();
                            }

                            @Generated
                            public Object getGetReservation() {
                                return this.getReservation.get();
                            }

                            @Generated
                            public NetflixAmazonCredentials getCredentials() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
                            }

                            @Generated
                            public Object getFetchedInstanceCount() {
                                return this.fetchedInstanceCount.get();
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure10.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "reservations", 0, result), new _closure10((Object)this, this.getThisObject(), allowedStates, this.getReservation, this.credentials, fetchedInstanceCount));
                        CallSite callSite5 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{fetchedInstanceCount.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get()), IndyInterface.bootstrap("getProperty", "nextToken", 0, result)}, new String[]{"Fetched ", " instances in ", "/", " (nextToken: ", ")"})) : null;
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextToken", 0, result)) != false) {
                            IndyInterface.bootstrap("invoke", "withNextToken", 0, describeInstancesRequest, IndyInterface.bootstrap("getProperty", "nextToken", 0, result));
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    IndyInterface.bootstrap("invoke", "recordError", 2, this, IndyInterface.bootstrap("getProperty", "registry", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.errorsByRegion.get()), IndyInterface.bootstrap("cast", "()", 0, this.credentials.get()), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get()), e);
                }
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class), startTime), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get())}, new String[]{"Took ", "ms to describe instances for ", "/", ""})) : null;
            }

            @Generated
            public Object call(AmazonCredentials.AWSRegion region) {
                Reference region2 = new Reference((Object)region);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (AmazonCredentials.AWSRegion)region2.get());
            }

            @Generated
            public NetflixAmazonCredentials getCredentials() {
                return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
            }

            @Generated
            public Object getGetReservation() {
                return this.getReservation.get();
            }

            @Generated
            public ConcurrentHashMap getErrorsByRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.errorsByRegion.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractReservations_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "regions", 0, (NetflixAmazonCredentials)((Object)credentials2.get())), new _extractReservations_closure6(this, this, credentials2, getReservation, errorsByRegion2));
    }

    public static void recordError(Registry registry, ConcurrentHashMap<String, Collection<String>> errorsByRegion, NetflixAmazonCredentials credentials, String region, Exception e) {
        String errorMessage = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, credentials), region, IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Failed to describe instances in ", ":", ", reason: ", ""}), String.class));
        IndyInterface.bootstrap("invoke", "error", 0, log, errorMessage, e);
        CallSite errors = IndyInterface.bootstrap("init", "<init>", 0, CopyOnWriteArrayList.class, ScriptBytecodeAdapter.createList((Object[])new Object[]{errorMessage}));
        CallSite previousValue = IndyInterface.bootstrap("invoke", "putIfAbsent", 0, errorsByRegion, region, errors);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)previousValue, null)) {
            IndyInterface.bootstrap("invoke", "add", 0, previousValue, errorMessage);
        }
        IndyInterface.bootstrap("invoke", "recordErrorMetric", 0, ReservationReportCachingAgent.class, registry, IndyInterface.bootstrap("getProperty", "name", 0, credentials), region);
    }

    public static void recordErrorMetric(Registry registry, String account, String region) {
        CallSite id = IndyInterface.bootstrap("invoke", "createId", 0, registry, "reservedInstances.errors");
        if (IndyInterface.bootstrap("cast", "()", 0, account) != false) {
            id = IndyInterface.bootstrap("invoke", "withTag", 0, id, "account", account);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, region) != false) {
            id = IndyInterface.bootstrap("invoke", "withTag", 0, id, "region", region);
        }
        IndyInterface.bootstrap("invoke", "increment", 0, IndyInterface.bootstrap("invoke", "counter", 0, registry, id));
    }

    public static AmazonReservationReport.OperatingSystemType operatingSystemType(String productDescription) {
        CallSite callSite = IndyInterface.bootstrap("invoke", "toUpperCase", 0, productDescription);
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, "Linux/UNIX"))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "LINUX", 0, AmazonReservationReport.OperatingSystemType.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, "Linux/UNIX (Amazon VPC)"))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "LINUX_VPC", 0, AmazonReservationReport.OperatingSystemType.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, "Windows"))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "WINDOWS", 0, AmazonReservationReport.OperatingSystemType.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, "Windows (Amazon VPC)"))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "WINDOWS_VPC", 0, AmazonReservationReport.OperatingSystemType.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, "Red Hat Enterprise Linux"))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "RHEL", 0, AmazonReservationReport.OperatingSystemType.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, "Windows with SQL Server Standard"))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "WINDOWS_SQL_SERVER", 0, AmazonReservationReport.OperatingSystemType.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("invoke", "toUpperCase", 0, "Windows BYOL (Amazon VPC)"))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "WINDOWS_VPC_BYOL", 0, AmazonReservationReport.OperatingSystemType.class));
        }
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "error", 0, log, new GStringImpl(new Object[]{productDescription}, new String[]{"Unknown product description (", ")"})) : null;
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "UNKNOWN", 0, AmazonReservationReport.OperatingSystemType.class));
    }

    private Cache getCacheView() {
        if (IndyInterface.bootstrap("cast", "()", 0, this.cacheView) == false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "getBean", 0, this.ctx, Cache.class);
            this.cacheView = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        return this.cacheView;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ReservationReportCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReservationReportCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReservationReportCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReservationReportCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ReservationReportCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ReservationReportCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class), true);
        DEFAULT_POLL_INTERVAL_MILLIS = DefaultTypeTransformation.longUnbox((Object)callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class), 5);
        DEFAULT_TIMEOUT_MILLIS = DefaultTypeTransformation.longUnbox((Object)callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.provider.agent.ReservationReportCachingAgent");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite3);
    }

    @Generated
    public final Collection<AgentDataType> getTypes() {
        return this.types;
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public final AmazonS3DataProvider getAmazonS3DataProvider() {
        return this.amazonS3DataProvider;
    }

    @Generated
    public final CredentialsRepository<NetflixAmazonCredentials> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public final AccountReservationDetailSerializer getAccountReservationDetailSerializer() {
        return this.accountReservationDetailSerializer;
    }

    @Generated
    public final MetricsSupport getMetricsSupport() {
        return this.metricsSupport;
    }

    @Generated
    public final Registry getRegistry() {
        return this.registry;
    }

    public static class AccountReservationDetailSerializer
    extends JsonSerializer<AmazonReservationReport.AccountReservationDetail>
    implements GroovyObject {
        private ObjectMapper objectMapper;
        private boolean mergeVpcReservations;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public AccountReservationDetailSerializer() {
            MetaClass metaClass;
            CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ObjectMapper.class);
            this.objectMapper = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void serialize(AmazonReservationReport.AccountReservationDetail value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            if (this.mergeVpcReservations) {
                value = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonReservationReport.AccountReservationDetail.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"reserved", IndyInterface.bootstrap("init", "<init>", 0, AtomicInteger.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "intValue", 0, IndyInterface.bootstrap("getProperty", "reserved", 4, value)), IndyInterface.bootstrap("invoke", "intValue", 0, IndyInterface.bootstrap("getProperty", "reservedVpc", 4, value)))), "used", IndyInterface.bootstrap("init", "<init>", 0, AtomicInteger.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "intValue", 0, IndyInterface.bootstrap("getProperty", "used", 4, value)), IndyInterface.bootstrap("invoke", "intValue", 0, IndyInterface.bootstrap("getProperty", "usedVpc", 4, value)))), "reservedVpc", null, "usedVpc", null})));
            }
            IndyInterface.bootstrap("invoke", "writeObject", 0, gen, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, value, Map.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != AccountReservationDetailSerializer.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AccountReservationDetailSerializer.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AccountReservationDetailSerializer.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AccountReservationDetailSerializer.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        @Generated
        public void setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Generated
        public boolean getMergeVpcReservations() {
            return this.mergeVpcReservations;
        }

        @Generated
        public boolean isMergeVpcReservations() {
            return this.mergeVpcReservations;
        }

        @Generated
        public void setMergeVpcReservations(boolean bl) {
            this.mergeVpcReservations = bl;
        }
    }

    public static class MetricsSupport
    implements GroovyObject {
        private final LoadingCache<String, AmazonReservationReport> reservationReportCache;
        private final Map<String, Id> existingMetricIds;
        private final ObjectMapper objectMapper;
        private final Registry registry;
        private final Closure<Cache> cache;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public MetricsSupport(ObjectMapper objectMapper, Registry registry, Closure<Cache> cache) {
            ObjectMapper objectMapper2;
            Registry registry2;
            MetaClass metaClass;
            CallSite callSite = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "expireAfterWrite", 0, IndyInterface.bootstrap("invoke", "maximumSize", 0, IndyInterface.bootstrap("invoke", "weakKeys", 0, IndyInterface.bootstrap("invoke", "concurrencyLevel", 0, IndyInterface.bootstrap("invoke", "newBuilder", 0, CacheBuilder.class), true)), true), 15, IndyInterface.bootstrap("getProperty", "SECONDS", 0, TimeUnit.class)), new 1(this));
            this.reservationReportCache = IndyInterface.bootstrap("cast", "()", 0, callSite);
            CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, ConcurrentHashMap.class);
            this.existingMetricIds = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.registry = registry2 = registry;
            this.objectMapper = objectMapper2 = objectMapper;
            Closure<Cache> closure = cache;
            this.cache = closure;
        }

        /*
         * WARNING - void declaration
         */
        private void registerMetric(String name, Map<String, String> tags, Closure metricValueClosure) {
            void var3_3;
            Reference tags2 = new Reference(tags);
            Reference metricValueClosure2 = new Reference((Object)var3_3);
            CallSite id = IndyInterface.bootstrap("invoke", "withTags", 0, IndyInterface.bootstrap("invoke", "createId", 0, this.registry, name), (Map)tags2.get());
            CallSite existingId = IndyInterface.bootstrap("invoke", "putIfAbsent", 0, this.existingMetricIds, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, name, ":"), IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "values", 0, (Map)tags2.get())), ":")), id);
            if (IndyInterface.bootstrap("cast", "()", 0, existingId) == false) {
                public final class _registerMetric_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tags;
                    private /* synthetic */ Reference metricValueClosure;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _registerMetric_closure1(Object _outerInstance, Object _thisObject, Reference tags, Reference metricValueClosure) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.tags = reference2 = tags;
                        this.metricValueClosure = reference = metricValueClosure;
                    }

                    public Object doCall(LoadingCache<String, AmazonReservationReport> reservationReportCache) {
                        public final class _closure3
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference tags;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure3(Object _outerInstance, Object _thisObject, Reference tags) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.tags = reference = tags;
                            }

                            public Object doCall(Object it) {
                                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "availabilityZone", 0, it), (Object)IndyInterface.bootstrap("getProperty", "availabilityZone", 0, IndyInterface.bootstrap("cast", "()", 0, this.tags.get()))) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "instanceType", 0, it), (Object)IndyInterface.bootstrap("getProperty", "instanceType", 0, IndyInterface.bootstrap("cast", "()", 0, this.tags.get()))) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "os", 0, it)), (Object)IndyInterface.bootstrap("getProperty", "os", 0, IndyInterface.bootstrap("cast", "()", 0, this.tags.get()))) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "region", 0, it), (Object)IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("cast", "()", 0, this.tags.get())));
                            }

                            @Generated
                            public Map getTags() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.tags.get());
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure3.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite overallReservationDetail = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "reservations", 0, IndyInterface.bootstrap("invoke", "get", 0, reservationReportCache, "v3")), new _closure3((Object)this, this.getThisObject(), this.tags));
                        return IndyInterface.bootstrap("invoke", "call", 0, IndyInterface.bootstrap("cast", "()", 0, this.metricValueClosure.get()), overallReservationDetail);
                    }

                    @Generated
                    public Object call(LoadingCache<String, AmazonReservationReport> reservationReportCache) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, reservationReportCache);
                    }

                    @Generated
                    public Map getTags() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.tags.get());
                    }

                    @Generated
                    public Closure getMetricValueClosure() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.metricValueClosure.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _registerMetric_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "gauge", 0, this.registry, id, this.reservationReportCache, ScriptBytecodeAdapter.createPojoWrapper((Object)((ToDoubleFunction)((Object)IndyInterface.bootstrap("invoke", "asType", 0, new _registerMetric_closure1(this, this, tags2, metricValueClosure2), ToDoubleFunction.class))), ToDoubleFunction.class));
            }
        }

        public void registerMetrics(AmazonReservationReport reservationReport) {
            public final class _registerMetrics_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _registerMetrics_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(AmazonReservationReport.OverallReservationDetail overallReservationDetail) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "availabilityZone", 4, overallReservationDetail);
                    Reference baseTags = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"availabilityZone", IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "n/a", "instanceType", IndyInterface.bootstrap("getProperty", "instanceType", 4, overallReservationDetail), "os", IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "os", 4, overallReservationDetail)), "region", IndyInterface.bootstrap("invoke", "region", 0, overallReservationDetail)}));
                    public final class _closure4
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure4(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(AmazonReservationReport.OverallReservationDetail o) {
                            CallSite callSite = IndyInterface.bootstrap("invoke", "totalSurplus", 1, o);
                            return (Double)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0), Double.class));
                        }

                        @Generated
                        public Object call(AmazonReservationReport.OverallReservationDetail o) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, o);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "registerMetric", 2, this, "reservedInstances.surplusOverall", baseTags.get(), new _closure4((Object)this, this.getThisObject()));
                    public final class _closure5
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference baseTags;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure5(Object _outerInstance, Object _thisObject, Reference baseTags) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.baseTags = reference = baseTags;
                        }

                        public Object doCall(String accountName, AmazonReservationReport.AccountReservationDetail reservationDetail) {
                            Reference accountName2 = new Reference((Object)accountName);
                            public final class _closure6
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference accountName;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure6(Object _outerInstance, Object _thisObject, Reference accountName) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.accountName = reference = accountName;
                                }

                                public Object doCall(AmazonReservationReport.OverallReservationDetail o) {
                                    CallSite callSite = IndyInterface.bootstrap("invoke", "surplusVpc", 1, IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "accounts", 5, o), IndyInterface.bootstrap("cast", "()", 0, this.accountName.get())));
                                    return (Double)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0), Double.class));
                                }

                                @Generated
                                public Object call(AmazonReservationReport.OverallReservationDetail o) {
                                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, o);
                                }

                                @Generated
                                public String getAccountName() {
                                    return IndyInterface.bootstrap("cast", "()", 0, this.accountName.get());
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure6.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            IndyInterface.bootstrap("invoke", "registerMetric", 2, this, "reservedInstances.surplusByAccountVpc", IndyInterface.bootstrap("invoke", "plus", 0, this.baseTags.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", (String)accountName2.get()})), new _closure6((Object)this, this.getThisObject(), accountName2));
                            public final class _closure7
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference accountName;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure7(Object _outerInstance, Object _thisObject, Reference accountName) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.accountName = reference = accountName;
                                }

                                public Object doCall(AmazonReservationReport.OverallReservationDetail o) {
                                    CallSite callSite = IndyInterface.bootstrap("invoke", "surplus", 1, IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "accounts", 5, o), IndyInterface.bootstrap("cast", "()", 0, this.accountName.get())));
                                    return (Double)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0), Double.class));
                                }

                                @Generated
                                public Object call(AmazonReservationReport.OverallReservationDetail o) {
                                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, o);
                                }

                                @Generated
                                public String getAccountName() {
                                    return IndyInterface.bootstrap("cast", "()", 0, this.accountName.get());
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure7.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            return IndyInterface.bootstrap("invoke", "registerMetric", 2, this, "reservedInstances.surplusByAccountClassic", IndyInterface.bootstrap("invoke", "plus", 0, this.baseTags.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", (String)accountName2.get()})), new _closure7((Object)this, this.getThisObject(), accountName2));
                        }

                        @Generated
                        public Object call(String accountName, AmazonReservationReport.AccountReservationDetail reservationDetail) {
                            Reference accountName2 = new Reference((Object)accountName);
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, (String)accountName2.get(), reservationDetail);
                        }

                        @Generated
                        public Object getBaseTags() {
                            return this.baseTags.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure5.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "accounts", 4, overallReservationDetail), new _closure5((Object)this, this.getThisObject(), baseTags));
                }

                @Generated
                public Object call(AmazonReservationReport.OverallReservationDetail overallReservationDetail) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, overallReservationDetail);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _registerMetrics_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "reservations", 4, reservationReport), new _registerMetrics_closure2(this, this));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != MetricsSupport.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MetricsSupport.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MetricsSupport.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            }
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MetricsSupport.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, MetricsSupport.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(MetricsSupport.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), MetricsSupport.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), MetricsSupport.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(MetricsSupport.class, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(MetricsSupport.class, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), MetricsSupport.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public class 1
        extends CacheLoader<String, AmazonReservationReport>
        implements GroovyObject {
            final /* synthetic */ MetricsSupport this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;

            /* synthetic */ 1(MetricsSupport p0) {
                MetaClass metaClass;
                MetricsSupport metricsSupport;
                this.this$0 = metricsSupport = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public AmazonReservationReport load(String key) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "call", 0, IndyInterface.bootstrap("getProperty", "cache", 12, this)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "RESERVATION_REPORTS", 0, Namespace.class)), key)), "report"), Map.class))), Map.class), AmazonReservationReport.class));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                try {
                    return this.this$0.this$dist$invoke$1(name, args);
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
                }
            }

            /*
             * Unable to fully structure code
             */
            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[] == false)) ** GOTO lbl8
                var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, MetricsSupport.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                return var2_2;
lbl8:
                // 1 sources

                if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
                var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, MetricsSupport.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
                return var3_3;
lbl14:
                // 1 sources

                var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, MetricsSupport.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                try {
                    return var4_4;
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
                }
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                try {
                    this.this$0.this$dist$set$1(name, value);
                    return;
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                try {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, MetricsSupport.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public /* synthetic */ Object propertyMissing(String name) {
                try {
                    return this.this$0.this$dist$get$1(name);
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                Object object = ScriptBytecodeAdapter.getProperty(1.class, MetricsSupport.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                try {
                    return object;
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
    }

    public static class MutableCacheData
    implements CacheData,
    GroovyObject {
        private final String id;
        private int ttlSeconds;
        private final Map<String, Object> attributes;
        private final Map<String, Collection<String>> relationships;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public MutableCacheData(String id) {
            String string;
            MetaClass metaClass;
            Map map;
            int n;
            this.ttlSeconds = n = -1;
            this.attributes = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            CallSite callSite = IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _closure1(this, this));
            this.relationships = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.id = string = id;
        }

        @JsonCreator
        public MutableCacheData(@JsonProperty(value="id") String id, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="relationships") Map<String, Collection<String>> relationships) {
            this(id);
            IndyInterface.bootstrap("invoke", "putAll", 0, this.attributes, attributes);
            IndyInterface.bootstrap("invoke", "putAll", 0, this.relationships, relationships);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != MutableCacheData.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), MutableCacheData.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), MutableCacheData.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(MutableCacheData.class, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(MutableCacheData.class, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), MutableCacheData.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final String getId() {
            return this.id;
        }

        @Generated
        public int getTtlSeconds() {
            return this.ttlSeconds;
        }

        @Generated
        public void setTtlSeconds(int n) {
            this.ttlSeconds = n;
        }

        @Generated
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Generated
        public final Map<String, Collection<String>> getRelationships() {
            return this.relationships;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
    }

    public static class ReservedInstanceDetails
    implements GroovyObject {
        private String state;
        private String offeringType;
        private String productDescription;
        private String availabilityZone;
        private String region;
        private String instanceType;
        private int instanceCount;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ReservedInstanceDetails() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ReservedInstanceDetails.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), ReservedInstanceDetails.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ReservedInstanceDetails.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ReservedInstanceDetails.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public void setState(String string) {
            this.state = string;
        }

        @Generated
        public String getOfferingType() {
            return this.offeringType;
        }

        @Generated
        public void setOfferingType(String string) {
            this.offeringType = string;
        }

        @Generated
        public String getProductDescription() {
            return this.productDescription;
        }

        @Generated
        public void setProductDescription(String string) {
            this.productDescription = string;
        }

        @Generated
        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Generated
        public void setAvailabilityZone(String string) {
            this.availabilityZone = string;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public void setRegion(String string) {
            this.region = string;
        }

        @Generated
        public String getInstanceType() {
            return this.instanceType;
        }

        @Generated
        public void setInstanceType(String string) {
            this.instanceType = string;
        }

        @Generated
        public int getInstanceCount() {
            return this.instanceCount;
        }

        @Generated
        public void setInstanceCount(int n) {
            this.instanceCount = n;
        }
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return IndyInterface.bootstrap("invoke", "getCacheView", 2, this);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

