/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentProvider;
import com.netflix.spinnaker.cats.provider.Provider;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.AwsConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.agent.CleanupAlarmsAgent;
import com.netflix.spinnaker.clouddriver.aws.agent.CleanupDetachedInstancesAgent;
import com.netflix.spinnaker.clouddriver.aws.agent.ReconcileClassicLinkSecurityGroupsAgent;
import com.netflix.spinnaker.clouddriver.aws.edda.EddaApiFactory;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsCleanupProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonApplicationLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonCachingAgentFilter;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonCertificateCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonCloudFormationCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonElasticIpCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonInstanceTypeCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonKeyPairCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonLaunchTemplateCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonLoadBalancerInstanceStateCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonSecurityGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonSubnetCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonVpcCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.ClusterCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.ClusterCleanupAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.EddaLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.ImageCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.InstanceCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.LaunchConfigCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.ReservedInstancesCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonS3DataProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.EddaTimeoutConfig;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.security.ProviderUtils;
import com.netflix.spinnaker.config.AwsConfiguration;
import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.springframework.context.ApplicationContext;

public class ProviderHelpers {
    public static BuildResult buildAwsInfrastructureAgents(NetflixAmazonCredentials credentials, AwsInfrastructureProvider awsInfrastructureProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, AmazonClientProvider amazonClientProvider, ObjectMapper amazonObjectMapper, Registry registry, EddaTimeoutConfig eddaTimeoutConfig, Set<String> regions) {
        Set scheduledAccounts = ProviderUtils.getScheduledAccounts((Provider)awsInfrastructureProvider);
        ArrayList<Agent> newlyAddedAgents = new ArrayList<Agent>();
        for (AmazonCredentials.AWSRegion region : credentials.getRegions()) {
            if (scheduledAccounts.contains(credentials.getName())) continue;
            if (regions.add(region.getName())) {
                newlyAddedAgents.add((Agent)new AmazonInstanceTypeCachingAgent(region.getName(), amazonClientProvider, credentials, amazonObjectMapper));
            }
            newlyAddedAgents.add((Agent)new AmazonElasticIpCachingAgent(amazonClientProvider, credentials, region.getName()));
            newlyAddedAgents.add((Agent)new AmazonKeyPairCachingAgent(amazonClientProvider, credentials, region.getName()));
            newlyAddedAgents.add((Agent)new AmazonSecurityGroupCachingAgent(amazonClientProvider, credentials, region.getName(), amazonObjectMapper, registry, eddaTimeoutConfig));
            newlyAddedAgents.add((Agent)new AmazonSubnetCachingAgent(amazonClientProvider, credentials, region.getName(), amazonObjectMapper));
            newlyAddedAgents.add((Agent)new AmazonVpcCachingAgent(amazonClientProvider, credentials, region.getName(), amazonObjectMapper));
        }
        return new BuildResult(newlyAddedAgents, regions);
    }

    public static BuildResult buildAwsProviderAgents(NetflixAmazonCredentials credentials, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, AmazonClientProvider amazonClientProvider, ObjectMapper objectMapper, Registry registry, EddaTimeoutConfig eddaTimeoutConfig, AmazonCachingAgentFilter amazonCachingAgentFilter, AwsProvider awsProvider, AmazonCloudProvider amazonCloudProvider, DynamicConfigService dynamicConfigService, EddaApiFactory eddaApiFactory, Optional<ExecutorService> reservationReportPool, Optional<Collection<AgentProvider>> agentProviders, ApplicationContext ctx, AmazonS3DataProvider amazonS3DataProvider, Set<String> publicRegions) {
        Set scheduledAccounts = ProviderUtils.getScheduledAccounts((Provider)awsProvider);
        ArrayList<Agent> newlyAddedAgents = new ArrayList<Agent>();
        newlyAddedAgents.add((Agent)new ClusterCleanupAgent());
        for (AmazonCredentials.AWSRegion region : credentials.getRegions()) {
            if (scheduledAccounts.contains(credentials.getName())) continue;
            newlyAddedAgents.add((Agent)new ClusterCachingAgent(amazonCloudProvider, amazonClientProvider, credentials, region.getName(), objectMapper, registry, eddaTimeoutConfig, amazonCachingAgentFilter));
            newlyAddedAgents.add((Agent)new LaunchConfigCachingAgent(amazonClientProvider, credentials, region.getName(), objectMapper, registry));
            newlyAddedAgents.add((Agent)new ImageCachingAgent(amazonClientProvider, credentials, region.getName(), objectMapper, registry, false, dynamicConfigService));
            if (!publicRegions.contains(region.getName())) {
                publicRegions.add(region.getName());
                newlyAddedAgents.add((Agent)new ImageCachingAgent(amazonClientProvider, credentials, region.getName(), objectMapper, registry, true, dynamicConfigService));
            }
            newlyAddedAgents.add((Agent)new InstanceCachingAgent(amazonClientProvider, credentials, region.getName(), objectMapper, registry));
            newlyAddedAgents.add((Agent)new AmazonLoadBalancerCachingAgent(amazonCloudProvider, amazonClientProvider, credentials, region.getName(), eddaApiFactory.createApi(credentials.getEdda(), region.getName()), objectMapper, registry, amazonCachingAgentFilter));
            newlyAddedAgents.add((Agent)new AmazonApplicationLoadBalancerCachingAgent(amazonCloudProvider, amazonClientProvider, credentials, region.getName(), eddaApiFactory.createApi(credentials.getEdda(), region.getName()), objectMapper, registry, eddaTimeoutConfig, amazonCachingAgentFilter));
            newlyAddedAgents.add((Agent)new ReservedInstancesCachingAgent(amazonClientProvider, credentials, region.getName(), objectMapper, registry));
            newlyAddedAgents.add((Agent)new AmazonCertificateCachingAgent(amazonClientProvider, credentials, region.getName(), objectMapper, registry));
            if (dynamicConfigService.isEnabled("aws.features.cloud-formation", false)) {
                newlyAddedAgents.add((Agent)new AmazonCloudFormationCachingAgent(amazonClientProvider, credentials, region.getName(), registry));
            }
            if (credentials.isEddaEnabled() && !eddaTimeoutConfig.getDisabledRegions().contains(region.getName())) {
                newlyAddedAgents.add((Agent)new EddaLoadBalancerCachingAgent(eddaApiFactory.createApi(credentials.getEdda(), region.getName()), credentials, region.getName(), objectMapper));
            } else {
                newlyAddedAgents.add((Agent)new AmazonLoadBalancerInstanceStateCachingAgent(amazonClientProvider, credentials, region.getName(), objectMapper, ctx));
            }
            if (!dynamicConfigService.isEnabled("aws.features.launch-templates", false)) continue;
            newlyAddedAgents.add((Agent)new AmazonLaunchTemplateCachingAgent(amazonClientProvider, credentials, region.getName(), objectMapper, registry));
        }
        agentProviders.ifPresent(providers -> providers.stream().filter(it -> it.supports(AwsProvider.PROVIDER_NAME)).forEach(provider -> newlyAddedAgents.addAll(provider.agents((Credentials)credentials))));
        return new BuildResult(newlyAddedAgents, publicRegions);
    }

    public static List<Agent> buildAwsCleanupAgents(NetflixAmazonCredentials credentials, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, AmazonClientProvider amazonClientProvider, AwsCleanupProvider awsCleanupProvider, AwsConfiguration.DeployDefaults deployDefaults, AwsConfigurationProperties awsConfigurationProperties, boolean hasPreviouslyScheduledCleanupAgents) {
        Set scheduledAccounts = ProviderUtils.getScheduledAccounts((Provider)awsCleanupProvider);
        ArrayList<Agent> newlyAddedAgents = new ArrayList<Agent>();
        if (!scheduledAccounts.contains(credentials.getName())) {
            for (AmazonCredentials.AWSRegion region : credentials.getRegions()) {
                if (!deployDefaults.isReconcileClassicLinkAccount(credentials)) continue;
                newlyAddedAgents.add((Agent)new ReconcileClassicLinkSecurityGroupsAgent(amazonClientProvider, credentials, region.getName(), deployDefaults));
            }
        }
        if (!hasPreviouslyScheduledCleanupAgents) {
            if (awsConfigurationProperties.getCleanup().getAlarms().getEnabled()) {
                newlyAddedAgents.add((Agent)new CleanupAlarmsAgent(amazonClientProvider, credentialsRepository, awsConfigurationProperties.getCleanup().getAlarms().getDaysToKeep(), awsConfigurationProperties.getCleanup().getAlarms().getAlarmsNamePattern()));
            }
            newlyAddedAgents.add((Agent)new CleanupDetachedInstancesAgent(amazonClientProvider, credentialsRepository));
        }
        return newlyAddedAgents;
    }

    public static class BuildResult {
        private final List<Agent> agents;
        private final Set<String> regionsToAdd;

        @Generated
        public List<Agent> getAgents() {
            return this.agents;
        }

        @Generated
        public Set<String> getRegionsToAdd() {
            return this.regionsToAdd;
        }

        @Generated
        public BuildResult(List<Agent> agents, Set<String> regionsToAdd) {
            this.agents = agents;
            this.regionsToAdd = regionsToAdd;
        }
    }
}

