/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.view;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonS3StaticDataProviderConfiguration;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.model.DataProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component
public class AmazonS3DataProvider
implements DataProvider {
    private final ObjectMapper objectMapper;
    private final AmazonClientProvider amazonClientProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository;
    private final AmazonS3StaticDataProviderConfiguration configuration;
    private final Set<String> supportedIdentifiers;
    private final LoadingCache<String, Object> staticCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).recordStats().build((CacheLoader)new CacheLoader<String, Object>(){

        public Object load(String id) throws IOException {
            AmazonS3StaticDataProviderConfiguration.StaticRecord record = AmazonS3DataProvider.this.configuration.getStaticRecord(id);
            S3Object s3Object = AmazonS3DataProvider.this.fetchObject(record.getBucketAccount(), record.getBucketRegion(), record.getBucketName(), record.getBucketKey());
            switch (record.getType()) {
                case list: {
                    return AmazonS3DataProvider.this.objectMapper.readValue((InputStream)s3Object.getObjectContent(), List.class);
                }
                case object: {
                    return AmazonS3DataProvider.this.objectMapper.readValue((InputStream)s3Object.getObjectContent(), Map.class);
                }
            }
            return IOUtils.toString((InputStream)s3Object.getObjectContent());
        }
    });

    @Autowired
    public AmazonS3DataProvider(@Qualifier(value="amazonObjectMapper") ObjectMapper objectMapper, AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository, AmazonS3StaticDataProviderConfiguration configuration) {
        this.objectMapper = objectMapper;
        this.amazonClientProvider = amazonClientProvider;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.configuration = configuration;
        this.supportedIdentifiers = configuration.getStaticRecords().stream().map(r -> r.getId().toLowerCase()).collect(Collectors.toSet());
    }

    public Object getStaticData(String id, Map<String, Object> filters) {
        try {
            Object contents = this.staticCache.get((Object)id);
            if (filters.isEmpty() || !(contents instanceof List)) {
                return contents;
            }
            return ((List)contents).stream().filter(r -> filters.entrySet().stream().anyMatch(f -> r.get(f.getKey()).equals(f.getValue()))).collect(Collectors.toList());
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public void getAdhocData(String groupId, String bucketId, String objectId, OutputStream outputStream) {
        String[] bucketCoordinates = bucketId.split(":");
        if (bucketCoordinates.length != 3) {
            throw new IllegalArgumentException("'bucketId' must be of the form {account}:{region}:{name}");
        }
        String bucketAccount = this.getAccountName(bucketCoordinates[0]);
        String bucketRegion = bucketCoordinates[1];
        String bucketName = bucketCoordinates[2];
        AmazonS3StaticDataProviderConfiguration.AdhocRecord record = this.configuration.getAdhocRecord(groupId);
        Matcher bucketNameMatcher = record.getBucketNamePattern().matcher(bucketName);
        Matcher objectKeyMatcher = record.getObjectKeyPattern().matcher(objectId);
        if (!bucketNameMatcher.matches() || !objectKeyMatcher.matches()) {
            throw new AccessDeniedException("Access denied (bucket: " + bucketName + ", object: " + objectId + ")");
        }
        try {
            S3Object s3Object = this.fetchObject(bucketAccount, bucketRegion, bucketName, objectId);
            IOUtils.copy((InputStream)s3Object.getObjectContent(), (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getAccountForIdentifier(DataProvider.IdentifierType identifierType, String id) {
        switch (identifierType) {
            case Static: {
                return this.configuration.getStaticRecord(id).getBucketAccount();
            }
            case Adhoc: {
                return this.getAccountName(id.split(":")[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported identifierType (" + String.valueOf(identifierType) + ")");
    }

    public boolean supportsIdentifier(DataProvider.IdentifierType identifierType, String id) {
        switch (identifierType) {
            case Static: {
                return this.supportedIdentifiers.contains(id.toLowerCase());
            }
            case Adhoc: {
                return this.configuration.getAdhocRecords().stream().anyMatch(r -> r.getId().equalsIgnoreCase(id));
            }
        }
        throw new IllegalArgumentException("Unsupported identifierType (" + String.valueOf(identifierType) + ")");
    }

    CacheStats getStaticCacheStats() {
        return this.staticCache.stats();
    }

    protected S3Object fetchObject(String bucketAccount, String bucketRegion, String bucketName, String objectId) {
        NetflixAmazonCredentials account = (NetflixAmazonCredentials)this.accountCredentialsRepository.getOne(bucketAccount);
        AmazonS3 amazonS3 = this.amazonClientProvider.getAmazonS3(account, bucketRegion);
        return amazonS3.getObject(bucketName, objectId);
    }

    private String getAccountName(String accountIdOrName) {
        return this.accountCredentialsRepository.getAll().stream().filter(c -> accountIdOrName.equalsIgnoreCase(c.getAccountId()) || accountIdOrName.equalsIgnoreCase(c.getName())).map(AccountCredentials::getName).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported account identifier (accountId: " + accountIdOrName + ")"));
    }
}

