/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.view;

import com.amazonaws.services.ec2.model.Subnet;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.cache.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonSubnet;
import com.netflix.spinnaker.clouddriver.model.SubnetProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AmazonSubnetProvider
implements SubnetProvider<AmazonSubnet>,
GroovyObject {
    private static final String METADATA_TAG_KEY = "immutable_metadata";
    private static final String NAME_TAG_KEY = "name";
    private static final String DEPRECATED_TAG_KEY = "is_deprecated";
    private final Cache cacheView;
    private final ObjectMapper amazonObjectMapper;
    private final String cloudProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public AmazonSubnetProvider(Cache cacheView, @Qualifier(value="amazonObjectMapper") ObjectMapper amazonObjectMapper) {
        ObjectMapper objectMapper;
        Cache cache;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, AmazonCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.cacheView = cache = cacheView;
        this.amazonObjectMapper = objectMapper = amazonObjectMapper;
    }

    public Set<AmazonSubnet> getAll() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSubnetKey", 0, Keys.class, "*", "*", "*")));
    }

    public Set<AmazonSubnet> getAllMatchingKeyPattern(String pattern) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadResults", 2, this, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SUBNETS", 0, Keys.Namespace.class)), pattern)));
    }

    public Set<AmazonSubnet> loadResults(Collection<String> identifiers) {
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SUBNETS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        CallSite transformed = IndyInterface.bootstrap("invoke", "collect", 0, data, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData"));
        return IndyInterface.bootstrap("cast", "()", 0, transformed);
    }

    public AmazonSubnet fromCacheData(CacheData cacheData) {
        CallSite parts = IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, cacheData));
        CallSite subnet = IndyInterface.bootstrap("invoke", "convertValue", 0, this.amazonObjectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), Subnet.class);
        public final class _fromCacheData_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromCacheData_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)IndyInterface.bootstrap("getProperty", "METADATA_TAG_KEY", 12, this));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromCacheData_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite tag = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "tags", 0, subnet), new _fromCacheData_closure1(this, this));
        public final class _fromCacheData_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromCacheData_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)IndyInterface.bootstrap("getProperty", "DEPRECATED_TAG_KEY", 12, this));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromCacheData_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite isDeprecated = IndyInterface.bootstrap("getProperty", "value", 1, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "tags", 0, subnet), new _fromCacheData_closure2(this, this)));
        CallSite json = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 1, tag));
        CallSite purpose = null;
        CallSite target = null;
        if (IndyInterface.bootstrap("cast", "()", 0, json) != false) {
            CallSite objectMapper = IndyInterface.bootstrap("init", "<init>", 0, ObjectMapper.class);
            try {
                CallSite metadata = IndyInterface.bootstrap("invoke", "readValue", 0, objectMapper, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)json)), String.class), Map.class);
                purpose = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "purpose", 1, metadata));
                target = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "target", 1, metadata));
            }
            catch (JsonParseException e) {
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "error", 0, log, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{METADATA_TAG_KEY}, new String[]{"Can not extract purpose and/or target from ", "\n"}), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "account", 0, parts)) != false ? IndyInterface.bootstrap("getProperty", "account", 0, parts) : "account not resolved"}, new String[]{"\tAccount: ", "\n"})), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 0, parts)) != false ? IndyInterface.bootstrap("getProperty", "id", 0, parts) : "subnet id not found"}, new String[]{"\tSubnet id: ", "\n"})), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"\tException message: ", ""}))) : null;
            }
        }
        public final class _fromCacheData_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromCacheData_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, it), IndyInterface.bootstrap("getProperty", "NAME_TAG_KEY", 12, this));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromCacheData_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite name = IndyInterface.bootstrap("getProperty", "value", 1, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "tags", 0, subnet), new _fromCacheData_closure3(this, this)));
        if (DefaultTypeTransformation.booleanUnbox((Object)name) && IndyInterface.bootstrap("cast", "()", 0, purpose) == false) {
            CallSite splits = IndyInterface.bootstrap("invoke", "split", 0, name, "\\.");
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, splits), (Object)3)) {
                purpose = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, splits, true), IndyInterface.bootstrap("invoke", "getAt", 0, splits, false)}, new String[]{"", " (", ")"}));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonSubnet.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", IndyInterface.bootstrap("getProperty", "ID", 0, AmazonCloudProvider.class), "id", IndyInterface.bootstrap("getProperty", "subnetId", 0, subnet), "state", IndyInterface.bootstrap("getProperty", "state", 0, subnet), "vpcId", IndyInterface.bootstrap("getProperty", "vpcId", 0, subnet), "cidrBlock", IndyInterface.bootstrap("getProperty", "cidrBlock", 0, subnet), "availableIpAddressCount", IndyInterface.bootstrap("getProperty", "availableIpAddressCount", 0, subnet), "account", IndyInterface.bootstrap("getProperty", "account", 0, parts), "accountId", IndyInterface.bootstrap("getProperty", "accountId", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData)), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts), "availabilityZone", IndyInterface.bootstrap("getProperty", "availabilityZone", 0, subnet), "purpose", purpose, "target", target, "deprecated", IndyInterface.bootstrap("init", "<init>", 0, Boolean.class, isDeprecated)})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonSubnetProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonSubnetProvider");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }
}

