/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.DescribeRegionsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.Region;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Vpc;
import com.netflix.spinnaker.clouddriver.aws.security.AWSAccountInfoLookup;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultAWSAccountInfoLookup
implements AWSAccountInfoLookup {
    private static final String DEFAULT_SECURITY_GROUP_NAME = "default";
    private static final Pattern IAM_ARN_PATTERN = Pattern.compile(".*?arn:aws(?:-cn|-us-gov)?:(?:iam|sts)::(\\d+):.*");
    private final AWSCredentialsProvider credentialsProvider;
    private final AmazonClientProvider amazonClientProvider;

    public DefaultAWSAccountInfoLookup(AWSCredentialsProvider credentialsProvider, AmazonClientProvider amazonClientProvider) {
        this.credentialsProvider = credentialsProvider;
        this.amazonClientProvider = amazonClientProvider;
    }

    @Override
    public String findAccountId() {
        AmazonEC2 ec2 = this.amazonClientProvider.getAmazonEC2(this.credentialsProvider, AmazonClientProvider.DEFAULT_REGION);
        try {
            List vpcs = ec2.describeVpcs().getVpcs();
            boolean supportsByName = false;
            if (vpcs.isEmpty()) {
                supportsByName = true;
            } else {
                for (Vpc vpc : vpcs) {
                    if (!vpc.getIsDefault().booleanValue()) continue;
                    supportsByName = true;
                    break;
                }
            }
            DescribeSecurityGroupsRequest request = new DescribeSecurityGroupsRequest();
            if (supportsByName) {
                request.withGroupNames(new String[]{DEFAULT_SECURITY_GROUP_NAME});
            }
            DescribeSecurityGroupsResult result = ec2.describeSecurityGroups(request);
            for (SecurityGroup sg : result.getSecurityGroups()) {
                if ((sg.getVpcId() == null || sg.getVpcId().length() <= 0) && !DEFAULT_SECURITY_GROUP_NAME.equals(sg.getGroupName())) continue;
                return sg.getOwnerId();
            }
            throw new IllegalArgumentException("Unable to lookup accountId with provided credentials");
        }
        catch (AmazonServiceException ase) {
            String message;
            Matcher matcher;
            if ("AccessDenied".equals(ase.getErrorCode()) && (matcher = IAM_ARN_PATTERN.matcher(message = ase.getMessage())).matches()) {
                return matcher.group(1);
            }
            throw ase;
        }
    }

    @Override
    public List<String> listAvailabilityZones(String regionName) {
        List<AmazonCredentials.AWSRegion> regions = this.listRegions(regionName);
        if (regions.isEmpty()) {
            throw new IllegalArgumentException("Unknown region: " + regionName);
        }
        return new ArrayList<String>(regions.get(0).getAvailabilityZones());
    }

    @Override
    public List<AmazonCredentials.AWSRegion> listRegions(String ... regionNames) {
        return this.listRegions(Arrays.asList(regionNames));
    }

    @Override
    public List<AmazonCredentials.AWSRegion> listRegions(Collection<String> regionNames) {
        List regions;
        HashSet<String> nameSet = new HashSet<String>(regionNames);
        AmazonEC2 ec2 = this.amazonClientProvider.getAmazonEC2(this.credentialsProvider, AmazonClientProvider.DEFAULT_REGION);
        DescribeRegionsRequest request = new DescribeRegionsRequest();
        if (!nameSet.isEmpty()) {
            request.withRegionNames(regionNames);
        }
        if ((regions = ec2.describeRegions(request).getRegions()).size() != nameSet.size()) {
            HashSet<String> missingSet = new HashSet<String>(nameSet);
            for (Region region : regions) {
                missingSet.remove(region.getRegionName());
            }
            throw new IllegalArgumentException("Unknown region" + (missingSet.size() > 1 ? "s: " : ": ") + String.valueOf(missingSet));
        }
        ArrayList<AmazonCredentials.AWSRegion> awsRegions = new ArrayList<AmazonCredentials.AWSRegion>(regions.size());
        for (Region region : regions) {
            AmazonEC2 regionalEc2 = this.amazonClientProvider.getAmazonEC2(this.credentialsProvider, region.getRegionName());
            List azs = regionalEc2.describeAvailabilityZones().getAvailabilityZones();
            ArrayList<String> availabilityZoneNames = new ArrayList<String>(azs.size());
            for (AvailabilityZone az : azs) {
                availabilityZoneNames.add(az.getZoneName());
            }
            awsRegions.add(new AmazonCredentials.AWSRegion(region.getRegionName(), availabilityZoneNames));
        }
        return awsRegions;
    }
}

