/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.util.List;
import lombok.Generated;

public class NetflixAmazonCredentials
extends AmazonCredentials {
    private final String edda;
    private final boolean eddaEnabled;
    private final String discovery;
    private final boolean discoveryEnabled;
    private final String front50;
    private final boolean front50Enabled;
    private final String bastionHost;
    private final boolean bastionEnabled;
    private final boolean shieldEnabled;
    private final boolean lambdaEnabled;

    public NetflixAmazonCredentials(@JsonProperty(value="name") String name, @JsonProperty(value="environment") String environment, @JsonProperty(value="accountType") String accountType, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="defaultKeyPair") String defaultKeyPair, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="regions") List<AmazonCredentials.AWSRegion> regions, @JsonProperty(value="defaultSecurityGroups") List<String> defaultSecurityGroups, @JsonProperty(value="requiredGroupMembership") List<String> requiredGroupMembership, @JsonProperty(value="permissions") Permissions permissions, @JsonProperty(value="lifecycleHooks") List<AmazonCredentials.LifecycleHook> lifecycleHooks, @JsonProperty(value="allowPrivateThirdPartyImages") boolean allowPrivateThirdPartyImages, @JsonProperty(value="edda") String edda, @JsonProperty(value="eddaEnabled") Boolean eddaEnabled, @JsonProperty(value="discovery") String discovery, @JsonProperty(value="discoveryEnabled") Boolean discoveryEnabled, @JsonProperty(value="front50") String front50, @JsonProperty(value="front50Enabled") Boolean front50Enabled, @JsonProperty(value="bastionHost") String bastionHost, @JsonProperty(value="bastionEnabled") Boolean bastionEnabled, @JsonProperty(value="shieldEnabled") Boolean shieldEnabled, @JsonProperty(value="lambdaEnabled") Boolean lambdaEnabled) {
        this(name, environment, accountType, accountId, defaultKeyPair, enabled, regions, defaultSecurityGroups, requiredGroupMembership, permissions, lifecycleHooks, allowPrivateThirdPartyImages, null, edda, eddaEnabled, discovery, discoveryEnabled, front50, front50Enabled, bastionHost, bastionEnabled, shieldEnabled, lambdaEnabled);
    }

    private static boolean flagValue(String serviceUrl, Boolean flag) {
        return serviceUrl != null && serviceUrl.trim().length() != 0 && (flag == null || flag != false);
    }

    public NetflixAmazonCredentials(NetflixAmazonCredentials copy, AWSCredentialsProvider credentialsProvider) {
        this(copy.getName(), copy.getEnvironment(), copy.getAccountType(), copy.getAccountId(), copy.getDefaultKeyPair(), copy.isEnabled(), copy.getRegions(), copy.getDefaultSecurityGroups(), copy.getRequiredGroupMembership(), copy.getPermissions(), copy.getLifecycleHooks(), copy.getAllowPrivateThirdPartyImages(), credentialsProvider, copy.getEdda(), copy.isEddaEnabled(), copy.getDiscovery(), copy.isDiscoveryEnabled(), copy.getFront50(), copy.isFront50Enabled(), copy.getBastionHost(), copy.isBastionEnabled(), copy.isShieldEnabled(), copy.isLambdaEnabled());
    }

    NetflixAmazonCredentials(String name, String environment, String accountType, String accountId, String defaultKeyPair, Boolean enabled, List<AmazonCredentials.AWSRegion> regions, List<String> defaultSecurityGroups, List<String> requiredGroupMembership, Permissions permissions, List<AmazonCredentials.LifecycleHook> lifecycleHooks, boolean allowPrivateThirdPartyImages, AWSCredentialsProvider credentialsProvider, String edda, Boolean eddaEnabled, String discovery, Boolean discoveryEnabled, String front50, Boolean front50Enabled, String bastionHost, Boolean bastionEnabled, Boolean shieldEnabled, Boolean lambdaEnabled) {
        super(name, environment, accountType, accountId, defaultKeyPair, enabled, regions, defaultSecurityGroups, requiredGroupMembership, permissions, lifecycleHooks, allowPrivateThirdPartyImages, credentialsProvider);
        this.edda = edda;
        this.eddaEnabled = NetflixAmazonCredentials.flagValue(edda, eddaEnabled);
        this.discovery = discovery;
        this.discoveryEnabled = NetflixAmazonCredentials.flagValue(discovery, discoveryEnabled);
        this.front50 = front50;
        this.front50Enabled = NetflixAmazonCredentials.flagValue(front50, front50Enabled);
        this.bastionHost = bastionHost;
        this.bastionEnabled = NetflixAmazonCredentials.flagValue(bastionHost, bastionEnabled);
        this.shieldEnabled = shieldEnabled != null && shieldEnabled != false;
        this.lambdaEnabled = lambdaEnabled != null && lambdaEnabled != false;
    }

    @Generated
    public String getEdda() {
        return this.edda;
    }

    @Generated
    public boolean isEddaEnabled() {
        return this.eddaEnabled;
    }

    @Generated
    public String getDiscovery() {
        return this.discovery;
    }

    @Generated
    public boolean isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    @Generated
    public String getFront50() {
        return this.front50;
    }

    @Generated
    public boolean isFront50Enabled() {
        return this.front50Enabled;
    }

    @Generated
    public String getBastionHost() {
        return this.bastionHost;
    }

    @Generated
    public boolean isBastionEnabled() {
        return this.bastionEnabled;
    }

    @Generated
    public boolean isShieldEnabled() {
        return this.shieldEnabled;
    }

    @Generated
    public boolean isLambdaEnabled() {
        return this.lambdaEnabled;
    }
}

