/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.SpinnakerAwsRegionProvider;
import java.io.Closeable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetflixSTSAssumeRoleSessionCredentialsProvider
implements AWSSessionCredentialsProvider,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetflixSTSAssumeRoleSessionCredentialsProvider.class);
    private final String accountId;
    private final String roleArn;
    private final String region;
    private final Integer sessionDurationSeconds;
    private final STSAssumeRoleSessionCredentialsProvider delegate;

    public NetflixSTSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, String roleArn, String roleSessionName, Integer sessionDurationSeconds, String accountId, String externalId) {
        this.accountId = accountId;
        this.roleArn = roleArn;
        this.sessionDurationSeconds = sessionDurationSeconds;
        SpinnakerAwsRegionProvider chain = new SpinnakerAwsRegionProvider();
        this.region = chain.getRegion();
        log.debug("Setting up a credentials provider session named {} in the region {} for account {} using role {} with {} duration", new Object[]{roleSessionName, this.region, accountId, roleArn, sessionDurationSeconds == null ? "default" : sessionDurationSeconds + "seconds"});
        AWSSecurityTokenServiceClientBuilder stsClientBuilder = (AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClient.builder().withCredentials(longLivedCredentialsProvider);
        if (roleArn.contains("aws-us-gov")) {
            stsClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("sts.us-gov-west-1.amazonaws.com", this.region));
        } else if (roleArn.contains("aws-cn")) {
            stsClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("sts.cn-north-1.amazonaws.com.cn", this.region));
        } else {
            stsClientBuilder.withRegion(this.region);
        }
        STSAssumeRoleSessionCredentialsProvider.Builder stsSessionProviderBuilder = new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, roleSessionName).withExternalId(externalId).withStsClient((AWSSecurityTokenService)stsClientBuilder.build());
        if (sessionDurationSeconds != null) {
            stsSessionProviderBuilder.withRoleSessionDurationSeconds(sessionDurationSeconds.intValue());
        }
        this.delegate = stsSessionProviderBuilder.build();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public AWSSessionCredentials getCredentials() {
        log.debug("Getting AWS Session credentials for account {} with role {} in region {}", new Object[]{this.accountId, this.roleArn, this.region});
        return this.delegate.getCredentials();
    }

    public void refresh() {
        log.debug("Refreshing AWS Session credentials for account {} with role {} in region {} with {} duration", new Object[]{this.accountId, this.roleArn, this.region, this.sessionDurationSeconds == null ? "default" : this.sessionDurationSeconds + "seconds"});
        this.delegate.refresh();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

