/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.services;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.netflix.spinnaker.clouddriver.aws.model.SecurityGroupNotFoundException;
import com.netflix.spinnaker.clouddriver.aws.model.SubnetAnalyzer;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class SecurityGroupService
implements GroovyObject {
    private static final Pattern SG_PATTERN;
    private final AmazonEC2 amazonEC2;
    private final SubnetAnalyzer subnetAnalyzer;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public SecurityGroupService(AmazonEC2 amazonEC2, SubnetAnalyzer subnetAnalyzer) {
        SubnetAnalyzer subnetAnalyzer2;
        AmazonEC2 amazonEC22;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonEC2 = amazonEC22 = amazonEC2;
        this.subnetAnalyzer = subnetAnalyzer2 = subnetAnalyzer;
    }

    public String getSecurityGroupForApplication(String applicationName, String subnetPurpose) {
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("invoke", "values", 1, IndyInterface.bootstrap("invoke", "getSecurityGroupIdsWithSubnetPurpose", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{applicationName}), subnetPurpose)), false));
        try {
            return callSite;
        }
        catch (SecurityGroupNotFoundException ignore) {
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, null);
            return callSite2;
        }
    }

    public Map<String, String> getSecurityGroupIds(Collection<String> securityGroupNames, String vpcId, boolean failIfNotAllResolved) {
        Reference vpcId2 = new Reference((Object)vpcId);
        if (IndyInterface.bootstrap("cast", "()", 0, securityGroupNames) == false) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        CallSite request = IndyInterface.bootstrap("invoke", "withFilters", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeSecurityGroupsRequest.class), IndyInterface.bootstrap("init", "<init>", 0, Filter.class, "group-name", IndyInterface.bootstrap("invoke", "toList", 0, securityGroupNames)));
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, this.amazonEC2, request));
        public final class _getSecurityGroupIds_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference vpcId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSecurityGroupIds_closure1(Object _outerInstance, Object _thisObject, Reference vpcId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.vpcId = reference = vpcId;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "vpcId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get()));
            }

            @Generated
            public String getVpcId() {
                return IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSecurityGroupIds_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getSecurityGroupIds_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSecurityGroupIds_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "groupName", 0, it), IndyInterface.bootstrap("getProperty", "groupId", 0, it)});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSecurityGroupIds_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite securityGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "securityGroups", 0, result), new _getSecurityGroupIds_closure1(this, this, vpcId2)), new _getSecurityGroupIds_closure2(this, this)));
        if (failIfNotAllResolved && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsAll", 0, IndyInterface.bootstrap("invoke", "keySet", 0, securityGroups), securityGroupNames)) == false) {
            CallSite missingGroups = IndyInterface.bootstrap("invoke", "minus", 0, securityGroupNames, IndyInterface.bootstrap("invoke", "keySet", 0, securityGroups));
            CallSite ex = IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupNotFoundException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, missingGroups, ",")}, new String[]{"Missing security groups: ", ""}));
            CallSite callSite = missingGroups;
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)ex, (String)"missingSecurityGroups");
            throw (Throwable)((Object)ex);
        }
        return securityGroups;
    }

    public Map<String, String> getSecurityGroupIdsWithSubnetPurpose(Collection<String> securityGroupNames, String subnetPurpose) {
        CallSite vpcId = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareEqual((Object)subnetPurpose, null) ? null : IndyInterface.bootstrap("invoke", "getVpcIdForSubnetPurpose", 0, this.subnetAnalyzer, subnetPurpose));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSecurityGroupIds", 2, this, securityGroupNames, vpcId));
    }

    public String createSecurityGroup(String applicationName, String subnetPurpose) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createSecurityGroupWithVpcId", 2, this, applicationName, IndyInterface.bootstrap("cast", "()", 0, subnetPurpose) != false ? IndyInterface.bootstrap("invoke", "getVpcIdForSubnetPurpose", 0, this.subnetAnalyzer, subnetPurpose) : null));
    }

    public String createSecurityGroupWithVpcId(String applicationName, String vpcId) {
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateSecurityGroupRequest.class, applicationName, new GStringImpl(new Object[]{applicationName}, new String[]{"Security Group for ", ""})));
        if (IndyInterface.bootstrap("cast", "()", 0, vpcId) != false) {
            IndyInterface.bootstrap("invoke", "withVpcId", 0, request, vpcId);
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createSecurityGroup", 0, this.amazonEC2, request));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "groupId", 0, result));
    }

    public Map<String, String> getSecurityGroupNamesFromIds(Collection<String> securityGroupIds) {
        if (IndyInterface.bootstrap("cast", "()", 0, securityGroupIds) == false) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        CallSite groupIds = IndyInterface.bootstrap("init", "<init>", 0, HashSet.class, securityGroupIds);
        Reference groups = new Reference((Object)IndyInterface.bootstrap("getProperty", "securityGroups", 0, IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, this.amazonEC2, IndyInterface.bootstrap("invoke", "withGroupIds", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeSecurityGroupsRequest.class), groupIds))));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, groups.get()), (Object)IndyInterface.bootstrap("invoke", "size", 0, groupIds))) {
            public final class _getSecurityGroupNamesFromIds_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference groups;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSecurityGroupNamesFromIds_closure3(Object _outerInstance, Object _thisObject, Reference groups) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.groups = reference = groups;
                }

                public Object doCall(Object id) {
                    Reference id2 = new Reference(id);
                    public final class _closure9
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference id;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure9(Object _outerInstance, Object _thisObject, Reference id) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.id = reference = id;
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "groupId", 0, it), (Object)this.id.get());
                        }

                        @Generated
                        public Object getId() {
                            return this.id.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure9.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, this.groups.get(), new _closure9((Object)this, this.getThisObject(), id2))) == false;
                }

                @Generated
                public Object getGroups() {
                    return this.groups.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSecurityGroupNamesFromIds_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite missing = IndyInterface.bootstrap("invoke", "findAll", 0, groupIds, new _getSecurityGroupNamesFromIds_closure3(this, this, groups));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupNotFoundException.class, new GStringImpl(new Object[]{missing}, new String[]{"Failed to find groups ", ""})));
        }
        public final class _getSecurityGroupNamesFromIds_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSecurityGroupNamesFromIds_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "groupName", 0, it), IndyInterface.bootstrap("getProperty", "groupId", 0, it)});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSecurityGroupNamesFromIds_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "collectEntries", 0, groups.get(), new _getSecurityGroupNamesFromIds_closure4(this, this));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    public List<String> resolveSecurityGroupNamesByStrategy(List<String> securityGroupNamesAndIds, Closure<Map<String, String>> idResolver) {
        if (IndyInterface.bootstrap("cast", "()", 0, securityGroupNamesAndIds) != false) {
            CallSite ids = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toSet", 0, securityGroupNamesAndIds));
            public final class _resolveSecurityGroupNamesByStrategy_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _resolveSecurityGroupNamesByStrategy_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, IndyInterface.bootstrap("invoke", "matcher", 0, IndyInterface.bootstrap("getProperty", "SG_PATTERN", 12, this), it))) == false;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _resolveSecurityGroupNamesByStrategy_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Set names = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "findAll", 0, ids, new _resolveSecurityGroupNamesByStrategy_closure5(this, this)), Set.class));
            IndyInterface.bootstrap("invoke", "removeAll", 0, ids, names);
            if (IndyInterface.bootstrap("cast", "()", 0, ids) != false) {
                CallSite resolvedNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "call", 0, idResolver, IndyInterface.bootstrap("invoke", "toList", 0, ids)));
                IndyInterface.bootstrap("invoke", "addAll", 0, names, IndyInterface.bootstrap("invoke", "keySet", 0, resolvedNames));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toList", 0, names));
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    public List<String> resolveSecurityGroupIdsByStrategy(List<String> securityGroupNamesAndIds, Closure<Map<String, String>> nameResolver) {
        if (IndyInterface.bootstrap("cast", "()", 0, securityGroupNamesAndIds) != false) {
            CallSite names = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toSet", 0, securityGroupNamesAndIds));
            public final class _resolveSecurityGroupIdsByStrategy_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _resolveSecurityGroupIdsByStrategy_closure6(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "matches", 0, IndyInterface.bootstrap("invoke", "matcher", 0, IndyInterface.bootstrap("getProperty", "SG_PATTERN", 12, this), it));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _resolveSecurityGroupIdsByStrategy_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Set ids = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "findAll", 0, names, new _resolveSecurityGroupIdsByStrategy_closure6(this, this)), Set.class));
            IndyInterface.bootstrap("invoke", "removeAll", 0, names, ids);
            if (IndyInterface.bootstrap("cast", "()", 0, names) != false) {
                CallSite resolvedIds = IndyInterface.bootstrap("invoke", "call", 0, nameResolver, IndyInterface.bootstrap("invoke", "toList", 0, names));
                IndyInterface.bootstrap("invoke", "addAll", 0, ids, IndyInterface.bootstrap("invoke", "values", 0, resolvedIds));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toList", 0, ids));
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    public List<String> resolveSecurityGroupIdsWithSubnetType(List<String> securityGroupNamesAndIds, String subnetPurpose) {
        Reference subnetPurpose2 = new Reference((Object)subnetPurpose);
        public final class _resolveSecurityGroupIdsWithSubnetType_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference subnetPurpose;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveSecurityGroupIdsWithSubnetType_closure7(Object _outerInstance, Object _thisObject, Reference subnetPurpose) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.subnetPurpose = reference = subnetPurpose;
            }

            public Object doCall(List<String> names) {
                return IndyInterface.bootstrap("invoke", "getSecurityGroupIdsWithSubnetPurpose", 2, this.getThisObject(), names, IndyInterface.bootstrap("cast", "()", 0, this.subnetPurpose.get()));
            }

            @Generated
            public Object call(List<String> names) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, names);
            }

            @Generated
            public String getSubnetPurpose() {
                return IndyInterface.bootstrap("cast", "()", 0, this.subnetPurpose.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveSecurityGroupIdsWithSubnetType_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveSecurityGroupIdsByStrategy", 2, this, securityGroupNamesAndIds, new _resolveSecurityGroupIdsWithSubnetType_closure7(this, this, subnetPurpose2)));
    }

    public List<String> resolveSecurityGroupIdsInVpc(List<String> securityGroupNamesAndIds, String vpcId) {
        Reference vpcId2 = new Reference((Object)vpcId);
        public final class _resolveSecurityGroupIdsInVpc_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference vpcId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveSecurityGroupIdsInVpc_closure8(Object _outerInstance, Object _thisObject, Reference vpcId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.vpcId = reference = vpcId;
            }

            public Object doCall(List<String> names) {
                return IndyInterface.bootstrap("invoke", "getSecurityGroupIds", 2, this.getThisObject(), names, IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get()));
            }

            @Generated
            public Object call(List<String> names) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, names);
            }

            @Generated
            public String getVpcId() {
                return IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveSecurityGroupIdsInVpc_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveSecurityGroupIdsByStrategy", 2, this, securityGroupNamesAndIds, new _resolveSecurityGroupIdsInVpc_closure8(this, this, vpcId2)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SecurityGroupService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public String getSecurityGroupForApplication(String applicationName) {
        return this.getSecurityGroupForApplication(applicationName, null);
    }

    @Generated
    public Map<String, String> getSecurityGroupIds(Collection<String> securityGroupNames, String vpcId) {
        Reference vpcId2 = new Reference((Object)vpcId);
        return this.getSecurityGroupIds(securityGroupNames, (String)vpcId2.get(), true);
    }

    @Generated
    public Map<String, String> getSecurityGroupIds(Collection<String> securityGroupNames) {
        return this.getSecurityGroupIds(securityGroupNames, null, true);
    }

    @Generated
    public Map<String, String> getSecurityGroupIdsWithSubnetPurpose(Collection<String> securityGroupNames) {
        return this.getSecurityGroupIdsWithSubnetPurpose(securityGroupNames, null);
    }

    @Generated
    public String createSecurityGroup(String applicationName) {
        return this.createSecurityGroup(applicationName, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "compile", 0, Pattern.class, "^sg-[0-9a-f]+$");
        SG_PATTERN = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

