/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.common.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.management.resources.DeploymentOperation;
import com.microsoft.azure.management.resources.implementation.DeploymentExtendedInner;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationInner;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.security.AzureCredentials;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureDeploymentOperation
implements GroovyObject {
    private static final Integer AZURE_DEPLOYMENT_OPERATION_STATUS_RETRIES_MAX;
    private static ObjectMapper mapper;
    private List<OpsValue> value;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AzureDeploymentOperation() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static AzureDeploymentOperation getObjectFromJson(String responseContent) {
        return (AzureDeploymentOperation)ScriptBytecodeAdapter.castToType((Object)mapper.readValue(responseContent, AzureDeploymentOperation.class), AzureDeploymentOperation.class);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> checkDeploymentOperationStatus(Task task, String opsName, AzureCredentials creds, String resourceGroupName, String deploymentName) {
        void var1_1;
        Reference task2 = new Reference((Object)task);
        Reference opsName2 = new Reference((Object)var1_1);
        Reference errList = new Reference(new ArrayList());
        Reference resourceCompletedState = new Reference(new HashMap());
        String deploymentState = AzureUtilities.ProvisioningState.DEPLOYING;
        Integer checkDeployment = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)checkDeployment, (Object)AZURE_DEPLOYMENT_OPERATION_STATUS_RETRIES_MAX)) {
            Integer n;
            String string;
            deploymentState = string = ((DeploymentExtendedInner)creds.getResourceManagerClient().getDeployment(resourceGroupName, deploymentName).inner()).properties().provisioningState();
            public final class _checkDeploymentOperationStatus_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference resourceCompletedState;
                private /* synthetic */ Reference task;
                private /* synthetic */ Reference opsName;
                private /* synthetic */ Reference errList;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _checkDeploymentOperationStatus_closure1(Object _outerInstance, Object _thisObject, Reference resourceCompletedState, Reference task, Reference opsName, Reference errList) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.resourceCompletedState = reference4 = resourceCompletedState;
                    this.task = reference3 = task;
                    this.opsName = reference2 = opsName;
                    this.errList = reference = errList;
                }

                public Object doCall(DeploymentOperation d) {
                    DeploymentOperationInner inner = (DeploymentOperationInner)ScriptBytecodeAdapter.castToType((Object)d.inner(), DeploymentOperationInner.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)inner.properties().targetResource())) {
                        if (!((HashMap)this.resourceCompletedState.get()).containsKey(inner.id())) {
                            boolean bl = false;
                            DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.resourceCompletedState.get(), Map.class)), (Object)inner.id(), (Object)bl);
                        }
                        if (ScriptBytecodeAdapter.compareEqual((Object)inner.properties().provisioningState(), (Object)AzureUtilities.ProvisioningState.SUCCEEDED)) {
                            if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.resourceCompletedState.get(), Map.class)), (Object)inner.id()))) {
                                ((Task)this.task.get()).updateStatus(ShortTypeHandling.castToString((Object)this.opsName.get()), String.format("Resource %s created", inner.properties().targetResource().resourceName()));
                                boolean bl = true;
                                DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.resourceCompletedState.get(), Map.class)), (Object)inner.id(), (Object)bl);
                                return bl;
                            }
                            return null;
                        }
                        if (ScriptBytecodeAdapter.compareEqual((Object)inner.properties().provisioningState(), (Object)AzureUtilities.ProvisioningState.FAILED)) {
                            if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.resourceCompletedState.get(), Map.class)), (Object)inner.id()))) {
                                String string;
                                String err = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{inner.properties().targetResource().resourceName()}, new String[]{"Failed to create resource ", ": "}));
                                err = string = StringGroovyMethods.plus((CharSequence)err, (Object)(DefaultTypeTransformation.booleanUnbox((Object)inner.properties().statusMessage()) ? inner.properties().statusMessage() : "See Azure Portal for more information."));
                                ((Task)this.task.get()).updateStatus(ShortTypeHandling.castToString((Object)this.opsName.get()), err);
                                boolean bl = true;
                                DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.resourceCompletedState.get(), Map.class)), (Object)inner.id(), (Object)bl);
                                return ((ArrayList)this.errList.get()).add(err);
                            }
                            return null;
                        }
                        return null;
                    }
                    return null;
                }

                public Object call(DeploymentOperation d) {
                    return this.doCall(d);
                }

                @Generated
                public Map getResourceCompletedState() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.resourceCompletedState.get(), Map.class);
                }

                @Generated
                public Task getTask() {
                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                }

                @Generated
                public String getOpsName() {
                    return ShortTypeHandling.castToString((Object)this.opsName.get());
                }

                @Generated
                public Object getErrList() {
                    return this.errList.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _checkDeploymentOperationStatus_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(creds.getResourceManagerClient().getDeploymentOperations(resourceGroupName, deploymentName), (Closure)new _checkDeploymentOperationStatus_closure1(AzureDeploymentOperation.class, AzureDeploymentOperation.class, resourceCompletedState, task2, opsName2, errList));
            if (AzureDeploymentOperation.deploymentIsRunning(deploymentState)) {
                log.info("checkDeploymentOperationStatus -> SLEEP");
                DefaultGroovyStaticMethods.sleep(null, (long)500);
                checkDeployment = (Integer)ScriptBytecodeAdapter.castToType((Object)NumberNumberPlus.plus((Number)checkDeployment, (Number)1), Integer.class);
                continue;
            }
            checkDeployment = n = AZURE_DEPLOYMENT_OPERATION_STATUS_RETRIES_MAX;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)deploymentState, (Object)AzureUtilities.ProvisioningState.SUCCEEDED)) {
            String err = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{deploymentName}, new String[]{"Failed to deploy ", "; see Azure Portal for more information'}"}));
            ((Task)task2.get()).updateStatus((String)opsName2.get(), err);
            ((ArrayList)errList.get()).add(err);
        }
        return (ArrayList)errList.get();
    }

    private static boolean deploymentIsRunning(String deploymentState) {
        return ScriptBytecodeAdapter.compareNotEqual((Object)deploymentState, (Object)AzureUtilities.ProvisioningState.CANCELED) && ScriptBytecodeAdapter.compareNotEqual((Object)deploymentState, (Object)AzureUtilities.ProvisioningState.DELETED) && ScriptBytecodeAdapter.compareNotEqual((Object)deploymentState, (Object)AzureUtilities.ProvisioningState.FAILED) && ScriptBytecodeAdapter.compareNotEqual((Object)deploymentState, (Object)AzureUtilities.ProvisioningState.SUCCEEDED);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureDeploymentOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureDeploymentOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureDeploymentOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureDeploymentOperation.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        ObjectMapper objectMapper;
        int n = 1000;
        AZURE_DEPLOYMENT_OPERATION_STATUS_RETRIES_MAX = n;
        mapper = objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.azure.resources.common.model.AzureDeploymentOperation");
    }

    @Generated
    public static Integer getAZURE_DEPLOYMENT_OPERATION_STATUS_RETRIES_MAX() {
        return AZURE_DEPLOYMENT_OPERATION_STATUS_RETRIES_MAX;
    }

    @Generated
    public static ObjectMapper getMapper() {
        return mapper;
    }

    @Generated
    public static void setMapper(ObjectMapper objectMapper) {
        mapper = objectMapper;
    }

    @Generated
    public List<OpsValue> getValue() {
        return this.value;
    }

    @Generated
    public void setValue(List<OpsValue> list) {
        this.value = list;
    }

    public static class OpsValue
    implements GroovyObject {
        private String id;
        private String operationId;
        private OpsProperties properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public OpsValue() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OpsValue.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OpsValue.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OpsValue.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OpsValue.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OpsValue.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        @Generated
        public String getOperationId() {
            return this.operationId;
        }

        @Generated
        public void setOperationId(String string) {
            this.operationId = string;
        }

        @Generated
        public OpsProperties getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(OpsProperties opsProperties) {
            this.properties = opsProperties;
        }
    }

    public static class OpsProperties
    implements GroovyObject {
        private String provisioningOperation;
        private String provisioningState;
        private String timestamp;
        private String duration;
        private String trackingId;
        private String statusCode;
        private StatusMessage statusMessage;
        private TargetResource targetResource;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public OpsProperties() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OpsProperties.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OpsProperties.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OpsProperties.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OpsProperties.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OpsProperties.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getProvisioningOperation() {
            return this.provisioningOperation;
        }

        @Generated
        public void setProvisioningOperation(String string) {
            this.provisioningOperation = string;
        }

        @Generated
        public String getProvisioningState() {
            return this.provisioningState;
        }

        @Generated
        public void setProvisioningState(String string) {
            this.provisioningState = string;
        }

        @Generated
        public String getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public void setTimestamp(String string) {
            this.timestamp = string;
        }

        @Generated
        public String getDuration() {
            return this.duration;
        }

        @Generated
        public void setDuration(String string) {
            this.duration = string;
        }

        @Generated
        public String getTrackingId() {
            return this.trackingId;
        }

        @Generated
        public void setTrackingId(String string) {
            this.trackingId = string;
        }

        @Generated
        public String getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public void setStatusCode(String string) {
            this.statusCode = string;
        }

        @Generated
        public StatusMessage getStatusMessage() {
            return this.statusMessage;
        }

        @Generated
        public void setStatusMessage(StatusMessage statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Generated
        public TargetResource getTargetResource() {
            return this.targetResource;
        }

        @Generated
        public void setTargetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
        }
    }

    public static class StatusMessage
    implements GroovyObject {
        private StatusMessageError error;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public StatusMessage() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StatusMessage.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(StatusMessage.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(StatusMessage.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(StatusMessage.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(StatusMessage.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public StatusMessageError getError() {
            return this.error;
        }

        @Generated
        public void setError(StatusMessageError statusMessageError) {
            this.error = statusMessageError;
        }
    }

    public static class StatusMessageError
    implements GroovyObject {
        private String code;
        private String message;
        private List<String> details;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public StatusMessageError() {
            MetaClass metaClass;
            List list;
            this.details = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StatusMessageError.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(StatusMessageError.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(StatusMessageError.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(StatusMessageError.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(StatusMessageError.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public void setCode(String string) {
            this.code = string;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public void setMessage(String string) {
            this.message = string;
        }

        @Generated
        public List<String> getDetails() {
            return this.details;
        }

        @Generated
        public void setDetails(List<String> list) {
            this.details = list;
        }
    }

    public static class TargetResource
    implements GroovyObject {
        private String id;
        private String resourceType;
        private String resourceName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public TargetResource() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != TargetResource.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(TargetResource.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(TargetResource.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TargetResource.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TargetResource.class, AzureDeploymentOperation.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        @Generated
        public String getResourceType() {
            return this.resourceType;
        }

        @Generated
        public void setResourceType(String string) {
            this.resourceType = string;
        }

        @Generated
        public String getResourceName() {
            return this.resourceName;
        }

        @Generated
        public void setResourceName(String string) {
            this.resourceName = string;
        }
    }
}

