/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model;

import com.google.common.collect.Sets;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetDataDisk;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.azure.AzureCloudProvider;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.common.AzureResourceOpsDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.loadbalancer.model.AzureLoadBalancer;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureInstance;
import com.netflix.spinnaker.clouddriver.azure.resources.vmimage.model.AzureNamedImage;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;

public class AzureServerGroupDescription
extends AzureResourceOpsDescription
implements ServerGroup {
    private Set<AzureInstance> instances;
    private Set<String> loadBalancers;
    private Set<String> securityGroups;
    private Set<String> zones;
    private Map<String, String> instanceTags;
    private final String type;
    private final String cloudProvider;
    private Map<String, Object> launchConfig;
    private ServerGroup.Capacity capacity;
    private ServerGroup.ImagesSummary imagesSummary;
    private ServerGroup.ImageSummary imageSummary;
    private UpgradePolicy upgradePolicy;
    private String loadBalancerName;
    private String loadBalancerType;
    private String appGatewayName;
    private String appGatewayBapId;
    private AzureNamedImage image;
    private AzureScaleSetSku sku;
    private AzureOperatingSystemConfig osConfig;
    private String provisioningState;
    private String application;
    private String clusterName;
    private String securityGroupName;
    private String subnetId;
    private List<String> storageAccountNames;
    private Boolean isDisabled;
    private List<AzureInboundPortConfig> inboundPortConfigs;
    private String vnet;
    private String subnet;
    private String vnetResourceGroup;
    private Boolean hasNewSubnet;
    private Boolean createNewSubnet;
    private AzureExtensionCustomScriptSettings customScriptsSettings;
    private AzureExtensionHealthSettings healthSettings;
    private Boolean enableInboundNAT;
    private List<VirtualMachineScaleSetDataDisk> dataDisks;
    private Integer terminationNotBeforeTimeoutInMinutes;
    private String windowsTimeZone;
    private Boolean doNotRunExtensionsOnOverprovisionedVMs;
    private Boolean useSystemManagedIdentity;
    private String userAssignedIdentities;
    private Boolean enableIpForwarding;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AzureServerGroupDescription() {
        MetaClass metaClass;
        List list;
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(AzureCloudProvider.class);
        this.type = ShortTypeHandling.castToString((Object)object);
        Object object2 = callSiteArray[1].callGetProperty(AzureCloudProvider.class);
        this.cloudProvider = ShortTypeHandling.castToString((Object)object2);
        boolean bl = false;
        this.isDisabled = bl;
        this.inboundPortConfigs = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        boolean bl2 = false;
        this.hasNewSubnet = bl2;
        boolean bl3 = false;
        this.createNewSubnet = bl3;
        boolean bl4 = false;
        this.enableInboundNAT = bl4;
        boolean bl5 = false;
        this.doNotRunExtensionsOnOverprovisionedVMs = bl5;
        boolean bl6 = false;
        this.useSystemManagedIdentity = bl6;
        boolean bl7 = false;
        this.enableIpForwarding = bl7;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Integer getStorageAccountCount() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call((Object)DefaultTypeTransformation.intUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this.sku), (Object)20)), (Object)1), Integer.class);
        }
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this.sku), (Object)20)) + 1;
    }

    public static UpgradePolicy getPolicyFromMode(String mode) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return (UpgradePolicy)ShortTypeHandling.castToEnum((Object)(ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].call((Object)mode), (Object)callSiteArray[8].call((Object)"Automatic")) ? callSiteArray[9].callGetProperty(UpgradePolicy.class) : callSiteArray[10].callGetProperty(UpgradePolicy.class)), UpgradePolicy.class);
    }

    public String getClusterName() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        String string = this.clusterName;
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : callSiteArray[11].callGetProperty(callSiteArray[12].call(Names.class, callSiteArray[13].callGroovyObjectGetProperty((Object)this)))));
    }

    public String getIdentifier() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[14].call(String.class, (Object)"%s-%s-%s", (Object)this.application, callSiteArray[15].callGroovyObjectGetProperty((Object)this), callSiteArray[16].callGroovyObjectGetProperty((Object)this)));
    }

    public Set<String> getLoadBalancers() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.appGatewayName, null)) {
            return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call(Sets.class, (Object)this.appGatewayName), Set.class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.loadBalancerName, null)) {
            return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(Sets.class, (Object)this.loadBalancerName), Set.class);
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].callConstructor(HashSet.class), Set.class);
    }

    public Set<String> getSecurityGroups() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)(ScriptBytecodeAdapter.compareEqual((Object)this.securityGroupName, null) ? callSiteArray[20].callConstructor(HashSet.class) : callSiteArray[21].call(Sets.class, (Object)this.securityGroupName)), Set.class);
    }

    public Boolean isDisabled() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return this.isDisabled;
    }

    public ServerGroup.InstanceCounts getInstanceCounts() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        Collection<AzureInstance> instances = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[22].callCurrent((GroovyObject)this);
            instances = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
        } else {
            Set<AzureInstance> set;
            instances = set = this.getInstances();
        }
        Object[] objectArray = new Object[12];
        objectArray[0] = "total";
        Object object = callSiteArray[24].callSafe(instances);
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
        objectArray[2] = "up";
        Object object2 = callSiteArray[25].callSafe(callSiteArray[26].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[27].callGetProperty(HealthState.class)));
        objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Integer.valueOf(0);
        objectArray[4] = "down";
        Object object3 = callSiteArray[28].callSafe(callSiteArray[29].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[30].callGetProperty(HealthState.class)));
        objectArray[5] = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : Integer.valueOf(0);
        objectArray[6] = "unknown";
        Object object4 = callSiteArray[31].callSafe(callSiteArray[32].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[33].callGetProperty(HealthState.class)));
        objectArray[7] = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : Integer.valueOf(0);
        objectArray[8] = "starting";
        Object object5 = callSiteArray[34].callSafe(callSiteArray[35].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[36].callGetProperty(HealthState.class)));
        objectArray[9] = DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : Integer.valueOf(0);
        objectArray[10] = "outOfService";
        Object object6 = callSiteArray[37].callSafe(callSiteArray[38].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[39].callGetProperty(HealthState.class)));
        objectArray[11] = DefaultTypeTransformation.booleanUnbox((Object)object6) ? object6 : Integer.valueOf(0);
        return (ServerGroup.InstanceCounts)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(ServerGroup.InstanceCounts.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), ServerGroup.InstanceCounts.class);
    }

    public ServerGroup.Capacity getCapacity() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return (ServerGroup.Capacity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].callConstructor(ServerGroup.Capacity.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", 1, "max", DefaultTypeTransformation.booleanUnbox(this.instances) ? callSiteArray[41].call(this.instances) : Integer.valueOf(1), "desired", DefaultTypeTransformation.booleanUnbox(this.instances) ? callSiteArray[42].call(this.instances) : Integer.valueOf(1)})), ServerGroup.Capacity.class);
    }

    public static AzureServerGroupDescription build(VirtualMachineScaleSetInner scaleSet) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        Object azureSG = callSiteArray[43].callConstructor(AzureServerGroupDescription.class);
        Object object = callSiteArray[44].call((Object)scaleSet);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)azureSG, (String)"name");
        Object parsedName = callSiteArray[45].call(Names.class, callSiteArray[46].call((Object)scaleSet));
        Map map = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callGetProperty((Object)scaleSet)) ? callSiteArray[48].callGetProperty((Object)scaleSet) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)azureSG, (String)"tags");
        Object object2 = callSiteArray[49].callGetPropertySafe(callSiteArray[50].callGetProperty((Object)scaleSet));
        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : callSiteArray[51].callGetProperty(parsedName);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)azureSG, (String)"appName");
        Object object4 = callSiteArray[52].callGetPropertySafe(callSiteArray[53].callGetProperty((Object)scaleSet));
        Object object5 = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : callSiteArray[54].callGetProperty(parsedName);
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)azureSG, (String)"stack");
        Object object6 = callSiteArray[55].callGetPropertySafe(callSiteArray[56].callGetProperty((Object)scaleSet));
        Object object7 = DefaultTypeTransformation.booleanUnbox((Object)object6) ? object6 : callSiteArray[57].callGetProperty(parsedName);
        ScriptBytecodeAdapter.setProperty((Object)object7, null, (Object)azureSG, (String)"detail");
        Object object8 = callSiteArray[58].callGetProperty(azureSG);
        ScriptBytecodeAdapter.setProperty((Object)object8, null, (Object)azureSG, (String)"application");
        Object object9 = callSiteArray[59].callGetPropertySafe(callSiteArray[60].callGetProperty((Object)scaleSet));
        Object object10 = DefaultTypeTransformation.booleanUnbox((Object)object9) ? object9 : callSiteArray[61].callGetProperty(parsedName);
        ScriptBytecodeAdapter.setProperty((Object)object10, null, (Object)azureSG, (String)"clusterName");
        Object object11 = callSiteArray[62].callGetPropertySafe(callSiteArray[63].callGetProperty((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object11, null, (Object)azureSG, (String)"securityGroupName");
        Object object12 = callSiteArray[64].callGetPropertySafe(callSiteArray[65].callGetProperty((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object12, null, (Object)azureSG, (String)"loadBalancerName");
        Object object13 = callSiteArray[66].callGetPropertySafe(callSiteArray[67].callGetProperty((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object13, null, (Object)azureSG, (String)"enableInboundNAT");
        Object object14 = callSiteArray[68].callGetPropertySafe(callSiteArray[69].callGetProperty((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object14, null, (Object)azureSG, (String)"appGatewayName");
        Object object15 = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[70].callGetProperty(azureSG), null) ? callSiteArray[71].call(callSiteArray[72].callGetProperty(AzureLoadBalancer.AzureLoadBalancerType.class)) : callSiteArray[73].call(callSiteArray[74].callGetProperty(AzureLoadBalancer.AzureLoadBalancerType.class));
        ScriptBytecodeAdapter.setProperty((Object)object15, null, (Object)azureSG, (String)"loadBalancerType");
        Object object16 = callSiteArray[75].callGetPropertySafe(callSiteArray[76].callGetProperty((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object16, null, (Object)azureSG, (String)"appGatewayBapId");
        Object networkInterfaceConfigurations = callSiteArray[77].callSafe(callSiteArray[78].callSafe(callSiteArray[79].call((Object)scaleSet)));
        if (DefaultTypeTransformation.booleanUnbox((Object)networkInterfaceConfigurations) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[80].call(networkInterfaceConfigurations), (Object)0)) {
            Object object17 = callSiteArray[81].call(callSiteArray[82].call(networkInterfaceConfigurations, (Object)0));
            ScriptBytecodeAdapter.setProperty((Object)object17, null, (Object)azureSG, (String)"enableIpForwarding");
        }
        Object object18 = callSiteArray[83].callGetPropertySafe(callSiteArray[84].callGetProperty((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object18, null, (Object)azureSG, (String)"subnetId");
        Object object19 = callSiteArray[85].call(AzureUtilities.class, callSiteArray[86].callGetProperty(azureSG));
        ScriptBytecodeAdapter.setProperty((Object)object19, null, (Object)azureSG, (String)"subnet");
        Object object20 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].callGetProperty(azureSG)) ? callSiteArray[88].call(AzureUtilities.class, callSiteArray[89].callGetProperty(azureSG)) : callSiteArray[90].callGetPropertySafe(callSiteArray[91].callGetProperty((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object20, null, (Object)azureSG, (String)"vnet");
        Object object21 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].callGetProperty(azureSG)) ? callSiteArray[93].call(AzureUtilities.class, callSiteArray[94].callGetProperty(azureSG)) : callSiteArray[95].callGetPropertySafe(callSiteArray[96].callGetProperty((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object21, null, (Object)azureSG, (String)"vnetResourceGroup");
        boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[97].callGetPropertySafe(callSiteArray[98].callGetProperty((Object)scaleSet)), (Object)"true");
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)azureSG, (String)"hasNewSubnet");
        Object object22 = callSiteArray[99].callSafe(callSiteArray[100].callGetPropertySafe(callSiteArray[101].callGetProperty((Object)scaleSet)));
        ScriptBytecodeAdapter.setProperty((Object)object22, null, (Object)azureSG, (String)"createdTime");
        Object object23 = callSiteArray[102].callConstructor(AzureNamedImage.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"isCustom", callSiteArray[103].callGetPropertySafe(callSiteArray[104].callGetProperty((Object)scaleSet)), "imageName", callSiteArray[105].callGetPropertySafe(callSiteArray[106].callGetProperty((Object)scaleSet))}));
        ScriptBytecodeAdapter.setProperty((Object)object23, null, (Object)azureSG, (String)"image");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].callGetProperty(callSiteArray[108].callGetProperty(azureSG)))) {
            Object object24 = callSiteArray[109].callConstructor(ArrayList.class);
            ScriptBytecodeAdapter.setProperty((Object)object24, null, (Object)azureSG, (String)"storageAccountNames");
            String storageNames = ShortTypeHandling.castToString((Object)callSiteArray[110].callGetPropertySafe(callSiteArray[111].callGetProperty((Object)scaleSet)));
            if (DefaultTypeTransformation.booleanUnbox((Object)storageNames)) {
                callSiteArray[112].call(callSiteArray[113].callGetProperty(azureSG), callSiteArray[114].call((Object)storageNames, (Object)","));
            }
        }
        Object object25 = callSiteArray[115].call((Object)scaleSet);
        ScriptBytecodeAdapter.setProperty((Object)object25, null, (Object)azureSG, (String)"doNotRunExtensionsOnOverprovisionedVMs");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[116].call((Object)scaleSet), null)) {
            ResourceIdentityType rType = (ResourceIdentityType)ShortTypeHandling.castToEnum((Object)callSiteArray[117].call(callSiteArray[118].call((Object)scaleSet)), ResourceIdentityType.class);
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                boolean bl2 = ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[119].callGetProperty(ResourceIdentityType.class)) || ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[120].callGetProperty(ResourceIdentityType.class));
                ScriptBytecodeAdapter.setProperty((Object)bl2, null, (Object)azureSG, (String)"useSystemManagedIdentity");
            } else {
                boolean bl3 = ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[121].callGetProperty(ResourceIdentityType.class)) || ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[122].callGetProperty(ResourceIdentityType.class));
                ScriptBytecodeAdapter.setProperty((Object)bl3, null, (Object)azureSG, (String)"useSystemManagedIdentity");
            }
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[123].callGetProperty(ResourceIdentityType.class)) || ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[124].callGetProperty(ResourceIdentityType.class))) {
                    StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[125].callConstructor(StringBuilder.class), StringBuilder.class);
                    String identity = null;
                    Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[126].call(callSiteArray[127].call(callSiteArray[128].call(callSiteArray[129].call((Object)scaleSet)))), Iterator.class);
                    while (iterator.hasNext()) {
                        identity = ShortTypeHandling.castToString(iterator.next());
                        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[130].call((Object)sb), (Object)0)) {
                            callSiteArray[131].call((Object)sb, (Object)",");
                        }
                        callSiteArray[132].call((Object)sb, (Object)identity);
                    }
                    Object object26 = callSiteArray[133].call((Object)sb);
                    ScriptBytecodeAdapter.setProperty((Object)object26, null, (Object)azureSG, (String)"userAssignedIdentities");
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[134].callGetProperty(ResourceIdentityType.class)) || ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[135].callGetProperty(ResourceIdentityType.class))) {
                StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[136].callConstructor(StringBuilder.class), StringBuilder.class);
                String identity = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[137].call(callSiteArray[138].call(callSiteArray[139].call(callSiteArray[140].call((Object)scaleSet)))), Iterator.class);
                while (iterator.hasNext()) {
                    identity = ShortTypeHandling.castToString(iterator.next());
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[141].call((Object)sb), (Object)0)) {
                        callSiteArray[142].call((Object)sb, (Object)",");
                    }
                    callSiteArray[143].call((Object)sb, (Object)identity);
                }
                Object object27 = callSiteArray[144].call((Object)sb);
                ScriptBytecodeAdapter.setProperty((Object)object27, null, (Object)azureSG, (String)"userAssignedIdentities");
            }
        }
        Object object28 = callSiteArray[145].call((Object)scaleSet);
        ScriptBytecodeAdapter.setProperty((Object)object28, null, (Object)azureSG, (String)"region");
        Object object29 = callSiteArray[146].callStatic(AzureServerGroupDescription.class, callSiteArray[147].call(callSiteArray[148].call(callSiteArray[149].call((Object)scaleSet))));
        ScriptBytecodeAdapter.setProperty((Object)object29, null, (Object)azureSG, (String)"upgradePolicy");
        Object termProfile = callSiteArray[150].callSafe(callSiteArray[151].callSafe(callSiteArray[152].call((Object)scaleSet)));
        if (DefaultTypeTransformation.booleanUnbox((Object)termProfile)) {
            Object[] str = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[153].call(callSiteArray[154].call(termProfile), (Object)"\\d+"), String[].class);
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[155].call((Object)str), (Object)0)) {
                    Object object30 = callSiteArray[156].call(callSiteArray[157].call((Object)str, (Object)0));
                    ScriptBytecodeAdapter.setProperty((Object)object30, null, (Object)azureSG, (String)"terminationNotBeforeTimeoutInMinutes");
                }
            } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[158].call((Object)str), (Object)0)) {
                Object object31 = callSiteArray[159].call(BytecodeInterface8.objectArrayGet((Object[])str, (int)0));
                ScriptBytecodeAdapter.setProperty((Object)object31, null, (Object)azureSG, (String)"terminationNotBeforeTimeoutInMinutes");
            }
        }
        Object object32 = callSiteArray[160].callSafe(callSiteArray[161].callSafe(callSiteArray[162].callSafe(callSiteArray[163].call((Object)scaleSet))));
        ScriptBytecodeAdapter.setProperty((Object)object32, null, (Object)azureSG, (String)"windowsTimeZone");
        Object storageProfile = callSiteArray[164].callSafe(callSiteArray[165].call((Object)scaleSet));
        Object imgRef = callSiteArray[166].callSafe(storageProfile);
        if (DefaultTypeTransformation.booleanUnbox((Object)imgRef)) {
            Object object33 = callSiteArray[167].call(imgRef);
            ScriptBytecodeAdapter.setProperty((Object)object33, null, (Object)callSiteArray[168].callGetProperty(azureSG), (String)"offer");
            Object object34 = callSiteArray[169].call(imgRef);
            ScriptBytecodeAdapter.setProperty((Object)object34, null, (Object)callSiteArray[170].callGetProperty(azureSG), (String)"publisher");
            Object object35 = callSiteArray[171].call(imgRef);
            ScriptBytecodeAdapter.setProperty((Object)object35, null, (Object)callSiteArray[172].callGetProperty(azureSG), (String)"sku");
            Object object36 = callSiteArray[173].call(imgRef);
            ScriptBytecodeAdapter.setProperty((Object)object36, null, (Object)callSiteArray[174].callGetProperty(azureSG), (String)"version");
        }
        Object object37 = callSiteArray[175].callSafe(storageProfile);
        ScriptBytecodeAdapter.setProperty((Object)object37, null, (Object)azureSG, (String)"dataDisks");
        Object osConfig = callSiteArray[176].callConstructor(AzureOperatingSystemConfig.class);
        Object osProfile = callSiteArray[177].callSafe(callSiteArray[178].callSafe((Object)scaleSet));
        if (DefaultTypeTransformation.booleanUnbox((Object)osProfile)) {
            Object object38 = callSiteArray[179].call(osProfile);
            ScriptBytecodeAdapter.setProperty((Object)object38, null, (Object)osConfig, (String)"adminPassword");
            Object object39 = callSiteArray[180].call(osProfile);
            ScriptBytecodeAdapter.setProperty((Object)object39, null, (Object)osConfig, (String)"adminUserName");
            Object object40 = callSiteArray[181].call(osProfile);
            ScriptBytecodeAdapter.setProperty((Object)object40, null, (Object)osConfig, (String)"computerNamePrefix");
            Object object41 = callSiteArray[182].call(osProfile);
            ScriptBytecodeAdapter.setProperty((Object)object41, null, (Object)osConfig, (String)"customData");
        }
        Object object42 = osConfig;
        ScriptBytecodeAdapter.setProperty((Object)object42, null, (Object)azureSG, (String)"osConfig");
        Object customScriptSettings = callSiteArray[183].callConstructor(AzureExtensionCustomScriptSettings.class);
        Object extensionProfile = callSiteArray[184].callSafe(callSiteArray[185].callSafe((Object)scaleSet));
        if (DefaultTypeTransformation.booleanUnbox((Object)extensionProfile)) {
            public final class _build_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _build_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _build_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _build_closure1.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(it), (Object)callSiteArray[1].callGetProperty(AzureUtilities.class)) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(it), (Object)callSiteArray[3].callGetProperty(AzureUtilities.class));
                    }
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].call(it), (Object)callSiteArray[5].callGetProperty(AzureUtilities.class)) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(it), (Object)callSiteArray[7].callGetProperty(AzureUtilities.class));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _build_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _build_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "type";
                    stringArray[1] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX";
                    stringArray[2] = "type";
                    stringArray[3] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS";
                    stringArray[4] = "type";
                    stringArray[5] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX";
                    stringArray[6] = "type";
                    stringArray[7] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _build_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_build_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _build_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object customScriptExtensionSettings = callSiteArray[186].callSafe(callSiteArray[187].call(callSiteArray[188].call(extensionProfile), (Object)new _build_closure1(AzureServerGroupDescription.class, AzureServerGroupDescription.class)));
            if (DefaultTypeTransformation.booleanUnbox((Object)customScriptExtensionSettings)) {
                Object object43;
                customScriptSettings = object43 = callSiteArray[189].call(callSiteArray[190].callGetProperty(AzureServerGroupDescription.class), customScriptExtensionSettings, AzureExtensionCustomScriptSettings.class);
            }
        }
        Object object44 = customScriptSettings;
        ScriptBytecodeAdapter.setProperty((Object)object44, null, (Object)azureSG, (String)"customScriptsSettings");
        Object sku = callSiteArray[191].callConstructor(AzureScaleSetSku.class);
        Object skuData = callSiteArray[192].call((Object)scaleSet);
        if (DefaultTypeTransformation.booleanUnbox((Object)skuData)) {
            Object object45 = callSiteArray[193].call(skuData);
            ScriptBytecodeAdapter.setProperty((Object)object45, null, (Object)sku, (String)"capacity");
            Object object46 = callSiteArray[194].call(skuData);
            ScriptBytecodeAdapter.setProperty((Object)object46, null, (Object)sku, (String)"name");
            Object object47 = callSiteArray[195].call(skuData);
            ScriptBytecodeAdapter.setProperty((Object)object47, null, (Object)sku, (String)"tier");
        }
        Object object48 = sku;
        ScriptBytecodeAdapter.setProperty((Object)object48, null, (Object)azureSG, (String)"sku");
        Object zones = callSiteArray[196].call((Object)scaleSet);
        Object object49 = ScriptBytecodeAdapter.compareEqual((Object)zones, null) ? callSiteArray[197].callConstructor(HashSet.class) : callSiteArray[198].call(zones);
        ScriptBytecodeAdapter.setProperty((Object)object49, null, (Object)azureSG, (String)"zones");
        Object object50 = callSiteArray[199].call((Object)scaleSet);
        ScriptBytecodeAdapter.setProperty((Object)object50, null, (Object)azureSG, (String)"provisioningState");
        return (AzureServerGroupDescription)ScriptBytecodeAdapter.castToType((Object)azureSG, AzureServerGroupDescription.class);
    }

    public static Collection<Instance> filterInstancesByHealthState(Set<? extends Instance> instances, HealthState healthState) {
        Reference healthState2 = new Reference((Object)healthState);
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        public final class _filterInstancesByHealthState_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthState;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _filterInstancesByHealthState_closure2(Object _outerInstance, Object _thisObject, Reference healthState) {
                Reference reference;
                CallSite[] callSiteArray = _filterInstancesByHealthState_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.healthState = reference = healthState;
            }

            public Object doCall(Instance it) {
                CallSite[] callSiteArray = _filterInstancesByHealthState_closure2.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call((Object)it), (Object)this.healthState.get());
            }

            public Object call(Instance it) {
                CallSite[] callSiteArray = _filterInstancesByHealthState_closure2.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)it);
            }

            @Generated
            public HealthState getHealthState() {
                CallSite[] callSiteArray = _filterInstancesByHealthState_closure2.$getCallSiteArray();
                return (HealthState)ShortTypeHandling.castToEnum((Object)this.healthState.get(), HealthState.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterInstancesByHealthState_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getHealthState";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _filterInstancesByHealthState_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_filterInstancesByHealthState_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _filterInstancesByHealthState_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[200].callSafe(instances, (Object)new _filterInstancesByHealthState_closure2(AzureServerGroupDescription.class, AzureServerGroupDescription.class, healthState2)), Collection.class);
    }

    public void addInboundPortConfig(String name, int startRange, int endRange, String protocol, int backendPort) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        AzureInboundPortConfig inboundConfig = (AzureInboundPortConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[201].callConstructor(AzureInboundPortConfig.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name})), AzureInboundPortConfig.class);
        int n = startRange;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, AzureServerGroupDescription.class, (GroovyObject)inboundConfig, (String)"frontEndPortRangeStart");
        int n2 = endRange;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n2, AzureServerGroupDescription.class, (GroovyObject)inboundConfig, (String)"frontEndPortRangeEnd");
        int n3 = backendPort;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n3, AzureServerGroupDescription.class, (GroovyObject)inboundConfig, (String)"backendPort");
        String string = protocol;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, AzureServerGroupDescription.class, (GroovyObject)inboundConfig, (String)"protocol");
        callSiteArray[202].call(this.inboundPortConfigs, (Object)inboundConfig);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureServerGroupDescription.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureServerGroupDescription.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureServerGroupDescription.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureServerGroupDescription.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public Set<AzureInstance> getInstances() {
        return this.instances;
    }

    @Generated
    public void setInstances(Set<AzureInstance> set) {
        this.instances = set;
    }

    @Generated
    public void setLoadBalancers(Set<String> set) {
        this.loadBalancers = set;
    }

    @Generated
    public void setSecurityGroups(Set<String> set) {
        this.securityGroups = set;
    }

    @Generated
    public Set<String> getZones() {
        return this.zones;
    }

    @Generated
    public void setZones(Set<String> set) {
        this.zones = set;
    }

    @Generated
    public Map<String, String> getInstanceTags() {
        return this.instanceTags;
    }

    @Generated
    public void setInstanceTags(Map<String, String> map) {
        this.instanceTags = map;
    }

    @Generated
    public final String getType() {
        return this.type;
    }

    @Override
    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public Map<String, Object> getLaunchConfig() {
        return this.launchConfig;
    }

    @Generated
    public void setLaunchConfig(Map<String, Object> map) {
        this.launchConfig = map;
    }

    @Generated
    public void setCapacity(ServerGroup.Capacity capacity) {
        this.capacity = capacity;
    }

    @Generated
    public ServerGroup.ImagesSummary getImagesSummary() {
        return this.imagesSummary;
    }

    @Generated
    public void setImagesSummary(ServerGroup.ImagesSummary imagesSummary) {
        this.imagesSummary = imagesSummary;
    }

    @Generated
    public ServerGroup.ImageSummary getImageSummary() {
        return this.imageSummary;
    }

    @Generated
    public void setImageSummary(ServerGroup.ImageSummary imageSummary) {
        this.imageSummary = imageSummary;
    }

    @Generated
    public UpgradePolicy getUpgradePolicy() {
        return this.upgradePolicy;
    }

    @Generated
    public void setUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
    }

    @Generated
    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    @Generated
    public void setLoadBalancerName(String string) {
        this.loadBalancerName = string;
    }

    @Generated
    public String getLoadBalancerType() {
        return this.loadBalancerType;
    }

    @Generated
    public void setLoadBalancerType(String string) {
        this.loadBalancerType = string;
    }

    @Generated
    public String getAppGatewayName() {
        return this.appGatewayName;
    }

    @Generated
    public void setAppGatewayName(String string) {
        this.appGatewayName = string;
    }

    @Generated
    public String getAppGatewayBapId() {
        return this.appGatewayBapId;
    }

    @Generated
    public void setAppGatewayBapId(String string) {
        this.appGatewayBapId = string;
    }

    @Generated
    public AzureNamedImage getImage() {
        return this.image;
    }

    @Generated
    public void setImage(AzureNamedImage azureNamedImage) {
        this.image = azureNamedImage;
    }

    @Generated
    public AzureScaleSetSku getSku() {
        return this.sku;
    }

    @Generated
    public void setSku(AzureScaleSetSku azureScaleSetSku) {
        this.sku = azureScaleSetSku;
    }

    @Generated
    public AzureOperatingSystemConfig getOsConfig() {
        return this.osConfig;
    }

    @Generated
    public void setOsConfig(AzureOperatingSystemConfig azureOperatingSystemConfig) {
        this.osConfig = azureOperatingSystemConfig;
    }

    @Generated
    public String getProvisioningState() {
        return this.provisioningState;
    }

    @Generated
    public void setProvisioningState(String string) {
        this.provisioningState = string;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public void setApplication(String string) {
        this.application = string;
    }

    @Generated
    public void setClusterName(String string) {
        this.clusterName = string;
    }

    @Generated
    public String getSecurityGroupName() {
        return this.securityGroupName;
    }

    @Generated
    public void setSecurityGroupName(String string) {
        this.securityGroupName = string;
    }

    @Generated
    public String getSubnetId() {
        return this.subnetId;
    }

    @Generated
    public void setSubnetId(String string) {
        this.subnetId = string;
    }

    @Generated
    public List<String> getStorageAccountNames() {
        return this.storageAccountNames;
    }

    @Generated
    public void setStorageAccountNames(List<String> list) {
        this.storageAccountNames = list;
    }

    @Generated
    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    @Generated
    public void setIsDisabled(Boolean bl) {
        this.isDisabled = bl;
    }

    @Generated
    public List<AzureInboundPortConfig> getInboundPortConfigs() {
        return this.inboundPortConfigs;
    }

    @Generated
    public void setInboundPortConfigs(List<AzureInboundPortConfig> list) {
        this.inboundPortConfigs = list;
    }

    @Generated
    public String getVnet() {
        return this.vnet;
    }

    @Generated
    public void setVnet(String string) {
        this.vnet = string;
    }

    @Generated
    public String getSubnet() {
        return this.subnet;
    }

    @Generated
    public void setSubnet(String string) {
        this.subnet = string;
    }

    @Generated
    public String getVnetResourceGroup() {
        return this.vnetResourceGroup;
    }

    @Generated
    public void setVnetResourceGroup(String string) {
        this.vnetResourceGroup = string;
    }

    @Generated
    public Boolean getHasNewSubnet() {
        return this.hasNewSubnet;
    }

    @Generated
    public void setHasNewSubnet(Boolean bl) {
        this.hasNewSubnet = bl;
    }

    @Generated
    public Boolean getCreateNewSubnet() {
        return this.createNewSubnet;
    }

    @Generated
    public void setCreateNewSubnet(Boolean bl) {
        this.createNewSubnet = bl;
    }

    @Generated
    public AzureExtensionCustomScriptSettings getCustomScriptsSettings() {
        return this.customScriptsSettings;
    }

    @Generated
    public void setCustomScriptsSettings(AzureExtensionCustomScriptSettings azureExtensionCustomScriptSettings) {
        this.customScriptsSettings = azureExtensionCustomScriptSettings;
    }

    @Generated
    public AzureExtensionHealthSettings getHealthSettings() {
        return this.healthSettings;
    }

    @Generated
    public void setHealthSettings(AzureExtensionHealthSettings azureExtensionHealthSettings) {
        this.healthSettings = azureExtensionHealthSettings;
    }

    @Generated
    public Boolean getEnableInboundNAT() {
        return this.enableInboundNAT;
    }

    @Generated
    public void setEnableInboundNAT(Boolean bl) {
        this.enableInboundNAT = bl;
    }

    @Generated
    public List<VirtualMachineScaleSetDataDisk> getDataDisks() {
        return this.dataDisks;
    }

    @Generated
    public void setDataDisks(List<VirtualMachineScaleSetDataDisk> list) {
        this.dataDisks = list;
    }

    @Generated
    public Integer getTerminationNotBeforeTimeoutInMinutes() {
        return this.terminationNotBeforeTimeoutInMinutes;
    }

    @Generated
    public void setTerminationNotBeforeTimeoutInMinutes(Integer n) {
        this.terminationNotBeforeTimeoutInMinutes = n;
    }

    @Generated
    public String getWindowsTimeZone() {
        return this.windowsTimeZone;
    }

    @Generated
    public void setWindowsTimeZone(String string) {
        this.windowsTimeZone = string;
    }

    @Generated
    public Boolean getDoNotRunExtensionsOnOverprovisionedVMs() {
        return this.doNotRunExtensionsOnOverprovisionedVMs;
    }

    @Generated
    public void setDoNotRunExtensionsOnOverprovisionedVMs(Boolean bl) {
        this.doNotRunExtensionsOnOverprovisionedVMs = bl;
    }

    @Generated
    public Boolean getUseSystemManagedIdentity() {
        return this.useSystemManagedIdentity;
    }

    @Generated
    public void setUseSystemManagedIdentity(Boolean bl) {
        this.useSystemManagedIdentity = bl;
    }

    @Generated
    public String getUserAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    @Generated
    public void setUserAssignedIdentities(String string) {
        this.userAssignedIdentities = string;
    }

    @Generated
    public Boolean getEnableIpForwarding() {
        return this.enableIpForwarding;
    }

    @Generated
    public void setEnableIpForwarding(Boolean bl) {
        this.enableIpForwarding = bl;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ String super$2$getCloudProvider() {
        return super.getCloudProvider();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "ID";
        stringArray[1] = "ID";
        stringArray[2] = "plus";
        stringArray[3] = "div";
        stringArray[4] = "capacity";
        stringArray[5] = "div";
        stringArray[6] = "capacity";
        stringArray[7] = "toLowerCase";
        stringArray[8] = "toLowerCase";
        stringArray[9] = "Automatic";
        stringArray[10] = "Manual";
        stringArray[11] = "cluster";
        stringArray[12] = "parseName";
        stringArray[13] = "name";
        stringArray[14] = "format";
        stringArray[15] = "stack";
        stringArray[16] = "detail";
        stringArray[17] = "newHashSet";
        stringArray[18] = "newHashSet";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "newHashSet";
        stringArray[22] = "getInstances";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "size";
        stringArray[25] = "size";
        stringArray[26] = "filterInstancesByHealthState";
        stringArray[27] = "Up";
        stringArray[28] = "size";
        stringArray[29] = "filterInstancesByHealthState";
        stringArray[30] = "Down";
        stringArray[31] = "size";
        stringArray[32] = "filterInstancesByHealthState";
        stringArray[33] = "Unknown";
        stringArray[34] = "size";
        stringArray[35] = "filterInstancesByHealthState";
        stringArray[36] = "Starting";
        stringArray[37] = "size";
        stringArray[38] = "filterInstancesByHealthState";
        stringArray[39] = "OutOfService";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "size";
        stringArray[42] = "size";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "name";
        stringArray[45] = "parseName";
        stringArray[46] = "name";
        stringArray[47] = "tags";
        stringArray[48] = "tags";
        stringArray[49] = "appName";
        stringArray[50] = "tags";
        stringArray[51] = "app";
        stringArray[52] = "stack";
        stringArray[53] = "tags";
        stringArray[54] = "stack";
        stringArray[55] = "detail";
        stringArray[56] = "tags";
        stringArray[57] = "detail";
        stringArray[58] = "appName";
        stringArray[59] = "cluster";
        stringArray[60] = "tags";
        stringArray[61] = "cluster";
        stringArray[62] = "securityGroupName";
        stringArray[63] = "tags";
        stringArray[64] = "loadBalancerName";
        stringArray[65] = "tags";
        stringArray[66] = "enableInboundNAT";
        stringArray[67] = "tags";
        stringArray[68] = "appGatewayName";
        stringArray[69] = "tags";
        stringArray[70] = "appGatewayName";
        stringArray[71] = "toString";
        stringArray[72] = "AZURE_APPLICATION_GATEWAY";
        stringArray[73] = "toString";
        stringArray[74] = "AZURE_LOAD_BALANCER";
        stringArray[75] = "appGatewayBapId";
        stringArray[76] = "tags";
        stringArray[77] = "networkInterfaceConfigurations";
        stringArray[78] = "networkProfile";
        stringArray[79] = "virtualMachineProfile";
        stringArray[80] = "size";
        stringArray[81] = "enableIPForwarding";
        stringArray[82] = "getAt";
        stringArray[83] = "subnetId";
        stringArray[84] = "tags";
        stringArray[85] = "getNameFromResourceId";
        stringArray[86] = "subnetId";
        stringArray[87] = "subnetId";
        stringArray[88] = "getNameFromResourceId";
        stringArray[89] = "subnetId";
        stringArray[90] = "vnet";
        stringArray[91] = "tags";
        stringArray[92] = "subnetId";
        stringArray[93] = "getResourceGroupNameFromResourceId";
        stringArray[94] = "subnetId";
        stringArray[95] = "vnetResourceGroup";
        stringArray[96] = "tags";
        stringArray[97] = "hasNewSubnet";
        stringArray[98] = "tags";
        stringArray[99] = "toLong";
        stringArray[100] = "createdTime";
        stringArray[101] = "tags";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "customImage";
        stringArray[104] = "tags";
        stringArray[105] = "imageName";
        stringArray[106] = "tags";
        stringArray[107] = "isCustom";
        stringArray[108] = "image";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "storageAccountNames";
        stringArray[111] = "tags";
        stringArray[112] = "addAll";
        stringArray[113] = "storageAccountNames";
        stringArray[114] = "split";
        stringArray[115] = "doNotRunExtensionsOnOverprovisionedVMs";
        stringArray[116] = "identity";
        stringArray[117] = "type";
        stringArray[118] = "identity";
        stringArray[119] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
        stringArray[120] = "SYSTEM_ASSIGNED";
        stringArray[121] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
        stringArray[122] = "SYSTEM_ASSIGNED";
        stringArray[123] = "USER_ASSIGNED";
        stringArray[124] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "iterator";
        stringArray[127] = "keySet";
        stringArray[128] = "userAssignedIdentities";
        stringArray[129] = "identity";
        stringArray[130] = "length";
        stringArray[131] = "append";
        stringArray[132] = "append";
        stringArray[133] = "toString";
        stringArray[134] = "USER_ASSIGNED";
        stringArray[135] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
        stringArray[136] = "<$constructor$>";
        stringArray[137] = "iterator";
        stringArray[138] = "keySet";
        stringArray[139] = "userAssignedIdentities";
        stringArray[140] = "identity";
        stringArray[141] = "length";
        stringArray[142] = "append";
        stringArray[143] = "append";
        stringArray[144] = "toString";
        stringArray[145] = "location";
        stringArray[146] = "getPolicyFromMode";
        stringArray[147] = "name";
        stringArray[148] = "mode";
        stringArray[149] = "upgradePolicy";
        stringArray[150] = "terminateNotificationProfile";
        stringArray[151] = "scheduledEventsProfile";
        stringArray[152] = "virtualMachineProfile";
        stringArray[153] = "findAll";
        stringArray[154] = "notBeforeTimeout";
        stringArray[155] = "size";
        stringArray[156] = "toInteger";
        stringArray[157] = "getAt";
        stringArray[158] = "size";
        stringArray[159] = "toInteger";
        stringArray[160] = "timeZone";
        stringArray[161] = "windowsConfiguration";
        stringArray[162] = "osProfile";
        stringArray[163] = "virtualMachineProfile";
        stringArray[164] = "storageProfile";
        stringArray[165] = "virtualMachineProfile";
        stringArray[166] = "imageReference";
        stringArray[167] = "offer";
        stringArray[168] = "image";
        stringArray[169] = "publisher";
        stringArray[170] = "image";
        stringArray[171] = "sku";
        stringArray[172] = "image";
        stringArray[173] = "version";
        stringArray[174] = "image";
        stringArray[175] = "dataDisks";
        stringArray[176] = "<$constructor$>";
        stringArray[177] = "osProfile";
        stringArray[178] = "virtualMachineProfile";
        stringArray[179] = "adminPassword";
        stringArray[180] = "adminUsername";
        stringArray[181] = "computerNamePrefix";
        stringArray[182] = "customData";
        stringArray[183] = "<$constructor$>";
        stringArray[184] = "extensionProfile";
        stringArray[185] = "virtualMachineProfile";
        stringArray[186] = "settings";
        stringArray[187] = "find";
        stringArray[188] = "extensions";
        stringArray[189] = "convertValue";
        stringArray[190] = "mapper";
        stringArray[191] = "<$constructor$>";
        stringArray[192] = "sku";
        stringArray[193] = "capacity";
        stringArray[194] = "name";
        stringArray[195] = "tier";
        stringArray[196] = "zones";
        stringArray[197] = "<$constructor$>";
        stringArray[198] = "toSet";
        stringArray[199] = "provisioningState";
        stringArray[200] = "findAll";
        stringArray[201] = "<$constructor$>";
        stringArray[202] = "add";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[203];
        AzureServerGroupDescription.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AzureServerGroupDescription.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AzureServerGroupDescription.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static final class UpgradePolicy
    extends Enum<UpgradePolicy>
    implements GroovyObject {
        public static final /* enum */ UpgradePolicy Automatic;
        public static final /* enum */ UpgradePolicy Manual;
        public static final UpgradePolicy MIN_VALUE;
        public static final UpgradePolicy MAX_VALUE;
        private static final /* synthetic */ UpgradePolicy[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public UpgradePolicy(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (ScriptBytecodeAdapter.compareEqual((Object)__namedArgs, null)) {
                throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"One of the enum constants for enum com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureServerGroupDescription$UpgradePolicy was initialized with null. Please use a non-null value or define your own constructor.");
            }
            callSiteArray[1].callStatic(ImmutableASTTransformation.class, (Object)this, (Object)__namedArgs);
        }

        @Generated
        public UpgradePolicy() {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            this((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(LinkedHashMap.class), LinkedHashMap.class));
        }

        public static final UpgradePolicy[] values() {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            return (UpgradePolicy[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), UpgradePolicy[].class);
        }

        public /* synthetic */ UpgradePolicy next() {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            Object ordinal = callSiteArray[3].call(callSiteArray[4].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)callSiteArray[5].call((Object)$VALUES))) {
                Integer n = 0;
                ordinal = n;
            }
            return (UpgradePolicy)ShortTypeHandling.castToEnum((Object)callSiteArray[6].call((Object)$VALUES, ordinal), UpgradePolicy.class);
        }

        public /* synthetic */ UpgradePolicy previous() {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            Object ordinal = callSiteArray[7].call(callSiteArray[8].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Object object;
                ordinal = object = callSiteArray[9].call(callSiteArray[10].call((Object)$VALUES), (Object)1);
            }
            return (UpgradePolicy)ShortTypeHandling.castToEnum((Object)callSiteArray[11].call((Object)$VALUES, ordinal), UpgradePolicy.class);
        }

        public static UpgradePolicy valueOf(String name) {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            return (UpgradePolicy)ShortTypeHandling.castToEnum((Object)callSiteArray[12].callStatic(UpgradePolicy.class, UpgradePolicy.class, (Object)name), UpgradePolicy.class);
        }

        public static final /* synthetic */ UpgradePolicy $INIT(Object ... para) {
            UpgradePolicy upgradePolicy;
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, UpgradePolicy.class)) {
                case -1348271900: {
                    UpgradePolicy upgradePolicy2;
                    upgradePolicy = upgradePolicy2;
                    Object[] objectArray2 = objectArray;
                    upgradePolicy2 = new UpgradePolicy();
                    break;
                }
                case -242181752: {
                    UpgradePolicy upgradePolicy2;
                    upgradePolicy = upgradePolicy2;
                    Object[] objectArray2 = objectArray;
                    upgradePolicy2 = new UpgradePolicy((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return upgradePolicy;
        }

        static {
            UpgradePolicy upgradePolicy;
            UpgradePolicy upgradePolicy2;
            Object object = UpgradePolicy.$getCallSiteArray()[13].callStatic(UpgradePolicy.class, (Object)"Automatic", (Object)0);
            Automatic = (UpgradePolicy)ShortTypeHandling.castToEnum((Object)object, UpgradePolicy.class);
            Object object2 = UpgradePolicy.$getCallSiteArray()[14].callStatic(UpgradePolicy.class, (Object)"Manual", (Object)1);
            Manual = (UpgradePolicy)ShortTypeHandling.castToEnum((Object)object2, UpgradePolicy.class);
            MIN_VALUE = upgradePolicy2 = Automatic;
            MAX_VALUE = upgradePolicy = Manual;
            UpgradePolicy[] upgradePolicyArray = new UpgradePolicy[]{Automatic, Manual};
            $VALUES = upgradePolicyArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != UpgradePolicy.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "checkPropNames";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "next";
            stringArray[4] = "ordinal";
            stringArray[5] = "size";
            stringArray[6] = "getAt";
            stringArray[7] = "previous";
            stringArray[8] = "ordinal";
            stringArray[9] = "minus";
            stringArray[10] = "size";
            stringArray[11] = "getAt";
            stringArray[12] = "valueOf";
            stringArray[13] = "$INIT";
            stringArray[14] = "$INIT";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[15];
            UpgradePolicy.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(UpgradePolicy.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = UpgradePolicy.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureScaleSetSku
    implements GroovyObject {
        private String name;
        private String tier;
        private Long capacity;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureScaleSetSku() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureScaleSetSku.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureScaleSetSku.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureScaleSetSku.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureScaleSetSku.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureScaleSetSku.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getTier() {
            return this.tier;
        }

        @Generated
        public void setTier(String string) {
            this.tier = string;
        }

        @Generated
        public Long getCapacity() {
            return this.capacity;
        }

        @Generated
        public void setCapacity(Long l) {
            this.capacity = l;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureScaleSetSku.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureScaleSetSku.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureOperatingSystemConfig
    implements GroovyObject {
        private String adminUserName;
        private String adminPassword;
        private String computerNamePrefix;
        private String customData;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureOperatingSystemConfig() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureOperatingSystemConfig.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureOperatingSystemConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureOperatingSystemConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureOperatingSystemConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureOperatingSystemConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getAdminUserName() {
            return this.adminUserName;
        }

        @Generated
        public void setAdminUserName(String string) {
            this.adminUserName = string;
        }

        @Generated
        public String getAdminPassword() {
            return this.adminPassword;
        }

        @Generated
        public void setAdminPassword(String string) {
            this.adminPassword = string;
        }

        @Generated
        public String getComputerNamePrefix() {
            return this.computerNamePrefix;
        }

        @Generated
        public void setComputerNamePrefix(String string) {
            this.computerNamePrefix = string;
        }

        @Generated
        public String getCustomData() {
            return this.customData;
        }

        @Generated
        public void setCustomData(String string) {
            this.customData = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureOperatingSystemConfig.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureOperatingSystemConfig.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureInboundPortConfig
    implements GroovyObject {
        private String name;
        private String protocol;
        private int frontEndPortRangeStart;
        private int frontEndPortRangeEnd;
        private int backendPort;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureInboundPortConfig() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureInboundPortConfig.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureInboundPortConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureInboundPortConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureInboundPortConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureInboundPortConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public void setProtocol(String string) {
            this.protocol = string;
        }

        @Generated
        public int getFrontEndPortRangeStart() {
            return this.frontEndPortRangeStart;
        }

        @Generated
        public void setFrontEndPortRangeStart(int n) {
            this.frontEndPortRangeStart = n;
        }

        @Generated
        public int getFrontEndPortRangeEnd() {
            return this.frontEndPortRangeEnd;
        }

        @Generated
        public void setFrontEndPortRangeEnd(int n) {
            this.frontEndPortRangeEnd = n;
        }

        @Generated
        public int getBackendPort() {
            return this.backendPort;
        }

        @Generated
        public void setBackendPort(int n) {
            this.backendPort = n;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureInboundPortConfig.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureInboundPortConfig.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureExtensionHealthSettings
    implements GroovyObject {
        private String protocol;
        private String port;
        private String requestPath;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureExtensionHealthSettings() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureExtensionHealthSettings.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureExtensionHealthSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureExtensionHealthSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureExtensionHealthSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureExtensionHealthSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public void setProtocol(String string) {
            this.protocol = string;
        }

        @Generated
        public String getPort() {
            return this.port;
        }

        @Generated
        public void setPort(String string) {
            this.port = string;
        }

        @Generated
        public String getRequestPath() {
            return this.requestPath;
        }

        @Generated
        public void setRequestPath(String string) {
            this.requestPath = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureExtensionHealthSettings.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureExtensionHealthSettings.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureExtensionCustomScriptSettings
    implements GroovyObject {
        private Collection<String> fileUris;
        private String commandToExecute;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureExtensionCustomScriptSettings() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureExtensionCustomScriptSettings.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureExtensionCustomScriptSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureExtensionCustomScriptSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureExtensionCustomScriptSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureExtensionCustomScriptSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Collection<String> getFileUris() {
            return this.fileUris;
        }

        @Generated
        public void setFileUris(Collection<String> collection) {
            this.fileUris = collection;
        }

        @Generated
        public String getCommandToExecute() {
            return this.commandToExecute;
        }

        @Generated
        public void setCommandToExecute(String string) {
            this.commandToExecute = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureExtensionCustomScriptSettings.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureExtensionCustomScriptSettings.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

