/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.security;

import com.netflix.spinnaker.clouddriver.azure.client.AzureComputeClient;
import com.netflix.spinnaker.clouddriver.azure.resources.vmimage.model.AzureCustomImageStorage;
import com.netflix.spinnaker.clouddriver.azure.resources.vmimage.model.AzureVMImage;
import com.netflix.spinnaker.clouddriver.azure.security.AzureCredentials;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureNamedAccountCredentials
extends AbstractAccountCredentials<AzureCredentials>
implements GroovyObject {
    private static final String CLOUD_PROVIDER = "azure";
    private final String accountName;
    private final String environment;
    private final String accountType;
    private final String tenantId;
    private final String subscriptionId;
    private final String clientId;
    private final String appKey;
    private final List<AzureRegion> regions;
    private final List<AzureVMImage> vmImages;
    private final List<AzureCustomImageStorage> vmCustomImages;
    private final String applicationName;
    private final List<String> requiredGroupMembership;
    private final AzureCredentials credentials;
    private final String defaultKeyVault;
    private final String defaultResourceGroup;
    private final Map<String, List<AzureComputeClient.VirtualMachineSize>> locationToInstanceTypesMap;
    private final List<String> regionsSupportZones;
    private final List<String> availabilityZones;
    private final Boolean useSshPublicKey;
    private final Permissions permissions;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AzureNamedAccountCredentials(String accountName, String environment, String accountType, String clientId, String appKey, String tenantId, String subscriptionId, List<String> regions, List<AzureVMImage> vmImages, List<AzureCustomImageStorage> vmCustomImages, String defaultResourceGroup, String defaultKeyVault, Boolean useSshPublicKey, String applicationName, Permissions permissions, List<String> requiredGroupMembership) {
        Permissions permissions2;
        List list;
        Boolean bl;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.accountName = string10 = accountName;
        this.environment = string9 = environment;
        this.accountType = string8 = accountType;
        this.clientId = string7 = clientId;
        this.appKey = string6 = appKey;
        this.tenantId = string5 = tenantId;
        this.subscriptionId = string4 = subscriptionId;
        List<AzureRegion> list2 = AzureNamedAccountCredentials.buildRegions(regions);
        this.regions = list2;
        List<AzureVMImage> list3 = AzureNamedAccountCredentials.buildPreferredVMImageList(vmImages);
        this.vmImages = list3;
        List<AzureCustomImageStorage> list4 = AzureNamedAccountCredentials.buildCustomImageStorages(vmCustomImages);
        this.vmCustomImages = list4;
        this.applicationName = string3 = applicationName;
        this.defaultKeyVault = string2 = defaultKeyVault;
        this.defaultResourceGroup = string = defaultResourceGroup;
        this.useSshPublicKey = bl = useSshPublicKey;
        List list5 = requiredGroupMembership;
        this.requiredGroupMembership = list = DefaultTypeTransformation.booleanUnbox(list5) ? list5 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.permissions = permissions2 = permissions;
        AzureCredentials azureCredentials = appKey.isEmpty() ? null : this.buildCredentials();
        this.credentials = (AzureCredentials)ScriptBytecodeAdapter.castToType((Object)azureCredentials, AzureCredentials.class);
        Map<String, List<AzureComputeClient.VirtualMachineSize>> map = this.credentials.getComputeClient().getVirtualMachineSizesByRegions(this.regions);
        this.locationToInstanceTypesMap = map;
        List<Object> list6 = Arrays.asList("centralus", "eastus", "eastus2", "francecentral", "northeurope", "southeastasia", "westeurope", "westus2");
        this.regionsSupportZones = list6;
        List<Object> list7 = Arrays.asList("1", "2", "3");
        this.availabilityZones = list7;
    }

    @Generated
    public AzureNamedAccountCredentials(String accountName, String environment, String accountType, String clientId, String appKey, String tenantId, String subscriptionId, List<String> regions, List<AzureVMImage> vmImages, List<AzureCustomImageStorage> vmCustomImages, String defaultResourceGroup, String defaultKeyVault, Boolean useSshPublicKey, String applicationName, Permissions permissions) {
        this(accountName, environment, accountType, clientId, appKey, tenantId, subscriptionId, regions, vmImages, vmCustomImages, defaultResourceGroup, defaultKeyVault, useSshPublicKey, applicationName, permissions, null);
    }

    @Generated
    public AzureNamedAccountCredentials(String accountName, String environment, String accountType, String clientId, String appKey, String tenantId, String subscriptionId, List<String> regions, List<AzureVMImage> vmImages, List<AzureCustomImageStorage> vmCustomImages, String defaultResourceGroup, String defaultKeyVault, Boolean useSshPublicKey, String applicationName) {
        this(accountName, environment, accountType, clientId, appKey, tenantId, subscriptionId, regions, vmImages, vmCustomImages, defaultResourceGroup, defaultKeyVault, useSshPublicKey, applicationName, null, null);
    }

    public String getCloudProvider() {
        return CLOUD_PROVIDER;
    }

    public String getName() {
        return this.accountName;
    }

    private AzureCredentials buildCredentials() {
        return new AzureCredentials(this.tenantId, this.clientId, this.appKey, this.subscriptionId, this.defaultKeyVault, this.defaultResourceGroup, this.applicationName, this.environment, this.useSshPublicKey);
    }

    private static List<AzureVMImage> buildPreferredVMImageList(List<AzureVMImage> vmImages) {
        Reference result = new Reference(new ArrayList());
        List<AzureVMImage> list = vmImages;
        public final class _buildPreferredVMImageList_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildPreferredVMImageList_closure1(Object _outerInstance, Object _thisObject, Reference result) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.result = reference = result;
            }

            public Object doCall(Object vmImage) {
                if (DefaultTypeTransformation.booleanUnbox((Object)vmImage) && DefaultTypeTransformation.booleanUnbox((Object)((AzureVMImage)vmImage).getPublisher()) && DefaultTypeTransformation.booleanUnbox((Object)((AzureVMImage)vmImage).getOffer()) && DefaultTypeTransformation.booleanUnbox((Object)((AzureVMImage)vmImage).getSku()) && DefaultTypeTransformation.booleanUnbox((Object)((AzureVMImage)vmImage).getVersion())) {
                    List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)vmImage);
                    this.result.set((Object)list);
                    return list;
                }
                ((Logger)ScriptBytecodeAdapter.getField(_buildPreferredVMImageList_closure1.class, AzureNamedAccountCredentials.class, (String)"log")).warn("Invalid preferred VM image entry found in the config file");
                return null;
            }

            @Generated
            public Object getResult() {
                return this.result.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildPreferredVMImageList_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each(list, (Closure)new _buildPreferredVMImageList_closure1(AzureNamedAccountCredentials.class, AzureNamedAccountCredentials.class, result)) : null;
        return (ArrayList)result.get();
    }

    private static List<AzureCustomImageStorage> buildCustomImageStorages(List<AzureCustomImageStorage> vmCustomImages) {
        Reference result = new Reference(new ArrayList());
        List<AzureCustomImageStorage> list = vmCustomImages;
        public final class _buildCustomImageStorages_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCustomImageStorages_closure2(Object _outerInstance, Object _thisObject, Reference result) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.result = reference = result;
            }

            public Object doCall(Object vmImage) {
                if (DefaultTypeTransformation.booleanUnbox((Object)vmImage) && DefaultTypeTransformation.booleanUnbox((Object)((AzureCustomImageStorage)vmImage).getScs()) && DefaultTypeTransformation.booleanUnbox((Object)((AzureCustomImageStorage)vmImage).getBlobDir()) && DefaultTypeTransformation.booleanUnbox((Object)((AzureCustomImageStorage)vmImage).getOsType())) {
                    List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)vmImage);
                    this.result.set((Object)list);
                    return list;
                }
                ((Logger)ScriptBytecodeAdapter.getField(_buildCustomImageStorages_closure2.class, AzureNamedAccountCredentials.class, (String)"log")).warn("Invalid custom image storage entry found in the config file");
                return null;
            }

            @Generated
            public Object getResult() {
                return this.result.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCustomImageStorages_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each(list, (Closure)new _buildCustomImageStorages_closure2(AzureNamedAccountCredentials.class, AzureNamedAccountCredentials.class, result)) : null;
        return (ArrayList)result.get();
    }

    private static List<AzureRegion> buildRegions(List<String> regions) {
        List<String> list = regions;
        public final class _buildRegions_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildRegions_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return new AzureRegion(ShortTypeHandling.castToString((Object)it));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildRegions_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.collect(list, (Closure)new _buildRegions_closure3(AzureNamedAccountCredentials.class, AzureNamedAccountCredentials.class)) : null;
        return DefaultTypeTransformation.booleanUnbox(list2) ? list2 : new ArrayList();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AzureNamedAccountCredentials.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureNamedAccountCredentials.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Logger pfaccess$0(AzureNamedAccountCredentials $that) {
        return log;
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.azure.security.AzureNamedAccountCredentials");
    }

    @Generated
    public final String getAccountName() {
        return this.accountName;
    }

    @Generated
    public final String getEnvironment() {
        return this.environment;
    }

    @Generated
    public final String getAccountType() {
        return this.accountType;
    }

    @Generated
    public final List<AzureRegion> getRegions() {
        return this.regions;
    }

    @Generated
    public final List<AzureVMImage> getVmImages() {
        return this.vmImages;
    }

    @Generated
    public final List<AzureCustomImageStorage> getVmCustomImages() {
        return this.vmCustomImages;
    }

    @Generated
    public final String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public final List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    @Generated
    public final AzureCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public final String getDefaultKeyVault() {
        return this.defaultKeyVault;
    }

    @Generated
    public final String getDefaultResourceGroup() {
        return this.defaultResourceGroup;
    }

    @Generated
    public final Map<String, List<AzureComputeClient.VirtualMachineSize>> getLocationToInstanceTypesMap() {
        return this.locationToInstanceTypesMap;
    }

    @Generated
    public final List<String> getRegionsSupportZones() {
        return this.regionsSupportZones;
    }

    @Generated
    public final List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    @Generated
    public final Boolean getUseSshPublicKey() {
        return this.useSshPublicKey;
    }

    @Generated
    public final Permissions getPermissions() {
        return this.permissions;
    }

    public static class AzureRegion
    implements GroovyObject {
        public final String name;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public AzureRegion(String name) {
            String string;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (name == null) {
                throw (Throwable)new IllegalArgumentException("name must be specified.");
            }
            this.name = string = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this, (Object)o)) {
                return true;
            }
            if (o == null || ScriptBytecodeAdapter.compareNotEqual(this.getClass(), o.getClass())) {
                return false;
            }
            AzureRegion awsRegion = (AzureRegion)ScriptBytecodeAdapter.castToType((Object)o, AzureRegion.class);
            return this.name.equals(awsRegion.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureRegion.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(AzureRegion.class, AzureNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(AzureRegion.class, AzureNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(AzureRegion.class, AzureNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(AzureRegion.class, AzureNamedAccountCredentials.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

