/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.client;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.management.compute.VirtualMachineScaleSet;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVMs;
import com.microsoft.azure.management.network.AddressSpace;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGatewayRequestRoutingRule;
import com.microsoft.azure.management.network.InboundNatPool;
import com.microsoft.azure.management.network.LoadBalancer;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.network.implementation.NetworkSecurityGroupInner;
import com.microsoft.azure.management.network.implementation.SecurityRuleInner;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkInner;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.trafficmanager.CheckProfileDnsNameAvailabilityResult;
import com.microsoft.rest.ServiceResponse;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.azure.client.AzureBaseClient;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.appgateway.model.AzureAppGatewayDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.loadbalancer.model.AzureLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.network.model.AzureVirtualNetworkDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.securitygroup.model.AzureSecurityGroupDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.subnet.model.AzureSubnetDescription;
import com.netflix.spinnaker.clouddriver.azure.templates.AzureAppGatewayResourceTemplate;
import com.netflix.spinnaker.clouddriver.azure.templates.AzureLoadBalancerResourceTemplate;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureNetworkClient
extends AzureBaseClient {
    private final Integer NAT_POOL_PORT_START;
    private final Integer NAT_POOL_PORT_END;
    private final Integer NAT_POOL_PORT_NUMBER_PER_POOL;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AzureNetworkClient(String subscriptionId, ApplicationTokenCredentials credentials, String userAgentApplicationName) {
        super(subscriptionId, userAgentApplicationName, credentials);
        MetaClass metaClass;
        int n = 50000;
        this.NAT_POOL_PORT_START = n;
        int n2 = 59999;
        this.NAT_POOL_PORT_END = n2;
        int n3 = 100;
        this.NAT_POOL_PORT_NUMBER_PER_POOL = n3;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Collection<AzureLoadBalancerDescription> getLoadBalancersAll(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference(new ArrayList());
        try {
            public final class _getLoadBalancersAll_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLoadBalancersAll_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().loadBalancers().list();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLoadBalancersAll_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            PagedList loadBalancers = (PagedList)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getLoadBalancersAll_closure1(this, this)), PagedList.class);
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            PagedList pagedList = loadBalancers;
            public final class _getLoadBalancersAll_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLoadBalancersAll_closure2(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((LoadBalancerInner)((LoadBalancer)item).inner()).location(), (Object)this.region.get())) {
                        AzureLoadBalancerDescription lbItem = AzureLoadBalancerDescription.build((LoadBalancerInner)ScriptBytecodeAdapter.castToType((Object)((LoadBalancer)item).inner(), LoadBalancerInner.class));
                        if (DefaultTypeTransformation.booleanUnbox((Object)((LoadBalancer)item).publicIPAddressIds()) && !((LoadBalancer)item).publicIPAddressIds().isEmpty()) {
                            List list;
                            String string = ((AzureNetworkClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureNetworkClient.class)).getDnsNameForPublicIp(AzureUtilities.getResourceGroupNameFromResourceId(((LoadBalancer)item).id()), AzureUtilities.getNameFromResourceId(ShortTypeHandling.castToString((Object)((list = ((LoadBalancer)item).publicIPAddressIds()) != null ? DefaultGroovyMethods.first((List)list) : null))));
                            lbItem.setDnsName(string);
                        }
                        Object object = this.currentTime.get();
                        lbItem.setLastReadTime(DefaultTypeTransformation.longUnbox((Object)object));
                        List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)lbItem);
                        this.result.set((Object)list);
                        List list2 = list;
                        try {
                            return list2;
                        }
                        catch (RuntimeException re) {
                            Object v0;
                            if (((Logger)ScriptBytecodeAdapter.getField(_getLoadBalancersAll_closure2.class, AzureNetworkClient.class, (String)"log")).isErrorEnabled()) {
                                ((Logger)ScriptBytecodeAdapter.getField(_getLoadBalancersAll_closure2.class, AzureNetworkClient.class, (String)"log")).error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((LoadBalancer)item).name(), re.getMessage()}, new String[]{"Unable to process load balancer ", ": ", ""})));
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                            Object var9_9 = v0;
                            return var9_9;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public Object getCurrentTime() {
                    return this.currentTime.get();
                }

                @Generated
                public Object getResult() {
                    return this.result.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLoadBalancersAll_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List list = pagedList != null ? DefaultGroovyMethods.each((List)pagedList, (Closure)new _getLoadBalancersAll_closure2(this, this, region2, currentTime, result)) : null;
        }
        catch (Exception e) {
            log.error("getLoadBalancersAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public AzureLoadBalancerDescription getLoadBalancer(String resourceGroupName, String loadBalancerName) {
        block7: {
            List list;
            void var2_2;
            Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
            Reference loadBalancerName2 = new Reference((Object)var2_2);
            long currentTime = System.currentTimeMillis();
            public final class _getLoadBalancer_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference resourceGroupName;
                private /* synthetic */ Reference loadBalancerName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLoadBalancer_closure3(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.resourceGroupName = reference2 = resourceGroupName;
                    this.loadBalancerName = reference = loadBalancerName;
                }

                public Object doCall(Object it) {
                    return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().loadBalancers().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.loadBalancerName.get()));
                }

                @Generated
                public String getResourceGroupName() {
                    return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
                }

                @Generated
                public String getLoadBalancerName() {
                    return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLoadBalancer_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            LoadBalancer item = (LoadBalancer)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getLoadBalancer_closure3(this, this, resourceGroupName2, loadBalancerName2)), LoadBalancer.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)item)) break block7;
            AzureLoadBalancerDescription lbItem = AzureLoadBalancerDescription.build((LoadBalancerInner)ScriptBytecodeAdapter.castToType((Object)item.inner(), LoadBalancerInner.class));
            String string = this.getDnsNameForPublicIp(AzureUtilities.getResourceGroupNameFromResourceId(item.id()), AzureUtilities.getNameFromResourceId(ShortTypeHandling.castToString((Object)((list = item.publicIPAddressIds()) != null ? DefaultGroovyMethods.first((List)list) : null))));
            lbItem.setDnsName(string);
            long l = currentTime;
            lbItem.setLastReadTime(l);
            AzureLoadBalancerDescription azureLoadBalancerDescription = lbItem;
            try {
                return azureLoadBalancerDescription;
            }
            catch (CloudException e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)resourceGroupName2.get(), (String)loadBalancerName2.get()}, new String[]{"getLoadBalancer(", ",", ") -> Cloud Exception "})), (Throwable)e);
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
        }
        return (AzureLoadBalancerDescription)ScriptBytecodeAdapter.castToType(null, AzureLoadBalancerDescription.class);
    }

    public ServiceResponse deleteLoadBalancer(String resourceGroupName, String loadBalancerName) {
        LoadBalancer loadBalancer = (LoadBalancer)ScriptBytecodeAdapter.castToType((Object)this.getAzure().loadBalancers().getByResourceGroup(resourceGroupName, loadBalancerName), LoadBalancer.class);
        LoadBalancer loadBalancer2 = loadBalancer;
        List list = loadBalancer2 != null ? loadBalancer2.publicIPAddressIds() : null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
            throw (Throwable)new RuntimeException("Unexpected number of public IP addresses associated with the load balancer (should always be only one)!");
        }
        List list2 = loadBalancer.publicIPAddressIds();
        String publicIpAddressName = AzureUtilities.getNameFromResourceId(ShortTypeHandling.castToString((Object)(list2 != null ? DefaultGroovyMethods.first((List)list2) : null)));
        AzureBaseClient.deleteAzureResource(ScriptBytecodeAdapter.getMethodPointer((Object)this.getAzure().loadBalancers(), (String)"deleteByResourceGroup"), resourceGroupName, loadBalancerName, null, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Delete Load Balancer ", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{loadBalancerName, resourceGroupName}, new String[]{"Failed to delete Load Balancer ", " in ", ""})));
        return this.deletePublicIp(resourceGroupName, publicIpAddressName);
    }

    public ServiceResponse deletePublicIp(String resourceGroupName, String publicIpName) {
        return AzureBaseClient.deleteAzureResource(ScriptBytecodeAdapter.getMethodPointer((Object)this.getAzure().publicIPAddresses(), (String)"deleteByResourceGroup"), resourceGroupName, publicIpName, null, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{publicIpName}, new String[]{"Delete PublicIp ", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{publicIpName, resourceGroupName}, new String[]{"Failed to delete PublicIp ", " in ", ""})));
    }

    /*
     * WARNING - void declaration
     */
    public AzureAppGatewayDescription getAppGateway(String resourceGroupName, String appGatewayName) {
        block7: {
            void var2_2;
            Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
            Reference appGatewayName2 = new Reference((Object)var2_2);
            long currentTime = System.currentTimeMillis();
            public final class _getAppGateway_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference resourceGroupName;
                private /* synthetic */ Reference appGatewayName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAppGateway_closure4(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.resourceGroupName = reference2 = resourceGroupName;
                    this.appGatewayName = reference = appGatewayName;
                }

                public Object doCall(Object it) {
                    return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().applicationGateways().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.appGatewayName.get()));
                }

                @Generated
                public String getResourceGroupName() {
                    return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
                }

                @Generated
                public String getAppGatewayName() {
                    return ShortTypeHandling.castToString((Object)this.appGatewayName.get());
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAppGateway_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ApplicationGateway appGateway = (ApplicationGateway)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getAppGateway_closure4(this, this, resourceGroupName2, appGatewayName2)), ApplicationGateway.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)appGateway)) break block7;
            AzureAppGatewayDescription agItem = AzureAppGatewayDescription.getDescriptionForAppGateway((ApplicationGatewayInner)ScriptBytecodeAdapter.castToType((Object)appGateway.inner(), ApplicationGatewayInner.class));
            String string = this.getDnsNameForPublicIp(AzureUtilities.getResourceGroupNameFromResourceId(appGateway.id()), AzureUtilities.getNameFromResourceId(appGateway.defaultPublicFrontend().publicIPAddressId()));
            agItem.setDnsName(string);
            long l = currentTime;
            agItem.setLastReadTime(l);
            AzureAppGatewayDescription azureAppGatewayDescription = agItem;
            try {
                return azureAppGatewayDescription;
            }
            catch (Exception e) {
                Object v0;
                if (log.isWarnEnabled()) {
                    log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)resourceGroupName2.get(), (String)appGatewayName2.get()}, new String[]{"getAppGateway(", ",", ") -> Exception "})), (Throwable)e);
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
        }
        return (AzureAppGatewayDescription)ScriptBytecodeAdapter.castToType(null, AzureAppGatewayDescription.class);
    }

    public Collection<AzureAppGatewayDescription> getAppGatewaysAll(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        try {
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            public final class _getAppGatewaysAll_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAppGatewaysAll_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().applicationGateways().list();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAppGatewaysAll_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            PagedList appGateways = (PagedList)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getAppGatewaysAll_closure5(this, this)), PagedList.class);
            public final class _getAppGatewaysAll_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAppGatewaysAll_closure6(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((ApplicationGatewayInner)((ApplicationGateway)item).inner()).location(), (Object)this.region.get())) {
                        AzureAppGatewayDescription agItem = AzureAppGatewayDescription.getDescriptionForAppGateway((ApplicationGatewayInner)ScriptBytecodeAdapter.castToType((Object)((ApplicationGateway)item).inner(), ApplicationGatewayInner.class));
                        String string = ((AzureNetworkClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureNetworkClient.class)).getDnsNameForPublicIp(AzureUtilities.getResourceGroupNameFromResourceId(((ApplicationGateway)item).id()), AzureUtilities.getNameFromResourceId(((ApplicationGateway)item).defaultPublicFrontend().publicIPAddressId()));
                        agItem.setDnsName(string);
                        Object object = this.currentTime.get();
                        agItem.setLastReadTime(DefaultTypeTransformation.longUnbox((Object)object));
                        List list = DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)agItem);
                        try {
                            return list;
                        }
                        catch (RuntimeException re) {
                            Object v0;
                            if (((Logger)ScriptBytecodeAdapter.getField(_getAppGatewaysAll_closure6.class, AzureNetworkClient.class, (String)"log")).isErrorEnabled()) {
                                ((Logger)ScriptBytecodeAdapter.getField(_getAppGatewaysAll_closure6.class, AzureNetworkClient.class, (String)"log")).error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((ApplicationGateway)item).name(), re.getMessage()}, new String[]{"Unable to process application gateway ", ": ", ""})));
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                            Object var7_7 = v0;
                            return var7_7;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public Object getCurrentTime() {
                    return this.currentTime.get();
                }

                @Generated
                public Object getResult() {
                    return this.result.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAppGatewaysAll_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)appGateways, (Closure)new _getAppGatewaysAll_closure6(this, this, region2, currentTime, result));
        }
        catch (Exception e) {
            log.error("getAppGatewaysAll -> Unexpected exception ", (Throwable)e);
        }
        return (List)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public ServiceResponse deleteAppGateway(String resourceGroupName, String appGatewayName) {
        ServiceResponse serviceResponse;
        ApplicationGateway applicationGateway;
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        ServiceResponse result = null;
        public final class _deleteAppGateway_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteAppGateway_closure7(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().applicationGateways().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.appGatewayName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return ShortTypeHandling.castToString((Object)this.appGatewayName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteAppGateway_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ApplicationGateway appGateway = (ApplicationGateway)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _deleteAppGateway_closure7(this, this, resourceGroupName2, appGatewayName2)), ApplicationGateway.class);
        ApplicationGateway applicationGateway2 = appGateway;
        if (DefaultTypeTransformation.booleanUnbox((applicationGateway2 != null ? applicationGateway2.tags() : null) == null ? null : ((applicationGateway = appGateway) != null ? applicationGateway.tags() : null).get("cluster"))) {
            ApplicationGateway applicationGateway3;
            ApplicationGateway applicationGateway4;
            GStringImpl errMsg = new GStringImpl(new Object[]{(String)appGatewayName2.get(), ((applicationGateway4 = appGateway) != null ? applicationGateway4.tags() : null) == null ? null : ((applicationGateway3 = appGateway) != null ? applicationGateway3.tags() : null).get("cluster")}, new String[]{"Failed to delete ", "; the application gateway is still associated with server groups in ", " cluster. Please delete associated server groups before deleting the load balancer."});
            log.error(ShortTypeHandling.castToString((Object)errMsg));
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
        }
        ApplicationGateway applicationGateway5 = appGateway;
        String publicIpAddressName = AzureUtilities.getNameFromResourceId((applicationGateway5 != null ? applicationGateway5.defaultPublicFrontend() : null).publicIPAddressId());
        result = serviceResponse = AzureBaseClient.deleteAzureResource(ScriptBytecodeAdapter.getMethodPointer((Object)this.getAzure().applicationGateways(), (String)"deleteByResourceGroup"), (String)resourceGroupName2.get(), (String)appGatewayName2.get(), null, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)appGatewayName2.get()}, new String[]{"Delete Application Gateway ", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)appGatewayName2.get(), (String)resourceGroupName2.get()}, new String[]{"Failed to delete Application Gateway ", " in ", ""})));
        if (DefaultTypeTransformation.booleanUnbox((Object)publicIpAddressName)) {
            ServiceResponse serviceResponse2;
            result = serviceResponse2 = this.deletePublicIp((String)resourceGroupName2.get(), publicIpAddressName);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public String createAppGatewayBAPforServerGroup(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _createAppGatewayBAPforServerGroup_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createAppGatewayBAPforServerGroup_closure8(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().applicationGateways().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.appGatewayName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return ShortTypeHandling.castToString((Object)this.appGatewayName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createAppGatewayBAPforServerGroup_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ApplicationGateway appGateway = (ApplicationGateway)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _createAppGatewayBAPforServerGroup_closure8(this, this, resourceGroupName2, appGatewayName2)), ApplicationGateway.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)appGateway)) {
            AzureAppGatewayDescription agDescription = AzureAppGatewayDescription.getDescriptionForAppGateway((ApplicationGatewayInner)ScriptBytecodeAdapter.castToType((Object)appGateway.inner(), ApplicationGatewayInner.class));
            Names parsedName = Names.parseName((String)serverGroupName);
            if (!DefaultTypeTransformation.booleanUnbox((Object)agDescription) || DefaultTypeTransformation.booleanUnbox((Object)agDescription.getCluster()) && ScriptBytecodeAdapter.compareNotEqual((Object)agDescription.getCluster(), (Object)parsedName.getCluster())) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)appGatewayName2.get(), agDescription.getCluster()}, new String[]{"Failed to associate ", " with ", "; expecting server group to be in ", " cluster"});
                log.error(ShortTypeHandling.castToString((Object)errMsg));
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
            }
            Map map = appGateway.backends();
            if (!DefaultTypeTransformation.booleanUnbox(map != null ? Boolean.valueOf(map.containsKey(serverGroupName)) : null)) {
                Object v0;
                if (DefaultTypeTransformation.booleanUnbox(agDescription.getServerGroups())) {
                    DefaultGroovyMethods.leftShift(agDescription.getServerGroups(), (Object)serverGroupName);
                } else {
                    List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{serverGroupName});
                    agDescription.setServerGroups(list);
                }
                ((ApplicationGateway.Update)((ApplicationGateway.Update)((ApplicationGateway.Update)appGateway.update()).withTag("cluster", parsedName.getCluster())).defineBackend(serverGroupName).attach()).apply();
                if (log.isInfoEnabled()) {
                    log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{appGateway.name(), serverGroupName}, new String[]{"Adding backend address pool to ", " for server group ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{appGateway.id(), serverGroupName}, new String[]{"", "/backendAddressPools/", ""}));
        }
        return ShortTypeHandling.castToString(null);
    }

    /*
     * WARNING - void declaration
     */
    public String removeAppGatewayBAPforServerGroup(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _removeAppGatewayBAPforServerGroup_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeAppGatewayBAPforServerGroup_closure9(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().applicationGateways().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.appGatewayName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return ShortTypeHandling.castToString((Object)this.appGatewayName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeAppGatewayBAPforServerGroup_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ApplicationGateway appGateway = (ApplicationGateway)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _removeAppGatewayBAPforServerGroup_closure9(this, this, resourceGroupName2, appGatewayName2)), ApplicationGateway.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)appGateway)) {
            AzureAppGatewayDescription agDescription = AzureAppGatewayDescription.getDescriptionForAppGateway((ApplicationGatewayInner)ScriptBytecodeAdapter.castToType((Object)appGateway.inner(), ApplicationGatewayInner.class));
            if (!DefaultTypeTransformation.booleanUnbox((Object)agDescription)) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)appGatewayName2.get(), (String)appGatewayName2.get()}, new String[]{"Failed to disassociate ", " from ", "; could not find ", ""});
                log.error(ShortTypeHandling.castToString((Object)errMsg));
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
            }
            ApplicationGatewayBackend agBAP = (ApplicationGatewayBackend)ScriptBytecodeAdapter.castToType(appGateway.backends().get(serverGroupName), ApplicationGatewayBackend.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)agBAP)) {
                ApplicationGateway.Update chain = ((ApplicationGateway.Update)appGateway.update()).withoutBackend(agBAP.name());
                if (appGateway.backends().size() == 1) {
                    Object object = chain.withoutTag("cluster");
                    chain = (ApplicationGateway.Update)ScriptBytecodeAdapter.castToType((Object)object, ApplicationGateway.Update.class);
                }
                chain.apply();
            }
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{appGateway.id(), serverGroupName}, new String[]{"", "/backendAddressPools/", ""}));
        }
        return ShortTypeHandling.castToString(null);
    }

    /*
     * WARNING - void declaration
     */
    public String createLoadBalancerAPforServerGroup(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _createLoadBalancerAPforServerGroup_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createLoadBalancerAPforServerGroup_closure10(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().loadBalancers().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.loadBalancerName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createLoadBalancerAPforServerGroup_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        LoadBalancer loadBalancer = (LoadBalancer)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _createLoadBalancerAPforServerGroup_closure10(this, this, resourceGroupName2, loadBalancerName2)), LoadBalancer.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)loadBalancer)) {
            Map map = loadBalancer.backends();
            if (!DefaultTypeTransformation.booleanUnbox(map != null ? Boolean.valueOf(map.containsKey(serverGroupName)) : null)) {
                Object v0;
                ((LoadBalancer.Update)((LoadBalancer.Update)loadBalancer.update()).defineBackend(serverGroupName).attach()).apply();
                if (log.isInfoEnabled()) {
                    log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{loadBalancer.name(), serverGroupName}, new String[]{"Adding backend address pool to ", " for server group ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{loadBalancer.id(), serverGroupName}, new String[]{"", "/backendAddressPools/", ""}));
        }
        throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)loadBalancerName2.get(), (String)resourceGroupName2.get()}, new String[]{"Load balancer ", " not found in resource group ", ""})));
    }

    /*
     * WARNING - void declaration
     */
    public String removeLoadBalancerAPforServerGroup(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _removeLoadBalancerAPforServerGroup_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeLoadBalancerAPforServerGroup_closure11(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().loadBalancers().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.loadBalancerName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeLoadBalancerAPforServerGroup_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        LoadBalancer loadBalancer = (LoadBalancer)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _removeLoadBalancerAPforServerGroup_closure11(this, this, resourceGroupName2, loadBalancerName2)), LoadBalancer.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)loadBalancer)) {
            LoadBalancerBackend lbAP = (LoadBalancerBackend)ScriptBytecodeAdapter.castToType(loadBalancer.backends().get(serverGroupName), LoadBalancerBackend.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)lbAP)) {
                LoadBalancer.Update chain = ((LoadBalancer.Update)loadBalancer.update()).withoutBackend(lbAP.name());
                chain.apply();
            }
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{loadBalancer.id(), serverGroupName}, new String[]{"", "/backendAddressPools/", ""}));
        }
        throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)loadBalancerName2.get(), (String)resourceGroupName2.get()}, new String[]{"Load balancer ", " not found in resource group ", ""})));
    }

    /*
     * Exception decompiling
     */
    public String createLoadBalancerNatPoolPortRangeforServerGroup(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int findUnusedPortsRange(List<int[]> usedList, int start, int end, int targetLength) {
        int ret = start;
        int retEnd = ret + targetLength;
        if (retEnd > end) {
            return -1;
        }
        int[] p = null;
        Iterator<int[]> iterator = usedList.iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            p = (int[])ScriptBytecodeAdapter.castToType((Object)iterator.next(), int[].class);
            if (BytecodeInterface8.intArrayGet((int[])p, (int)0) > retEnd) {
                return ret;
            }
            ret = n2 = BytecodeInterface8.intArrayGet((int[])p, (int)1) + 1;
            retEnd = n = ret + targetLength;
            if (!(retEnd > end)) continue;
            return -1;
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public String removeLoadBalancerNatPoolPortRangeforServerGroup(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _removeLoadBalancerNatPoolPortRangeforServerGroup_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeLoadBalancerNatPoolPortRangeforServerGroup_closure13(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().loadBalancers().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.loadBalancerName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeLoadBalancerNatPoolPortRangeforServerGroup_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        LoadBalancer loadBalancer = (LoadBalancer)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _removeLoadBalancerNatPoolPortRangeforServerGroup_closure13(this, this, resourceGroupName2, loadBalancerName2)), LoadBalancer.class);
        String id = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)loadBalancer)) {
            Map map = loadBalancer.inboundNatPools();
            Boolean bl = map != null ? Boolean.valueOf(map.containsKey(serverGroupName)) : null;
            if (bl == null ? false : bl) {
                String string;
                id = string = ((InboundNatPool)((LoadBalancerInboundNatPool)loadBalancer.inboundNatPools().get(serverGroupName)).inner()).id();
                ((LoadBalancer.Update)loadBalancer.update()).withoutInboundNatPool(serverGroupName).apply();
            } else {
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{serverGroupName, (String)loadBalancerName2.get()}, new String[]{"Load balancer nat pool ", " not found in load balancer ", ""})));
            }
        }
        return id;
    }

    /*
     * WARNING - void declaration
     */
    public void enableServerGroupWithAppGateway(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _enableServerGroupWithAppGateway_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _enableServerGroupWithAppGateway_closure14(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().applicationGateways().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.appGatewayName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return ShortTypeHandling.castToString((Object)this.appGatewayName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _enableServerGroupWithAppGateway_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference appGateway = new Reference((Object)((ApplicationGateway)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _enableServerGroupWithAppGateway_closure14(this, this, resourceGroupName2, appGatewayName2)), ApplicationGateway.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)((ApplicationGateway)appGateway.get()))) {
            Reference agBAP = new Reference((Object)((ApplicationGatewayBackend)ScriptBytecodeAdapter.castToType(((ApplicationGateway)appGateway.get()).backends().get(serverGroupName), ApplicationGatewayBackend.class)));
            if (!DefaultTypeTransformation.booleanUnbox((Object)((ApplicationGatewayBackend)agBAP.get()))) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)appGatewayName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error(ShortTypeHandling.castToString((Object)errMsg));
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
            }
            public final class _enableServerGroupWithAppGateway_closure15
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference appGateway;
                private /* synthetic */ Reference agBAP;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _enableServerGroupWithAppGateway_closure15(Object _outerInstance, Object _thisObject, Reference appGateway, Reference agBAP) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.appGateway = reference2 = appGateway;
                    this.agBAP = reference = agBAP;
                }

                public Object doCall(Object name, Object rule) {
                    return ((ApplicationGateway.Update)((ApplicationGateway.Update)((ApplicationGateway)this.appGateway.get()).update()).updateRequestRoutingRule(ShortTypeHandling.castToString((Object)name)).toBackend(((ApplicationGatewayBackend)this.agBAP.get()).name()).parent()).apply();
                }

                public Object call(Object name, Object rule) {
                    return this.doCall(name, rule);
                }

                @Generated
                public Object getAppGateway() {
                    return this.appGateway.get();
                }

                @Generated
                public Object getAgBAP() {
                    return this.agBAP.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _enableServerGroupWithAppGateway_closure15.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Map)((ApplicationGateway)appGateway.get()).requestRoutingRules(), (Closure)new _enableServerGroupWithAppGateway_closure15(this, this, appGateway, agBAP));
            ((ApplicationGateway.Update)((ApplicationGateway.Update)((ApplicationGateway)appGateway.get()).update()).withTag("trafficEnabledSG", serverGroupName)).apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void disableServerGroup(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _disableServerGroup_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _disableServerGroup_closure16(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().applicationGateways().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.appGatewayName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return ShortTypeHandling.castToString((Object)this.appGatewayName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _disableServerGroup_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference appGateway = new Reference((Object)((ApplicationGateway)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _disableServerGroup_closure16(this, this, resourceGroupName2, appGatewayName2)), ApplicationGateway.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)((ApplicationGateway)appGateway.get()))) {
            Reference defaultBAP = new Reference((Object)((ApplicationGatewayBackend)ScriptBytecodeAdapter.castToType(((ApplicationGateway)appGateway.get()).backends().get(AzureAppGatewayResourceTemplate.getDefaultAppGatewayBeAddrPoolName()), ApplicationGatewayBackend.class)));
            if (!DefaultTypeTransformation.booleanUnbox((Object)((ApplicationGatewayBackend)defaultBAP.get()))) {
                GStringImpl errMsg = new GStringImpl(new Object[]{AzureAppGatewayResourceTemplate.getDefaultAppGatewayBeAddrPoolName(), (String)appGatewayName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error(ShortTypeHandling.castToString((Object)errMsg));
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
            }
            Reference agBAP = new Reference((Object)((ApplicationGatewayBackend)ScriptBytecodeAdapter.castToType(((ApplicationGateway)appGateway.get()).backends().get(serverGroupName), ApplicationGatewayBackend.class)));
            if (!DefaultTypeTransformation.booleanUnbox((Object)((ApplicationGatewayBackend)agBAP.get()))) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)appGatewayName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error(ShortTypeHandling.castToString((Object)errMsg));
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
            }
            Map map = ((ApplicationGateway)appGateway.get()).requestRoutingRules();
            public final class _disableServerGroup_closure17
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference agBAP;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _disableServerGroup_closure17(Object _outerInstance, Object _thisObject, Reference agBAP) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.agBAP = reference = agBAP;
                }

                public Object doCall(Object name, Object rule) {
                    return ScriptBytecodeAdapter.compareEqual((Object)((ApplicationGatewayRequestRoutingRule)rule).backend(), (Object)this.agBAP.get());
                }

                public Object call(Object name, Object rule) {
                    return this.doCall(name, rule);
                }

                @Generated
                public Object getAgBAP() {
                    return this.agBAP.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _disableServerGroup_closure17.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Map requestedRoutingRules = map != null ? DefaultGroovyMethods.findAll((Map)map, (Closure)new _disableServerGroup_closure17(this, this, agBAP)) : null;
            if (DefaultTypeTransformation.booleanUnbox(requestedRoutingRules)) {
                public final class _disableServerGroup_closure18
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference appGateway;
                    private /* synthetic */ Reference defaultBAP;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _disableServerGroup_closure18(Object _outerInstance, Object _thisObject, Reference appGateway, Reference defaultBAP) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.appGateway = reference2 = appGateway;
                        this.defaultBAP = reference = defaultBAP;
                    }

                    public Object doCall(Object name, Object rule) {
                        return ((ApplicationGateway.Update)((ApplicationGateway.Update)((ApplicationGateway)this.appGateway.get()).update()).updateRequestRoutingRule(ShortTypeHandling.castToString((Object)name)).toBackend(((ApplicationGatewayBackend)this.defaultBAP.get()).name()).parent()).apply();
                    }

                    public Object call(Object name, Object rule) {
                        return this.doCall(name, rule);
                    }

                    @Generated
                    public Object getAppGateway() {
                        return this.appGateway.get();
                    }

                    @Generated
                    public Object getDefaultBAP() {
                        return this.defaultBAP.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _disableServerGroup_closure18.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((Map)requestedRoutingRules, (Closure)new _disableServerGroup_closure18(this, this, appGateway, defaultBAP));
                ((ApplicationGateway.Update)((ApplicationGateway.Update)((ApplicationGateway)appGateway.get()).update()).withoutTag("trafficEnabledSG")).apply();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Boolean isServerGroupWithoutLoadBalancerDisabled(String resourceGroupName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference serverGroupName2 = new Reference((Object)var2_2);
        public final class _isServerGroupWithoutLoadBalancerDisabled_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference serverGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isServerGroupWithoutLoadBalancerDisabled_closure19(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference serverGroupName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.serverGroupName = reference = serverGroupName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().virtualMachineScaleSets().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.serverGroupName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getServerGroupName() {
                return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isServerGroupWithoutLoadBalancerDisabled_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        VirtualMachineScaleSet scaleSet = (VirtualMachineScaleSet)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _isServerGroupWithoutLoadBalancerDisabled_closure19(this, this, resourceGroupName2, serverGroupName2)), VirtualMachineScaleSet.class);
        VirtualMachineScaleSetVMs machines = scaleSet.virtualMachines();
        return machines.list().size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public Boolean isServerGroupWithAppGatewayDisabled(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _isServerGroupWithAppGatewayDisabled_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isServerGroupWithAppGatewayDisabled_closure20(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().applicationGateways().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.appGatewayName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return ShortTypeHandling.castToString((Object)this.appGatewayName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isServerGroupWithAppGatewayDisabled_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ApplicationGateway appGateway = (ApplicationGateway)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _isServerGroupWithAppGatewayDisabled_closure20(this, this, resourceGroupName2, appGatewayName2)), ApplicationGateway.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)appGateway)) {
            Reference agBAP = new Reference((Object)((ApplicationGatewayBackend)ScriptBytecodeAdapter.castToType(appGateway.backends().get(serverGroupName), ApplicationGatewayBackend.class)));
            if (DefaultTypeTransformation.booleanUnbox((Object)((ApplicationGatewayBackend)agBAP.get()))) {
                Map map = appGateway.requestRoutingRules();
                public final class _isServerGroupWithAppGatewayDisabled_closure21
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference agBAP;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _isServerGroupWithAppGatewayDisabled_closure21(Object _outerInstance, Object _thisObject, Reference agBAP) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.agBAP = reference = agBAP;
                    }

                    public Object doCall(Object name, Object rule) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((ApplicationGatewayRequestRoutingRule)rule).backend(), (Object)this.agBAP.get());
                    }

                    public Object call(Object name, Object rule) {
                        return this.doCall(name, rule);
                    }

                    @Generated
                    public Object getAgBAP() {
                        return this.agBAP.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _isServerGroupWithAppGatewayDisabled_closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Map.Entry requestedRoutingRules = map != null ? DefaultGroovyMethods.find((Map)map, (Closure)new _isServerGroupWithAppGatewayDisabled_closure21(this, this, agBAP)) : null;
                if (requestedRoutingRules != null) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void enableServerGroupWithLoadBalancer(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var3_3;
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        Reference serverGroupName2 = new Reference((Object)var3_3);
        public final class _enableServerGroupWithLoadBalancer_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _enableServerGroupWithLoadBalancer_closure22(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().loadBalancers().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.loadBalancerName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _enableServerGroupWithLoadBalancer_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference loadBalancer = new Reference((Object)((LoadBalancer)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _enableServerGroupWithLoadBalancer_closure22(this, this, resourceGroupName2, loadBalancerName2)), LoadBalancer.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)((LoadBalancer)loadBalancer.get()))) {
            LoadBalancerBackend lbBAP = (LoadBalancerBackend)ScriptBytecodeAdapter.castToType(((LoadBalancer)loadBalancer.get()).backends().get((String)serverGroupName2.get()), LoadBalancerBackend.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)lbBAP)) {
                GStringImpl errMsg = new GStringImpl(new Object[]{(String)serverGroupName2.get(), (String)loadBalancerName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error(ShortTypeHandling.castToString((Object)errMsg));
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
            }
            public final class _enableServerGroupWithLoadBalancer_closure23
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancer;
                private /* synthetic */ Reference serverGroupName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _enableServerGroupWithLoadBalancer_closure23(Object _outerInstance, Object _thisObject, Reference loadBalancer, Reference serverGroupName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.loadBalancer = reference2 = loadBalancer;
                    this.serverGroupName = reference = serverGroupName;
                }

                /*
                 * Exception decompiling
                 */
                public Object doCall(Object name, Object rule) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public Object call(Object name, Object rule) {
                    return this.doCall(name, rule);
                }

                @Generated
                public Object getLoadBalancer() {
                    return this.loadBalancer.get();
                }

                @Generated
                public String getServerGroupName() {
                    return ShortTypeHandling.castToString((Object)this.serverGroupName.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _enableServerGroupWithLoadBalancer_closure23.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Map)((LoadBalancer)loadBalancer.get()).loadBalancingRules(), (Closure)new _enableServerGroupWithLoadBalancer_closure23(this, this, loadBalancer, serverGroupName2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void disableServerGroupWithLoadBalancer(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _disableServerGroupWithLoadBalancer_closure24
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _disableServerGroupWithLoadBalancer_closure24(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().loadBalancers().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.loadBalancerName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _disableServerGroupWithLoadBalancer_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference loadBalancer = new Reference((Object)((LoadBalancer)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _disableServerGroupWithLoadBalancer_closure24(this, this, resourceGroupName2, loadBalancerName2)), LoadBalancer.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)((LoadBalancer)loadBalancer.get()))) {
            LoadBalancerBackend defaultBAP = (LoadBalancerBackend)ScriptBytecodeAdapter.castToType(((LoadBalancer)loadBalancer.get()).backends().get(AzureLoadBalancerResourceTemplate.getDEFAULT_BACKEND_POOL()), LoadBalancerBackend.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)defaultBAP)) {
                GStringImpl errMsg = new GStringImpl(new Object[]{AzureLoadBalancerResourceTemplate.getDEFAULT_BACKEND_POOL(), (String)loadBalancerName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error(ShortTypeHandling.castToString((Object)errMsg));
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
            }
            Reference lbBAP = new Reference((Object)((LoadBalancerBackend)ScriptBytecodeAdapter.castToType(((LoadBalancer)loadBalancer.get()).backends().get(serverGroupName), LoadBalancerBackend.class)));
            if (!DefaultTypeTransformation.booleanUnbox((Object)((LoadBalancerBackend)lbBAP.get()))) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)loadBalancerName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error(ShortTypeHandling.castToString((Object)errMsg));
                throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)errMsg));
            }
            Map map = ((LoadBalancer)loadBalancer.get()).loadBalancingRules();
            public final class _disableServerGroupWithLoadBalancer_closure25
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference lbBAP;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _disableServerGroupWithLoadBalancer_closure25(Object _outerInstance, Object _thisObject, Reference lbBAP) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.lbBAP = reference = lbBAP;
                }

                public Object doCall(Object name, Object rule) {
                    return ScriptBytecodeAdapter.compareEqual((Object)((LoadBalancingRule)rule).backend(), (Object)this.lbBAP.get());
                }

                public Object call(Object name, Object rule) {
                    return this.doCall(name, rule);
                }

                @Generated
                public Object getLbBAP() {
                    return this.lbBAP.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _disableServerGroupWithLoadBalancer_closure25.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Map requestedRoutingRules = map != null ? DefaultGroovyMethods.findAll((Map)map, (Closure)new _disableServerGroupWithLoadBalancer_closure25(this, this, lbBAP)) : null;
            if (DefaultTypeTransformation.booleanUnbox(requestedRoutingRules)) {
                public final class _disableServerGroupWithLoadBalancer_closure26
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference loadBalancer;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _disableServerGroupWithLoadBalancer_closure26(Object _outerInstance, Object _thisObject, Reference loadBalancer) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.loadBalancer = reference = loadBalancer;
                    }

                    /*
                     * Exception decompiling
                     */
                    public Object doCall(Object name, Object rule) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }

                    public Object call(Object name, Object rule) {
                        return this.doCall(name, rule);
                    }

                    @Generated
                    public Object getLoadBalancer() {
                        return this.loadBalancer.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _disableServerGroupWithLoadBalancer_closure26.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((Map)requestedRoutingRules, (Closure)new _disableServerGroupWithLoadBalancer_closure26(this, this, loadBalancer));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Boolean isServerGroupWithLoadBalancerDisabled(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _isServerGroupWithLoadBalancerDisabled_closure27
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isServerGroupWithLoadBalancerDisabled_closure27(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().loadBalancers().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.loadBalancerName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isServerGroupWithLoadBalancerDisabled_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        LoadBalancer loadBalancer = (LoadBalancer)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _isServerGroupWithLoadBalancerDisabled_closure27(this, this, resourceGroupName2, loadBalancerName2)), LoadBalancer.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)loadBalancer)) {
            Reference lbBAP = new Reference((Object)((LoadBalancerBackend)ScriptBytecodeAdapter.castToType(loadBalancer.backends().get(serverGroupName), LoadBalancerBackend.class)));
            if (DefaultTypeTransformation.booleanUnbox((Object)((LoadBalancerBackend)lbBAP.get()))) {
                Map map = loadBalancer.loadBalancingRules();
                public final class _isServerGroupWithLoadBalancerDisabled_closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference lbBAP;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _isServerGroupWithLoadBalancerDisabled_closure28(Object _outerInstance, Object _thisObject, Reference lbBAP) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.lbBAP = reference = lbBAP;
                    }

                    public Object doCall(Object name, Object rule) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((LoadBalancingRule)rule).backend(), (Object)this.lbBAP.get());
                    }

                    public Object call(Object name, Object rule) {
                        return this.doCall(name, rule);
                    }

                    @Generated
                    public Object getLbBAP() {
                        return this.lbBAP.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _isServerGroupWithLoadBalancerDisabled_closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Map.Entry requestedRoutingRules = map != null ? DefaultGroovyMethods.find((Map)map, (Closure)new _isServerGroupWithLoadBalancerDisabled_closure28(this, this, lbBAP)) : null;
                if (requestedRoutingRules != null) {
                    return false;
                }
            }
        }
        return true;
    }

    public ServiceResponse deleteSecurityGroup(String resourceGroupName, String securityGroupName) {
        List associatedSubnets = ((NetworkSecurityGroup)this.getAzure().networkSecurityGroups().getByResourceGroup(resourceGroupName, securityGroupName)).listAssociatedSubnets();
        List list = associatedSubnets;
        public final class _deleteSecurityGroup_closure29
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteSecurityGroup_closure29(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object associatedSubnet) {
                String subnetName = ((SubnetInner)((Subnet)associatedSubnet).inner()).name();
                return ((Network.Update)((Network.Update)((Network)((Subnet)associatedSubnet).parent()).update()).updateSubnet(subnetName).withoutNetworkSecurityGroup().parent()).apply();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteSecurityGroup_closure29.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each((List)list, (Closure)new _deleteSecurityGroup_closure29(this, this)) : null;
        return AzureBaseClient.deleteAzureResource(ScriptBytecodeAdapter.getMethodPointer((Object)this.getAzure().networkSecurityGroups(), (String)"deleteByResourceGroup"), resourceGroupName, securityGroupName, null, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{securityGroupName}, new String[]{"Delete Security Group ", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{securityGroupName, resourceGroupName}, new String[]{"Failed to delete Security Group ", " in ", ""})));
    }

    public void createVirtualNetwork(String resourceGroupName, String virtualNetworkName, String region, String addressPrefix) {
        try {
            ((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.getAzure().networks().define(virtualNetworkName)).withRegion(region)).withExistingResourceGroup(resourceGroupName)).withAddressSpace(addressPrefix).create();
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{virtualNetworkName, resourceGroupName}, new String[]{"Unable to create Virtual network ", " in Resource Group ", ""})), (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
        }
    }

    public String createSubnet(String resourceGroupName, String virtualNetworkName, String subnetName, String addressPrefix, String securityGroupName) {
        Network virtualNetwork = (Network)ScriptBytecodeAdapter.castToType((Object)this.getAzure().networks().getByResourceGroup(resourceGroupName, virtualNetworkName), Network.class);
        if (virtualNetwork == null) {
            GStringImpl error = new GStringImpl(new Object[]{virtualNetwork, subnetName}, new String[]{"Virtual network: ", " not found when creating subnet: ", ""});
            log.error(ShortTypeHandling.castToString((Object)error));
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)error));
        }
        Subnet.UpdateDefinitionStages.WithAttach chain = ((Network.Update)virtualNetwork.update()).defineSubnet(subnetName).withAddressPrefix(addressPrefix);
        if (DefaultTypeTransformation.booleanUnbox((Object)securityGroupName)) {
            NetworkSecurityGroup sg = (NetworkSecurityGroup)ScriptBytecodeAdapter.castToType((Object)this.getAzure().networkSecurityGroups().getByResourceGroup(resourceGroupName, securityGroupName), NetworkSecurityGroup.class);
            chain.withExistingNetworkSecurityGroup(sg);
        }
        ((Network.Update)chain.attach()).apply();
        return ((SubnetInner)((Subnet)virtualNetwork.subnets().get(subnetName)).inner()).id();
    }

    public ServiceResponse<Void> deleteSubnet(String resourceGroupName, String virtualNetworkName, String subnetName) {
        public final class _deleteSubnet_closure30
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteSubnet_closure30(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String _resourceGroupName, String _subnetName, String _virtualNetworkName) {
                return ((Network.Update)((Network)((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().networks().getByResourceGroup(_resourceGroupName, _virtualNetworkName)).update()).withoutSubnet(_subnetName).apply();
            }

            public Object call(String _resourceGroupName, String _subnetName, String _virtualNetworkName) {
                return this.doCall(_resourceGroupName, _subnetName, _virtualNetworkName);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteSubnet_closure30.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return AzureBaseClient.deleteAzureResource(new _deleteSubnet_closure30(this, this), resourceGroupName, subnetName, virtualNetworkName, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{subnetName}, new String[]{"Delete subnet ", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{subnetName, resourceGroupName}, new String[]{"Failed to delete subnet ", " in ", ""})));
    }

    public Collection<AzureSecurityGroupDescription> getNetworkSecurityGroupsAll(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference(new ArrayList());
        try {
            public final class _getNetworkSecurityGroupsAll_closure31
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getNetworkSecurityGroupsAll_closure31(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().networkSecurityGroups().list();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getNetworkSecurityGroupsAll_closure31.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            PagedList securityGroups = (PagedList)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getNetworkSecurityGroupsAll_closure31(this, this)), PagedList.class);
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            PagedList pagedList = securityGroups;
            public final class _getNetworkSecurityGroupsAll_closure32
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getNetworkSecurityGroupsAll_closure32(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((NetworkSecurityGroupInner)((NetworkSecurityGroup)item).inner()).location(), (Object)this.region.get())) {
                        AzureSecurityGroupDescription sgItem = AzureNetworkClient.getAzureSecurityGroupDescription((NetworkSecurityGroupInner)ScriptBytecodeAdapter.castToType((Object)((NetworkSecurityGroup)item).inner(), NetworkSecurityGroupInner.class));
                        Object object = this.currentTime.get();
                        sgItem.setLastReadTime(DefaultTypeTransformation.longUnbox((Object)object));
                        List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)sgItem);
                        this.result.set((Object)list);
                        List list2 = list;
                        try {
                            return list2;
                        }
                        catch (RuntimeException re) {
                            Object v0;
                            if (((Logger)ScriptBytecodeAdapter.getField(_getNetworkSecurityGroupsAll_closure32.class, AzureNetworkClient.class, (String)"log")).isErrorEnabled()) {
                                ((Logger)ScriptBytecodeAdapter.getField(_getNetworkSecurityGroupsAll_closure32.class, AzureNetworkClient.class, (String)"log")).error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((NetworkSecurityGroup)item).name(), re.getMessage()}, new String[]{"Unable to process network security group ", ": ", ""})));
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                            Object var7_7 = v0;
                            return var7_7;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public Object getCurrentTime() {
                    return this.currentTime.get();
                }

                @Generated
                public Object getResult() {
                    return this.result.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getNetworkSecurityGroupsAll_closure32.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List list = pagedList != null ? DefaultGroovyMethods.each((List)pagedList, (Closure)new _getNetworkSecurityGroupsAll_closure32(this, this, region2, currentTime, result)) : null;
        }
        catch (Exception e) {
            log.error("getNetworkSecurityGroupsAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public AzureSecurityGroupDescription getNetworkSecurityGroup(String resourceGroupName, String securityGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference securityGroupName2 = new Reference((Object)var2_2);
        public final class _getNetworkSecurityGroup_closure33
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference securityGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getNetworkSecurityGroup_closure33(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference securityGroupName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.securityGroupName = reference = securityGroupName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().networkSecurityGroups().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.securityGroupName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getSecurityGroupName() {
                return ShortTypeHandling.castToString((Object)this.securityGroupName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNetworkSecurityGroup_closure33.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        NetworkSecurityGroup securityGroup = (NetworkSecurityGroup)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getNetworkSecurityGroup_closure33(this, this, resourceGroupName2, securityGroupName2)), NetworkSecurityGroup.class);
        long currentTime = System.currentTimeMillis();
        AzureSecurityGroupDescription sgItem = AzureNetworkClient.getAzureSecurityGroupDescription((NetworkSecurityGroupInner)ScriptBytecodeAdapter.castToType((Object)securityGroup.inner(), NetworkSecurityGroupInner.class));
        long l = currentTime;
        sgItem.setLastReadTime(l);
        AzureSecurityGroupDescription azureSecurityGroupDescription = sgItem;
        try {
            return azureSecurityGroupDescription;
        }
        catch (Exception e) {
            log.error("getNetworkSecurityGroupsAll -> Unexpected exception ", (Throwable)e);
        }
        return (AzureSecurityGroupDescription)ScriptBytecodeAdapter.castToType(null, AzureSecurityGroupDescription.class);
    }

    private static AzureSecurityGroupDescription getAzureSecurityGroupDescription(NetworkSecurityGroupInner item) {
        Reference sgItem = new Reference((Object)new AzureSecurityGroupDescription());
        String string = item.name();
        ((AzureSecurityGroupDescription)sgItem.get()).setName(string);
        String string2 = item.name();
        ((AzureSecurityGroupDescription)sgItem.get()).setId(string2);
        String string3 = item.location();
        ((AzureSecurityGroupDescription)sgItem.get()).setLocation(string3);
        String string4 = item.name();
        ((AzureSecurityGroupDescription)sgItem.get()).setRegion(string4);
        String string5 = "azure";
        ((AzureSecurityGroupDescription)sgItem.get()).setCloudProvider(string5);
        ProvisioningState provisioningState = item.provisioningState();
        ((AzureSecurityGroupDescription)sgItem.get()).setProvisioningState(ShortTypeHandling.castToString((Object)provisioningState));
        String string6 = item.id();
        ((AzureSecurityGroupDescription)sgItem.get()).setResourceGuid(string6);
        String string7 = item.id();
        ((AzureSecurityGroupDescription)sgItem.get()).setResourceId(string7);
        ((AzureSecurityGroupDescription)sgItem.get()).getTags().putAll(item.getTags());
        Names parsedName = Names.parseName((String)item.name());
        Object v0 = item.getTags() == null ? null : item.getTags().get("stack");
        String string8 = ShortTypeHandling.castToString(v0);
        String string9 = DefaultTypeTransformation.booleanUnbox(v0) ? string8 : parsedName.getStack();
        ((AzureSecurityGroupDescription)sgItem.get()).setStack(string9);
        Object v1 = item.getTags() == null ? null : item.getTags().get("detail");
        String string10 = ShortTypeHandling.castToString(v1);
        String string11 = DefaultTypeTransformation.booleanUnbox(v1) ? string10 : parsedName.getDetail();
        ((AzureSecurityGroupDescription)sgItem.get()).setDetail(string11);
        Object v2 = item.getTags() == null ? null : item.getTags().get("appName");
        String string12 = ShortTypeHandling.castToString(v2);
        String string13 = DefaultTypeTransformation.booleanUnbox(v2) ? string12 : parsedName.getApp();
        ((AzureSecurityGroupDescription)sgItem.get()).setAppName(string13);
        Object var17_17 = item.getTags() == null ? null : item.getTags().get("createdTime");
        Long l = var17_17 != null ? StringGroovyMethods.toLong((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType(var17_17, CharSequence.class))) : null;
        ((AzureSecurityGroupDescription)sgItem.get()).setCreatedTime(l);
        String string14 = item.type();
        ((AzureSecurityGroupDescription)sgItem.get()).setType(string14);
        ArrayList<AzureSecurityGroupDescription.AzureSGRule> arrayList = new ArrayList<AzureSecurityGroupDescription.AzureSGRule>();
        ((AzureSecurityGroupDescription)sgItem.get()).setSecurityRules(arrayList);
        public final class _getAzureSecurityGroupDescription_closure34
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sgItem;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAzureSecurityGroupDescription_closure34(Object _outerInstance, Object _thisObject, Reference sgItem) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.sgItem = reference = sgItem;
            }

            public Object doCall(Object rule) {
                String string;
                String string2;
                List<AzureSecurityGroupDescription.AzureSGRule> list = ((AzureSecurityGroupDescription)this.sgItem.get()).getSecurityRules();
                AzureSecurityGroupDescription.AzureSGRule azureSGRule = new AzureSecurityGroupDescription.AzureSGRule();
                String string3 = ((SecurityRuleInner)rule).id();
                azureSGRule.setResourceId(string3);
                String string4 = ((SecurityRuleInner)rule).name();
                azureSGRule.setId(string4);
                String string5 = ((SecurityRuleInner)rule).name();
                azureSGRule.setName(string5);
                String string6 = ((SecurityRuleInner)rule).access().toString();
                azureSGRule.setAccess(string6);
                Integer n = ((SecurityRuleInner)rule).priority();
                azureSGRule.setPriority(n);
                String string7 = ((SecurityRuleInner)rule).protocol().toString();
                azureSGRule.setProtocol(string7);
                String string8 = ((SecurityRuleInner)rule).direction().toString();
                azureSGRule.setDirection(string8);
                String string9 = ((SecurityRuleInner)rule).destinationAddressPrefix();
                azureSGRule.setDestinationAddressPrefix(string9);
                String string10 = ((SecurityRuleInner)rule).destinationPortRange();
                azureSGRule.setDestinationPortRange(string10);
                List list2 = ((SecurityRuleInner)rule).destinationPortRanges();
                azureSGRule.setDestinationPortRanges(list2);
                if (DefaultTypeTransformation.booleanUnbox((Object)((SecurityRuleInner)rule).destinationPortRange())) {
                    string2 = ((SecurityRuleInner)rule).destinationPortRange();
                } else {
                    List list3 = ((SecurityRuleInner)rule).destinationPortRanges();
                    String string11 = list3 != null ? list3.toString() : null;
                    string2 = string11 != null ? string11.replaceAll("[^(0-9),-]", "") : null;
                }
                String string12 = string2;
                azureSGRule.setDestinationPortRangeModel(string12);
                String string13 = ((SecurityRuleInner)rule).sourceAddressPrefix();
                azureSGRule.setSourceAddressPrefix(string13);
                List list4 = ((SecurityRuleInner)rule).sourceAddressPrefixes();
                azureSGRule.setSourceAddressPrefixes(list4);
                if (DefaultTypeTransformation.booleanUnbox((Object)((SecurityRuleInner)rule).sourceAddressPrefix())) {
                    string = ((SecurityRuleInner)rule).sourceAddressPrefix();
                } else {
                    List list5 = ((SecurityRuleInner)rule).sourceAddressPrefixes();
                    String string14 = list5 != null ? list5.toString() : null;
                    string = string14 != null ? string14.replaceAll("[^(0-9a-zA-Z)./,:]", "") : null;
                }
                String string15 = string;
                azureSGRule.setSourceAddressPrefixModel(string15);
                String string16 = ((SecurityRuleInner)rule).sourcePortRange();
                azureSGRule.setSourcePortRange(string16);
                List list6 = DefaultGroovyMethods.plus(list, (Object)azureSGRule);
                ((AzureSecurityGroupDescription)this.sgItem.get()).setSecurityRules(list6);
                return list6;
            }

            @Generated
            public Object getSgItem() {
                return this.sgItem.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAzureSecurityGroupDescription_closure34.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)item.securityRules(), (Closure)new _getAzureSecurityGroupDescription_closure34(AzureNetworkClient.class, AzureNetworkClient.class, sgItem));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ((AzureSecurityGroupDescription)sgItem.get()).setSubnets(arrayList2);
        List list = item.subnets();
        public final class _getAzureSecurityGroupDescription_closure35
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sgItem;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAzureSecurityGroupDescription_closure35(Object _outerInstance, Object _thisObject, Reference sgItem) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.sgItem = reference = sgItem;
            }

            public Object doCall(Object it) {
                List list = DefaultGroovyMethods.plus(((AzureSecurityGroupDescription)this.sgItem.get()).getSubnets(), (Object)AzureUtilities.getNameFromResourceId(((SubnetInner)it).id()));
                ((AzureSecurityGroupDescription)this.sgItem.get()).setSubnets(list);
                return list;
            }

            @Generated
            public Object getSgItem() {
                return this.sgItem.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAzureSecurityGroupDescription_closure35.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each((List)list, (Closure)new _getAzureSecurityGroupDescription_closure35(AzureNetworkClient.class, AzureNetworkClient.class, sgItem)) : null;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ((AzureSecurityGroupDescription)sgItem.get()).setNetworkInterfaces(arrayList3);
        List list3 = item.networkInterfaces();
        public final class _getAzureSecurityGroupDescription_closure36
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sgItem;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAzureSecurityGroupDescription_closure36(Object _outerInstance, Object _thisObject, Reference sgItem) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.sgItem = reference = sgItem;
            }

            public Object doCall(Object it) {
                List list = DefaultGroovyMethods.plus(((AzureSecurityGroupDescription)this.sgItem.get()).getNetworkInterfaces(), (Object)((NetworkInterfaceInner)it).id());
                ((AzureSecurityGroupDescription)this.sgItem.get()).setNetworkInterfaces(list);
                return list;
            }

            @Generated
            public Object getSgItem() {
                return this.sgItem.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAzureSecurityGroupDescription_closure36.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list4 = list3 != null ? DefaultGroovyMethods.each((List)list3, (Closure)new _getAzureSecurityGroupDescription_closure36(AzureNetworkClient.class, AzureNetworkClient.class, sgItem)) : null;
        return (AzureSecurityGroupDescription)sgItem.get();
    }

    public Collection<AzureSubnetDescription> getSubnetsInRegion(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference(new ArrayList());
        try {
            public final class _getSubnetsInRegion_closure37
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSubnetsInRegion_closure37(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().networks().list();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSubnetsInRegion_closure37.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            PagedList vnets = (PagedList)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getSubnetsInRegion_closure37(this, this)), PagedList.class);
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            PagedList pagedList = vnets;
            public final class _getSubnetsInRegion_closure38
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSubnetsInRegion_closure38(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((VirtualNetworkInner)((Network)item).inner()).location(), (Object)this.region.get())) {
                        public final class _closure43
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference currentTime;
                            private /* synthetic */ Reference result;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure43(Object _outerInstance, Object _thisObject, Reference currentTime, Reference result) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.currentTime = reference2 = currentTime;
                                this.result = reference = result;
                            }

                            public Object doCall(AzureSubnetDescription subnet) {
                                Object object = this.currentTime.get();
                                subnet.setLastReadTime(DefaultTypeTransformation.longUnbox((Object)object));
                                List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)subnet);
                                this.result.set((Object)list);
                                return list;
                            }

                            public Object call(AzureSubnetDescription subnet) {
                                return this.doCall(subnet);
                            }

                            @Generated
                            public Object getCurrentTime() {
                                return this.currentTime.get();
                            }

                            @Generated
                            public Object getResult() {
                                return this.result.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure43.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Collection collection = DefaultGroovyMethods.each(AzureSubnetDescription.getSubnetsForVirtualNetwork((VirtualNetworkInner)ScriptBytecodeAdapter.castToType((Object)((Network)item).inner(), VirtualNetworkInner.class)), (Closure)new _closure43((Object)this, this.getThisObject(), this.currentTime, this.result));
                        try {
                            return collection;
                        }
                        catch (RuntimeException re) {
                            Object v0;
                            if (((Logger)ScriptBytecodeAdapter.getField(_getSubnetsInRegion_closure38.class, AzureNetworkClient.class, (String)"log")).isErrorEnabled()) {
                                ((Logger)ScriptBytecodeAdapter.getField(_getSubnetsInRegion_closure38.class, AzureNetworkClient.class, (String)"log")).error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Network)item).name()}, new String[]{"Unable to process subnets for virtual network ", ""})), (Throwable)re);
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                            Object var4_4 = v0;
                            return var4_4;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public Object getCurrentTime() {
                    return this.currentTime.get();
                }

                @Generated
                public Object getResult() {
                    return this.result.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSubnetsInRegion_closure38.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List list = pagedList != null ? DefaultGroovyMethods.each((List)pagedList, (Closure)new _getSubnetsInRegion_closure38(this, this, region2, currentTime, result)) : null;
        }
        catch (Exception e) {
            log.error("getSubnetsAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public Network getVirtualNetwork(String resourceGroupName, String virtualNetworkName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference virtualNetworkName2 = new Reference((Object)var2_2);
        public final class _getVirtualNetwork_closure39
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference virtualNetworkName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getVirtualNetwork_closure39(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference virtualNetworkName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.virtualNetworkName = reference = virtualNetworkName;
            }

            public Object doCall(Object it) {
                return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().networks().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.virtualNetworkName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getVirtualNetworkName() {
                return ShortTypeHandling.castToString((Object)this.virtualNetworkName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getVirtualNetwork_closure39.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Network)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getVirtualNetwork_closure39(this, this, resourceGroupName2, virtualNetworkName2)), Network.class);
    }

    public Collection<AzureVirtualNetworkDescription> getVirtualNetworksAll(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference(new ArrayList());
        try {
            public final class _getVirtualNetworksAll_closure40
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getVirtualNetworksAll_closure40(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().networks().list();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getVirtualNetworksAll_closure40.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            PagedList vnetList = (PagedList)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getVirtualNetworksAll_closure40(this, this)), PagedList.class);
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            PagedList pagedList = vnetList;
            public final class _getVirtualNetworksAll_closure41
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getVirtualNetworksAll_closure41(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((VirtualNetworkInner)((Network)item).inner()).location(), (Object)this.region.get())) {
                        Object object = item;
                        AddressSpace addressSpace = ((VirtualNetworkInner)(object != null ? ((HasInner)object).inner() : null)).addressSpace();
                        List list = addressSpace != null ? addressSpace.addressPrefixes() : null;
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                            Object v1;
                            if (((Logger)ScriptBytecodeAdapter.getField(_getVirtualNetworksAll_closure41.class, AzureNetworkClient.class, (String)"log")).isWarnEnabled()) {
                                Object[] objectArray = new Object[1];
                                Object object2 = item;
                                AddressSpace addressSpace2 = ((VirtualNetworkInner)(object2 != null ? ((HasInner)object2).inner() : null)).addressSpace();
                                List list2 = addressSpace2 != null ? addressSpace2.addressPrefixes() : null;
                                objectArray[0] = list2 != null ? Integer.valueOf(list2.size()) : null;
                                ((Logger)ScriptBytecodeAdapter.getField(_getVirtualNetworksAll_closure41.class, AzureNetworkClient.class, (String)"log")).warn(ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"Virtual Network found with ", " address spaces; expected: 1"})));
                                v1 = null;
                            } else {
                                v1 = null;
                            }
                        }
                        AzureVirtualNetworkDescription vnet = AzureVirtualNetworkDescription.getDescriptionForVirtualNetwork((VirtualNetworkInner)ScriptBytecodeAdapter.castToType((Object)((Network)item).inner(), VirtualNetworkInner.class));
                        List list3 = DefaultGroovyMethods.toList(AzureSubnetDescription.getSubnetsForVirtualNetwork((VirtualNetworkInner)ScriptBytecodeAdapter.castToType((Object)((Network)item).inner(), VirtualNetworkInner.class)));
                        vnet.setSubnets(list3);
                        Object object3 = this.currentTime.get();
                        vnet.setLastReadTime(DefaultTypeTransformation.longUnbox((Object)object3));
                        List list4 = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)vnet);
                        this.result.set((Object)list4);
                        List list5 = list4;
                        try {
                            return list5;
                        }
                        catch (RuntimeException re) {
                            Object v2;
                            if (((Logger)ScriptBytecodeAdapter.getField(_getVirtualNetworksAll_closure41.class, AzureNetworkClient.class, (String)"log")).isErrorEnabled()) {
                                ((Logger)ScriptBytecodeAdapter.getField(_getVirtualNetworksAll_closure41.class, AzureNetworkClient.class, (String)"log")).error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((VirtualNetworkInner)((Network)item).inner()).name()}, new String[]{"Unable to process virtual network ", ""})), (Throwable)re);
                                v2 = null;
                            } else {
                                v2 = null;
                            }
                            Object var14_14 = v2;
                            return var14_14;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return ShortTypeHandling.castToString((Object)this.region.get());
                }

                @Generated
                public Object getCurrentTime() {
                    return this.currentTime.get();
                }

                @Generated
                public Object getResult() {
                    return this.result.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getVirtualNetworksAll_closure41.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List list = pagedList != null ? DefaultGroovyMethods.each((List)pagedList, (Closure)new _getVirtualNetworksAll_closure41(this, this, region2, currentTime, result)) : null;
        }
        catch (Exception e) {
            log.error("getVirtualNetworksAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public String getDnsNameForPublicIp(String resourceGroupName, String publicIpName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference publicIpName2 = new Reference((Object)var2_2);
        String dnsName = "dns-not-found";
        try {
            public final class _getDnsNameForPublicIp_closure42
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference resourceGroupName;
                private /* synthetic */ Reference publicIpName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getDnsNameForPublicIp_closure42(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference publicIpName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.resourceGroupName = reference2 = resourceGroupName;
                    this.publicIpName = reference = publicIpName;
                }

                public Object doCall(Object it) {
                    return ((AzureNetworkClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().publicIPAddresses().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.publicIpName.get()));
                }

                @Generated
                public String getResourceGroupName() {
                    return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
                }

                @Generated
                public String getPublicIpName() {
                    return ShortTypeHandling.castToString((Object)this.publicIpName.get());
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getDnsNameForPublicIp_closure42.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            PublicIPAddress publicIp = (PublicIPAddress)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)((String)publicIpName2.get())) ? AzureBaseClient.executeOp(new _getDnsNameForPublicIp_closure42(this, this, resourceGroupName2, publicIpName2)) : null, PublicIPAddress.class);
            PublicIPAddress publicIPAddress = publicIp;
            if (DefaultTypeTransformation.booleanUnbox((Object)(publicIPAddress != null ? publicIPAddress.fqdn() : null))) {
                String string;
                dnsName = string = publicIp.fqdn();
            }
        }
        catch (Exception e) {
            log.error("getDnsNameForPublicIp -> Unexpected exception ", (Throwable)e);
        }
        return dnsName;
    }

    public Boolean checkDnsNameAvailability(String dnsName) {
        CheckProfileDnsNameAvailabilityResult isAvailable = this.getAzure().trafficManagerProfiles().checkDnsNameAvailability(dnsName);
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)isAvailable, Boolean.class);
    }

    @Override
    public String getProviderNamespace() {
        return "Microsoft.Network";
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureNetworkClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureNetworkClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureNetworkClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureNetworkClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Logger pfaccess$0(AzureNetworkClient $that) {
        return log;
    }

    @Generated
    public void createVirtualNetwork(String resourceGroupName, String virtualNetworkName, String region) {
        this.createVirtualNetwork(resourceGroupName, virtualNetworkName, region, AzureUtilities.getVNET_DEFAULT_ADDRESS_PREFIX());
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.azure.client.AzureNetworkClient");
    }
}

