/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model;

import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.OSDisk;
import com.microsoft.azure.management.compute.StatusLevelTypes;
import com.microsoft.azure.management.compute.StorageProfile;
import com.microsoft.azure.management.compute.VirtualHardDisk;
import com.microsoft.azure.management.compute.VirtualMachineExtensionInstanceView;
import com.microsoft.azure.management.compute.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVM;
import com.netflix.spinnaker.clouddriver.azure.AzureCloudProvider;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.joda.time.DateTime;

public class AzureInstance
implements Instance,
Serializable,
GroovyObject {
    public static final String APP_HEALTH_EXT_LINUX = "Microsoft.ManagedServices.ApplicationHealthLinux";
    public static final String APP_HEALTH_EXT_WINDOWS = "Microsoft.ManagedServices.ApplicationHealthWindows";
    private String name;
    private String resourceId;
    private String vhd;
    private HealthState healthState;
    private Long launchTime;
    private final String zone;
    private String instanceType;
    private List<Map<String, Object>> health;
    private final String providerType;
    private final String cloudProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AzureInstance() {
        MetaClass metaClass;
        String string;
        this.zone = string = "N/A";
        Object object = AzureCloudProvider.getID();
        this.providerType = ShortTypeHandling.castToString((Object)object);
        Object object2 = AzureCloudProvider.getID();
        this.cloudProvider = ShortTypeHandling.castToString((Object)object2);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static AzureInstance build(VirtualMachineScaleSetVM vm) {
        Reference instance = new Reference((Object)new AzureInstance());
        String string = vm.name();
        ((AzureInstance)instance.get()).setName(string);
        String string2 = vm.sku().name();
        ((AzureInstance)instance.get()).setInstanceType(string2);
        String string3 = vm.instanceId();
        ((AzureInstance)instance.get()).setResourceId(string3);
        StorageProfile storageProfile = vm.storageProfile();
        OSDisk oSDisk = storageProfile != null ? storageProfile.osDisk() : null;
        VirtualHardDisk virtualHardDisk = oSDisk != null ? oSDisk.vhd() : null;
        String string4 = virtualHardDisk != null ? virtualHardDisk.uri() : null;
        ((AzureInstance)instance.get()).setVhd(string4);
        VirtualMachineInstanceView virtualMachineInstanceView = vm.instanceView();
        List list = virtualMachineInstanceView != null ? virtualMachineInstanceView.statuses() : null;
        public final class _build_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instance;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _build_closure1(Object _outerInstance, Object _thisObject, Reference instance) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.instance = reference = instance;
            }

            public Object doCall(Object status) {
                Object[] codes = ((InstanceViewStatus)status).code().split("/");
                Object object = BytecodeInterface8.objectArrayGet((Object[])codes, (int)0);
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"ProvisioningState")) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((String)BytecodeInterface8.objectArrayGet((Object[])codes, (int)1)).toLowerCase(), (Object)AzureUtilities.ProvisioningState.SUCCEEDED.toLowerCase())) {
                        DateTime dateTime = ((InstanceViewStatus)status).time();
                        Long l = dateTime != null ? Long.valueOf(dateTime.getMillis()) : null;
                        ((AzureInstance)this.instance.get()).setLaunchTime(l);
                        return l;
                    }
                    HealthState healthState = HealthState.Failed;
                    ((AzureInstance)this.instance.get()).setHealthState(healthState);
                    return healthState;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"PowerState")) {
                    HealthState healthState = ScriptBytecodeAdapter.compareEqual((Object)((String)BytecodeInterface8.objectArrayGet((Object[])codes, (int)1)).toLowerCase(), (Object)"Running".toLowerCase()) ? HealthState.Up : HealthState.Down;
                    ((AzureInstance)this.instance.get()).setHealthState(healthState);
                    return healthState;
                }
                return null;
            }

            @Generated
            public AzureInstance getInstance() {
                return (AzureInstance)ScriptBytecodeAdapter.castToType((Object)this.instance.get(), AzureInstance.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _build_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each((List)list, (Closure)new _build_closure1(AzureInstance.class, AzureInstance.class, instance)) : null;
        VirtualMachineScaleSetVM virtualMachineScaleSetVM = vm;
        VirtualMachineInstanceView virtualMachineInstanceView2 = virtualMachineScaleSetVM != null ? virtualMachineScaleSetVM.instanceView() : null;
        List list3 = virtualMachineInstanceView2 != null ? virtualMachineInstanceView2.extensions() : null;
        public final class _build_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instance;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _build_closure2(Object _outerInstance, Object _thisObject, Reference instance) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.instance = reference = instance;
            }

            public Object doCall(Object extension) {
                if (ScriptBytecodeAdapter.compareEqual((Object)((VirtualMachineExtensionInstanceView)extension).type(), (Object)ScriptBytecodeAdapter.getField(_build_closure2.class, AzureInstance.class, (String)"APP_HEALTH_EXT_LINUX")) || ScriptBytecodeAdapter.compareEqual((Object)((VirtualMachineExtensionInstanceView)extension).type(), (Object)ScriptBytecodeAdapter.getField(_build_closure2.class, AzureInstance.class, (String)"APP_HEALTH_EXT_WINDOWS"))) {
                    List substatuses = ((VirtualMachineExtensionInstanceView)extension).substatuses();
                    if (substatuses != null) {
                        Object object = DefaultGroovyMethods.getAt((List)substatuses, (int)0);
                        StatusLevelTypes statusLevel = object != null ? ((InstanceViewStatus)object).level() : null;
                        if (ScriptBytecodeAdapter.compareEqual((Object)statusLevel, (Object)StatusLevelTypes.ERROR)) {
                            HealthState healthState = HealthState.Down;
                            ((AzureInstance)this.instance.get()).setHealthState(healthState);
                            return healthState;
                        }
                        HealthState healthState = HealthState.Up;
                        ((AzureInstance)this.instance.get()).setHealthState(healthState);
                        return healthState;
                    }
                    return null;
                }
                return null;
            }

            @Generated
            public AzureInstance getInstance() {
                return (AzureInstance)ScriptBytecodeAdapter.castToType((Object)this.instance.get(), AzureInstance.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _build_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list4 = list3 != null ? DefaultGroovyMethods.each((List)list3, (Closure)new _build_closure2(AzureInstance.class, AzureInstance.class, instance)) : null;
        return (AzureInstance)instance.get();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureInstance.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ HealthState pfaccess$00(AzureInstance $that, HealthState $value) {
        HealthState healthState = $value;
        $that.setHealthState(healthState);
        return healthState;
    }

    public static /* synthetic */ Long pfaccess$01(AzureInstance $that, Long $value) {
        Long l = $value;
        $that.setLaunchTime(l);
        return l;
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public void setResourceId(String string) {
        this.resourceId = string;
    }

    @Generated
    public String getVhd() {
        return this.vhd;
    }

    @Generated
    public void setVhd(String string) {
        this.vhd = string;
    }

    @Generated
    public HealthState getHealthState() {
        return this.healthState;
    }

    @Generated
    public void setHealthState(HealthState healthState) {
        this.healthState = healthState;
    }

    @Generated
    public Long getLaunchTime() {
        return this.launchTime;
    }

    @Generated
    public void setLaunchTime(Long l) {
        this.launchTime = l;
    }

    @Generated
    public final String getZone() {
        return this.zone;
    }

    @Generated
    public String getInstanceType() {
        return this.instanceType;
    }

    @Generated
    public void setInstanceType(String string) {
        this.instanceType = string;
    }

    @Generated
    public List<Map<String, Object>> getHealth() {
        return this.health;
    }

    @Generated
    public void setHealth(List<Map<String, Object>> list) {
        this.health = list;
    }

    @Generated
    public final String getProviderType() {
        return this.providerType;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }
}

