/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model;

import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetInner;
import com.azure.resourcemanager.compute.models.ResourceIdentityType;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetDataDisk;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.azure.AzureCloudProvider;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.common.AzureResourceOpsDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.loadbalancer.model.AzureLoadBalancer;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureInstance;
import com.netflix.spinnaker.clouddriver.azure.resources.vmimage.model.AzureNamedImage;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;

public class AzureServerGroupDescription
extends AzureResourceOpsDescription
implements ServerGroup {
    private Set<AzureInstance> instances;
    private Set<String> loadBalancers;
    private Set<String> securityGroups;
    private Set<String> zones;
    private Map<String, String> instanceTags;
    private final String type;
    private final String cloudProvider;
    private Map<String, Object> launchConfig;
    private ServerGroup.Capacity capacity;
    private ServerGroup.ImagesSummary imagesSummary;
    private ServerGroup.ImageSummary imageSummary;
    private UpgradePolicy upgradePolicy;
    private String loadBalancerName;
    private String loadBalancerType;
    private String appGatewayName;
    private String appGatewayBapId;
    private AzureNamedImage image;
    private AzureScaleSetSku sku;
    private AzureOperatingSystemConfig osConfig;
    private String provisioningState;
    private String application;
    private String clusterName;
    private String securityGroupName;
    private String subnetId;
    private List<String> storageAccountNames;
    private Boolean isDisabled;
    private List<AzureInboundPortConfig> inboundPortConfigs;
    private String vnet;
    private String subnet;
    private String vnetResourceGroup;
    private Boolean hasNewSubnet;
    private Boolean createNewSubnet;
    private AzureExtensionCustomScriptSettings customScriptsSettings;
    private AzureExtensionHealthSettings healthSettings;
    private Boolean enableInboundNAT;
    private List<VirtualMachineScaleSetDataDisk> dataDisks;
    private Integer terminationNotBeforeTimeoutInMinutes;
    private String windowsTimeZone;
    private Boolean doNotRunExtensionsOnOverprovisionedVMs;
    private Boolean useSystemManagedIdentity;
    private String userAssignedIdentities;
    private Boolean enableIpForwarding;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AzureServerGroupDescription() {
        MetaClass metaClass;
        List list;
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(AzureCloudProvider.class);
        this.type = ShortTypeHandling.castToString((Object)object);
        Object object2 = callSiteArray[1].callGetProperty(AzureCloudProvider.class);
        this.cloudProvider = ShortTypeHandling.castToString((Object)object2);
        boolean bl = false;
        this.isDisabled = bl;
        this.inboundPortConfigs = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        boolean bl2 = false;
        this.hasNewSubnet = bl2;
        boolean bl3 = false;
        this.createNewSubnet = bl3;
        boolean bl4 = false;
        this.enableInboundNAT = bl4;
        boolean bl5 = false;
        this.doNotRunExtensionsOnOverprovisionedVMs = bl5;
        boolean bl6 = false;
        this.useSystemManagedIdentity = bl6;
        boolean bl7 = false;
        this.enableIpForwarding = bl7;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Integer getStorageAccountCount() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call((Object)DefaultTypeTransformation.intUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this.sku), (Object)20)), (Object)1), Integer.class);
        }
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this.sku), (Object)20)) + 1;
    }

    public static UpgradePolicy getPolicyFromMode(String mode) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return (UpgradePolicy)ShortTypeHandling.castToEnum((Object)(ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].call((Object)mode), (Object)callSiteArray[8].call((Object)"Automatic")) ? callSiteArray[9].callGetProperty(UpgradePolicy.class) : callSiteArray[10].callGetProperty(UpgradePolicy.class)), UpgradePolicy.class);
    }

    public String getClusterName() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        String string = this.clusterName;
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : callSiteArray[11].callGetProperty(callSiteArray[12].call(Names.class, callSiteArray[13].callGroovyObjectGetProperty((Object)this)))));
    }

    public String getIdentifier() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[14].call(String.class, (Object)"%s-%s-%s", (Object)this.application, callSiteArray[15].callGroovyObjectGetProperty((Object)this), callSiteArray[16].callGroovyObjectGetProperty((Object)this)));
    }

    public Set<String> getLoadBalancers() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.appGatewayName, null)) {
            return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)this), (Object)this.appGatewayName), Set.class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.loadBalancerName, null)) {
            return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)this.loadBalancerName), Set.class);
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callConstructor(HashSet.class), Set.class);
    }

    public Set<String> getSecurityGroups() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)(ScriptBytecodeAdapter.compareEqual((Object)this.securityGroupName, null) ? callSiteArray[22].callConstructor(HashSet.class) : callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)this), (Object)this.securityGroupName)), Set.class);
    }

    public Boolean isDisabled() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return this.isDisabled;
    }

    public ServerGroup.InstanceCounts getInstanceCounts() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        Collection<AzureInstance> instances = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[25].callCurrent((GroovyObject)this);
            instances = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
        } else {
            Set<AzureInstance> set;
            instances = set = this.getInstances();
        }
        Object[] objectArray = new Object[12];
        objectArray[0] = "total";
        Object object = callSiteArray[27].callSafe(instances);
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
        objectArray[2] = "up";
        Object object2 = callSiteArray[28].callSafe(callSiteArray[29].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[30].callGetProperty(HealthState.class)));
        objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Integer.valueOf(0);
        objectArray[4] = "down";
        Object object3 = callSiteArray[31].callSafe(callSiteArray[32].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[33].callGetProperty(HealthState.class)));
        objectArray[5] = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : Integer.valueOf(0);
        objectArray[6] = "unknown";
        Object object4 = callSiteArray[34].callSafe(callSiteArray[35].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[36].callGetProperty(HealthState.class)));
        objectArray[7] = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : Integer.valueOf(0);
        objectArray[8] = "starting";
        Object object5 = callSiteArray[37].callSafe(callSiteArray[38].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[39].callGetProperty(HealthState.class)));
        objectArray[9] = DefaultTypeTransformation.booleanUnbox((Object)object5) ? object5 : Integer.valueOf(0);
        objectArray[10] = "outOfService";
        Object object6 = callSiteArray[40].callSafe(callSiteArray[41].callStatic(AzureServerGroupDescription.class, instances, callSiteArray[42].callGetProperty(HealthState.class)));
        objectArray[11] = DefaultTypeTransformation.booleanUnbox((Object)object6) ? object6 : Integer.valueOf(0);
        return (ServerGroup.InstanceCounts)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].callConstructor(ServerGroup.InstanceCounts.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), ServerGroup.InstanceCounts.class);
    }

    public ServerGroup.Capacity getCapacity() {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return (ServerGroup.Capacity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callConstructor(ServerGroup.Capacity.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", 1, "max", DefaultTypeTransformation.booleanUnbox(this.instances) ? callSiteArray[44].call(this.instances) : Integer.valueOf(1), "desired", DefaultTypeTransformation.booleanUnbox(this.instances) ? callSiteArray[45].call(this.instances) : Integer.valueOf(1)})), ServerGroup.Capacity.class);
    }

    public static AzureServerGroupDescription build(VirtualMachineScaleSetInner scaleSet) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        Object azureSG = callSiteArray[46].callConstructor(AzureServerGroupDescription.class);
        Object object = callSiteArray[47].call((Object)scaleSet);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)azureSG, (String)"name");
        Object parsedName = callSiteArray[48].call(Names.class, callSiteArray[49].call((Object)scaleSet));
        Map map = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[50].call((Object)scaleSet)) ? callSiteArray[51].call((Object)scaleSet) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)azureSG, (String)"tags");
        Object object2 = callSiteArray[52].callGetPropertySafe(callSiteArray[53].call((Object)scaleSet));
        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : callSiteArray[54].callGetProperty(parsedName);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)azureSG, (String)"appName");
        Object object4 = callSiteArray[55].callGetPropertySafe(callSiteArray[56].call((Object)scaleSet));
        Object object5 = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : callSiteArray[57].callGetProperty(parsedName);
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)azureSG, (String)"stack");
        Object object6 = callSiteArray[58].callGetPropertySafe(callSiteArray[59].call((Object)scaleSet));
        Object object7 = DefaultTypeTransformation.booleanUnbox((Object)object6) ? object6 : callSiteArray[60].callGetProperty(parsedName);
        ScriptBytecodeAdapter.setProperty((Object)object7, null, (Object)azureSG, (String)"detail");
        Object object8 = callSiteArray[61].callGetProperty(azureSG);
        ScriptBytecodeAdapter.setProperty((Object)object8, null, (Object)azureSG, (String)"application");
        Object object9 = callSiteArray[62].callGetPropertySafe(callSiteArray[63].call((Object)scaleSet));
        Object object10 = DefaultTypeTransformation.booleanUnbox((Object)object9) ? object9 : callSiteArray[64].callGetProperty(parsedName);
        ScriptBytecodeAdapter.setProperty((Object)object10, null, (Object)azureSG, (String)"clusterName");
        Object object11 = callSiteArray[65].callGetPropertySafe(callSiteArray[66].call((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object11, null, (Object)azureSG, (String)"securityGroupName");
        Object object12 = callSiteArray[67].callGetPropertySafe(callSiteArray[68].call((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object12, null, (Object)azureSG, (String)"loadBalancerName");
        Object object13 = callSiteArray[69].callGetPropertySafe(callSiteArray[70].call((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object13, null, (Object)azureSG, (String)"enableInboundNAT");
        Object object14 = callSiteArray[71].callGetPropertySafe(callSiteArray[72].call((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object14, null, (Object)azureSG, (String)"appGatewayName");
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[73].callGetProperty(azureSG), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[74].callGetProperty(azureSG), null)) {
                Object var19_19 = null;
                ScriptBytecodeAdapter.setProperty(var19_19, null, (Object)azureSG, (String)"loadBalancerType");
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[75].callGetProperty(azureSG), null)) {
                Object object15 = callSiteArray[76].call(callSiteArray[77].callGetProperty(AzureLoadBalancer.AzureLoadBalancerType.class));
                ScriptBytecodeAdapter.setProperty((Object)object15, null, (Object)azureSG, (String)"loadBalancerType");
            } else {
                Object object16 = callSiteArray[78].call(callSiteArray[79].callGetProperty(AzureLoadBalancer.AzureLoadBalancerType.class));
                ScriptBytecodeAdapter.setProperty((Object)object16, null, (Object)azureSG, (String)"loadBalancerType");
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[80].callGetProperty(azureSG), null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[81].callGetProperty(azureSG), null)) {
            Object var22_22 = null;
            ScriptBytecodeAdapter.setProperty(var22_22, null, (Object)azureSG, (String)"loadBalancerType");
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[82].callGetProperty(azureSG), null)) {
            Object object17 = callSiteArray[83].call(callSiteArray[84].callGetProperty(AzureLoadBalancer.AzureLoadBalancerType.class));
            ScriptBytecodeAdapter.setProperty((Object)object17, null, (Object)azureSG, (String)"loadBalancerType");
        } else {
            Object object18 = callSiteArray[85].call(callSiteArray[86].callGetProperty(AzureLoadBalancer.AzureLoadBalancerType.class));
            ScriptBytecodeAdapter.setProperty((Object)object18, null, (Object)azureSG, (String)"loadBalancerType");
        }
        Object object19 = callSiteArray[87].callGetPropertySafe(callSiteArray[88].call((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object19, null, (Object)azureSG, (String)"appGatewayBapId");
        Object networkInterfaceConfigurations = callSiteArray[89].callSafe(callSiteArray[90].callSafe(callSiteArray[91].call((Object)scaleSet)));
        if (DefaultTypeTransformation.booleanUnbox((Object)networkInterfaceConfigurations) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[92].call(networkInterfaceConfigurations), (Object)0)) {
            Object object20 = callSiteArray[93].call(callSiteArray[94].call(networkInterfaceConfigurations, (Object)0));
            ScriptBytecodeAdapter.setProperty((Object)object20, null, (Object)azureSG, (String)"enableIpForwarding");
        }
        Object object21 = callSiteArray[95].callGetPropertySafe(callSiteArray[96].call((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object21, null, (Object)azureSG, (String)"subnetId");
        Object object22 = callSiteArray[97].call(AzureUtilities.class, callSiteArray[98].callGetProperty(azureSG));
        ScriptBytecodeAdapter.setProperty((Object)object22, null, (Object)azureSG, (String)"subnet");
        Object object23 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[99].callGetProperty(azureSG)) ? callSiteArray[100].call(AzureUtilities.class, callSiteArray[101].callGetProperty(azureSG)) : callSiteArray[102].callGetPropertySafe(callSiteArray[103].call((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object23, null, (Object)azureSG, (String)"vnet");
        Object object24 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[104].callGetProperty(azureSG)) ? callSiteArray[105].call(AzureUtilities.class, callSiteArray[106].callGetProperty(azureSG)) : callSiteArray[107].callGetPropertySafe(callSiteArray[108].call((Object)scaleSet));
        ScriptBytecodeAdapter.setProperty((Object)object24, null, (Object)azureSG, (String)"vnetResourceGroup");
        boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[109].callGetPropertySafe(callSiteArray[110].call((Object)scaleSet)), (Object)"true");
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)azureSG, (String)"hasNewSubnet");
        Object object25 = callSiteArray[111].callSafe(callSiteArray[112].callGetPropertySafe(callSiteArray[113].call((Object)scaleSet)));
        ScriptBytecodeAdapter.setProperty((Object)object25, null, (Object)azureSG, (String)"createdTime");
        Object object26 = callSiteArray[114].callConstructor(AzureNamedImage.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"isCustom", callSiteArray[115].callGetPropertySafe(callSiteArray[116].call((Object)scaleSet)), "imageName", callSiteArray[117].callGetPropertySafe(callSiteArray[118].call((Object)scaleSet))}));
        ScriptBytecodeAdapter.setProperty((Object)object26, null, (Object)azureSG, (String)"image");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[119].callGetProperty(callSiteArray[120].callGetProperty(azureSG)))) {
            Object object27 = callSiteArray[121].callConstructor(ArrayList.class);
            ScriptBytecodeAdapter.setProperty((Object)object27, null, (Object)azureSG, (String)"storageAccountNames");
            String storageNames = ShortTypeHandling.castToString((Object)callSiteArray[122].callGetPropertySafe(callSiteArray[123].call((Object)scaleSet)));
            if (DefaultTypeTransformation.booleanUnbox((Object)storageNames)) {
                callSiteArray[124].call(callSiteArray[125].callGetProperty(azureSG), callSiteArray[126].call((Object)storageNames, (Object)","));
            }
        }
        Object object28 = callSiteArray[127].call((Object)scaleSet);
        ScriptBytecodeAdapter.setProperty((Object)object28, null, (Object)azureSG, (String)"doNotRunExtensionsOnOverprovisionedVMs");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[128].call((Object)scaleSet), null)) {
            ResourceIdentityType rType = (ResourceIdentityType)ShortTypeHandling.castToEnum((Object)callSiteArray[129].call(callSiteArray[130].call((Object)scaleSet)), ResourceIdentityType.class);
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                boolean bl2 = ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[131].callGetProperty(ResourceIdentityType.class)) || ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[132].callGetProperty(ResourceIdentityType.class));
                ScriptBytecodeAdapter.setProperty((Object)bl2, null, (Object)azureSG, (String)"useSystemManagedIdentity");
            } else {
                boolean bl3 = ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[133].callGetProperty(ResourceIdentityType.class)) || ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[134].callGetProperty(ResourceIdentityType.class));
                ScriptBytecodeAdapter.setProperty((Object)bl3, null, (Object)azureSG, (String)"useSystemManagedIdentity");
            }
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[135].callGetProperty(ResourceIdentityType.class)) || ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[136].callGetProperty(ResourceIdentityType.class))) {
                    StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[137].callConstructor(StringBuilder.class), StringBuilder.class);
                    String identity = null;
                    Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].call(callSiteArray[139].call(callSiteArray[140].call(callSiteArray[141].call((Object)scaleSet)))), Iterator.class);
                    while (iterator.hasNext()) {
                        identity = ShortTypeHandling.castToString(iterator.next());
                        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[142].call((Object)sb), (Object)0)) {
                            callSiteArray[143].call((Object)sb, (Object)",");
                        }
                        callSiteArray[144].call((Object)sb, (Object)identity);
                    }
                    Object object29 = callSiteArray[145].call((Object)sb);
                    ScriptBytecodeAdapter.setProperty((Object)object29, null, (Object)azureSG, (String)"userAssignedIdentities");
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[146].callGetProperty(ResourceIdentityType.class)) || ScriptBytecodeAdapter.compareEqual((Object)rType, (Object)callSiteArray[147].callGetProperty(ResourceIdentityType.class))) {
                StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].callConstructor(StringBuilder.class), StringBuilder.class);
                String identity = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].call(callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].call((Object)scaleSet)))), Iterator.class);
                while (iterator.hasNext()) {
                    identity = ShortTypeHandling.castToString(iterator.next());
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[153].call((Object)sb), (Object)0)) {
                        callSiteArray[154].call((Object)sb, (Object)",");
                    }
                    callSiteArray[155].call((Object)sb, (Object)identity);
                }
                Object object30 = callSiteArray[156].call((Object)sb);
                ScriptBytecodeAdapter.setProperty((Object)object30, null, (Object)azureSG, (String)"userAssignedIdentities");
            }
        }
        Object object31 = callSiteArray[157].call((Object)scaleSet);
        ScriptBytecodeAdapter.setProperty((Object)object31, null, (Object)azureSG, (String)"region");
        Object object32 = callSiteArray[158].callStatic(AzureServerGroupDescription.class, callSiteArray[159].call(callSiteArray[160].call(callSiteArray[161].call((Object)scaleSet))));
        ScriptBytecodeAdapter.setProperty((Object)object32, null, (Object)azureSG, (String)"upgradePolicy");
        Object termProfile = callSiteArray[162].callSafe(callSiteArray[163].callSafe(callSiteArray[164].call((Object)scaleSet)));
        if (DefaultTypeTransformation.booleanUnbox((Object)termProfile)) {
            Object[] str = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].call(callSiteArray[166].call(termProfile), (Object)"\\d+"), String[].class);
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[167].call((Object)str), (Object)0)) {
                    Object object33 = callSiteArray[168].call(callSiteArray[169].call((Object)str, (Object)0));
                    ScriptBytecodeAdapter.setProperty((Object)object33, null, (Object)azureSG, (String)"terminationNotBeforeTimeoutInMinutes");
                }
            } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[170].call((Object)str), (Object)0)) {
                Object object34 = callSiteArray[171].call(BytecodeInterface8.objectArrayGet((Object[])str, (int)0));
                ScriptBytecodeAdapter.setProperty((Object)object34, null, (Object)azureSG, (String)"terminationNotBeforeTimeoutInMinutes");
            }
        }
        Object object35 = callSiteArray[172].callSafe(callSiteArray[173].callSafe(callSiteArray[174].callSafe(callSiteArray[175].call((Object)scaleSet))));
        ScriptBytecodeAdapter.setProperty((Object)object35, null, (Object)azureSG, (String)"windowsTimeZone");
        Object storageProfile = callSiteArray[176].callSafe(callSiteArray[177].call((Object)scaleSet));
        Object imgRef = callSiteArray[178].callSafe(storageProfile);
        if (DefaultTypeTransformation.booleanUnbox((Object)imgRef)) {
            Object object36 = callSiteArray[179].call(imgRef);
            ScriptBytecodeAdapter.setProperty((Object)object36, null, (Object)callSiteArray[180].callGetProperty(azureSG), (String)"offer");
            Object object37 = callSiteArray[181].call(imgRef);
            ScriptBytecodeAdapter.setProperty((Object)object37, null, (Object)callSiteArray[182].callGetProperty(azureSG), (String)"publisher");
            Object object38 = callSiteArray[183].call(imgRef);
            ScriptBytecodeAdapter.setProperty((Object)object38, null, (Object)callSiteArray[184].callGetProperty(azureSG), (String)"sku");
            Object object39 = callSiteArray[185].call(imgRef);
            ScriptBytecodeAdapter.setProperty((Object)object39, null, (Object)callSiteArray[186].callGetProperty(azureSG), (String)"version");
        }
        Object object40 = callSiteArray[187].callSafe(storageProfile);
        ScriptBytecodeAdapter.setProperty((Object)object40, null, (Object)azureSG, (String)"dataDisks");
        Object osConfig = callSiteArray[188].callConstructor(AzureOperatingSystemConfig.class);
        Object osProfile = callSiteArray[189].callSafe(callSiteArray[190].callSafe((Object)scaleSet));
        if (DefaultTypeTransformation.booleanUnbox((Object)osProfile)) {
            Object object41 = callSiteArray[191].call(osProfile);
            ScriptBytecodeAdapter.setProperty((Object)object41, null, (Object)osConfig, (String)"adminPassword");
            Object object42 = callSiteArray[192].call(osProfile);
            ScriptBytecodeAdapter.setProperty((Object)object42, null, (Object)osConfig, (String)"adminUserName");
            Object object43 = callSiteArray[193].call(osProfile);
            ScriptBytecodeAdapter.setProperty((Object)object43, null, (Object)osConfig, (String)"computerNamePrefix");
            Object object44 = callSiteArray[194].call(osProfile);
            ScriptBytecodeAdapter.setProperty((Object)object44, null, (Object)osConfig, (String)"customData");
        }
        Object object45 = osConfig;
        ScriptBytecodeAdapter.setProperty((Object)object45, null, (Object)azureSG, (String)"osConfig");
        Object customScriptSettings = callSiteArray[195].callConstructor(AzureExtensionCustomScriptSettings.class);
        Object extensionProfile = callSiteArray[196].callSafe(callSiteArray[197].callSafe((Object)scaleSet));
        if (DefaultTypeTransformation.booleanUnbox((Object)extensionProfile)) {
            public final class _build_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _build_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _build_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _build_closure1.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(it), (Object)callSiteArray[1].callGetProperty(AzureUtilities.class)) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(it), (Object)callSiteArray[3].callGetProperty(AzureUtilities.class));
                    }
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].call(it), (Object)callSiteArray[5].callGetProperty(AzureUtilities.class)) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(it), (Object)callSiteArray[7].callGetProperty(AzureUtilities.class));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _build_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _build_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "type";
                    stringArray[1] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX";
                    stringArray[2] = "type";
                    stringArray[3] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS";
                    stringArray[4] = "type";
                    stringArray[5] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX";
                    stringArray[6] = "type";
                    stringArray[7] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _build_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_build_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _build_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object customScriptExtensionSettings = callSiteArray[198].callSafe(callSiteArray[199].call(callSiteArray[200].call(extensionProfile), (Object)new _build_closure1(AzureServerGroupDescription.class, AzureServerGroupDescription.class)));
            if (DefaultTypeTransformation.booleanUnbox((Object)customScriptExtensionSettings)) {
                Object object46;
                customScriptSettings = object46 = callSiteArray[201].call(callSiteArray[202].callGetProperty(AzureServerGroupDescription.class), customScriptExtensionSettings, AzureExtensionCustomScriptSettings.class);
            }
        }
        Object object47 = customScriptSettings;
        ScriptBytecodeAdapter.setProperty((Object)object47, null, (Object)azureSG, (String)"customScriptsSettings");
        Object sku = callSiteArray[203].callConstructor(AzureScaleSetSku.class);
        Object skuData = callSiteArray[204].call((Object)scaleSet);
        if (DefaultTypeTransformation.booleanUnbox((Object)skuData)) {
            Object object48 = callSiteArray[205].call(skuData);
            ScriptBytecodeAdapter.setProperty((Object)object48, null, (Object)sku, (String)"capacity");
            Object object49 = callSiteArray[206].call(skuData);
            ScriptBytecodeAdapter.setProperty((Object)object49, null, (Object)sku, (String)"name");
            Object object50 = callSiteArray[207].call(skuData);
            ScriptBytecodeAdapter.setProperty((Object)object50, null, (Object)sku, (String)"tier");
        }
        Object object51 = sku;
        ScriptBytecodeAdapter.setProperty((Object)object51, null, (Object)azureSG, (String)"sku");
        Object zones = callSiteArray[208].call((Object)scaleSet);
        Object object52 = ScriptBytecodeAdapter.compareEqual((Object)zones, null) ? callSiteArray[209].callConstructor(HashSet.class) : callSiteArray[210].call(zones);
        ScriptBytecodeAdapter.setProperty((Object)object52, null, (Object)azureSG, (String)"zones");
        Object object53 = callSiteArray[211].call((Object)scaleSet);
        ScriptBytecodeAdapter.setProperty((Object)object53, null, (Object)azureSG, (String)"provisioningState");
        return (AzureServerGroupDescription)ScriptBytecodeAdapter.castToType((Object)azureSG, AzureServerGroupDescription.class);
    }

    public static Collection<Instance> filterInstancesByHealthState(Set<? extends Instance> instances, HealthState healthState) {
        Reference healthState2 = new Reference((Object)healthState);
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        public final class _filterInstancesByHealthState_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthState;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _filterInstancesByHealthState_closure2(Object _outerInstance, Object _thisObject, Reference healthState) {
                Reference reference;
                CallSite[] callSiteArray = _filterInstancesByHealthState_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.healthState = reference = healthState;
            }

            public Object doCall(Instance it) {
                CallSite[] callSiteArray = _filterInstancesByHealthState_closure2.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call((Object)it), (Object)this.healthState.get());
            }

            @Generated
            public Object call(Instance it) {
                CallSite[] callSiteArray = _filterInstancesByHealthState_closure2.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)it);
            }

            @Generated
            public HealthState getHealthState() {
                CallSite[] callSiteArray = _filterInstancesByHealthState_closure2.$getCallSiteArray();
                return (HealthState)ShortTypeHandling.castToEnum((Object)this.healthState.get(), HealthState.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterInstancesByHealthState_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getHealthState";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _filterInstancesByHealthState_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_filterInstancesByHealthState_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _filterInstancesByHealthState_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[212].callSafe(instances, (Object)new _filterInstancesByHealthState_closure2(AzureServerGroupDescription.class, AzureServerGroupDescription.class, healthState2)), Collection.class);
    }

    public void addInboundPortConfig(String name, int startRange, int endRange, String protocol, int backendPort) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        AzureInboundPortConfig inboundConfig = (AzureInboundPortConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[213].callConstructor(AzureInboundPortConfig.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name})), AzureInboundPortConfig.class);
        int n = startRange;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, AzureServerGroupDescription.class, (GroovyObject)inboundConfig, (String)"frontEndPortRangeStart");
        int n2 = endRange;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n2, AzureServerGroupDescription.class, (GroovyObject)inboundConfig, (String)"frontEndPortRangeEnd");
        int n3 = backendPort;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n3, AzureServerGroupDescription.class, (GroovyObject)inboundConfig, (String)"backendPort");
        String string = protocol;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, AzureServerGroupDescription.class, (GroovyObject)inboundConfig, (String)"protocol");
        callSiteArray[214].call(this.inboundPortConfigs, (Object)inboundConfig);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureServerGroupDescription.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureServerGroupDescription.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureServerGroupDescription.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = AzureServerGroupDescription.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureServerGroupDescription.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public Set<AzureInstance> getInstances() {
        return this.instances;
    }

    @Generated
    public void setInstances(Set<AzureInstance> set) {
        this.instances = set;
    }

    @Generated
    public void setLoadBalancers(Set<String> set) {
        this.loadBalancers = set;
    }

    @Generated
    public void setSecurityGroups(Set<String> set) {
        this.securityGroups = set;
    }

    @Generated
    public Set<String> getZones() {
        return this.zones;
    }

    @Generated
    public void setZones(Set<String> set) {
        this.zones = set;
    }

    @Generated
    public Map<String, String> getInstanceTags() {
        return this.instanceTags;
    }

    @Generated
    public void setInstanceTags(Map<String, String> map) {
        this.instanceTags = map;
    }

    @Generated
    public final String getType() {
        return this.type;
    }

    @Override
    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public Map<String, Object> getLaunchConfig() {
        return this.launchConfig;
    }

    @Generated
    public void setLaunchConfig(Map<String, Object> map) {
        this.launchConfig = map;
    }

    @Generated
    public void setCapacity(ServerGroup.Capacity capacity) {
        this.capacity = capacity;
    }

    @Generated
    public ServerGroup.ImagesSummary getImagesSummary() {
        return this.imagesSummary;
    }

    @Generated
    public void setImagesSummary(ServerGroup.ImagesSummary imagesSummary) {
        this.imagesSummary = imagesSummary;
    }

    @Generated
    public ServerGroup.ImageSummary getImageSummary() {
        return this.imageSummary;
    }

    @Generated
    public void setImageSummary(ServerGroup.ImageSummary imageSummary) {
        this.imageSummary = imageSummary;
    }

    @Generated
    public UpgradePolicy getUpgradePolicy() {
        return this.upgradePolicy;
    }

    @Generated
    public void setUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
    }

    @Generated
    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    @Generated
    public void setLoadBalancerName(String string) {
        this.loadBalancerName = string;
    }

    @Generated
    public String getLoadBalancerType() {
        return this.loadBalancerType;
    }

    @Generated
    public void setLoadBalancerType(String string) {
        this.loadBalancerType = string;
    }

    @Generated
    public String getAppGatewayName() {
        return this.appGatewayName;
    }

    @Generated
    public void setAppGatewayName(String string) {
        this.appGatewayName = string;
    }

    @Generated
    public String getAppGatewayBapId() {
        return this.appGatewayBapId;
    }

    @Generated
    public void setAppGatewayBapId(String string) {
        this.appGatewayBapId = string;
    }

    @Generated
    public AzureNamedImage getImage() {
        return this.image;
    }

    @Generated
    public void setImage(AzureNamedImage azureNamedImage) {
        this.image = azureNamedImage;
    }

    @Generated
    public AzureScaleSetSku getSku() {
        return this.sku;
    }

    @Generated
    public void setSku(AzureScaleSetSku azureScaleSetSku) {
        this.sku = azureScaleSetSku;
    }

    @Generated
    public AzureOperatingSystemConfig getOsConfig() {
        return this.osConfig;
    }

    @Generated
    public void setOsConfig(AzureOperatingSystemConfig azureOperatingSystemConfig) {
        this.osConfig = azureOperatingSystemConfig;
    }

    @Generated
    public String getProvisioningState() {
        return this.provisioningState;
    }

    @Generated
    public void setProvisioningState(String string) {
        this.provisioningState = string;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public void setApplication(String string) {
        this.application = string;
    }

    @Generated
    public void setClusterName(String string) {
        this.clusterName = string;
    }

    @Generated
    public String getSecurityGroupName() {
        return this.securityGroupName;
    }

    @Generated
    public void setSecurityGroupName(String string) {
        this.securityGroupName = string;
    }

    @Generated
    public String getSubnetId() {
        return this.subnetId;
    }

    @Generated
    public void setSubnetId(String string) {
        this.subnetId = string;
    }

    @Generated
    public List<String> getStorageAccountNames() {
        return this.storageAccountNames;
    }

    @Generated
    public void setStorageAccountNames(List<String> list) {
        this.storageAccountNames = list;
    }

    @Generated
    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    @Generated
    public void setIsDisabled(Boolean bl) {
        this.isDisabled = bl;
    }

    @Generated
    public List<AzureInboundPortConfig> getInboundPortConfigs() {
        return this.inboundPortConfigs;
    }

    @Generated
    public void setInboundPortConfigs(List<AzureInboundPortConfig> list) {
        this.inboundPortConfigs = list;
    }

    @Generated
    public String getVnet() {
        return this.vnet;
    }

    @Generated
    public void setVnet(String string) {
        this.vnet = string;
    }

    @Generated
    public String getSubnet() {
        return this.subnet;
    }

    @Generated
    public void setSubnet(String string) {
        this.subnet = string;
    }

    @Generated
    public String getVnetResourceGroup() {
        return this.vnetResourceGroup;
    }

    @Generated
    public void setVnetResourceGroup(String string) {
        this.vnetResourceGroup = string;
    }

    @Generated
    public Boolean getHasNewSubnet() {
        return this.hasNewSubnet;
    }

    @Generated
    public void setHasNewSubnet(Boolean bl) {
        this.hasNewSubnet = bl;
    }

    @Generated
    public Boolean getCreateNewSubnet() {
        return this.createNewSubnet;
    }

    @Generated
    public void setCreateNewSubnet(Boolean bl) {
        this.createNewSubnet = bl;
    }

    @Generated
    public AzureExtensionCustomScriptSettings getCustomScriptsSettings() {
        return this.customScriptsSettings;
    }

    @Generated
    public void setCustomScriptsSettings(AzureExtensionCustomScriptSettings azureExtensionCustomScriptSettings) {
        this.customScriptsSettings = azureExtensionCustomScriptSettings;
    }

    @Generated
    public AzureExtensionHealthSettings getHealthSettings() {
        return this.healthSettings;
    }

    @Generated
    public void setHealthSettings(AzureExtensionHealthSettings azureExtensionHealthSettings) {
        this.healthSettings = azureExtensionHealthSettings;
    }

    @Generated
    public Boolean getEnableInboundNAT() {
        return this.enableInboundNAT;
    }

    @Generated
    public void setEnableInboundNAT(Boolean bl) {
        this.enableInboundNAT = bl;
    }

    @Generated
    public List<VirtualMachineScaleSetDataDisk> getDataDisks() {
        return this.dataDisks;
    }

    @Generated
    public void setDataDisks(List<VirtualMachineScaleSetDataDisk> list) {
        this.dataDisks = list;
    }

    @Generated
    public Integer getTerminationNotBeforeTimeoutInMinutes() {
        return this.terminationNotBeforeTimeoutInMinutes;
    }

    @Generated
    public void setTerminationNotBeforeTimeoutInMinutes(Integer n) {
        this.terminationNotBeforeTimeoutInMinutes = n;
    }

    @Generated
    public String getWindowsTimeZone() {
        return this.windowsTimeZone;
    }

    @Generated
    public void setWindowsTimeZone(String string) {
        this.windowsTimeZone = string;
    }

    @Generated
    public Boolean getDoNotRunExtensionsOnOverprovisionedVMs() {
        return this.doNotRunExtensionsOnOverprovisionedVMs;
    }

    @Generated
    public void setDoNotRunExtensionsOnOverprovisionedVMs(Boolean bl) {
        this.doNotRunExtensionsOnOverprovisionedVMs = bl;
    }

    @Generated
    public Boolean getUseSystemManagedIdentity() {
        return this.useSystemManagedIdentity;
    }

    @Generated
    public void setUseSystemManagedIdentity(Boolean bl) {
        this.useSystemManagedIdentity = bl;
    }

    @Generated
    public String getUserAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    @Generated
    public void setUserAssignedIdentities(String string) {
        this.userAssignedIdentities = string;
    }

    @Generated
    public Boolean getEnableIpForwarding() {
        return this.enableIpForwarding;
    }

    @Generated
    public void setEnableIpForwarding(Boolean bl) {
        this.enableIpForwarding = bl;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ String super$2$getCloudProvider() {
        return super.getCloudProvider();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "ID";
        stringArray[1] = "ID";
        stringArray[2] = "plus";
        stringArray[3] = "div";
        stringArray[4] = "capacity";
        stringArray[5] = "div";
        stringArray[6] = "capacity";
        stringArray[7] = "toLowerCase";
        stringArray[8] = "toLowerCase";
        stringArray[9] = "Automatic";
        stringArray[10] = "Manual";
        stringArray[11] = "cluster";
        stringArray[12] = "parseName";
        stringArray[13] = "name";
        stringArray[14] = "format";
        stringArray[15] = "stack";
        stringArray[16] = "detail";
        stringArray[17] = "newHashSet";
        stringArray[18] = "Sets";
        stringArray[19] = "newHashSet";
        stringArray[20] = "Sets";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "newHashSet";
        stringArray[24] = "Sets";
        stringArray[25] = "getInstances";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "size";
        stringArray[28] = "size";
        stringArray[29] = "filterInstancesByHealthState";
        stringArray[30] = "Up";
        stringArray[31] = "size";
        stringArray[32] = "filterInstancesByHealthState";
        stringArray[33] = "Down";
        stringArray[34] = "size";
        stringArray[35] = "filterInstancesByHealthState";
        stringArray[36] = "Unknown";
        stringArray[37] = "size";
        stringArray[38] = "filterInstancesByHealthState";
        stringArray[39] = "Starting";
        stringArray[40] = "size";
        stringArray[41] = "filterInstancesByHealthState";
        stringArray[42] = "OutOfService";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "size";
        stringArray[45] = "size";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "name";
        stringArray[48] = "parseName";
        stringArray[49] = "name";
        stringArray[50] = "tags";
        stringArray[51] = "tags";
        stringArray[52] = "appName";
        stringArray[53] = "tags";
        stringArray[54] = "app";
        stringArray[55] = "stack";
        stringArray[56] = "tags";
        stringArray[57] = "stack";
        stringArray[58] = "detail";
        stringArray[59] = "tags";
        stringArray[60] = "detail";
        stringArray[61] = "appName";
        stringArray[62] = "cluster";
        stringArray[63] = "tags";
        stringArray[64] = "cluster";
        stringArray[65] = "securityGroupName";
        stringArray[66] = "tags";
        stringArray[67] = "loadBalancerName";
        stringArray[68] = "tags";
        stringArray[69] = "enableInboundNAT";
        stringArray[70] = "tags";
        stringArray[71] = "appGatewayName";
        stringArray[72] = "tags";
        stringArray[73] = "appGatewayName";
        stringArray[74] = "loadBalancerName";
        stringArray[75] = "appGatewayName";
        stringArray[76] = "toString";
        stringArray[77] = "AZURE_LOAD_BALANCER";
        stringArray[78] = "toString";
        stringArray[79] = "AZURE_APPLICATION_GATEWAY";
        stringArray[80] = "appGatewayName";
        stringArray[81] = "loadBalancerName";
        stringArray[82] = "appGatewayName";
        stringArray[83] = "toString";
        stringArray[84] = "AZURE_LOAD_BALANCER";
        stringArray[85] = "toString";
        stringArray[86] = "AZURE_APPLICATION_GATEWAY";
        stringArray[87] = "appGatewayBapId";
        stringArray[88] = "tags";
        stringArray[89] = "networkInterfaceConfigurations";
        stringArray[90] = "networkProfile";
        stringArray[91] = "virtualMachineProfile";
        stringArray[92] = "size";
        stringArray[93] = "enableIPForwarding";
        stringArray[94] = "getAt";
        stringArray[95] = "subnetId";
        stringArray[96] = "tags";
        stringArray[97] = "getNameFromResourceId";
        stringArray[98] = "subnetId";
        stringArray[99] = "subnetId";
        stringArray[100] = "getNameFromResourceId";
        stringArray[101] = "subnetId";
        stringArray[102] = "vnet";
        stringArray[103] = "tags";
        stringArray[104] = "subnetId";
        stringArray[105] = "getResourceGroupNameFromResourceId";
        stringArray[106] = "subnetId";
        stringArray[107] = "vnetResourceGroup";
        stringArray[108] = "tags";
        stringArray[109] = "hasNewSubnet";
        stringArray[110] = "tags";
        stringArray[111] = "toLong";
        stringArray[112] = "createdTime";
        stringArray[113] = "tags";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "customImage";
        stringArray[116] = "tags";
        stringArray[117] = "imageName";
        stringArray[118] = "tags";
        stringArray[119] = "isCustom";
        stringArray[120] = "image";
        stringArray[121] = "<$constructor$>";
        stringArray[122] = "storageAccountNames";
        stringArray[123] = "tags";
        stringArray[124] = "addAll";
        stringArray[125] = "storageAccountNames";
        stringArray[126] = "split";
        stringArray[127] = "doNotRunExtensionsOnOverprovisionedVMs";
        stringArray[128] = "identity";
        stringArray[129] = "type";
        stringArray[130] = "identity";
        stringArray[131] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
        stringArray[132] = "SYSTEM_ASSIGNED";
        stringArray[133] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
        stringArray[134] = "SYSTEM_ASSIGNED";
        stringArray[135] = "USER_ASSIGNED";
        stringArray[136] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
        stringArray[137] = "<$constructor$>";
        stringArray[138] = "iterator";
        stringArray[139] = "keySet";
        stringArray[140] = "userAssignedIdentities";
        stringArray[141] = "identity";
        stringArray[142] = "length";
        stringArray[143] = "append";
        stringArray[144] = "append";
        stringArray[145] = "toString";
        stringArray[146] = "USER_ASSIGNED";
        stringArray[147] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
        stringArray[148] = "<$constructor$>";
        stringArray[149] = "iterator";
        stringArray[150] = "keySet";
        stringArray[151] = "userAssignedIdentities";
        stringArray[152] = "identity";
        stringArray[153] = "length";
        stringArray[154] = "append";
        stringArray[155] = "append";
        stringArray[156] = "toString";
        stringArray[157] = "location";
        stringArray[158] = "getPolicyFromMode";
        stringArray[159] = "name";
        stringArray[160] = "mode";
        stringArray[161] = "upgradePolicy";
        stringArray[162] = "terminateNotificationProfile";
        stringArray[163] = "scheduledEventsProfile";
        stringArray[164] = "virtualMachineProfile";
        stringArray[165] = "findAll";
        stringArray[166] = "notBeforeTimeout";
        stringArray[167] = "size";
        stringArray[168] = "toInteger";
        stringArray[169] = "getAt";
        stringArray[170] = "size";
        stringArray[171] = "toInteger";
        stringArray[172] = "timeZone";
        stringArray[173] = "windowsConfiguration";
        stringArray[174] = "osProfile";
        stringArray[175] = "virtualMachineProfile";
        stringArray[176] = "storageProfile";
        stringArray[177] = "virtualMachineProfile";
        stringArray[178] = "imageReference";
        stringArray[179] = "offer";
        stringArray[180] = "image";
        stringArray[181] = "publisher";
        stringArray[182] = "image";
        stringArray[183] = "sku";
        stringArray[184] = "image";
        stringArray[185] = "version";
        stringArray[186] = "image";
        stringArray[187] = "dataDisks";
        stringArray[188] = "<$constructor$>";
        stringArray[189] = "osProfile";
        stringArray[190] = "virtualMachineProfile";
        stringArray[191] = "adminPassword";
        stringArray[192] = "adminUsername";
        stringArray[193] = "computerNamePrefix";
        stringArray[194] = "customData";
        stringArray[195] = "<$constructor$>";
        stringArray[196] = "extensionProfile";
        stringArray[197] = "virtualMachineProfile";
        stringArray[198] = "settings";
        stringArray[199] = "find";
        stringArray[200] = "extensions";
        stringArray[201] = "convertValue";
        stringArray[202] = "mapper";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "sku";
        stringArray[205] = "capacity";
        stringArray[206] = "name";
        stringArray[207] = "tier";
        stringArray[208] = "zones";
        stringArray[209] = "<$constructor$>";
        stringArray[210] = "toSet";
        stringArray[211] = "provisioningState";
        stringArray[212] = "findAll";
        stringArray[213] = "<$constructor$>";
        stringArray[214] = "add";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[215];
        AzureServerGroupDescription.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AzureServerGroupDescription.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AzureServerGroupDescription.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static final class UpgradePolicy
    extends Enum<UpgradePolicy>
    implements GroovyObject {
        public static final /* enum */ UpgradePolicy Automatic;
        public static final /* enum */ UpgradePolicy Manual;
        public static final UpgradePolicy MIN_VALUE;
        public static final UpgradePolicy MAX_VALUE;
        private static final /* synthetic */ UpgradePolicy[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public UpgradePolicy(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (ScriptBytecodeAdapter.compareEqual((Object)__namedArgs, null)) {
                throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"One of the enum constants for enum com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureServerGroupDescription$UpgradePolicy was initialized with null. Please use a non-null value or define your own constructor.");
            }
            callSiteArray[1].callStatic(ImmutableASTTransformation.class, (Object)this, (Object)__namedArgs);
        }

        @Generated
        public UpgradePolicy() {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            this((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(LinkedHashMap.class), LinkedHashMap.class));
        }

        public static final UpgradePolicy[] values() {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            return (UpgradePolicy[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), UpgradePolicy[].class);
        }

        public /* synthetic */ UpgradePolicy next() {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            Object ordinal = callSiteArray[3].call(callSiteArray[4].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)callSiteArray[5].call((Object)$VALUES))) {
                Integer n = 0;
                ordinal = n;
            }
            return (UpgradePolicy)ShortTypeHandling.castToEnum((Object)callSiteArray[6].call((Object)$VALUES, ordinal), UpgradePolicy.class);
        }

        public /* synthetic */ UpgradePolicy previous() {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            Object ordinal = callSiteArray[7].call(callSiteArray[8].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Object object;
                ordinal = object = callSiteArray[9].call(callSiteArray[10].call((Object)$VALUES), (Object)1);
            }
            return (UpgradePolicy)ShortTypeHandling.castToEnum((Object)callSiteArray[11].call((Object)$VALUES, ordinal), UpgradePolicy.class);
        }

        public static UpgradePolicy valueOf(String name) {
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            return (UpgradePolicy)ShortTypeHandling.castToEnum((Object)callSiteArray[12].callStatic(UpgradePolicy.class, UpgradePolicy.class, (Object)name), UpgradePolicy.class);
        }

        public static final /* synthetic */ UpgradePolicy $INIT(Object ... para) {
            UpgradePolicy upgradePolicy;
            CallSite[] callSiteArray = UpgradePolicy.$getCallSiteArray();
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, UpgradePolicy.class)) {
                case -1348271900: {
                    UpgradePolicy upgradePolicy2;
                    upgradePolicy = upgradePolicy2;
                    Object[] objectArray2 = objectArray;
                    upgradePolicy2 = new UpgradePolicy();
                    break;
                }
                case -242181752: {
                    UpgradePolicy upgradePolicy2;
                    upgradePolicy = upgradePolicy2;
                    Object[] objectArray2 = objectArray;
                    upgradePolicy2 = new UpgradePolicy((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return upgradePolicy;
        }

        static {
            UpgradePolicy upgradePolicy;
            UpgradePolicy upgradePolicy2;
            Object object = UpgradePolicy.$getCallSiteArray()[13].callStatic(UpgradePolicy.class, (Object)"Automatic", (Object)0);
            Automatic = (UpgradePolicy)ShortTypeHandling.castToEnum((Object)object, UpgradePolicy.class);
            Object object2 = UpgradePolicy.$getCallSiteArray()[14].callStatic(UpgradePolicy.class, (Object)"Manual", (Object)1);
            Manual = (UpgradePolicy)ShortTypeHandling.castToEnum((Object)object2, UpgradePolicy.class);
            MIN_VALUE = upgradePolicy2 = Automatic;
            MAX_VALUE = upgradePolicy = Manual;
            UpgradePolicy[] upgradePolicyArray = new UpgradePolicy[]{Automatic, Manual};
            $VALUES = upgradePolicyArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != UpgradePolicy.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "checkPropNames";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "next";
            stringArray[4] = "ordinal";
            stringArray[5] = "size";
            stringArray[6] = "getAt";
            stringArray[7] = "previous";
            stringArray[8] = "ordinal";
            stringArray[9] = "minus";
            stringArray[10] = "size";
            stringArray[11] = "getAt";
            stringArray[12] = "valueOf";
            stringArray[13] = "$INIT";
            stringArray[14] = "$INIT";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[15];
            UpgradePolicy.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(UpgradePolicy.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = UpgradePolicy.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureScaleSetSku
    implements GroovyObject {
        private String name;
        private String tier;
        private Long capacity;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureScaleSetSku() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureScaleSetSku.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureScaleSetSku.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureScaleSetSku.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureScaleSetSku.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureScaleSetSku.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureScaleSetSku.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getTier() {
            return this.tier;
        }

        @Generated
        public void setTier(String string) {
            this.tier = string;
        }

        @Generated
        public Long getCapacity() {
            return this.capacity;
        }

        @Generated
        public void setCapacity(Long l) {
            this.capacity = l;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureScaleSetSku.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureScaleSetSku.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureOperatingSystemConfig
    implements GroovyObject {
        private String adminUserName;
        private String adminPassword;
        private String computerNamePrefix;
        private String customData;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureOperatingSystemConfig() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureOperatingSystemConfig.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureOperatingSystemConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureOperatingSystemConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureOperatingSystemConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureOperatingSystemConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureOperatingSystemConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getAdminUserName() {
            return this.adminUserName;
        }

        @Generated
        public void setAdminUserName(String string) {
            this.adminUserName = string;
        }

        @Generated
        public String getAdminPassword() {
            return this.adminPassword;
        }

        @Generated
        public void setAdminPassword(String string) {
            this.adminPassword = string;
        }

        @Generated
        public String getComputerNamePrefix() {
            return this.computerNamePrefix;
        }

        @Generated
        public void setComputerNamePrefix(String string) {
            this.computerNamePrefix = string;
        }

        @Generated
        public String getCustomData() {
            return this.customData;
        }

        @Generated
        public void setCustomData(String string) {
            this.customData = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureOperatingSystemConfig.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureOperatingSystemConfig.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureInboundPortConfig
    implements GroovyObject {
        private String name;
        private String protocol;
        private int frontEndPortRangeStart;
        private int frontEndPortRangeEnd;
        private int backendPort;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureInboundPortConfig() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureInboundPortConfig.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureInboundPortConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureInboundPortConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureInboundPortConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureInboundPortConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureInboundPortConfig.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public void setProtocol(String string) {
            this.protocol = string;
        }

        @Generated
        public int getFrontEndPortRangeStart() {
            return this.frontEndPortRangeStart;
        }

        @Generated
        public void setFrontEndPortRangeStart(int n) {
            this.frontEndPortRangeStart = n;
        }

        @Generated
        public int getFrontEndPortRangeEnd() {
            return this.frontEndPortRangeEnd;
        }

        @Generated
        public void setFrontEndPortRangeEnd(int n) {
            this.frontEndPortRangeEnd = n;
        }

        @Generated
        public int getBackendPort() {
            return this.backendPort;
        }

        @Generated
        public void setBackendPort(int n) {
            this.backendPort = n;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureInboundPortConfig.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureInboundPortConfig.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureExtensionHealthSettings
    implements GroovyObject {
        private String protocol;
        private String port;
        private String requestPath;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureExtensionHealthSettings() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureExtensionHealthSettings.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureExtensionHealthSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureExtensionHealthSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureExtensionHealthSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureExtensionHealthSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureExtensionHealthSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public void setProtocol(String string) {
            this.protocol = string;
        }

        @Generated
        public String getPort() {
            return this.port;
        }

        @Generated
        public void setPort(String string) {
            this.port = string;
        }

        @Generated
        public String getRequestPath() {
            return this.requestPath;
        }

        @Generated
        public void setRequestPath(String string) {
            this.requestPath = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureExtensionHealthSettings.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureExtensionHealthSettings.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AzureExtensionCustomScriptSettings
    implements GroovyObject {
        private Collection<String> fileUris;
        private String commandToExecute;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AzureExtensionCustomScriptSettings() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureExtensionCustomScriptSettings.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureExtensionCustomScriptSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AzureExtensionCustomScriptSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureExtensionCustomScriptSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AzureExtensionCustomScriptSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AzureExtensionCustomScriptSettings.class, AzureServerGroupDescription.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Collection<String> getFileUris() {
            return this.fileUris;
        }

        @Generated
        public void setFileUris(Collection<String> collection) {
            this.fileUris = collection;
        }

        @Generated
        public String getCommandToExecute() {
            return this.commandToExecute;
        }

        @Generated
        public void setCommandToExecute(String string) {
            this.commandToExecute = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AzureExtensionCustomScriptSettings.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AzureExtensionCustomScriptSettings.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

