/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.servergroup.ops;

import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.cluster.view.AzureClusterProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureServerGroupDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.ResizeAzureServerGroupDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.springframework.beans.factory.annotation.Autowired;

public class ResizeAzureServerGroupAtomicOperation
implements AtomicOperation<Void> {
    private static final String BASE_PHASE = "RESIZE_SERVER_GROUP";
    private final ResizeAzureServerGroupDescription description;
    @Autowired
    private AzureClusterProvider azureClusterProvider;

    public AzureClusterProvider getAzureClusterProvider() {
        return this.azureClusterProvider;
    }

    public void setAzureClusterProvider(AzureClusterProvider azureClusterProvider) {
        this.azureClusterProvider = azureClusterProvider;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public ResizeAzureServerGroupAtomicOperation(ResizeAzureServerGroupDescription description) {
        this.description = description;
    }

    public Void operate(List priorOutputs) {
        ResizeAzureServerGroupAtomicOperation.getTask().updateStatus(BASE_PHASE, "Initializing Resize Azure Server Group Operation...");
        String region = this.description.getRegion();
        if (StringGroovyMethods.asBoolean((CharSequence)this.description.getServerGroupName())) {
            this.description.setName(this.description.getServerGroupName());
        }
        if (!StringGroovyMethods.asBoolean((CharSequence)this.description.getApplication())) {
            String name = this.description.getAppName();
            this.description.setApplication(StringGroovyMethods.asBoolean((CharSequence)name) ? name : Names.parseName((String)this.description.getName()).getApp());
        }
        int targetSize = this.description.getTargetSize() instanceof Number ? this.description.getTargetSize() : this.description.getCapacity().getDesired();
        ResizeAzureServerGroupAtomicOperation.getTask().updateStatus(BASE_PHASE, "Resizing server group " + this.description.getName() + " in " + region + " to target size " + String.valueOf(targetSize) + "...");
        if (!DefaultGroovyMethods.asBoolean((Object)this.description.getCredentials())) {
            throw new IllegalArgumentException("Unable to resolve credentials for the selected Azure account.");
        }
        ArrayList<Object> errList = new ArrayList<Object>();
        try {
            String resourceGroupName = AzureUtilities.getResourceGroupName(this.description.getApplication(), region);
            AzureServerGroupDescription serverGroupDescription = this.description.getCredentials().getComputeClient().getServerGroup(resourceGroupName, this.description.getName());
            if (!DefaultGroovyMethods.asBoolean((Object)serverGroupDescription)) {
                ResizeAzureServerGroupAtomicOperation.getTask().updateStatus(BASE_PHASE, "Resize Server Group Operation failed: could not find server group " + this.description.getName() + " in " + region);
                errList.add("could not find server group " + this.description.getName() + " in " + region);
            } else {
                try {
                    this.description.getCredentials().getComputeClient().resizeServerGroup(resourceGroupName, this.description.getName(), targetSize);
                    ResizeAzureServerGroupAtomicOperation.getTask().updateStatus(BASE_PHASE, "Done resizing Azure server group " + this.description.getName() + " in " + region + ".");
                }
                catch (Exception e) {
                    ResizeAzureServerGroupAtomicOperation.getTask().updateStatus(BASE_PHASE, "Resizing server group " + this.description.getName() + " failed: " + e.getMessage());
                    errList.add("Failed to resize server group " + this.description.getName() + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            ResizeAzureServerGroupAtomicOperation.getTask().updateStatus(BASE_PHASE, "Resizing server group " + this.description.getName() + " failed: " + e.getMessage());
            errList.add("Failed to resize server group " + this.description.getName() + ": " + e.getMessage());
        }
        if (!errList.isEmpty()) {
            errList.add(" Go to Azure Portal for more info");
            throw new AtomicOperationException("Failed to resize " + this.description.getName(), errList);
        }
        ResizeAzureServerGroupAtomicOperation.getTask().updateStatus(BASE_PHASE, "Resize Azure Server Group Operation for " + this.description.getName() + " succeeded.");
        return null;
    }
}

