/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.templates;

import com.azure.resourcemanager.compute.models.ResourceIdentityType;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetDataDisk;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.loadbalancer.model.AzureLoadBalancer;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureServerGroupDescription;
import com.netflix.spinnaker.clouddriver.azure.templates.DependingResource;
import com.netflix.spinnaker.clouddriver.azure.templates.IdRef;
import com.netflix.spinnaker.clouddriver.azure.templates.PublicIPPropertiesWithDns;
import com.netflix.spinnaker.clouddriver.azure.templates.PublicIpResource;
import com.netflix.spinnaker.clouddriver.azure.templates.Resource;
import com.netflix.spinnaker.clouddriver.azure.templates.SecureStringParameter;
import com.netflix.spinnaker.clouddriver.azure.templates.StringParameter;
import com.netflix.spinnaker.clouddriver.azure.templates.StringParameterWithDefault;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureServerGroupResourceTemplate
implements GroovyObject {
    private static final String STORAGE_ACCOUNT_SUFFIX = "sa";
    private static String LB_NAME;
    protected static ObjectMapper mapper;
    private static String subnetParameterName;
    private static String locationParameterName;
    private static String appGatewayAddressPoolParameterName;
    private static String loadBalancerAddressPoolParameterName;
    private static String loadBalancerNatPoolParameterName;
    private static String customDataParameterName;
    private static String vmUserNameParameterName;
    private static String vmPasswordParameterName;
    private static String vmSshPublicKeyParameterName;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AzureServerGroupResourceTemplate() {
        MetaClass metaClass;
        CallSite[] callSiteArray = AzureServerGroupResourceTemplate.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String getTemplate(AzureServerGroupDescription description) {
        CallSite[] callSiteArray = AzureServerGroupResourceTemplate.$getCallSiteArray();
        ServerGroupTemplate template = (ServerGroupTemplate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(ServerGroupTemplate.class, (Object)description), ServerGroupTemplate.class);
        return ShortTypeHandling.castToString((Object)callSiteArray[1].call((Object)mapper, (Object)template));
    }

    private static void initializeCommonVariables(AzureServerGroupDescription description) {
        CallSite[] callSiteArray = AzureServerGroupResourceTemplate.$getCallSiteArray();
        Object object = callSiteArray[2].call(callSiteArray[3].callGetProperty(AzureUtilities.class), callSiteArray[4].callGroovyObjectGetProperty((Object)description));
        LB_NAME = ShortTypeHandling.castToString((Object)object);
    }

    public static String getUniqueStorageName(String name, long idx) {
        CallSite[] callSiteArray = AzureServerGroupResourceTemplate.$getCallSiteArray();
        String noDashName = ShortTypeHandling.castToString((Object)callSiteArray[5].call(callSiteArray[6].call((Object)name, (Object)"-", (Object)"")));
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{noDashName, idx, STORAGE_ACCOUNT_SUFFIX}, new String[]{"[concat(uniqueString(concat(resourceGroup().id, subscription().id, '", "', '", "')), '", "')]"}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureServerGroupResourceTemplate.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = AzureServerGroupResourceTemplate.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureServerGroupResourceTemplate.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = AzureServerGroupResourceTemplate.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureServerGroupResourceTemplate.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = AzureServerGroupResourceTemplate.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureServerGroupResourceTemplate.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        vmSshPublicKeyParameterName = string9 = "vmSshPublicKey";
        vmPasswordParameterName = string8 = "vmPassword";
        vmUserNameParameterName = string7 = "vmUserName";
        customDataParameterName = string6 = "customData";
        loadBalancerNatPoolParameterName = string5 = "loadBalancerNatPoolId";
        loadBalancerAddressPoolParameterName = string4 = "loadBalancerAddressPoolId";
        appGatewayAddressPoolParameterName = string3 = "appGatewayAddressPoolId";
        locationParameterName = string2 = "location";
        subnetParameterName = string = "subnetId";
        Object var9_9 = null;
        LB_NAME = ShortTypeHandling.castToString(var9_9);
        Object object = AzureServerGroupResourceTemplate.$getCallSiteArray()[7].call(AzureServerGroupResourceTemplate.$getCallSiteArray()[8].call(AzureServerGroupResourceTemplate.$getCallSiteArray()[9].callConstructor(ObjectMapper.class), AzureServerGroupResourceTemplate.$getCallSiteArray()[10].callGetProperty(SerializationFeature.class), (Object)true), AzureServerGroupResourceTemplate.$getCallSiteArray()[11].callGetProperty(SerializationFeature.class), (Object)false);
        mapper = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
        Object object2 = AzureServerGroupResourceTemplate.$getCallSiteArray()[12].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.azure.templates.AzureServerGroupResourceTemplate");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object2, Logger.class);
    }

    @Generated
    public static String getSTORAGE_ACCOUNT_SUFFIX() {
        return STORAGE_ACCOUNT_SUFFIX;
    }

    @Generated
    public static String getLB_NAME() {
        return LB_NAME;
    }

    @Generated
    public static void setLB_NAME(String string) {
        LB_NAME = string;
    }

    @Generated
    public static String getSubnetParameterName() {
        return subnetParameterName;
    }

    @Generated
    public static void setSubnetParameterName(String string) {
        subnetParameterName = string;
    }

    @Generated
    public static String getLocationParameterName() {
        return locationParameterName;
    }

    @Generated
    public static void setLocationParameterName(String string) {
        locationParameterName = string;
    }

    @Generated
    public static String getAppGatewayAddressPoolParameterName() {
        return appGatewayAddressPoolParameterName;
    }

    @Generated
    public static void setAppGatewayAddressPoolParameterName(String string) {
        appGatewayAddressPoolParameterName = string;
    }

    @Generated
    public static String getLoadBalancerAddressPoolParameterName() {
        return loadBalancerAddressPoolParameterName;
    }

    @Generated
    public static void setLoadBalancerAddressPoolParameterName(String string) {
        loadBalancerAddressPoolParameterName = string;
    }

    @Generated
    public static String getLoadBalancerNatPoolParameterName() {
        return loadBalancerNatPoolParameterName;
    }

    @Generated
    public static void setLoadBalancerNatPoolParameterName(String string) {
        loadBalancerNatPoolParameterName = string;
    }

    @Generated
    public static String getCustomDataParameterName() {
        return customDataParameterName;
    }

    @Generated
    public static void setCustomDataParameterName(String string) {
        customDataParameterName = string;
    }

    @Generated
    public static String getVmUserNameParameterName() {
        return vmUserNameParameterName;
    }

    @Generated
    public static void setVmUserNameParameterName(String string) {
        vmUserNameParameterName = string;
    }

    @Generated
    public static String getVmPasswordParameterName() {
        return vmPasswordParameterName;
    }

    @Generated
    public static void setVmPasswordParameterName(String string) {
        vmPasswordParameterName = string;
    }

    @Generated
    public static String getVmSshPublicKeyParameterName() {
        return vmSshPublicKeyParameterName;
    }

    @Generated
    public static void setVmSshPublicKeyParameterName(String string) {
        vmSshPublicKeyParameterName = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "writeValueAsString";
        stringArray[2] = "plus";
        stringArray[3] = "LB_NAME_PREFIX";
        stringArray[4] = "name";
        stringArray[5] = "toLowerCase";
        stringArray[6] = "replaceAll";
        stringArray[7] = "configure";
        stringArray[8] = "configure";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "INDENT_OUTPUT";
        stringArray[11] = "FAIL_ON_EMPTY_BEANS";
        stringArray[12] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[13];
        AzureServerGroupResourceTemplate.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AzureServerGroupResourceTemplate.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AzureServerGroupResourceTemplate.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class ServerGroupTemplate
    implements GroovyObject {
        private String $schema;
        private String contentVersion;
        private ServerGroupTemplateParameters parameters;
        private TemplateVariables variables;
        private ArrayList<Resource> resources;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ServerGroupTemplate(AzureServerGroupDescription description) {
            MetaClass metaClass;
            String string;
            String string2;
            CallSite[] callSiteArray = ServerGroupTemplate.$getCallSiteArray();
            this.$schema = string2 = "https://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#";
            this.contentVersion = string = "1.0.0.0";
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.resources = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list, ArrayList.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)description))) {
                callSiteArray[1].callCurrent((GroovyObject)this, (Object)description);
                callSiteArray[2].call(this.resources, callSiteArray[3].callConstructor(PublicIpResource.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"properties", callSiteArray[4].callConstructor(PublicIPPropertiesWithDns.class)})));
                callSiteArray[5].call(this.resources, callSiteArray[6].callConstructor(LoadBalancer.class, (Object)description));
            }
            Object object = callSiteArray[7].callConstructor(ServerGroupTemplateParameters.class);
            this.parameters = (ServerGroupTemplateParameters)ScriptBytecodeAdapter.castToType((Object)object, ServerGroupTemplateParameters.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGetProperty(callSiteArray[9].callGroovyObjectGetProperty((Object)description)))) {
                Object object2 = callSiteArray[10].callConstructor(CoreServerGroupTemplateVariables.class, (Object)description);
                this.variables = (TemplateVariables)ScriptBytecodeAdapter.castToType((Object)object2, TemplateVariables.class);
            } else {
                Object object3 = callSiteArray[11].callConstructor(ExtendedServerGroupTemplateVariables.class, (Object)description);
                this.variables = (TemplateVariables)ScriptBytecodeAdapter.castToType((Object)object3, TemplateVariables.class);
                callSiteArray[12].call(this.resources, callSiteArray[13].callConstructor(StorageAccount.class, (Object)description));
            }
            callSiteArray[14].call(this.resources, callSiteArray[15].callConstructor(VirtualMachineScaleSet.class, (Object)description));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ServerGroupTemplate.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ServerGroupTemplate.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ServerGroupTemplate.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ServerGroupTemplate.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ServerGroupTemplate.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ServerGroupTemplate.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ServerGroupTemplate.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ServerGroupTemplate.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ServerGroupTemplate.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ServerGroupTemplate.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ServerGroupTemplate.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String get$schema() {
            return this.$schema;
        }

        @Generated
        public void set$schema(String string) {
            this.$schema = string;
        }

        @Generated
        public String getContentVersion() {
            return this.contentVersion;
        }

        @Generated
        public void setContentVersion(String string) {
            this.contentVersion = string;
        }

        @Generated
        public ServerGroupTemplateParameters getParameters() {
            return this.parameters;
        }

        @Generated
        public void setParameters(ServerGroupTemplateParameters serverGroupTemplateParameters) {
            this.parameters = serverGroupTemplateParameters;
        }

        @Generated
        public TemplateVariables getVariables() {
            return this.variables;
        }

        @Generated
        public void setVariables(TemplateVariables templateVariables) {
            this.variables = templateVariables;
        }

        @Generated
        public ArrayList<Resource> getResources() {
            return this.resources;
        }

        @Generated
        public void setResources(ArrayList<Resource> arrayList) {
            this.resources = arrayList;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "enableInboundNAT";
            stringArray[1] = "initializeCommonVariables";
            stringArray[2] = "add";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "<$constructor$>";
            stringArray[5] = "add";
            stringArray[6] = "<$constructor$>";
            stringArray[7] = "<$constructor$>";
            stringArray[8] = "isCustom";
            stringArray[9] = "image";
            stringArray[10] = "<$constructor$>";
            stringArray[11] = "<$constructor$>";
            stringArray[12] = "add";
            stringArray[13] = "<$constructor$>";
            stringArray[14] = "add";
            stringArray[15] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[16];
            ServerGroupTemplate.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ServerGroupTemplate.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ServerGroupTemplate.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public interface TemplateVariables {
    }

    public static class CoreServerGroupTemplateVariables
    implements TemplateVariables,
    GroovyObject {
        private final String apiVersion;
        private String publicIPAddressName;
        private String publicIPAddressID;
        private String publicIPAddressType;
        private String dnsNameForLBIP;
        private String loadBalancerBackend;
        private String loadBalancerFrontEnd;
        private String loadBalancerName;
        private String loadBalancerID;
        private String frontEndIPConfigID;
        private String inboundNatPoolName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CoreServerGroupTemplateVariables() {
            MetaClass metaClass;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            CallSite[] callSiteArray = CoreServerGroupTemplateVariables.$getCallSiteArray();
            this.apiVersion = string11 = "2019-03-01";
            this.publicIPAddressName = string10 = "";
            this.publicIPAddressID = string9 = "";
            this.publicIPAddressType = string8 = "";
            this.dnsNameForLBIP = string7 = "";
            this.loadBalancerBackend = string6 = "";
            this.loadBalancerFrontEnd = string5 = "";
            this.loadBalancerName = string4 = "";
            this.loadBalancerID = string3 = "";
            this.frontEndIPConfigID = string2 = "";
            this.inboundNatPoolName = string = "";
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public CoreServerGroupTemplateVariables(AzureServerGroupDescription description) {
            MetaClass metaClass;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            CallSite[] callSiteArray = CoreServerGroupTemplateVariables.$getCallSiteArray();
            this.apiVersion = string11 = "2019-03-01";
            this.publicIPAddressName = string10 = "";
            this.publicIPAddressID = string9 = "";
            this.publicIPAddressType = string8 = "";
            this.dnsNameForLBIP = string7 = "";
            this.loadBalancerBackend = string6 = "";
            this.loadBalancerFrontEnd = string5 = "";
            this.loadBalancerName = string4 = "";
            this.loadBalancerID = string3 = "";
            this.frontEndIPConfigID = string2 = "";
            this.inboundNatPoolName = string = "";
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)description))) {
                String string12;
                String string13;
                String string14;
                String string15;
                Object object = callSiteArray[1].call(callSiteArray[2].callGetProperty(AzureUtilities.class), callSiteArray[3].callGroovyObjectGetProperty((Object)description));
                this.publicIPAddressName = ShortTypeHandling.castToString((Object)object);
                this.publicIPAddressID = string15 = "[resourceId('Microsoft.Network/publicIPAddresses', variables('publicIPAddressName'))]";
                this.publicIPAddressType = string14 = "Dynamic";
                Object object2 = callSiteArray[4].call(callSiteArray[5].callGetProperty(AzureUtilities.class), callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)description)));
                this.dnsNameForLBIP = ShortTypeHandling.castToString((Object)object2);
                this.frontEndIPConfigID = string13 = "[resourceId('Microsoft.Network/loadBalancers/frontendIPConfigurations/', variables('loadBalancerName'), variables('loadBalancerFrontEnd'))]";
                Object object3 = callSiteArray[8].call(callSiteArray[9].callGetProperty(AzureUtilities.class), callSiteArray[10].callGroovyObjectGetProperty((Object)description));
                this.loadBalancerFrontEnd = ShortTypeHandling.castToString((Object)object3);
                Object object4 = callSiteArray[11].call(callSiteArray[12].callGetProperty(AzureUtilities.class), callSiteArray[13].callGroovyObjectGetProperty((Object)description));
                this.loadBalancerBackend = ShortTypeHandling.castToString((Object)object4);
                Object object5 = ScriptBytecodeAdapter.getField(CoreServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)"LB_NAME");
                this.loadBalancerName = ShortTypeHandling.castToString((Object)object5);
                this.loadBalancerID = string12 = "[resourceId('Microsoft.Network/loadBalancers', variables('loadBalancerName'))]";
                Object object6 = callSiteArray[14].call(callSiteArray[15].callGetProperty(AzureUtilities.class), callSiteArray[16].callGroovyObjectGetProperty((Object)description));
                this.inboundNatPoolName = ShortTypeHandling.castToString((Object)object6);
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CoreServerGroupTemplateVariables.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CoreServerGroupTemplateVariables.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CoreServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CoreServerGroupTemplateVariables.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CoreServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CoreServerGroupTemplateVariables.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CoreServerGroupTemplateVariables.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = CoreServerGroupTemplateVariables.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CoreServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = CoreServerGroupTemplateVariables.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CoreServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public final String getApiVersion() {
            return this.apiVersion;
        }

        @Generated
        public String getPublicIPAddressName() {
            return this.publicIPAddressName;
        }

        @Generated
        public void setPublicIPAddressName(String string) {
            this.publicIPAddressName = string;
        }

        @Generated
        public String getPublicIPAddressID() {
            return this.publicIPAddressID;
        }

        @Generated
        public void setPublicIPAddressID(String string) {
            this.publicIPAddressID = string;
        }

        @Generated
        public String getPublicIPAddressType() {
            return this.publicIPAddressType;
        }

        @Generated
        public void setPublicIPAddressType(String string) {
            this.publicIPAddressType = string;
        }

        @Generated
        public String getDnsNameForLBIP() {
            return this.dnsNameForLBIP;
        }

        @Generated
        public void setDnsNameForLBIP(String string) {
            this.dnsNameForLBIP = string;
        }

        @Generated
        public String getLoadBalancerBackend() {
            return this.loadBalancerBackend;
        }

        @Generated
        public void setLoadBalancerBackend(String string) {
            this.loadBalancerBackend = string;
        }

        @Generated
        public String getLoadBalancerFrontEnd() {
            return this.loadBalancerFrontEnd;
        }

        @Generated
        public void setLoadBalancerFrontEnd(String string) {
            this.loadBalancerFrontEnd = string;
        }

        @Generated
        public String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Generated
        public void setLoadBalancerName(String string) {
            this.loadBalancerName = string;
        }

        @Generated
        public String getLoadBalancerID() {
            return this.loadBalancerID;
        }

        @Generated
        public void setLoadBalancerID(String string) {
            this.loadBalancerID = string;
        }

        @Generated
        public String getFrontEndIPConfigID() {
            return this.frontEndIPConfigID;
        }

        @Generated
        public void setFrontEndIPConfigID(String string) {
            this.frontEndIPConfigID = string;
        }

        @Generated
        public String getInboundNatPoolName() {
            return this.inboundNatPoolName;
        }

        @Generated
        public void setInboundNatPoolName(String string) {
            this.inboundNatPoolName = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "enableInboundNAT";
            stringArray[1] = "plus";
            stringArray[2] = "PUBLICIP_NAME_PREFIX";
            stringArray[3] = "name";
            stringArray[4] = "plus";
            stringArray[5] = "DNS_NAME_PREFIX";
            stringArray[6] = "toLowerCase";
            stringArray[7] = "name";
            stringArray[8] = "plus";
            stringArray[9] = "LBFRONTEND_NAME_PREFIX";
            stringArray[10] = "name";
            stringArray[11] = "plus";
            stringArray[12] = "LBBACKEND_NAME_PREFIX";
            stringArray[13] = "name";
            stringArray[14] = "plus";
            stringArray[15] = "INBOUND_NATPOOL_PREFIX";
            stringArray[16] = "name";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[17];
            CoreServerGroupTemplateVariables.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(CoreServerGroupTemplateVariables.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CoreServerGroupTemplateVariables.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ExtendedServerGroupTemplateVariables
    extends CoreServerGroupTemplateVariables
    implements TemplateVariables {
        private static transient String uniqueStorageNamesArrayVar;
        private static transient String vhdContainerNameVar;
        private String vhdContainerName;
        private OsType osType;
        private String imageReference;
        private ArrayList<String> uniqueStorageNameArray;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ExtendedServerGroupTemplateVariables(AzureServerGroupDescription description) {
            String string;
            MetaClass metaClass;
            CallSite[] callSiteArray = ExtendedServerGroupTemplateVariables.$getCallSiteArray();
            super(description);
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.uniqueStorageNameArray = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list, ArrayList.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            this.vhdContainerName = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[2].callConstructor(OsType.class, (Object)description);
            this.osType = (OsType)ScriptBytecodeAdapter.castToType((Object)object2, OsType.class);
            this.imageReference = string = "[variables('osType')]";
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass()) {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[3].call((Object)description))) {
                    callSiteArray[4].call(this.uniqueStorageNameArray, callSiteArray[5].callCurrent((GroovyObject)this, callSiteArray[6].callGroovyObjectGetProperty((Object)description), (Object)i));
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[7].call((Object)n));
                }
            } else {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[8].call((Object)description))) {
                    callSiteArray[9].call(this.uniqueStorageNameArray, callSiteArray[10].callCurrent((GroovyObject)this, callSiteArray[11].callGroovyObjectGetProperty((Object)description), (Object)i));
                    int n = i;
                    int cfr_ignored_0 = n + 1;
                }
            }
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ExtendedServerGroupTemplateVariables.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ExtendedServerGroupTemplateVariables.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ExtendedServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ExtendedServerGroupTemplateVariables.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ExtendedServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        @Override
        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ExtendedServerGroupTemplateVariables.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ExtendedServerGroupTemplateVariables.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ExtendedServerGroupTemplateVariables.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ExtendedServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ExtendedServerGroupTemplateVariables.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ExtendedServerGroupTemplateVariables.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        static {
            String string;
            String string2;
            vhdContainerNameVar = string2 = "vhdContainerName";
            uniqueStorageNamesArrayVar = string = "uniqueStorageNameArray";
        }

        @Generated
        public static String getUniqueStorageNamesArrayVar() {
            return uniqueStorageNamesArrayVar;
        }

        @Generated
        public static void setUniqueStorageNamesArrayVar(String string) {
            uniqueStorageNamesArrayVar = string;
        }

        @Generated
        public static String getVhdContainerNameVar() {
            return vhdContainerNameVar;
        }

        @Generated
        public static void setVhdContainerNameVar(String string) {
            vhdContainerNameVar = string;
        }

        @Generated
        public String getVhdContainerName() {
            return this.vhdContainerName;
        }

        @Generated
        public void setVhdContainerName(String string) {
            this.vhdContainerName = string;
        }

        @Generated
        public OsType getOsType() {
            return this.osType;
        }

        @Generated
        public void setOsType(OsType osType) {
            this.osType = osType;
        }

        @Generated
        public String getImageReference() {
            return this.imageReference;
        }

        @Generated
        public void setImageReference(String string) {
            this.imageReference = string;
        }

        @Generated
        public ArrayList<String> getUniqueStorageNameArray() {
            return this.uniqueStorageNameArray;
        }

        @Generated
        public void setUniqueStorageNameArray(ArrayList<String> arrayList) {
            this.uniqueStorageNameArray = arrayList;
        }

        public /* synthetic */ Object super$2$propertyMissing(String string) {
            return super.propertyMissing(string);
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        public /* synthetic */ Object super$2$methodMissing(String string, Object object) {
            return super.methodMissing(string, object);
        }

        public /* synthetic */ void super$2$propertyMissing(String string, Object object) {
            super.propertyMissing(string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "toLowerCase";
            stringArray[1] = "name";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "getStorageAccountCount";
            stringArray[4] = "add";
            stringArray[5] = "getUniqueStorageName";
            stringArray[6] = "name";
            stringArray[7] = "next";
            stringArray[8] = "getStorageAccountCount";
            stringArray[9] = "add";
            stringArray[10] = "getUniqueStorageName";
            stringArray[11] = "name";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[12];
            ExtendedServerGroupTemplateVariables.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ExtendedServerGroupTemplateVariables.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ExtendedServerGroupTemplateVariables.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ServerGroupTemplateParameters
    implements GroovyObject {
        private LocationParameter location;
        private SubnetParameter subnetId;
        private AppGatewayAddressPoolParameter appGatewayAddressPoolId;
        private VMUserNameParameter vmUserName;
        private VMPasswordParameter vmPassword;
        private VMSshPublicKeyParameter vmSshPublicKey;
        private LoadBalancerPoolParameter loadBalancerAddressPoolId;
        private LoadBalancerNatPoolParameter loadBalancerNatPoolId;
        private CustomDataParameter customData;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public ServerGroupTemplateParameters() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ServerGroupTemplateParameters.$getCallSiteArray();
            Object object = callSiteArray[0].callConstructor(LocationParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "Location to deploy"}));
            this.location = (LocationParameter)ScriptBytecodeAdapter.castToType((Object)object, LocationParameter.class);
            Object object2 = callSiteArray[1].callConstructor(SubnetParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "Subnet Resource ID"}), (Object)"");
            this.subnetId = (SubnetParameter)ScriptBytecodeAdapter.castToType((Object)object2, SubnetParameter.class);
            Object object3 = callSiteArray[2].callConstructor(AppGatewayAddressPoolParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "App Gateway backend address pool resource ID"}), (Object)"");
            this.appGatewayAddressPoolId = (AppGatewayAddressPoolParameter)ScriptBytecodeAdapter.castToType((Object)object3, AppGatewayAddressPoolParameter.class);
            Object object4 = callSiteArray[3].callConstructor(VMUserNameParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "Admin username on all VMs"}), (Object)"");
            this.vmUserName = (VMUserNameParameter)ScriptBytecodeAdapter.castToType((Object)object4, VMUserNameParameter.class);
            Object object5 = callSiteArray[4].callConstructor(VMPasswordParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "Admin password on all VMs"}), (Object)"");
            this.vmPassword = (VMPasswordParameter)ScriptBytecodeAdapter.castToType((Object)object5, VMPasswordParameter.class);
            Object object6 = callSiteArray[5].callConstructor(VMSshPublicKeyParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "SSH public key on all VMs"}), (Object)"");
            this.vmSshPublicKey = (VMSshPublicKeyParameter)ScriptBytecodeAdapter.castToType((Object)object6, VMSshPublicKeyParameter.class);
            Object object7 = callSiteArray[6].callConstructor(LoadBalancerPoolParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "Load balancer pool ID"}), (Object)"");
            this.loadBalancerAddressPoolId = (LoadBalancerPoolParameter)ScriptBytecodeAdapter.castToType((Object)object7, LoadBalancerPoolParameter.class);
            Object object8 = callSiteArray[7].callConstructor(LoadBalancerNatPoolParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "Load balancer NAT pool ID"}), (Object)"");
            this.loadBalancerNatPoolId = (LoadBalancerNatPoolParameter)ScriptBytecodeAdapter.castToType((Object)object8, LoadBalancerNatPoolParameter.class);
            Object object9 = callSiteArray[8].callConstructor(CustomDataParameter.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"description", "custom data to pass down to the virtual machine(s)"}), (Object)"sample custom data");
            this.customData = (CustomDataParameter)ScriptBytecodeAdapter.castToType((Object)object9, CustomDataParameter.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ServerGroupTemplateParameters.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ServerGroupTemplateParameters.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ServerGroupTemplateParameters.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ServerGroupTemplateParameters.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ServerGroupTemplateParameters.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ServerGroupTemplateParameters.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ServerGroupTemplateParameters.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ServerGroupTemplateParameters.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ServerGroupTemplateParameters.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ServerGroupTemplateParameters.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ServerGroupTemplateParameters.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public LocationParameter getLocation() {
            return this.location;
        }

        @Generated
        public void setLocation(LocationParameter locationParameter) {
            this.location = locationParameter;
        }

        @Generated
        public SubnetParameter getSubnetId() {
            return this.subnetId;
        }

        @Generated
        public void setSubnetId(SubnetParameter subnetParameter) {
            this.subnetId = subnetParameter;
        }

        @Generated
        public AppGatewayAddressPoolParameter getAppGatewayAddressPoolId() {
            return this.appGatewayAddressPoolId;
        }

        @Generated
        public void setAppGatewayAddressPoolId(AppGatewayAddressPoolParameter appGatewayAddressPoolParameter) {
            this.appGatewayAddressPoolId = appGatewayAddressPoolParameter;
        }

        @Generated
        public VMUserNameParameter getVmUserName() {
            return this.vmUserName;
        }

        @Generated
        public void setVmUserName(VMUserNameParameter vMUserNameParameter) {
            this.vmUserName = vMUserNameParameter;
        }

        @Generated
        public VMPasswordParameter getVmPassword() {
            return this.vmPassword;
        }

        @Generated
        public void setVmPassword(VMPasswordParameter vMPasswordParameter) {
            this.vmPassword = vMPasswordParameter;
        }

        @Generated
        public VMSshPublicKeyParameter getVmSshPublicKey() {
            return this.vmSshPublicKey;
        }

        @Generated
        public void setVmSshPublicKey(VMSshPublicKeyParameter vMSshPublicKeyParameter) {
            this.vmSshPublicKey = vMSshPublicKeyParameter;
        }

        @Generated
        public LoadBalancerPoolParameter getLoadBalancerAddressPoolId() {
            return this.loadBalancerAddressPoolId;
        }

        @Generated
        public void setLoadBalancerAddressPoolId(LoadBalancerPoolParameter loadBalancerPoolParameter) {
            this.loadBalancerAddressPoolId = loadBalancerPoolParameter;
        }

        @Generated
        public LoadBalancerNatPoolParameter getLoadBalancerNatPoolId() {
            return this.loadBalancerNatPoolId;
        }

        @Generated
        public void setLoadBalancerNatPoolId(LoadBalancerNatPoolParameter loadBalancerNatPoolParameter) {
            this.loadBalancerNatPoolId = loadBalancerNatPoolParameter;
        }

        @Generated
        public CustomDataParameter getCustomData() {
            return this.customData;
        }

        @Generated
        public void setCustomData(CustomDataParameter customDataParameter) {
            this.customData = customDataParameter;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "<$constructor$>";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "<$constructor$>";
            stringArray[5] = "<$constructor$>";
            stringArray[6] = "<$constructor$>";
            stringArray[7] = "<$constructor$>";
            stringArray[8] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[9];
            ServerGroupTemplateParameters.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ServerGroupTemplateParameters.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ServerGroupTemplateParameters.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class SubnetParameter
    extends StringParameterWithDefault {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public SubnetParameter(Map<String, String> metadata, String defaultValue) {
            MetaClass metaClass;
            CallSite[] callSiteArray = SubnetParameter.$getCallSiteArray();
            super(metadata, defaultValue);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SubnetParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = SubnetParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(SubnetParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = SubnetParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(SubnetParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = SubnetParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = SubnetParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = SubnetParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(SubnetParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = SubnetParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(SubnetParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(SubnetParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = SubnetParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class LocationParameter
    extends StringParameter {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LocationParameter(Map<String, String> metadata) {
            MetaClass metaClass;
            CallSite[] callSiteArray = LocationParameter.$getCallSiteArray();
            super(metadata);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LocationParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LocationParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LocationParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LocationParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LocationParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LocationParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LocationParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = LocationParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LocationParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = LocationParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LocationParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(LocationParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LocationParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AppGatewayAddressPoolParameter
    extends StringParameterWithDefault {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public AppGatewayAddressPoolParameter(Map<String, String> metadata, String defaultValue) {
            MetaClass metaClass;
            CallSite[] callSiteArray = AppGatewayAddressPoolParameter.$getCallSiteArray();
            super(metadata, defaultValue);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AppGatewayAddressPoolParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AppGatewayAddressPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AppGatewayAddressPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AppGatewayAddressPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AppGatewayAddressPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AppGatewayAddressPoolParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AppGatewayAddressPoolParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AppGatewayAddressPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AppGatewayAddressPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AppGatewayAddressPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AppGatewayAddressPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AppGatewayAddressPoolParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AppGatewayAddressPoolParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class LoadBalancerPoolParameter
    extends StringParameterWithDefault {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LoadBalancerPoolParameter(Map<String, String> metadata, String defaultValue) {
            MetaClass metaClass;
            CallSite[] callSiteArray = LoadBalancerPoolParameter.$getCallSiteArray();
            super(metadata, defaultValue);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LoadBalancerPoolParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerPoolParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerPoolParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(LoadBalancerPoolParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LoadBalancerPoolParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class LoadBalancerNatPoolParameter
    extends StringParameterWithDefault {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LoadBalancerNatPoolParameter(Map<String, String> metadata, String defaultValue) {
            MetaClass metaClass;
            CallSite[] callSiteArray = LoadBalancerNatPoolParameter.$getCallSiteArray();
            super(metadata, defaultValue);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LoadBalancerNatPoolParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerNatPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerNatPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerNatPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerNatPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerNatPoolParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerNatPoolParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerNatPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerNatPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerNatPoolParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerNatPoolParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(LoadBalancerNatPoolParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LoadBalancerNatPoolParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class CustomDataParameter
    extends StringParameterWithDefault {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CustomDataParameter(Map<String, String> metadata, String defValue) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CustomDataParameter.$getCallSiteArray();
            super(metadata, defValue);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CustomDataParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CustomDataParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CustomDataParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CustomDataParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CustomDataParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CustomDataParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CustomDataParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = CustomDataParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CustomDataParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = CustomDataParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CustomDataParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(CustomDataParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CustomDataParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class VMUserNameParameter
    extends SecureStringParameter {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VMUserNameParameter(Map<String, String> metadata, String defaultValue) {
            MetaClass metaClass;
            CallSite[] callSiteArray = VMUserNameParameter.$getCallSiteArray();
            super(metadata, defaultValue);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != VMUserNameParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VMUserNameParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VMUserNameParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VMUserNameParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VMUserNameParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VMUserNameParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VMUserNameParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = VMUserNameParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VMUserNameParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = VMUserNameParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VMUserNameParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(VMUserNameParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VMUserNameParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class VMPasswordParameter
    extends SecureStringParameter {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VMPasswordParameter(Map<String, String> metadata, String defaultValue) {
            MetaClass metaClass;
            CallSite[] callSiteArray = VMPasswordParameter.$getCallSiteArray();
            super(metadata, defaultValue);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != VMPasswordParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VMPasswordParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VMPasswordParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VMPasswordParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VMPasswordParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VMPasswordParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VMPasswordParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = VMPasswordParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VMPasswordParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = VMPasswordParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VMPasswordParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(VMPasswordParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VMPasswordParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class VMSshPublicKeyParameter
    extends SecureStringParameter {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VMSshPublicKeyParameter(Map<String, String> metadata, String defaultValue) {
            MetaClass metaClass;
            CallSite[] callSiteArray = VMSshPublicKeyParameter.$getCallSiteArray();
            super(metadata, defaultValue);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != VMSshPublicKeyParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VMSshPublicKeyParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VMSshPublicKeyParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VMSshPublicKeyParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VMSshPublicKeyParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VMSshPublicKeyParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VMSshPublicKeyParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = VMSshPublicKeyParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VMSshPublicKeyParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = VMSshPublicKeyParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VMSshPublicKeyParameter.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(VMSshPublicKeyParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VMSshPublicKeyParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class OsType
    implements GroovyObject {
        private String publisher;
        private String offer;
        private String sku;
        private String version;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public OsType(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = OsType.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            this.publisher = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)description));
            this.offer = ShortTypeHandling.castToString((Object)object2);
            Object object3 = callSiteArray[4].callGetProperty(callSiteArray[5].callGroovyObjectGetProperty((Object)description));
            this.sku = ShortTypeHandling.castToString((Object)object3);
            Object object4 = callSiteArray[6].callGetProperty(callSiteArray[7].callGroovyObjectGetProperty((Object)description));
            this.version = ShortTypeHandling.castToString((Object)object4);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OsType.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = OsType.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(OsType.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = OsType.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(OsType.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = OsType.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = OsType.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = OsType.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(OsType.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = OsType.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(OsType.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getPublisher() {
            return this.publisher;
        }

        @Generated
        public void setPublisher(String string) {
            this.publisher = string;
        }

        @Generated
        public String getOffer() {
            return this.offer;
        }

        @Generated
        public void setOffer(String string) {
            this.offer = string;
        }

        @Generated
        public String getSku() {
            return this.sku;
        }

        @Generated
        public void setSku(String string) {
            this.sku = string;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public void setVersion(String string) {
            this.version = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "publisher";
            stringArray[1] = "image";
            stringArray[2] = "offer";
            stringArray[3] = "image";
            stringArray[4] = "sku";
            stringArray[5] = "image";
            stringArray[6] = "version";
            stringArray[7] = "image";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[8];
            OsType.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(OsType.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = OsType.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class StorageAccount
    extends Resource {
        private CopyOperation copy;
        private StorageAccountProperties properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public StorageAccount(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = StorageAccount.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = "[variables('apiVersion')]";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, StorageAccount.class, (GroovyObject)this, (String)"apiVersion");
            Object object = callSiteArray[0].call(String.class, (Object)"[concat(variables('%s')[copyIndex()])]", callSiteArray[1].callGetProperty(ExtendedServerGroupTemplateVariables.class));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, StorageAccount.class, (GroovyObject)this, (String)"name");
            String string2 = "Microsoft.Storage/storageAccounts";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, StorageAccount.class, (GroovyObject)this, (String)"type");
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(StorageAccount.class, AzureServerGroupResourceTemplate.class, (String)"locationParameterName")}, new String[]{"[parameters('", "')]"});
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, StorageAccount.class, (GroovyObject)this, (String)"location");
            Object currentTime = callSiteArray[2].call(System.class);
            Object object2 = callSiteArray[3].callConstructor(CopyOperation.class, (Object)"storageLoop", callSiteArray[4].call((Object)description));
            this.copy = (CopyOperation)ScriptBytecodeAdapter.castToType((Object)object2, CopyOperation.class);
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, StorageAccount.class, (GroovyObject)this, (String)"tags");
            Object object3 = callSiteArray[5].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)callSiteArray[6].callGroovyObjectGetProperty((Object)this), (String)"appName");
            Object object4 = callSiteArray[7].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)callSiteArray[8].callGroovyObjectGetProperty((Object)this), (String)"stack");
            Object object5 = callSiteArray[9].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)callSiteArray[10].callGroovyObjectGetProperty((Object)this), (String)"detail");
            Object object6 = callSiteArray[11].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)callSiteArray[12].callGroovyObjectGetProperty((Object)this), (String)"cluster");
            Object object7 = callSiteArray[13].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object7, null, (Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this), (String)"serverGroupName");
            Object object8 = callSiteArray[15].call(currentTime);
            ScriptBytecodeAdapter.setProperty((Object)object8, null, (Object)callSiteArray[16].callGroovyObjectGetProperty((Object)this), (String)"createdTime");
            Object object9 = callSiteArray[17].callConstructor(StorageAccountProperties.class);
            this.properties = (StorageAccountProperties)ScriptBytecodeAdapter.castToType((Object)object9, StorageAccountProperties.class);
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StorageAccount.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = StorageAccount.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(StorageAccount.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = StorageAccount.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(StorageAccount.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = StorageAccount.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = StorageAccount.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = StorageAccount.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(StorageAccount.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = StorageAccount.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(StorageAccount.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public CopyOperation getCopy() {
            return this.copy;
        }

        @Generated
        public void setCopy(CopyOperation copyOperation) {
            this.copy = copyOperation;
        }

        @Generated
        public StorageAccountProperties getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(StorageAccountProperties storageAccountProperties) {
            this.properties = storageAccountProperties;
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "format";
            stringArray[1] = "uniqueStorageNamesArrayVar";
            stringArray[2] = "currentTimeMillis";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "getStorageAccountCount";
            stringArray[5] = "application";
            stringArray[6] = "tags";
            stringArray[7] = "stack";
            stringArray[8] = "tags";
            stringArray[9] = "detail";
            stringArray[10] = "tags";
            stringArray[11] = "clusterName";
            stringArray[12] = "tags";
            stringArray[13] = "name";
            stringArray[14] = "tags";
            stringArray[15] = "toString";
            stringArray[16] = "tags";
            stringArray[17] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[18];
            StorageAccount.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(StorageAccount.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = StorageAccount.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class StorageAccountProperties
    implements GroovyObject {
        private String accountType;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public StorageAccountProperties() {
            String string;
            MetaClass metaClass;
            CallSite[] callSiteArray = StorageAccountProperties.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.accountType = string = "Premium_LRS";
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StorageAccountProperties.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = StorageAccountProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(StorageAccountProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = StorageAccountProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(StorageAccountProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = StorageAccountProperties.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = StorageAccountProperties.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = StorageAccountProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(StorageAccountProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = StorageAccountProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(StorageAccountProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getAccountType() {
            return this.accountType;
        }

        @Generated
        public void setAccountType(String string) {
            this.accountType = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(StorageAccountProperties.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = StorageAccountProperties.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class CopyOperation
    implements GroovyObject {
        private String name;
        private int count;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CopyOperation(String operationName, int iterations) {
            int n;
            String string;
            MetaClass metaClass;
            CallSite[] callSiteArray = CopyOperation.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.name = string = operationName;
            this.count = n = iterations;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CopyOperation.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CopyOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CopyOperation.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CopyOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CopyOperation.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CopyOperation.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CopyOperation.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = CopyOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CopyOperation.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = CopyOperation.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CopyOperation.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public void setCount(int n) {
            this.count = n;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(CopyOperation.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CopyOperation.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class VirtualMachineScaleSet
    extends DependingResource {
        private ScaleSetSkuProperty sku;
        private VirtualMachineScaleSetProperty properties;
        private ManagedIdentity identity;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private List<String> zones;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VirtualMachineScaleSet(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = VirtualMachineScaleSet.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = "[variables('apiVersion')]";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, VirtualMachineScaleSet.class, (GroovyObject)this, (String)"apiVersion");
            Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, VirtualMachineScaleSet.class, (GroovyObject)this, (String)"name");
            String string2 = "Microsoft.Compute/virtualMachineScaleSets";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, VirtualMachineScaleSet.class, (GroovyObject)this, (String)"type");
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(VirtualMachineScaleSet.class, AzureServerGroupResourceTemplate.class, (String)"locationParameterName")}, new String[]{"[parameters('", "')]"});
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, VirtualMachineScaleSet.class, (GroovyObject)this, (String)"location");
            String userAssignedIdentities = ShortTypeHandling.castToString((Object)callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callSafe((Object)userAssignedIdentities))) {
                Object object2 = callSiteArray[3].callConstructor(ManagedIdentity.class, callSiteArray[4].callGroovyObjectGetProperty((Object)description));
                this.identity = (ManagedIdentity)ScriptBytecodeAdapter.castToType((Object)object2, ManagedIdentity.class);
            } else {
                Object object3 = callSiteArray[5].callConstructor(UserAndOptionalSystemAssignedIdentity.class, callSiteArray[6].callGroovyObjectGetProperty((Object)description), (Object)userAssignedIdentities);
                this.identity = (ManagedIdentity)ScriptBytecodeAdapter.castToType((Object)object3, ManagedIdentity.class);
            }
            Object currentTime = callSiteArray[7].call(System.class);
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, VirtualMachineScaleSet.class, (GroovyObject)this, (String)"tags");
            Object object4 = callSiteArray[8].call(currentTime);
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)callSiteArray[9].callGroovyObjectGetProperty((Object)this), (String)"createdTime");
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callGroovyObjectGetProperty((Object)description))) {
                Object object5 = callSiteArray[11].callGroovyObjectGetProperty((Object)description);
                ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)callSiteArray[12].callGroovyObjectGetProperty((Object)this), (String)"subnetId");
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callGroovyObjectGetProperty((Object)description))) {
                Object object6 = callSiteArray[14].callGroovyObjectGetProperty((Object)description);
                ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)callSiteArray[15].callGroovyObjectGetProperty((Object)this), (String)"securityGroupName");
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[16].callGroovyObjectGetProperty((Object)description), null)) {
                callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)this), callSiteArray[19].callGroovyObjectGetProperty((Object)description));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callGroovyObjectGetProperty((Object)description))) {
                Object object7 = callSiteArray[21].callGroovyObjectGetProperty((Object)description);
                ScriptBytecodeAdapter.setProperty((Object)object7, null, (Object)callSiteArray[22].callGroovyObjectGetProperty((Object)this), (String)"appGatewayName");
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].callGroovyObjectGetProperty((Object)description))) {
                Object object8 = callSiteArray[24].callGroovyObjectGetProperty((Object)description);
                ScriptBytecodeAdapter.setProperty((Object)object8, null, (Object)callSiteArray[25].callGroovyObjectGetProperty((Object)this), (String)"loadBalancerName");
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].callGetProperty(callSiteArray[27].callGroovyObjectGetProperty((Object)description)))) {
                Object object9 = callSiteArray[28].callGetProperty(callSiteArray[29].callGroovyObjectGetProperty((Object)description));
                ScriptBytecodeAdapter.setProperty((Object)object9, null, (Object)callSiteArray[30].callGroovyObjectGetProperty((Object)this), (String)"imageName");
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[31].callGroovyObjectGetProperty((Object)description), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[32].call(callSiteArray[33].callGroovyObjectGetProperty((Object)description)), (Object)0)) {
                    Object object10 = callSiteArray[34].call(callSiteArray[35].callGroovyObjectGetProperty((Object)description));
                    this.zones = (List)ScriptBytecodeAdapter.castToType((Object)object10, List.class);
                }
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[36].callGroovyObjectGetProperty((Object)description), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[37].call(callSiteArray[38].callGroovyObjectGetProperty((Object)description)), (Object)0)) {
                Object object11 = callSiteArray[39].call(callSiteArray[40].callGroovyObjectGetProperty((Object)description));
                this.zones = (List)ScriptBytecodeAdapter.castToType((Object)object11, List.class);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].callGroovyObjectGetProperty((Object)description))) {
                String string3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)description)) ? "true" : "false";
                ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)callSiteArray[43].callGroovyObjectGetProperty((Object)this), (String)"enableInboundNAT");
                callSiteArray[44].call(callSiteArray[45].callGroovyObjectGetProperty((Object)this), (Object)"[concat('Microsoft.Network/loadBalancers/', variables('loadBalancerName'))]");
            }
            Object object12 = callSiteArray[46].callConstructor(VirtualMachineScaleSetProperty.class, (Object)description);
            this.properties = (VirtualMachineScaleSetProperty)ScriptBytecodeAdapter.castToType((Object)object12, VirtualMachineScaleSetProperty.class);
            Object object13 = callSiteArray[47].callConstructor(ScaleSetSkuProperty.class, (Object)description);
            this.sku = (ScaleSetSkuProperty)ScriptBytecodeAdapter.castToType((Object)object13, ScaleSetSkuProperty.class);
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != VirtualMachineScaleSet.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VirtualMachineScaleSet.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VirtualMachineScaleSet.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VirtualMachineScaleSet.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VirtualMachineScaleSet.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VirtualMachineScaleSet.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VirtualMachineScaleSet.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = VirtualMachineScaleSet.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VirtualMachineScaleSet.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = VirtualMachineScaleSet.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VirtualMachineScaleSet.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public ScaleSetSkuProperty getSku() {
            return this.sku;
        }

        @Generated
        public void setSku(ScaleSetSkuProperty scaleSetSkuProperty) {
            this.sku = scaleSetSkuProperty;
        }

        @Generated
        public VirtualMachineScaleSetProperty getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(VirtualMachineScaleSetProperty virtualMachineScaleSetProperty) {
            this.properties = virtualMachineScaleSetProperty;
        }

        @Generated
        public ManagedIdentity getIdentity() {
            return this.identity;
        }

        @Generated
        public void setIdentity(ManagedIdentity managedIdentity) {
            this.identity = managedIdentity;
        }

        @Generated
        public List<String> getZones() {
            return this.zones;
        }

        @Generated
        public void setZones(List<String> list) {
            this.zones = list;
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "name";
            stringArray[1] = "userAssignedIdentities";
            stringArray[2] = "trim";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "useSystemManagedIdentity";
            stringArray[5] = "<$constructor$>";
            stringArray[6] = "useSystemManagedIdentity";
            stringArray[7] = "currentTimeMillis";
            stringArray[8] = "toString";
            stringArray[9] = "tags";
            stringArray[10] = "subnetId";
            stringArray[11] = "subnetId";
            stringArray[12] = "tags";
            stringArray[13] = "securityGroupName";
            stringArray[14] = "securityGroupName";
            stringArray[15] = "tags";
            stringArray[16] = "instanceTags";
            stringArray[17] = "leftShift";
            stringArray[18] = "tags";
            stringArray[19] = "instanceTags";
            stringArray[20] = "appGatewayName";
            stringArray[21] = "appGatewayName";
            stringArray[22] = "tags";
            stringArray[23] = "loadBalancerName";
            stringArray[24] = "loadBalancerName";
            stringArray[25] = "tags";
            stringArray[26] = "imageName";
            stringArray[27] = "image";
            stringArray[28] = "imageName";
            stringArray[29] = "image";
            stringArray[30] = "tags";
            stringArray[31] = "zones";
            stringArray[32] = "size";
            stringArray[33] = "zones";
            stringArray[34] = "asList";
            stringArray[35] = "zones";
            stringArray[36] = "zones";
            stringArray[37] = "size";
            stringArray[38] = "zones";
            stringArray[39] = "asList";
            stringArray[40] = "zones";
            stringArray[41] = "enableInboundNAT";
            stringArray[42] = "enableInboundNAT";
            stringArray[43] = "tags";
            stringArray[44] = "add";
            stringArray[45] = "dependsOn";
            stringArray[46] = "<$constructor$>";
            stringArray[47] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[48];
            VirtualMachineScaleSet.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(VirtualMachineScaleSet.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VirtualMachineScaleSet.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class VirtualMachineScaleSetProperty
    implements GroovyObject {
        private Map<String, String> upgradePolicy;
        private ScaleSetVMProfile virtualMachineProfile;
        private Boolean doNotRunExtensionsOnOverprovisionedVMs;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VirtualMachineScaleSetProperty(AzureServerGroupDescription description) {
            MetaClass metaClass;
            Map map;
            CallSite[] callSiteArray = VirtualMachineScaleSetProperty.$getCallSiteArray();
            this.upgradePolicy = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            callSiteArray[2].call(this.upgradePolicy, (Object)"mode", object);
            Object object2 = callSiteArray[3].callGroovyObjectGetProperty((Object)description);
            this.doNotRunExtensionsOnOverprovisionedVMs = (Boolean)ScriptBytecodeAdapter.castToType((Object)object2, Boolean.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGetPropertySafe(callSiteArray[5].callGroovyObjectGetProperty((Object)description))) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetPropertySafe(callSiteArray[7].callGroovyObjectGetProperty((Object)description)))) {
                Object object3 = callSiteArray[8].callConstructor(ScaleSetVMProfilePropertyWithExtension.class, (Object)description);
                this.virtualMachineProfile = (ScaleSetVMProfile)ScriptBytecodeAdapter.castToType((Object)object3, ScaleSetVMProfile.class);
            } else {
                Object object4 = callSiteArray[9].callConstructor(ScaleSetVMProfileProperty.class, (Object)description);
                this.virtualMachineProfile = (ScaleSetVMProfile)ScriptBytecodeAdapter.castToType((Object)object4, ScaleSetVMProfile.class);
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != VirtualMachineScaleSetProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VirtualMachineScaleSetProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VirtualMachineScaleSetProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VirtualMachineScaleSetProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VirtualMachineScaleSetProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VirtualMachineScaleSetProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VirtualMachineScaleSetProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = VirtualMachineScaleSetProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VirtualMachineScaleSetProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = VirtualMachineScaleSetProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VirtualMachineScaleSetProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Map<String, String> getUpgradePolicy() {
            return this.upgradePolicy;
        }

        @Generated
        public void setUpgradePolicy(Map<String, String> map) {
            this.upgradePolicy = map;
        }

        @Generated
        public ScaleSetVMProfile getVirtualMachineProfile() {
            return this.virtualMachineProfile;
        }

        @Generated
        public void setVirtualMachineProfile(ScaleSetVMProfile scaleSetVMProfile) {
            this.virtualMachineProfile = scaleSetVMProfile;
        }

        @Generated
        public Boolean getDoNotRunExtensionsOnOverprovisionedVMs() {
            return this.doNotRunExtensionsOnOverprovisionedVMs;
        }

        @Generated
        public void setDoNotRunExtensionsOnOverprovisionedVMs(Boolean bl) {
            this.doNotRunExtensionsOnOverprovisionedVMs = bl;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "toString";
            stringArray[1] = "upgradePolicy";
            stringArray[2] = "putAt";
            stringArray[3] = "doNotRunExtensionsOnOverprovisionedVMs";
            stringArray[4] = "commandToExecute";
            stringArray[5] = "customScriptsSettings";
            stringArray[6] = "protocol";
            stringArray[7] = "healthSettings";
            stringArray[8] = "<$constructor$>";
            stringArray[9] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[10];
            VirtualMachineScaleSetProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(VirtualMachineScaleSetProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VirtualMachineScaleSetProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScaleSetSkuProperty
    implements GroovyObject {
        private String name;
        private String tier;
        private int capacity;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetSkuProperty(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetSkuProperty.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            this.name = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)description));
            this.tier = ShortTypeHandling.castToString((Object)object2);
            Object object3 = callSiteArray[4].callGetProperty(callSiteArray[5].callGroovyObjectGetProperty((Object)description));
            this.capacity = DefaultTypeTransformation.intUnbox((Object)object3);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetSkuProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetSkuProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetSkuProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetSkuProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetSkuProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetSkuProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetSkuProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetSkuProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetSkuProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetSkuProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetSkuProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getTier() {
            return this.tier;
        }

        @Generated
        public void setTier(String string) {
            this.tier = string;
        }

        @Generated
        public int getCapacity() {
            return this.capacity;
        }

        @Generated
        public void setCapacity(int n) {
            this.capacity = n;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "name";
            stringArray[1] = "sku";
            stringArray[2] = "tier";
            stringArray[3] = "sku";
            stringArray[4] = "capacity";
            stringArray[5] = "sku";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[6];
            ScaleSetSkuProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScaleSetSkuProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetSkuProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScheduledEventsProfile
    implements GroovyObject {
        private TerminateNotificationProfile terminateNotificationProfile;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScheduledEventsProfile(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScheduledEventsProfile.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(TerminateNotificationProfile.class, (Object)description);
            this.terminateNotificationProfile = (TerminateNotificationProfile)ScriptBytecodeAdapter.castToType((Object)object, TerminateNotificationProfile.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScheduledEventsProfile.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScheduledEventsProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScheduledEventsProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScheduledEventsProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScheduledEventsProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScheduledEventsProfile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScheduledEventsProfile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScheduledEventsProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScheduledEventsProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScheduledEventsProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScheduledEventsProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public TerminateNotificationProfile getTerminateNotificationProfile() {
            return this.terminateNotificationProfile;
        }

        @Generated
        public void setTerminateNotificationProfile(TerminateNotificationProfile terminateNotificationProfile) {
            this.terminateNotificationProfile = terminateNotificationProfile;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(ScheduledEventsProfile.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScheduledEventsProfile.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class TerminateNotificationProfile
    implements GroovyObject {
        private String notBeforeTimeout;
        private Boolean enable;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public TerminateNotificationProfile(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = TerminateNotificationProfile.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            boolean bl = true;
            this.enable = bl;
            Object object = callSiteArray[0].call(callSiteArray[1].call((Object)"PT", callSiteArray[2].callGroovyObjectGetProperty((Object)description)), (Object)"M");
            this.notBeforeTimeout = ShortTypeHandling.castToString((Object)object);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != TerminateNotificationProfile.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = TerminateNotificationProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(TerminateNotificationProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = TerminateNotificationProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(TerminateNotificationProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = TerminateNotificationProfile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = TerminateNotificationProfile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = TerminateNotificationProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(TerminateNotificationProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = TerminateNotificationProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(TerminateNotificationProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getNotBeforeTimeout() {
            return this.notBeforeTimeout;
        }

        @Generated
        public void setNotBeforeTimeout(String string) {
            this.notBeforeTimeout = string;
        }

        @Generated
        public Boolean getEnable() {
            return this.enable;
        }

        @Generated
        public void setEnable(Boolean bl) {
            this.enable = bl;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "plus";
            stringArray[1] = "plus";
            stringArray[2] = "terminationNotBeforeTimeoutInMinutes";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[3];
            TerminateNotificationProfile.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(TerminateNotificationProfile.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = TerminateNotificationProfile.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ManagedIdentity
    implements GroovyObject {
        private String type;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ManagedIdentity() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ManagedIdentity.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public ManagedIdentity(Boolean enableSystemAssigned) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ManagedIdentity.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = DefaultTypeTransformation.booleanUnbox((Object)enableSystemAssigned) ? callSiteArray[0].callGetProperty(ResourceIdentityType.class) : callSiteArray[1].callGetProperty(ResourceIdentityType.class);
            this.type = ShortTypeHandling.castToString((Object)object);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ManagedIdentity.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ManagedIdentity.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ManagedIdentity.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ManagedIdentity.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ManagedIdentity.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ManagedIdentity.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ManagedIdentity.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ManagedIdentity.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ManagedIdentity.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ManagedIdentity.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ManagedIdentity.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String string) {
            this.type = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "SYSTEM_ASSIGNED";
            stringArray[1] = "NONE";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            ManagedIdentity.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ManagedIdentity.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ManagedIdentity.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class UserAndOptionalSystemAssignedIdentity
    extends ManagedIdentity {
        private Map<String, Map<String, String>> userAssignedIdentities;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public UserAndOptionalSystemAssignedIdentity(Boolean enableSystemAssigned, String userAssignedIdentities) {
            MetaClass metaClass;
            Map map;
            CallSite[] callSiteArray = UserAndOptionalSystemAssignedIdentity.$getCallSiteArray();
            this.userAssignedIdentities = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = DefaultTypeTransformation.booleanUnbox((Object)enableSystemAssigned) ? callSiteArray[0].call(callSiteArray[1].callGetProperty(ResourceIdentityType.class)) : callSiteArray[2].callGetProperty(ResourceIdentityType.class);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, UserAndOptionalSystemAssignedIdentity.class, (GroovyObject)this, (String)"type");
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[3].call((Object)userAssignedIdentities), (Object)0)) {
                String identity = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].call((Object)userAssignedIdentities, (Object)",")), Iterator.class);
                while (iterator.hasNext()) {
                    identity = ShortTypeHandling.castToString(iterator.next());
                    callSiteArray[6].call(this.userAssignedIdentities, callSiteArray[7].call(String.class, (Object)"[resourceID('Microsoft.ManagedIdentity/userAssignedIdentities/','%s')]", (Object)identity), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                }
            }
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != UserAndOptionalSystemAssignedIdentity.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = UserAndOptionalSystemAssignedIdentity.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(UserAndOptionalSystemAssignedIdentity.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = UserAndOptionalSystemAssignedIdentity.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(UserAndOptionalSystemAssignedIdentity.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        @Override
        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = UserAndOptionalSystemAssignedIdentity.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = UserAndOptionalSystemAssignedIdentity.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = UserAndOptionalSystemAssignedIdentity.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(UserAndOptionalSystemAssignedIdentity.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = UserAndOptionalSystemAssignedIdentity.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(UserAndOptionalSystemAssignedIdentity.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public Map<String, Map<String, String>> getUserAssignedIdentities() {
            return this.userAssignedIdentities;
        }

        @Generated
        public void setUserAssignedIdentities(Map<String, Map<String, String>> map) {
            this.userAssignedIdentities = map;
        }

        public /* synthetic */ Object super$2$propertyMissing(String string) {
            return super.propertyMissing(string);
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        public /* synthetic */ Object super$2$methodMissing(String string, Object object) {
            return super.methodMissing(string, object);
        }

        public /* synthetic */ void super$2$propertyMissing(String string, Object object) {
            super.propertyMissing(string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "toString";
            stringArray[1] = "SYSTEM_ASSIGNED_USER_ASSIGNED";
            stringArray[2] = "USER_ASSIGNED";
            stringArray[3] = "length";
            stringArray[4] = "iterator";
            stringArray[5] = "split";
            stringArray[6] = "put";
            stringArray[7] = "format";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[8];
            UserAndOptionalSystemAssignedIdentity.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(UserAndOptionalSystemAssignedIdentity.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = UserAndOptionalSystemAssignedIdentity.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public interface ScaleSetOsProfile {
    }

    public static class ScaleSetOsProfileProperty
    implements ScaleSetOsProfile,
    GroovyObject {
        private String computerNamePrefix;
        private String adminUsername;
        private String adminPassword;
        private String customData;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetOsProfileProperty(AzureServerGroupDescription description) {
            String string;
            int n;
            int n2;
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetOsProfileProperty.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String osType = ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)description)));
            int maxLengthOsSpecific = ScriptBytecodeAdapter.compareEqual((Object)osType, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)osType)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call((Object)osType)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)osType, (Object)"linux")) ? 10 : 9;
            int identifierLength = DefaultTypeTransformation.intUnbox((Object)callSiteArray[5].call(callSiteArray[6].call((Object)description)));
            int identifierMaxIndex = 0;
            identifierMaxIndex = !BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = identifierLength < maxLengthOsSpecific ? identifierLength : maxLengthOsSpecific) : (n = identifierLength < maxLengthOsSpecific ? identifierLength : maxLengthOsSpecific);
            Object object = callSiteArray[7].call(callSiteArray[8].call((Object)description), (Object)0, (Object)identifierMaxIndex);
            this.computerNamePrefix = ShortTypeHandling.castToString((Object)object);
            callSiteArray[9].call(ScriptBytecodeAdapter.getField(ScaleSetOsProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)"log"), callSiteArray[10].call(String.class, (Object)"computerNamePrefix will be truncated to %d characters to maintain Azure restrictions", (Object)maxLengthOsSpecific));
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(ScaleSetOsProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)"vmUserNameParameterName")}, new String[]{"[parameters('", "')]"});
            this.adminUsername = ShortTypeHandling.castToString((Object)gStringImpl);
            GStringImpl gStringImpl2 = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(ScaleSetOsProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)"vmPasswordParameterName")}, new String[]{"[parameters('", "')]"});
            this.adminPassword = ShortTypeHandling.castToString((Object)gStringImpl2);
            this.customData = string = "[base64(parameters('customData'))]";
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetOsProfileProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getComputerNamePrefix() {
            return this.computerNamePrefix;
        }

        @Generated
        public void setComputerNamePrefix(String string) {
            this.computerNamePrefix = string;
        }

        @Generated
        public String getAdminUsername() {
            return this.adminUsername;
        }

        @Generated
        public void setAdminUsername(String string) {
            this.adminUsername = string;
        }

        @Generated
        public String getAdminPassword() {
            return this.adminPassword;
        }

        @Generated
        public void setAdminPassword(String string) {
            this.adminPassword = string;
        }

        @Generated
        public String getCustomData() {
            return this.customData;
        }

        @Generated
        public void setCustomData(String string) {
            this.customData = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "ostype";
            stringArray[1] = "image";
            stringArray[2] = "isEmpty";
            stringArray[3] = "isAllWhitespace";
            stringArray[4] = "equalsIgnoreCase";
            stringArray[5] = "length";
            stringArray[6] = "getIdentifier";
            stringArray[7] = "substring";
            stringArray[8] = "getIdentifier";
            stringArray[9] = "info";
            stringArray[10] = "format";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[11];
            ScaleSetOsProfileProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScaleSetOsProfileProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetOsProfileProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScaleSetOsProfileWindowsConfiguration
    extends ScaleSetOsProfileProperty
    implements ScaleSetOsProfile {
        private OsProfileWindowsConfiguration windowsConfiguration;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetOsProfileWindowsConfiguration(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetOsProfileWindowsConfiguration.$getCallSiteArray();
            super(description);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(OsProfileWindowsConfiguration.class, (Object)description);
            this.windowsConfiguration = (OsProfileWindowsConfiguration)ScriptBytecodeAdapter.castToType((Object)object, OsProfileWindowsConfiguration.class);
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetOsProfileWindowsConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileWindowsConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileWindowsConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileWindowsConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileWindowsConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        @Override
        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileWindowsConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileWindowsConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileWindowsConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileWindowsConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileWindowsConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileWindowsConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public OsProfileWindowsConfiguration getWindowsConfiguration() {
            return this.windowsConfiguration;
        }

        @Generated
        public void setWindowsConfiguration(OsProfileWindowsConfiguration osProfileWindowsConfiguration) {
            this.windowsConfiguration = osProfileWindowsConfiguration;
        }

        public /* synthetic */ Object super$2$propertyMissing(String string) {
            return super.propertyMissing(string);
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        public /* synthetic */ Object super$2$methodMissing(String string, Object object) {
            return super.methodMissing(string, object);
        }

        public /* synthetic */ void super$2$propertyMissing(String string, Object object) {
            super.propertyMissing(string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(ScaleSetOsProfileWindowsConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetOsProfileWindowsConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class OsProfileWindowsConfiguration
    implements GroovyObject {
        private String timeZone;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public OsProfileWindowsConfiguration(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = OsProfileWindowsConfiguration.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)description);
            this.timeZone = ShortTypeHandling.castToString((Object)object);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OsProfileWindowsConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = OsProfileWindowsConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(OsProfileWindowsConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = OsProfileWindowsConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(OsProfileWindowsConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = OsProfileWindowsConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = OsProfileWindowsConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = OsProfileWindowsConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(OsProfileWindowsConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = OsProfileWindowsConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(OsProfileWindowsConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getTimeZone() {
            return this.timeZone;
        }

        @Generated
        public void setTimeZone(String string) {
            this.timeZone = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "windowsTimeZone";
            return new CallSiteArray(OsProfileWindowsConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = OsProfileWindowsConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScaleSetOsProfileLinuxConfiguration
    extends ScaleSetOsProfileProperty
    implements ScaleSetOsProfile {
        private OsProfileLinuxConfiguration linuxConfiguration;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetOsProfileLinuxConfiguration(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfiguration.$getCallSiteArray();
            super(description);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(OsProfileLinuxConfiguration.class);
            this.linuxConfiguration = (OsProfileLinuxConfiguration)ScriptBytecodeAdapter.castToType((Object)object, OsProfileLinuxConfiguration.class);
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetOsProfileLinuxConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileLinuxConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileLinuxConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        @Override
        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileLinuxConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileLinuxConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public OsProfileLinuxConfiguration getLinuxConfiguration() {
            return this.linuxConfiguration;
        }

        @Generated
        public void setLinuxConfiguration(OsProfileLinuxConfiguration osProfileLinuxConfiguration) {
            this.linuxConfiguration = osProfileLinuxConfiguration;
        }

        public /* synthetic */ Object super$2$propertyMissing(String string) {
            return super.propertyMissing(string);
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        public /* synthetic */ Object super$2$methodMissing(String string, Object object) {
            return super.methodMissing(string, object);
        }

        public /* synthetic */ void super$2$propertyMissing(String string, Object object) {
            super.propertyMissing(string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(ScaleSetOsProfileLinuxConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetOsProfileLinuxConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class OsProfileLinuxConfiguration
    implements GroovyObject {
        private Boolean disablePasswordAuthentication;
        private ScaleSetOsProfileLinuxConfigurationSsh ssh;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public OsProfileLinuxConfiguration() {
            MetaClass metaClass;
            CallSite[] callSiteArray = OsProfileLinuxConfiguration.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            boolean bl = true;
            this.disablePasswordAuthentication = bl;
            Object object = callSiteArray[0].callConstructor(ScaleSetOsProfileLinuxConfigurationSsh.class);
            this.ssh = (ScaleSetOsProfileLinuxConfigurationSsh)ScriptBytecodeAdapter.castToType((Object)object, ScaleSetOsProfileLinuxConfigurationSsh.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OsProfileLinuxConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = OsProfileLinuxConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(OsProfileLinuxConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = OsProfileLinuxConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(OsProfileLinuxConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = OsProfileLinuxConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = OsProfileLinuxConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = OsProfileLinuxConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(OsProfileLinuxConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = OsProfileLinuxConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(OsProfileLinuxConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Boolean getDisablePasswordAuthentication() {
            return this.disablePasswordAuthentication;
        }

        @Generated
        public void setDisablePasswordAuthentication(Boolean bl) {
            this.disablePasswordAuthentication = bl;
        }

        @Generated
        public ScaleSetOsProfileLinuxConfigurationSsh getSsh() {
            return this.ssh;
        }

        @Generated
        public void setSsh(ScaleSetOsProfileLinuxConfigurationSsh scaleSetOsProfileLinuxConfigurationSsh) {
            this.ssh = scaleSetOsProfileLinuxConfigurationSsh;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(OsProfileLinuxConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = OsProfileLinuxConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScaleSetOsProfileLinuxConfigurationSsh
    implements GroovyObject {
        private ArrayList<ScaleSetOsProfileLinuxConfigurationSshPublicKey> publicKeys;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetOsProfileLinuxConfigurationSsh() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSsh.$getCallSiteArray();
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.publicKeys = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list, ArrayList.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            callSiteArray[0].call(this.publicKeys, callSiteArray[1].callConstructor(ScaleSetOsProfileLinuxConfigurationSshPublicKey.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetOsProfileLinuxConfigurationSsh.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSsh.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileLinuxConfigurationSsh.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSsh.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileLinuxConfigurationSsh.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSsh.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSsh.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSsh.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileLinuxConfigurationSsh.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSsh.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileLinuxConfigurationSsh.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public ArrayList<ScaleSetOsProfileLinuxConfigurationSshPublicKey> getPublicKeys() {
            return this.publicKeys;
        }

        @Generated
        public void setPublicKeys(ArrayList<ScaleSetOsProfileLinuxConfigurationSshPublicKey> arrayList) {
            this.publicKeys = arrayList;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "add";
            stringArray[1] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            ScaleSetOsProfileLinuxConfigurationSsh.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScaleSetOsProfileLinuxConfigurationSsh.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetOsProfileLinuxConfigurationSsh.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScaleSetOsProfileLinuxConfigurationSshPublicKey
    implements GroovyObject {
        private String path;
        private String keyData;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetOsProfileLinuxConfigurationSshPublicKey() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSshPublicKey.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(ScaleSetOsProfileLinuxConfigurationSshPublicKey.class, AzureServerGroupResourceTemplate.class, (String)"vmUserNameParameterName")}, new String[]{"[concat('/home/', parameters('", "'), '/.ssh/authorized_keys')]"});
            this.path = ShortTypeHandling.castToString((Object)gStringImpl);
            GStringImpl gStringImpl2 = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(ScaleSetOsProfileLinuxConfigurationSshPublicKey.class, AzureServerGroupResourceTemplate.class, (String)"vmSshPublicKeyParameterName")}, new String[]{"[parameters('", "')]"});
            this.keyData = ShortTypeHandling.castToString((Object)gStringImpl2);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetOsProfileLinuxConfigurationSshPublicKey.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSshPublicKey.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileLinuxConfigurationSshPublicKey.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSshPublicKey.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetOsProfileLinuxConfigurationSshPublicKey.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSshPublicKey.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSshPublicKey.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSshPublicKey.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileLinuxConfigurationSshPublicKey.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetOsProfileLinuxConfigurationSshPublicKey.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetOsProfileLinuxConfigurationSshPublicKey.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public void setPath(String string) {
            this.path = string;
        }

        @Generated
        public String getKeyData() {
            return this.keyData;
        }

        @Generated
        public void setKeyData(String string) {
            this.keyData = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ScaleSetOsProfileLinuxConfigurationSshPublicKey.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetOsProfileLinuxConfigurationSshPublicKey.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScaleSetNetworkProfileProperty
    implements GroovyObject {
        private ArrayList<NetworkInterfaceConfiguration> networkInterfaceConfigurations;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetNetworkProfileProperty(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetNetworkProfileProperty.$getCallSiteArray();
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.networkInterfaceConfigurations = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list, ArrayList.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            callSiteArray[0].call(this.networkInterfaceConfigurations, callSiteArray[1].callConstructor(NetworkInterfaceConfiguration.class, (Object)description));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetNetworkProfileProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetNetworkProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetNetworkProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetNetworkProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetNetworkProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetNetworkProfileProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetNetworkProfileProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetNetworkProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetNetworkProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetNetworkProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetNetworkProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public ArrayList<NetworkInterfaceConfiguration> getNetworkInterfaceConfigurations() {
            return this.networkInterfaceConfigurations;
        }

        @Generated
        public void setNetworkInterfaceConfigurations(ArrayList<NetworkInterfaceConfiguration> arrayList) {
            this.networkInterfaceConfigurations = arrayList;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "add";
            stringArray[1] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            ScaleSetNetworkProfileProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScaleSetNetworkProfileProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetNetworkProfileProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class NetworkInterfaceConfiguration
    implements GroovyObject {
        private String name;
        private NetworkInterfaceConfigurationProperty properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkInterfaceConfiguration(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = NetworkInterfaceConfiguration.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].call(callSiteArray[1].callGetProperty(AzureUtilities.class), callSiteArray[2].call((Object)description));
            this.name = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[3].callConstructor(NetworkInterfaceConfigurationProperty.class, (Object)description);
            this.properties = (NetworkInterfaceConfigurationProperty)ScriptBytecodeAdapter.castToType((Object)object2, NetworkInterfaceConfigurationProperty.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkInterfaceConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public NetworkInterfaceConfigurationProperty getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(NetworkInterfaceConfigurationProperty networkInterfaceConfigurationProperty) {
            this.properties = networkInterfaceConfigurationProperty;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "plus";
            stringArray[1] = "NETWORK_INTERFACE_PREFIX";
            stringArray[2] = "getIdentifier";
            stringArray[3] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            NetworkInterfaceConfiguration.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(NetworkInterfaceConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkInterfaceConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class NetworkInterfaceConfigurationProperty
    implements GroovyObject {
        private boolean primary;
        private boolean enableIpForwarding;
        private ArrayList<NetworkInterfaceIPConfiguration> ipConfigurations;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkInterfaceConfigurationProperty(AzureServerGroupDescription description) {
            boolean bl;
            MetaClass metaClass;
            CallSite[] callSiteArray = NetworkInterfaceConfigurationProperty.$getCallSiteArray();
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.ipConfigurations = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list, ArrayList.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.primary = bl = true;
            Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)description);
            this.enableIpForwarding = DefaultTypeTransformation.booleanUnbox((Object)object);
            callSiteArray[1].call(this.ipConfigurations, callSiteArray[2].callConstructor(NetworkInterfaceIPConfiguration.class, (Object)description));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkInterfaceConfigurationProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceConfigurationProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceConfigurationProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceConfigurationProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceConfigurationProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceConfigurationProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceConfigurationProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceConfigurationProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceConfigurationProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceConfigurationProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceConfigurationProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public boolean getPrimary() {
            return this.primary;
        }

        @Generated
        public boolean isPrimary() {
            return this.primary;
        }

        @Generated
        public void setPrimary(boolean bl) {
            this.primary = bl;
        }

        @Generated
        public boolean getEnableIpForwarding() {
            return this.enableIpForwarding;
        }

        @Generated
        public boolean isEnableIpForwarding() {
            return this.enableIpForwarding;
        }

        @Generated
        public void setEnableIpForwarding(boolean bl) {
            this.enableIpForwarding = bl;
        }

        @Generated
        public ArrayList<NetworkInterfaceIPConfiguration> getIpConfigurations() {
            return this.ipConfigurations;
        }

        @Generated
        public void setIpConfigurations(ArrayList<NetworkInterfaceIPConfiguration> arrayList) {
            this.ipConfigurations = arrayList;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "enableIpForwarding";
            stringArray[1] = "add";
            stringArray[2] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[3];
            NetworkInterfaceConfigurationProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(NetworkInterfaceConfigurationProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkInterfaceConfigurationProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class NetworkSecurityGroup
    implements GroovyObject {
        private String id;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkSecurityGroup(String name) {
            MetaClass metaClass;
            CallSite[] callSiteArray = NetworkSecurityGroup.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{name}, new String[]{"[resourceId('Microsoft.Network/networkSecurityGroups', '", "')]"});
            this.id = ShortTypeHandling.castToString((Object)gStringImpl);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkSecurityGroup.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkSecurityGroup.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkSecurityGroup.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkSecurityGroup.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkSecurityGroup.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkSecurityGroup.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkSecurityGroup.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkSecurityGroup.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkSecurityGroup.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkSecurityGroup.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkSecurityGroup.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkSecurityGroup.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkSecurityGroup.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class NetworkInterfaceIPConfiguration
    implements GroovyObject {
        private String name;
        private NetworkInterfaceIPConfigurationsProperty properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkInterfaceIPConfiguration(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = NetworkInterfaceIPConfiguration.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].call(callSiteArray[1].callGetProperty(AzureUtilities.class), callSiteArray[2].call((Object)description));
            this.name = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[3].callConstructor(NetworkInterfaceIPConfigurationsProperty.class, (Object)description);
            this.properties = (NetworkInterfaceIPConfigurationsProperty)ScriptBytecodeAdapter.castToType((Object)object2, NetworkInterfaceIPConfigurationsProperty.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkInterfaceIPConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceIPConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceIPConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceIPConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceIPConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public NetworkInterfaceIPConfigurationsProperty getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(NetworkInterfaceIPConfigurationsProperty networkInterfaceIPConfigurationsProperty) {
            this.properties = networkInterfaceIPConfigurationsProperty;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "plus";
            stringArray[1] = "IPCONFIG_NAME_PREFIX";
            stringArray[2] = "getIdentifier";
            stringArray[3] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            NetworkInterfaceIPConfiguration.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(NetworkInterfaceIPConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkInterfaceIPConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class NetworkInterfaceIPConfigurationsProperty
    implements GroovyObject {
        private NetworkInterfaceIPConfigurationSubnet subnet;
        private ArrayList<AppGatewayBackendAddressPool> ApplicationGatewayBackendAddressPools;
        private ArrayList<LoadBalancerBackendAddressPool> loadBalancerBackendAddressPools;
        private ArrayList<LoadBalancerInboundNatPoolId> loadBalancerInboundNatPools;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkInterfaceIPConfigurationsProperty(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationsProperty.$getCallSiteArray();
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.ApplicationGatewayBackendAddressPools = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list, ArrayList.class);
            List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.loadBalancerBackendAddressPools = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list2, ArrayList.class);
            List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.loadBalancerInboundNatPools = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list3, ArrayList.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)description), (Object)callSiteArray[1].call(callSiteArray[2].callGetProperty(AzureLoadBalancer.AzureLoadBalancerType.class)))) {
                Object object = callSiteArray[3].callConstructor(NetworkInterfaceIPConfigurationSubnet.class);
                this.subnet = (NetworkInterfaceIPConfigurationSubnet)ScriptBytecodeAdapter.castToType((Object)object, NetworkInterfaceIPConfigurationSubnet.class);
                callSiteArray[4].call(this.loadBalancerBackendAddressPools, callSiteArray[5].callConstructor(ExistLoadBalancerBackendAddressPool.class));
                callSiteArray[6].call(this.loadBalancerInboundNatPools, callSiteArray[7].callConstructor(ExistLoadBalancerInboundNatPoolId.class));
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[8].callGroovyObjectGetProperty((Object)description), (Object)callSiteArray[9].call(callSiteArray[10].callGetProperty(AzureLoadBalancer.AzureLoadBalancerType.class)))) {
                Object object = callSiteArray[11].callConstructor(NetworkInterfaceIPConfigurationSubnet.class);
                this.subnet = (NetworkInterfaceIPConfigurationSubnet)ScriptBytecodeAdapter.castToType((Object)object, NetworkInterfaceIPConfigurationSubnet.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callGroovyObjectGetProperty((Object)description))) {
                    callSiteArray[13].call(this.loadBalancerBackendAddressPools, callSiteArray[14].callConstructor(LoadBalancerBackendAddressPool.class));
                    callSiteArray[15].call(this.loadBalancerInboundNatPools, callSiteArray[16].callConstructor(LoadBalancerInboundNatPoolId.class));
                }
                callSiteArray[17].call(this.ApplicationGatewayBackendAddressPools, callSiteArray[18].callConstructor(AppGatewayBackendAddressPool.class));
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[19].callGroovyObjectGetProperty((Object)description), null)) {
                Object object = callSiteArray[20].callConstructor(NetworkInterfaceIPConfigurationSubnet.class);
                this.subnet = (NetworkInterfaceIPConfigurationSubnet)ScriptBytecodeAdapter.castToType((Object)object, NetworkInterfaceIPConfigurationSubnet.class);
            } else {
                throw (Throwable)callSiteArray[21].callConstructor(RuntimeException.class, (Object)new GStringImpl(new Object[]{callSiteArray[22].callGroovyObjectGetProperty((Object)description)}, new String[]{"Load balancer type ", " is not valid"}));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkInterfaceIPConfigurationsProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationsProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceIPConfigurationsProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationsProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceIPConfigurationsProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationsProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationsProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationsProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceIPConfigurationsProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationsProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceIPConfigurationsProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public NetworkInterfaceIPConfigurationSubnet getSubnet() {
            return this.subnet;
        }

        @Generated
        public void setSubnet(NetworkInterfaceIPConfigurationSubnet networkInterfaceIPConfigurationSubnet) {
            this.subnet = networkInterfaceIPConfigurationSubnet;
        }

        @Generated
        public ArrayList<AppGatewayBackendAddressPool> getApplicationGatewayBackendAddressPools() {
            return this.ApplicationGatewayBackendAddressPools;
        }

        @Generated
        public void setApplicationGatewayBackendAddressPools(ArrayList<AppGatewayBackendAddressPool> arrayList) {
            this.ApplicationGatewayBackendAddressPools = arrayList;
        }

        @Generated
        public ArrayList<LoadBalancerBackendAddressPool> getLoadBalancerBackendAddressPools() {
            return this.loadBalancerBackendAddressPools;
        }

        @Generated
        public void setLoadBalancerBackendAddressPools(ArrayList<LoadBalancerBackendAddressPool> arrayList) {
            this.loadBalancerBackendAddressPools = arrayList;
        }

        @Generated
        public ArrayList<LoadBalancerInboundNatPoolId> getLoadBalancerInboundNatPools() {
            return this.loadBalancerInboundNatPools;
        }

        @Generated
        public void setLoadBalancerInboundNatPools(ArrayList<LoadBalancerInboundNatPoolId> arrayList) {
            this.loadBalancerInboundNatPools = arrayList;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "loadBalancerType";
            stringArray[1] = "toString";
            stringArray[2] = "AZURE_LOAD_BALANCER";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "add";
            stringArray[5] = "<$constructor$>";
            stringArray[6] = "add";
            stringArray[7] = "<$constructor$>";
            stringArray[8] = "loadBalancerType";
            stringArray[9] = "toString";
            stringArray[10] = "AZURE_APPLICATION_GATEWAY";
            stringArray[11] = "<$constructor$>";
            stringArray[12] = "enableInboundNAT";
            stringArray[13] = "add";
            stringArray[14] = "<$constructor$>";
            stringArray[15] = "add";
            stringArray[16] = "<$constructor$>";
            stringArray[17] = "add";
            stringArray[18] = "<$constructor$>";
            stringArray[19] = "loadBalancerType";
            stringArray[20] = "<$constructor$>";
            stringArray[21] = "<$constructor$>";
            stringArray[22] = "loadBalancerType";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[23];
            NetworkInterfaceIPConfigurationsProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(NetworkInterfaceIPConfigurationsProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkInterfaceIPConfigurationsProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class NetworkInterfaceIPConfigurationSubnet
    implements GroovyObject {
        private String id;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public NetworkInterfaceIPConfigurationSubnet() {
            MetaClass metaClass;
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationSubnet.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(NetworkInterfaceIPConfigurationSubnet.class, AzureServerGroupResourceTemplate.class, (String)"subnetParameterName")}, new String[]{"[parameters('", "')]"});
            this.id = ShortTypeHandling.castToString((Object)gStringImpl);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NetworkInterfaceIPConfigurationSubnet.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationSubnet.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceIPConfigurationSubnet.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationSubnet.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(NetworkInterfaceIPConfigurationSubnet.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationSubnet.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationSubnet.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationSubnet.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceIPConfigurationSubnet.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = NetworkInterfaceIPConfigurationSubnet.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(NetworkInterfaceIPConfigurationSubnet.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(NetworkInterfaceIPConfigurationSubnet.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = NetworkInterfaceIPConfigurationSubnet.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class LoadBalancerBackendAddressPool
    implements GroovyObject {
        private String id;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LoadBalancerBackendAddressPool() {
            String string;
            MetaClass metaClass;
            CallSite[] callSiteArray = LoadBalancerBackendAddressPool.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.id = string = "[resourceId('Microsoft.Network/loadBalancers/backendAddressPools', variables('loadBalancerName'), variables('loadBalancerBackend'))]";
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LoadBalancerBackendAddressPool.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerBackendAddressPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerBackendAddressPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(LoadBalancerBackendAddressPool.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LoadBalancerBackendAddressPool.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class LoadBalancerInboundNatPoolId
    extends IdRef {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LoadBalancerInboundNatPoolId() {
            MetaClass metaClass;
            CallSite[] callSiteArray = LoadBalancerInboundNatPoolId.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = "[resourceId('Microsoft.Network/loadBalancers/inboundNatPools', variables('loadBalancerName'), variables('inboundNatPoolName'))]";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, LoadBalancerInboundNatPoolId.class, (GroovyObject)this, (String)"id");
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LoadBalancerInboundNatPoolId.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerInboundNatPoolId.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerInboundNatPoolId.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerInboundNatPoolId.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerInboundNatPoolId.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerInboundNatPoolId.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerInboundNatPoolId.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(LoadBalancerInboundNatPoolId.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LoadBalancerInboundNatPoolId.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ExistLoadBalancerBackendAddressPool
    implements GroovyObject {
        private String id;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ExistLoadBalancerBackendAddressPool() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ExistLoadBalancerBackendAddressPool.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(ExistLoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)"loadBalancerAddressPoolParameterName")}, new String[]{"[parameters('", "')]"});
            this.id = ShortTypeHandling.castToString((Object)gStringImpl);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ExistLoadBalancerBackendAddressPool.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ExistLoadBalancerBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ExistLoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ExistLoadBalancerBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ExistLoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ExistLoadBalancerBackendAddressPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ExistLoadBalancerBackendAddressPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ExistLoadBalancerBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ExistLoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ExistLoadBalancerBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ExistLoadBalancerBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ExistLoadBalancerBackendAddressPool.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ExistLoadBalancerBackendAddressPool.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ExistLoadBalancerInboundNatPoolId
    extends IdRef {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ExistLoadBalancerInboundNatPoolId() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ExistLoadBalancerInboundNatPoolId.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(ExistLoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)"loadBalancerNatPoolParameterName")}, new String[]{"[parameters('", "')]"});
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, ExistLoadBalancerInboundNatPoolId.class, (GroovyObject)this, (String)"id");
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ExistLoadBalancerInboundNatPoolId.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ExistLoadBalancerInboundNatPoolId.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ExistLoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ExistLoadBalancerInboundNatPoolId.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ExistLoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ExistLoadBalancerInboundNatPoolId.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ExistLoadBalancerInboundNatPoolId.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ExistLoadBalancerInboundNatPoolId.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ExistLoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ExistLoadBalancerInboundNatPoolId.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ExistLoadBalancerInboundNatPoolId.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ExistLoadBalancerInboundNatPoolId.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ExistLoadBalancerInboundNatPoolId.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class AppGatewayBackendAddressPool
    implements GroovyObject {
        private String id;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public AppGatewayBackendAddressPool() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AppGatewayBackendAddressPool.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(AppGatewayBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)"appGatewayAddressPoolParameterName")}, new String[]{"[parameters('", "')]"});
            this.id = ShortTypeHandling.castToString((Object)gStringImpl);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AppGatewayBackendAddressPool.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AppGatewayBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AppGatewayBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AppGatewayBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(AppGatewayBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AppGatewayBackendAddressPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = AppGatewayBackendAddressPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AppGatewayBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AppGatewayBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AppGatewayBackendAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AppGatewayBackendAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(AppGatewayBackendAddressPool.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AppGatewayBackendAddressPool.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public interface ScaleSetVMProfile {
    }

    public static class ScaleSetVMProfileProperty
    implements ScaleSetVMProfile,
    GroovyObject {
        private StorageProfile storageProfile;
        private ScaleSetOsProfile osProfile;
        private ScaleSetNetworkProfileProperty networkProfile;
        private ScheduledEventsProfile scheduledEventsProfile;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetVMProfileProperty(AzureServerGroupDescription description) {
            Object object;
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetVMProfileProperty.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.storageProfile = object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)description))) ? callSiteArray[2].callConstructor(ScaleSetCustomManagedImageStorageProfile.class, (Object)description) : callSiteArray[3].callConstructor(ScaleSetStorageProfile.class, (Object)description);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGetProperty(callSiteArray[5].callGroovyObjectGetProperty((Object)description)))) {
                Object object2 = callSiteArray[6].callConstructor(ScaleSetOsProfileLinuxConfiguration.class, (Object)description);
                this.osProfile = (ScaleSetOsProfile)ScriptBytecodeAdapter.castToType((Object)object2, ScaleSetOsProfile.class);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callGroovyObjectGetProperty((Object)description))) {
                Object object3 = callSiteArray[8].callConstructor(ScaleSetOsProfileWindowsConfiguration.class, (Object)description);
                this.osProfile = (ScaleSetOsProfile)ScriptBytecodeAdapter.castToType((Object)object3, ScaleSetOsProfile.class);
            } else {
                Object object4 = callSiteArray[9].callConstructor(ScaleSetOsProfileProperty.class, (Object)description);
                this.osProfile = (ScaleSetOsProfile)ScriptBytecodeAdapter.castToType((Object)object4, ScaleSetOsProfile.class);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[10].callGroovyObjectGetProperty((Object)description), null)) {
                Object object5 = callSiteArray[11].callConstructor(ScheduledEventsProfile.class, (Object)description);
                this.scheduledEventsProfile = (ScheduledEventsProfile)ScriptBytecodeAdapter.castToType((Object)object5, ScheduledEventsProfile.class);
            }
            Object object6 = callSiteArray[12].callConstructor(ScaleSetNetworkProfileProperty.class, (Object)description);
            this.networkProfile = (ScaleSetNetworkProfileProperty)ScriptBytecodeAdapter.castToType((Object)object6, ScaleSetNetworkProfileProperty.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetVMProfileProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetVMProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetVMProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetVMProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetVMProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetVMProfileProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetVMProfileProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetVMProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetVMProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetVMProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetVMProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public StorageProfile getStorageProfile() {
            return this.storageProfile;
        }

        @Generated
        public void setStorageProfile(StorageProfile storageProfile) {
            this.storageProfile = storageProfile;
        }

        @Generated
        public ScaleSetOsProfile getOsProfile() {
            return this.osProfile;
        }

        @Generated
        public void setOsProfile(ScaleSetOsProfile scaleSetOsProfile) {
            this.osProfile = scaleSetOsProfile;
        }

        @Generated
        public ScaleSetNetworkProfileProperty getNetworkProfile() {
            return this.networkProfile;
        }

        @Generated
        public void setNetworkProfile(ScaleSetNetworkProfileProperty scaleSetNetworkProfileProperty) {
            this.networkProfile = scaleSetNetworkProfileProperty;
        }

        @Generated
        public ScheduledEventsProfile getScheduledEventsProfile() {
            return this.scheduledEventsProfile;
        }

        @Generated
        public void setScheduledEventsProfile(ScheduledEventsProfile scheduledEventsProfile) {
            this.scheduledEventsProfile = scheduledEventsProfile;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "isCustom";
            stringArray[1] = "image";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "useSshPublicKey";
            stringArray[5] = "credentials";
            stringArray[6] = "<$constructor$>";
            stringArray[7] = "windowsTimeZone";
            stringArray[8] = "<$constructor$>";
            stringArray[9] = "<$constructor$>";
            stringArray[10] = "terminationNotBeforeTimeoutInMinutes";
            stringArray[11] = "<$constructor$>";
            stringArray[12] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[13];
            ScaleSetVMProfileProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScaleSetVMProfileProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetVMProfileProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScaleSetVMProfilePropertyWithExtension
    extends ScaleSetVMProfileProperty
    implements ScaleSetVMProfile {
        private ScaleSetExtensionProfileProperty extensionProfile;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetVMProfilePropertyWithExtension(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetVMProfilePropertyWithExtension.$getCallSiteArray();
            super(description);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(ScaleSetExtensionProfileProperty.class, (Object)description);
            this.extensionProfile = (ScaleSetExtensionProfileProperty)ScriptBytecodeAdapter.castToType((Object)object, ScaleSetExtensionProfileProperty.class);
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetVMProfilePropertyWithExtension.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetVMProfilePropertyWithExtension.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetVMProfilePropertyWithExtension.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetVMProfilePropertyWithExtension.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetVMProfilePropertyWithExtension.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        @Override
        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetVMProfilePropertyWithExtension.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetVMProfilePropertyWithExtension.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Override
        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetVMProfilePropertyWithExtension.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetVMProfilePropertyWithExtension.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetVMProfilePropertyWithExtension.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetVMProfilePropertyWithExtension.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public ScaleSetExtensionProfileProperty getExtensionProfile() {
            return this.extensionProfile;
        }

        @Generated
        public void setExtensionProfile(ScaleSetExtensionProfileProperty scaleSetExtensionProfileProperty) {
            this.extensionProfile = scaleSetExtensionProfileProperty;
        }

        public /* synthetic */ Object super$2$propertyMissing(String string) {
            return super.propertyMissing(string);
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        public /* synthetic */ Object super$2$methodMissing(String string, Object object) {
            return super.methodMissing(string, object);
        }

        public /* synthetic */ void super$2$propertyMissing(String string, Object object) {
            super.propertyMissing(string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(ScaleSetVMProfilePropertyWithExtension.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetVMProfilePropertyWithExtension.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public interface OSDisk {
        public static final String name;
        public static final String caching;
        public static final String createOption;
    }

    public interface StorageProfile {
        public static final OSDisk osDisk;
    }

    public static class ScaleSetStorageProfile
    implements StorageProfile,
    GroovyObject {
        private OSDisk osDisk;
        private String imageReference;
        private List<VirtualMachineScaleSetDataDisk> dataDisks;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetStorageProfile(AzureServerGroupDescription description) {
            String string;
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetStorageProfile.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(VirtualMachineOSDisk.class, (Object)description);
            this.osDisk = (OSDisk)ScriptBytecodeAdapter.castToType((Object)object, OSDisk.class);
            this.imageReference = string = "[variables('imageReference')]";
            Object object2 = callSiteArray[1].callGroovyObjectGetProperty((Object)description);
            this.dataDisks = (List)ScriptBytecodeAdapter.castToType((Object)object2, List.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetStorageProfile.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetStorageProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetStorageProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetStorageProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetStorageProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetStorageProfile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetStorageProfile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetStorageProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetStorageProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetStorageProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetStorageProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public OSDisk getOsDisk() {
            return this.osDisk;
        }

        @Generated
        public void setOsDisk(OSDisk oSDisk) {
            this.osDisk = oSDisk;
        }

        @Generated
        public String getImageReference() {
            return this.imageReference;
        }

        @Generated
        public void setImageReference(String string) {
            this.imageReference = string;
        }

        @Generated
        public List<VirtualMachineScaleSetDataDisk> getDataDisks() {
            return this.dataDisks;
        }

        @Generated
        public void setDataDisks(List<VirtualMachineScaleSetDataDisk> list) {
            this.dataDisks = list;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "dataDisks";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            ScaleSetStorageProfile.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScaleSetStorageProfile.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetStorageProfile.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ImageReference
    implements GroovyObject {
        private String id;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ImageReference(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ImageReference.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            this.id = ShortTypeHandling.castToString((Object)object);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ImageReference.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ImageReference.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ImageReference.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ImageReference.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ImageReference.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ImageReference.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ImageReference.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ImageReference.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ImageReference.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ImageReference.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ImageReference.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setId(String string) {
            this.id = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "uri";
            stringArray[1] = "image";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            ImageReference.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ImageReference.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ImageReference.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ScaleSetCustomManagedImageStorageProfile
    implements StorageProfile,
    GroovyObject {
        private ImageReference imageReference;
        private List<VirtualMachineScaleSetDataDisk> dataDisks;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetCustomManagedImageStorageProfile(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ScaleSetCustomManagedImageStorageProfile.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(ImageReference.class, (Object)description);
            this.imageReference = (ImageReference)ScriptBytecodeAdapter.castToType((Object)object, ImageReference.class);
            Object object2 = callSiteArray[1].callGroovyObjectGetProperty((Object)description);
            this.dataDisks = (List)ScriptBytecodeAdapter.castToType((Object)object2, List.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetCustomManagedImageStorageProfile.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetCustomManagedImageStorageProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetCustomManagedImageStorageProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetCustomManagedImageStorageProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetCustomManagedImageStorageProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetCustomManagedImageStorageProfile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetCustomManagedImageStorageProfile.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetCustomManagedImageStorageProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetCustomManagedImageStorageProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetCustomManagedImageStorageProfile.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetCustomManagedImageStorageProfile.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public ImageReference getImageReference() {
            return this.imageReference;
        }

        @Generated
        public void setImageReference(ImageReference imageReference) {
            this.imageReference = imageReference;
        }

        @Generated
        public List<VirtualMachineScaleSetDataDisk> getDataDisks() {
            return this.dataDisks;
        }

        @Generated
        public void setDataDisks(List<VirtualMachineScaleSetDataDisk> list) {
            this.dataDisks = list;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "dataDisks";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            ScaleSetCustomManagedImageStorageProfile.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScaleSetCustomManagedImageStorageProfile.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetCustomManagedImageStorageProfile.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class VirtualMachineOSDisk
    implements OSDisk,
    GroovyObject {
        private String name;
        private String caching;
        private String createOption;
        private ArrayList<String> vhdContainers;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public VirtualMachineOSDisk(AzureServerGroupDescription description) {
            String string;
            String string2;
            MetaClass metaClass;
            CallSite[] callSiteArray = VirtualMachineOSDisk.$getCallSiteArray();
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.vhdContainers = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list, ArrayList.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].call((Object)"osdisk-", callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            this.name = ShortTypeHandling.castToString((Object)object);
            this.caching = string2 = "ReadOnly";
            this.createOption = string = "FromImage";
            callSiteArray[2].call(callSiteArray[3].call((Object)description), (Object)new _closure1(this, this));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != VirtualMachineOSDisk.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VirtualMachineOSDisk.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VirtualMachineOSDisk.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = VirtualMachineOSDisk.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(VirtualMachineOSDisk.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VirtualMachineOSDisk.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = VirtualMachineOSDisk.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = VirtualMachineOSDisk.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VirtualMachineOSDisk.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = VirtualMachineOSDisk.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(VirtualMachineOSDisk.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getCaching() {
            return this.caching;
        }

        @Generated
        public void setCaching(String string) {
            this.caching = string;
        }

        @Generated
        public String getCreateOption() {
            return this.createOption;
        }

        @Generated
        public void setCreateOption(String string) {
            this.createOption = string;
        }

        @Generated
        public ArrayList<String> getVhdContainers() {
            return this.vhdContainers;
        }

        @Generated
        public void setVhdContainers(ArrayList<String> arrayList) {
            this.vhdContainers = arrayList;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "plus";
            stringArray[1] = "name";
            stringArray[2] = "times";
            stringArray[3] = "getStorageAccountCount";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            VirtualMachineOSDisk.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(VirtualMachineOSDisk.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = VirtualMachineOSDisk.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object idx) {
                CallSite[] callSiteArray = _closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].call(String.class, (Object)"[concat('https://', variables('%s')[%s], '.blob.core.windows.net/', variables('%s'))]", callSiteArray[3].callGetProperty(ExtendedServerGroupTemplateVariables.class), idx, callSiteArray[4].callGetProperty(ExtendedServerGroupTemplateVariables.class)));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "add";
                stringArray[1] = "vhdContainers";
                stringArray[2] = "format";
                stringArray[3] = "uniqueStorageNamesArrayVar";
                stringArray[4] = "vhdContainerNameVar";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
    }

    public static class ScaleSetExtensionProfileProperty
    implements GroovyObject {
        private Collection<IExtensions> extensions;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ScaleSetExtensionProfileProperty(AzureServerGroupDescription description) {
            MetaClass metaClass;
            List list;
            CallSite[] callSiteArray = ScaleSetExtensionProfileProperty.$getCallSiteArray();
            this.extensions = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetPropertySafe(callSiteArray[1].callGroovyObjectGetProperty((Object)description)))) {
                Collection uriTemp = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)description)), Collection.class);
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)uriTemp) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)uriTemp)) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].call((Object)uriTemp), (Object)1) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callSafe(callSiteArray[7].call((Object)uriTemp)))) {
                        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        ScriptBytecodeAdapter.setProperty((Object)list2, null, (Object)callSiteArray[8].callGroovyObjectGetProperty((Object)description), (String)"fileUris");
                    }
                } else if (!DefaultTypeTransformation.booleanUnbox((Object)uriTemp) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call((Object)uriTemp)) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[10].call((Object)uriTemp), (Object)1) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].callSafe(callSiteArray[12].call((Object)uriTemp)))) {
                    List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    ScriptBytecodeAdapter.setProperty((Object)list3, null, (Object)callSiteArray[13].callGroovyObjectGetProperty((Object)description), (String)"fileUris");
                }
                callSiteArray[14].call(this.extensions, callSiteArray[15].callConstructor(CustomScriptExtensions.class, (Object)description));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGetPropertySafe(callSiteArray[17].callGroovyObjectGetProperty((Object)description)))) {
                callSiteArray[18].call(this.extensions, callSiteArray[19].callConstructor(HealthExtensions.class, (Object)description));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ScaleSetExtensionProfileProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetExtensionProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetExtensionProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ScaleSetExtensionProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ScaleSetExtensionProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetExtensionProfileProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ScaleSetExtensionProfileProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetExtensionProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetExtensionProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ScaleSetExtensionProfileProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ScaleSetExtensionProfileProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Collection<IExtensions> getExtensions() {
            return this.extensions;
        }

        @Generated
        public void setExtensions(Collection<IExtensions> collection) {
            this.extensions = collection;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "commandToExecute";
            stringArray[1] = "customScriptsSettings";
            stringArray[2] = "fileUris";
            stringArray[3] = "customScriptsSettings";
            stringArray[4] = "isEmpty";
            stringArray[5] = "size";
            stringArray[6] = "trim";
            stringArray[7] = "first";
            stringArray[8] = "customScriptsSettings";
            stringArray[9] = "isEmpty";
            stringArray[10] = "size";
            stringArray[11] = "trim";
            stringArray[12] = "first";
            stringArray[13] = "customScriptsSettings";
            stringArray[14] = "add";
            stringArray[15] = "<$constructor$>";
            stringArray[16] = "protocol";
            stringArray[17] = "healthSettings";
            stringArray[18] = "add";
            stringArray[19] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[20];
            ScaleSetExtensionProfileProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ScaleSetExtensionProfileProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ScaleSetExtensionProfileProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public interface IExtensions {
        public static final String name;
        public static final IExtensionProperty properties;
    }

    public static class HealthExtensions
    implements IExtensions,
    GroovyObject {
        private String name;
        private HealthExtensionProperty properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public HealthExtensions(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = HealthExtensions.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)description), (Object)"_health_ext");
            this.name = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[2].callConstructor(HealthExtensionProperty.class, (Object)description);
            this.properties = (HealthExtensionProperty)ScriptBytecodeAdapter.castToType((Object)object2, HealthExtensionProperty.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != HealthExtensions.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthExtensions.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthExtensions.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthExtensions.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthExtensions.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthExtensions.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthExtensions.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = HealthExtensions.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthExtensions.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = HealthExtensions.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthExtensions.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public HealthExtensionProperty getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(HealthExtensionProperty healthExtensionProperty) {
            this.properties = healthExtensionProperty;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "plus";
            stringArray[1] = "application";
            stringArray[2] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[3];
            HealthExtensions.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(HealthExtensions.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = HealthExtensions.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class CustomScriptExtensions
    implements IExtensions,
    GroovyObject {
        private String name;
        private CustomStringExtensionProperty properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CustomScriptExtensions(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CustomScriptExtensions.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)description), (Object)"_ext");
            this.name = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[2].callConstructor(CustomStringExtensionProperty.class, (Object)description);
            this.properties = (CustomStringExtensionProperty)ScriptBytecodeAdapter.castToType((Object)object2, CustomStringExtensionProperty.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CustomScriptExtensions.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CustomScriptExtensions.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CustomScriptExtensions.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CustomScriptExtensions.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CustomScriptExtensions.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CustomScriptExtensions.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CustomScriptExtensions.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = CustomScriptExtensions.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CustomScriptExtensions.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = CustomScriptExtensions.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CustomScriptExtensions.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public CustomStringExtensionProperty getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(CustomStringExtensionProperty customStringExtensionProperty) {
            this.properties = customStringExtensionProperty;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "plus";
            stringArray[1] = "application";
            stringArray[2] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[3];
            CustomScriptExtensions.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(CustomScriptExtensions.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CustomScriptExtensions.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public interface IExtensionProperty {
        public static final String publisher;
        public static final String type;
        public static final String typeHandlerVersion;
        public static final Boolean autoUpgradeMinorVersion;
        public static final IExtensionSettings settings;

        static {
            boolean bl = true;
            autoUpgradeMinorVersion = bl;
        }
    }

    public static class HealthExtensionProperty
    implements IExtensionProperty,
    GroovyObject {
        private String publisher;
        private String type;
        private String typeHandlerVersion;
        private Boolean autoUpgradeMinorVersion;
        private HealthExtensionSettings settings;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public HealthExtensionProperty(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = HealthExtensionProperty.$getCallSiteArray();
            boolean bl = true;
            this.autoUpgradeMinorVersion = bl;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(HealthExtensionSettings.class, (Object)description);
            this.settings = (HealthExtensionSettings)ScriptBytecodeAdapter.castToType((Object)object, HealthExtensionSettings.class);
            Object object2 = callSiteArray[1].callGetProperty(AzureUtilities.class);
            this.publisher = ShortTypeHandling.castToString((Object)object2);
            Object object3 = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callSafe(callSiteArray[3].callGetPropertySafe(callSiteArray[4].callGroovyObjectGetProperty((Object)description))), (Object)"linux") ? callSiteArray[5].callGetProperty(AzureUtilities.class) : callSiteArray[6].callGetProperty(AzureUtilities.class);
            this.type = ShortTypeHandling.castToString((Object)object3);
            Object object4 = callSiteArray[7].callGetProperty(AzureUtilities.class);
            this.typeHandlerVersion = ShortTypeHandling.castToString((Object)object4);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != HealthExtensionProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthExtensionProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthExtensionProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthExtensionProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthExtensionProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthExtensionProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthExtensionProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = HealthExtensionProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthExtensionProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = HealthExtensionProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthExtensionProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getPublisher() {
            return this.publisher;
        }

        @Generated
        public void setPublisher(String string) {
            this.publisher = string;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String string) {
            this.type = string;
        }

        @Generated
        public String getTypeHandlerVersion() {
            return this.typeHandlerVersion;
        }

        @Generated
        public void setTypeHandlerVersion(String string) {
            this.typeHandlerVersion = string;
        }

        @Generated
        public Boolean getAutoUpgradeMinorVersion() {
            return this.autoUpgradeMinorVersion;
        }

        @Generated
        public void setAutoUpgradeMinorVersion(Boolean bl) {
            this.autoUpgradeMinorVersion = bl;
        }

        @Generated
        public HealthExtensionSettings getSettings() {
            return this.settings;
        }

        @Generated
        public void setSettings(HealthExtensionSettings healthExtensionSettings) {
            this.settings = healthExtensionSettings;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "AZURE_HEALTH_EXT_PUBLISHER";
            stringArray[2] = "toLowerCase";
            stringArray[3] = "ostype";
            stringArray[4] = "image";
            stringArray[5] = "AZURE_HEALTH_EXT_TYPE_LINUX";
            stringArray[6] = "AZURE_HEALTH_EXT_TYPE_WINDOWS";
            stringArray[7] = "AZURE_HEALTH_EXT_VERSION";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[8];
            HealthExtensionProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(HealthExtensionProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = HealthExtensionProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class CustomStringExtensionProperty
    implements IExtensionProperty,
    GroovyObject {
        private String publisher;
        private String type;
        private String typeHandlerVersion;
        private Boolean autoUpgradeMinorVersion;
        private CustomScriptExtensionSettings settings;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CustomStringExtensionProperty(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CustomStringExtensionProperty.$getCallSiteArray();
            boolean bl = true;
            this.autoUpgradeMinorVersion = bl;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(CustomScriptExtensionSettings.class, (Object)description);
            this.settings = (CustomScriptExtensionSettings)ScriptBytecodeAdapter.castToType((Object)object, CustomScriptExtensionSettings.class);
            Object object2 = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callSafe(callSiteArray[2].callGetPropertySafe(callSiteArray[3].callGroovyObjectGetProperty((Object)description))), (Object)"linux") ? callSiteArray[4].callGetProperty(AzureUtilities.class) : callSiteArray[5].callGetProperty(AzureUtilities.class);
            this.publisher = ShortTypeHandling.castToString((Object)object2);
            Object object3 = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callSafe(callSiteArray[7].callGetPropertySafe(callSiteArray[8].callGroovyObjectGetProperty((Object)description))), (Object)"linux") ? callSiteArray[9].callGetProperty(AzureUtilities.class) : callSiteArray[10].callGetProperty(AzureUtilities.class);
            this.type = ShortTypeHandling.castToString((Object)object3);
            Object object4 = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[11].callSafe(callSiteArray[12].callGetPropertySafe(callSiteArray[13].callGroovyObjectGetProperty((Object)description))), (Object)"linux") ? callSiteArray[14].callGetProperty(AzureUtilities.class) : callSiteArray[15].callGetProperty(AzureUtilities.class);
            this.typeHandlerVersion = ShortTypeHandling.castToString((Object)object4);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CustomStringExtensionProperty.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CustomStringExtensionProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CustomStringExtensionProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CustomStringExtensionProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CustomStringExtensionProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CustomStringExtensionProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CustomStringExtensionProperty.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = CustomStringExtensionProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CustomStringExtensionProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = CustomStringExtensionProperty.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CustomStringExtensionProperty.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getPublisher() {
            return this.publisher;
        }

        @Generated
        public void setPublisher(String string) {
            this.publisher = string;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String string) {
            this.type = string;
        }

        @Generated
        public String getTypeHandlerVersion() {
            return this.typeHandlerVersion;
        }

        @Generated
        public void setTypeHandlerVersion(String string) {
            this.typeHandlerVersion = string;
        }

        @Generated
        public Boolean getAutoUpgradeMinorVersion() {
            return this.autoUpgradeMinorVersion;
        }

        @Generated
        public void setAutoUpgradeMinorVersion(Boolean bl) {
            this.autoUpgradeMinorVersion = bl;
        }

        @Generated
        public CustomScriptExtensionSettings getSettings() {
            return this.settings;
        }

        @Generated
        public void setSettings(CustomScriptExtensionSettings customScriptExtensionSettings) {
            this.settings = customScriptExtensionSettings;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "toLowerCase";
            stringArray[2] = "ostype";
            stringArray[3] = "image";
            stringArray[4] = "AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_LINUX";
            stringArray[5] = "AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_WINDOWS";
            stringArray[6] = "toLowerCase";
            stringArray[7] = "ostype";
            stringArray[8] = "image";
            stringArray[9] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX";
            stringArray[10] = "AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS";
            stringArray[11] = "toLowerCase";
            stringArray[12] = "ostype";
            stringArray[13] = "image";
            stringArray[14] = "AZURE_CUSTOM_SCRIPT_EXT_VERSION_LINUX";
            stringArray[15] = "AZURE_CUSTOM_SCRIPT_EXT_VERSION_WINDOWS";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[16];
            CustomStringExtensionProperty.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(CustomStringExtensionProperty.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CustomStringExtensionProperty.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public interface IExtensionSettings {
    }

    public static class HealthExtensionSettings
    implements IExtensionSettings,
    GroovyObject {
        private String protocol;
        private int port;
        private String requestPath;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public HealthExtensionSettings(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = HealthExtensionSettings.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            this.protocol = ShortTypeHandling.castToString((Object)object);
            try {
                Object object2 = callSiteArray[2].call(Integer.class, callSiteArray[3].callGetProperty(callSiteArray[4].callGroovyObjectGetProperty((Object)description)));
                this.port = DefaultTypeTransformation.intUnbox((Object)object2);
            }
            catch (NumberFormatException ignored) {
                int n;
                this.port = n = 0;
                throw (Throwable)callSiteArray[5].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{callSiteArray[6].callGetProperty(callSiteArray[7].callGroovyObjectGetProperty((Object)description))}, new String[]{"healthSettings.port \"", "\" is not a valid integer"}));
            }
            Object object3 = callSiteArray[8].callGetProperty(callSiteArray[9].callGroovyObjectGetProperty((Object)description));
            this.requestPath = ShortTypeHandling.castToString((Object)object3);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != HealthExtensionSettings.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthExtensionSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthExtensionSettings.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = HealthExtensionSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(HealthExtensionSettings.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthExtensionSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = HealthExtensionSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = HealthExtensionSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthExtensionSettings.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = HealthExtensionSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(HealthExtensionSettings.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public void setProtocol(String string) {
            this.protocol = string;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public void setPort(int n) {
            this.port = n;
        }

        @Generated
        public String getRequestPath() {
            return this.requestPath;
        }

        @Generated
        public void setRequestPath(String string) {
            this.requestPath = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "protocol";
            stringArray[1] = "healthSettings";
            stringArray[2] = "parseInt";
            stringArray[3] = "port";
            stringArray[4] = "healthSettings";
            stringArray[5] = "<$constructor$>";
            stringArray[6] = "port";
            stringArray[7] = "healthSettings";
            stringArray[8] = "requestPath";
            stringArray[9] = "healthSettings";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[10];
            HealthExtensionSettings.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(HealthExtensionSettings.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = HealthExtensionSettings.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class CustomScriptExtensionSettings
    implements IExtensionSettings,
    GroovyObject {
        private Collection<String> fileUris;
        private String commandToExecute;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CustomScriptExtensionSettings(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CustomScriptExtensionSettings.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)description));
            this.commandToExecute = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)description));
            this.fileUris = (Collection)ScriptBytecodeAdapter.castToType((Object)object2, Collection.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CustomScriptExtensionSettings.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CustomScriptExtensionSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CustomScriptExtensionSettings.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CustomScriptExtensionSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CustomScriptExtensionSettings.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CustomScriptExtensionSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CustomScriptExtensionSettings.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = CustomScriptExtensionSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CustomScriptExtensionSettings.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = CustomScriptExtensionSettings.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CustomScriptExtensionSettings.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Collection<String> getFileUris() {
            return this.fileUris;
        }

        @Generated
        public void setFileUris(Collection<String> collection) {
            this.fileUris = collection;
        }

        @Generated
        public String getCommandToExecute() {
            return this.commandToExecute;
        }

        @Generated
        public void setCommandToExecute(String string) {
            this.commandToExecute = string;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "commandToExecute";
            stringArray[1] = "customScriptsSettings";
            stringArray[2] = "fileUris";
            stringArray[3] = "customScriptsSettings";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            CustomScriptExtensionSettings.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(CustomScriptExtensionSettings.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CustomScriptExtensionSettings.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class LoadBalancer
    extends DependingResource {
        private LoadBalancerProperties properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LoadBalancer(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = LoadBalancer.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = "[variables('apiVersion')]";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, LoadBalancer.class, (GroovyObject)this, (String)"apiVersion");
            String string2 = "[variables('loadBalancerName')]";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, LoadBalancer.class, (GroovyObject)this, (String)"name");
            String string3 = "Microsoft.Network/loadBalancers";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string3, LoadBalancer.class, (GroovyObject)this, (String)"type");
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ScriptBytecodeAdapter.getField(LoadBalancer.class, AzureServerGroupResourceTemplate.class, (String)"locationParameterName")}, new String[]{"[parameters('", "')]"});
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, LoadBalancer.class, (GroovyObject)this, (String)"location");
            Object currentTime = callSiteArray[0].call(System.class);
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, LoadBalancer.class, (GroovyObject)this, (String)"tags");
            Object object = callSiteArray[1].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[2].callGroovyObjectGetProperty((Object)this), (String)"appName");
            Object object2 = callSiteArray[3].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (String)"stack");
            Object object3 = callSiteArray[5].callGroovyObjectGetProperty((Object)description);
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)callSiteArray[6].callGroovyObjectGetProperty((Object)this), (String)"detail");
            Object object4 = callSiteArray[7].call(currentTime);
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)callSiteArray[8].callGroovyObjectGetProperty((Object)this), (String)"createdTime");
            String string4 = "1";
            ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)callSiteArray[9].callGroovyObjectGetProperty((Object)this), (String)"internal");
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callGroovyObjectGetProperty((Object)description))) {
                Object object5 = callSiteArray[11].callGroovyObjectGetProperty((Object)description);
                ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)callSiteArray[12].callGroovyObjectGetProperty((Object)this), (String)"cluster");
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callGroovyObjectGetProperty((Object)description))) {
                Object object6 = callSiteArray[14].callGroovyObjectGetProperty((Object)description);
                ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)callSiteArray[15].callGroovyObjectGetProperty((Object)this), (String)"serverGroup");
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGroovyObjectGetProperty((Object)description))) {
                Object object7 = callSiteArray[17].callGroovyObjectGetProperty((Object)description);
                ScriptBytecodeAdapter.setProperty((Object)object7, null, (Object)callSiteArray[18].callGroovyObjectGetProperty((Object)this), (String)"securityGroupName");
            }
            callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)"[concat('Microsoft.Network/publicIPAddresses/', variables('publicIPAddressName'))]");
            Object object8 = callSiteArray[21].callConstructor(LoadBalancerProperties.class, (Object)description);
            this.properties = (LoadBalancerProperties)ScriptBytecodeAdapter.castToType((Object)object8, LoadBalancerProperties.class);
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LoadBalancer.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancer.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancer.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancer.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancer.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancer.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancer.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancer.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancer.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancer.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancer.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        public LoadBalancerProperties getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(LoadBalancerProperties loadBalancerProperties) {
            this.properties = loadBalancerProperties;
        }

        public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "currentTimeMillis";
            stringArray[1] = "application";
            stringArray[2] = "tags";
            stringArray[3] = "stack";
            stringArray[4] = "tags";
            stringArray[5] = "detail";
            stringArray[6] = "tags";
            stringArray[7] = "toString";
            stringArray[8] = "tags";
            stringArray[9] = "tags";
            stringArray[10] = "clusterName";
            stringArray[11] = "clusterName";
            stringArray[12] = "tags";
            stringArray[13] = "name";
            stringArray[14] = "name";
            stringArray[15] = "tags";
            stringArray[16] = "securityGroupName";
            stringArray[17] = "securityGroupName";
            stringArray[18] = "tags";
            stringArray[19] = "add";
            stringArray[20] = "dependsOn";
            stringArray[21] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[22];
            LoadBalancer.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(LoadBalancer.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LoadBalancer.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class LoadBalancerProperties
    implements GroovyObject {
        private ArrayList<FrontEndIpConfiguration> frontendIPConfigurations;
        private ArrayList<BackEndAddressPool> backendAddressPools;
        private ArrayList<InboundNatPool> inboundNatPools;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LoadBalancerProperties(AzureServerGroupDescription description) {
            MetaClass metaClass;
            CallSite[] callSiteArray = LoadBalancerProperties.$getCallSiteArray();
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.frontendIPConfigurations = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list, ArrayList.class);
            List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.backendAddressPools = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list2, ArrayList.class);
            List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.inboundNatPools = (ArrayList)ScriptBytecodeAdapter.castToType((Object)list3, ArrayList.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            callSiteArray[0].call(this.frontendIPConfigurations, callSiteArray[1].callConstructor(FrontEndIpConfiguration.class));
            callSiteArray[2].call(this.backendAddressPools, callSiteArray[3].callConstructor(BackEndAddressPool.class));
            callSiteArray[4].callSafe(callSiteArray[5].callGroovyObjectGetProperty((Object)description), (Object)new _closure1(this, this));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LoadBalancerProperties.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LoadBalancerProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LoadBalancerProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerProperties.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LoadBalancerProperties.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = LoadBalancerProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LoadBalancerProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public ArrayList<FrontEndIpConfiguration> getFrontendIPConfigurations() {
            return this.frontendIPConfigurations;
        }

        @Generated
        public void setFrontendIPConfigurations(ArrayList<FrontEndIpConfiguration> arrayList) {
            this.frontendIPConfigurations = arrayList;
        }

        @Generated
        public ArrayList<BackEndAddressPool> getBackendAddressPools() {
            return this.backendAddressPools;
        }

        @Generated
        public void setBackendAddressPools(ArrayList<BackEndAddressPool> arrayList) {
            this.backendAddressPools = arrayList;
        }

        @Generated
        public ArrayList<InboundNatPool> getInboundNatPools() {
            return this.inboundNatPools;
        }

        @Generated
        public void setInboundNatPools(ArrayList<InboundNatPool> arrayList) {
            this.inboundNatPools = arrayList;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "add";
            stringArray[1] = "<$constructor$>";
            stringArray[2] = "add";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "each";
            stringArray[5] = "inboundPortConfigs";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[6];
            LoadBalancerProperties.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(LoadBalancerProperties.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LoadBalancerProperties.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].callConstructor(InboundNatPool.class, it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "add";
                stringArray[1] = "inboundNatPools";
                stringArray[2] = "<$constructor$>";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
    }

    public static class FrontEndIpConfiguration
    implements GroovyObject {
        private String name;
        private FrontEndIpProperties properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public FrontEndIpConfiguration() {
            String string;
            MetaClass metaClass;
            CallSite[] callSiteArray = FrontEndIpConfiguration.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.name = string = "[variables('loadBalancerFrontEnd')]";
            Object object = callSiteArray[0].callConstructor(FrontEndIpProperties.class, (Object)"[variables('publicIPAddressID')]");
            this.properties = (FrontEndIpProperties)ScriptBytecodeAdapter.castToType((Object)object, FrontEndIpProperties.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != FrontEndIpConfiguration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = FrontEndIpConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(FrontEndIpConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = FrontEndIpConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(FrontEndIpConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = FrontEndIpConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = FrontEndIpConfiguration.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = FrontEndIpConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(FrontEndIpConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = FrontEndIpConfiguration.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(FrontEndIpConfiguration.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public FrontEndIpProperties getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(FrontEndIpProperties frontEndIpProperties) {
            this.properties = frontEndIpProperties;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(FrontEndIpConfiguration.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = FrontEndIpConfiguration.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class FrontEndIpProperties
    implements GroovyObject {
        private IdRef publicIpAddress;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public FrontEndIpProperties(String id) {
            MetaClass metaClass;
            CallSite[] callSiteArray = FrontEndIpProperties.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(IdRef.class, (Object)id);
            this.publicIpAddress = (IdRef)ScriptBytecodeAdapter.castToType((Object)object, IdRef.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != FrontEndIpProperties.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = FrontEndIpProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(FrontEndIpProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = FrontEndIpProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(FrontEndIpProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = FrontEndIpProperties.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = FrontEndIpProperties.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = FrontEndIpProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(FrontEndIpProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = FrontEndIpProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(FrontEndIpProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public IdRef getPublicIpAddress() {
            return this.publicIpAddress;
        }

        @Generated
        public void setPublicIpAddress(IdRef idRef) {
            this.publicIpAddress = idRef;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "<$constructor$>";
            return new CallSiteArray(FrontEndIpProperties.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = FrontEndIpProperties.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class BackEndAddressPool
    implements GroovyObject {
        private String name;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public BackEndAddressPool() {
            String string;
            MetaClass metaClass;
            CallSite[] callSiteArray = BackEndAddressPool.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.name = string = "[variables('loadBalancerBackEnd')]";
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != BackEndAddressPool.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = BackEndAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(BackEndAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = BackEndAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(BackEndAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = BackEndAddressPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = BackEndAddressPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = BackEndAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(BackEndAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = BackEndAddressPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(BackEndAddressPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(BackEndAddressPool.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = BackEndAddressPool.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class InboundNatPool
    implements GroovyObject {
        private String name;
        private InboundNatPoolProperties properties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public InboundNatPool(AzureServerGroupDescription.AzureInboundPortConfig inboundPortConfig) {
            MetaClass metaClass;
            CallSite[] callSiteArray = InboundNatPool.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)inboundPortConfig);
            this.name = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[1].callConstructor(InboundNatPoolProperties.class, (Object)inboundPortConfig);
            this.properties = (InboundNatPoolProperties)ScriptBytecodeAdapter.castToType((Object)object2, InboundNatPoolProperties.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != InboundNatPool.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = InboundNatPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(InboundNatPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = InboundNatPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(InboundNatPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = InboundNatPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = InboundNatPool.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = InboundNatPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(InboundNatPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = InboundNatPool.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(InboundNatPool.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public InboundNatPoolProperties getProperties() {
            return this.properties;
        }

        @Generated
        public void setProperties(InboundNatPoolProperties inboundNatPoolProperties) {
            this.properties = inboundNatPoolProperties;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "name";
            stringArray[1] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            InboundNatPool.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(InboundNatPool.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = InboundNatPool.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class InboundNatPoolProperties
    implements GroovyObject {
        private IdRef frontendIPConfiguration;
        private String protocol;
        private int frontendPortRangeStart;
        private int frontendPortRangeEnd;
        private int backendPort;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public InboundNatPoolProperties(AzureServerGroupDescription.AzureInboundPortConfig inboundPortConfig) {
            MetaClass metaClass;
            CallSite[] callSiteArray = InboundNatPoolProperties.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(IdRef.class, (Object)"[variables('frontEndIPConfigID')]");
            this.frontendIPConfiguration = (IdRef)ScriptBytecodeAdapter.castToType((Object)object, IdRef.class);
            Object object2 = callSiteArray[1].callGroovyObjectGetProperty((Object)inboundPortConfig);
            this.protocol = ShortTypeHandling.castToString((Object)object2);
            Object object3 = callSiteArray[2].callGroovyObjectGetProperty((Object)inboundPortConfig);
            this.frontendPortRangeStart = DefaultTypeTransformation.intUnbox((Object)object3);
            Object object4 = callSiteArray[3].callGroovyObjectGetProperty((Object)inboundPortConfig);
            this.frontendPortRangeEnd = DefaultTypeTransformation.intUnbox((Object)object4);
            Object object5 = callSiteArray[4].callGroovyObjectGetProperty((Object)inboundPortConfig);
            this.backendPort = DefaultTypeTransformation.intUnbox((Object)object5);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != InboundNatPoolProperties.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = InboundNatPoolProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(InboundNatPoolProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = InboundNatPoolProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(InboundNatPoolProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = InboundNatPoolProperties.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = InboundNatPoolProperties.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = InboundNatPoolProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(InboundNatPoolProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = InboundNatPoolProperties.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(InboundNatPoolProperties.class, AzureServerGroupResourceTemplate.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public IdRef getFrontendIPConfiguration() {
            return this.frontendIPConfiguration;
        }

        @Generated
        public void setFrontendIPConfiguration(IdRef idRef) {
            this.frontendIPConfiguration = idRef;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public void setProtocol(String string) {
            this.protocol = string;
        }

        @Generated
        public int getFrontendPortRangeStart() {
            return this.frontendPortRangeStart;
        }

        @Generated
        public void setFrontendPortRangeStart(int n) {
            this.frontendPortRangeStart = n;
        }

        @Generated
        public int getFrontendPortRangeEnd() {
            return this.frontendPortRangeEnd;
        }

        @Generated
        public void setFrontendPortRangeEnd(int n) {
            this.frontendPortRangeEnd = n;
        }

        @Generated
        public int getBackendPort() {
            return this.backendPort;
        }

        @Generated
        public void setBackendPort(int n) {
            this.backendPort = n;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "protocol";
            stringArray[2] = "frontEndPortRangeStart";
            stringArray[3] = "frontEndPortRangeEnd";
            stringArray[4] = "backendPort";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[5];
            InboundNatPoolProperties.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(InboundNatPoolProperties.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = InboundNatPoolProperties.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

