/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.network.model;

import com.azure.resourcemanager.network.fluent.models.VirtualNetworkInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.common.AzureResourceOpsDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.subnet.model.AzureSubnetDescription;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class AzureVirtualNetworkDescription
extends AzureResourceOpsDescription {
    private String id;
    private String type;
    private List<String> addressSpace;
    private String resourceId;
    private String resourceGroup;
    private Map<String, Object> tags;
    private List<AzureSubnetDescription> subnets;
    private int maxSubnets;
    private int subnetAddressPrefixLength;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AzureVirtualNetworkDescription() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static AzureVirtualNetworkDescription getDescriptionForVirtualNetwork(VirtualNetworkInner vnet) {
        List<AzureSubnetDescription> list;
        if (!(vnet != null)) {
            return (AzureVirtualNetworkDescription)ScriptBytecodeAdapter.castToType(null, AzureVirtualNetworkDescription.class);
        }
        AzureVirtualNetworkDescription description = new AzureVirtualNetworkDescription();
        String string = vnet.name();
        description.setName(string);
        String string2 = vnet.location();
        description.setRegion(string2);
        AddressSpace addressSpace = vnet.addressSpace();
        List list2 = addressSpace != null ? addressSpace.addressPrefixes() : null;
        description.setAddressSpace(list2);
        Collection<AzureSubnetDescription> collection = AzureSubnetDescription.getSubnetsForVirtualNetwork(vnet);
        List list3 = collection != null ? DefaultGroovyMethods.toList(collection) : null;
        description.setSubnets(list3);
        String string3 = vnet.id();
        description.setResourceId(string3);
        String string4 = AzureUtilities.getResourceGroupNameFromResourceId(vnet.id());
        description.setResourceGroup(string4);
        String string5 = vnet.name();
        description.setId(string5);
        if (DefaultTypeTransformation.booleanUnbox((Object)vnet.tags())) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            description.setTags(hashMap);
            description.getTags().putAll(vnet.tags());
        }
        public final class _getDescriptionForVirtualNetwork_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDescriptionForVirtualNetwork_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Integer doCall(Object it) {
                return ((AzureSubnetDescription)it).getAddressPrefixLength();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Integer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDescriptionForVirtualNetwork_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Object object = (list = description.getSubnets()) != null ? DefaultGroovyMethods.min(list, (Closure)new _getDescriptionForVirtualNetwork_closure1(AzureVirtualNetworkDescription.class, AzureVirtualNetworkDescription.class)) : null;
        Integer n = object != null ? Integer.valueOf(((AzureSubnetDescription)object).getAddressPrefixLength()) : null;
        Integer n2 = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(AzureUtilities.getSUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH());
        description.setSubnetAddressPrefixLength(n2);
        List<String> list4 = description.getAddressSpace();
        int n3 = AzureUtilities.getSubnetRangeMax(ShortTypeHandling.castToString((Object)(list4 != null ? DefaultGroovyMethods.first(list4) : null)), description.getSubnetAddressPrefixLength());
        description.setMaxSubnets(n3);
        return description;
    }

    public static String getNextSubnetAddressPrefix(AzureVirtualNetworkDescription vnet, int seed) {
        AzureVirtualNetworkDescription azureVirtualNetworkDescription = vnet;
        if (!DefaultTypeTransformation.booleanUnbox(azureVirtualNetworkDescription != null ? Integer.valueOf(azureVirtualNetworkDescription.getMaxSubnets()) : null) || vnet.getSubnets().size() >= vnet.getMaxSubnets()) {
            return ShortTypeHandling.castToString(null);
        }
        AzureVirtualNetworkDescription azureVirtualNetworkDescription2 = vnet;
        List<String> list = azureVirtualNetworkDescription2 != null ? azureVirtualNetworkDescription2.getAddressSpace() : null;
        int vnetIpv4 = AzureUtilities.convertIpv4PrefixToInt(ShortTypeHandling.castToString((Object)(list != null ? DefaultGroovyMethods.first(list) : null)));
        if (vnetIpv4 <= 0) {
            return ShortTypeHandling.castToString(null);
        }
        long leftShift = 32 - vnet.getSubnetAddressPrefixLength();
        Reference nextIpv4 = new Reference((Object)(vnetIpv4 | (int)((long)seed << (int)leftShift)));
        int loopCount = 0;
        public final class _getNextSubnetAddressPrefix_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference nextIpv4;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getNextSubnetAddressPrefix_closure2(Object _outerInstance, Object _thisObject, Reference nextIpv4) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.nextIpv4 = reference = nextIpv4;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((AzureSubnetDescription)it).getIpv4(), (Object)this.nextIpv4.get());
            }

            @Generated
            public Integer getNextIpv4() {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.nextIpv4.get(), Integer.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNextSubnetAddressPrefix_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        while (loopCount < vnet.getMaxSubnets() && DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find(vnet.getSubnets(), (Closure)new _getNextSubnetAddressPrefix_closure2(AzureVirtualNetworkDescription.class, AzureVirtualNetworkDescription.class, nextIpv4)))) {
            int cfr_ignored_0 = (seed + 1) % vnet.getMaxSubnets();
            nextIpv4.set((Object)(vnetIpv4 | (int)((long)seed << (int)leftShift)));
            int cfr_ignored_1 = loopCount + 1;
        }
        return AzureUtilities.convertIntToIpv4Prefix((Integer)nextIpv4.get(), vnet.getSubnetAddressPrefixLength());
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureVirtualNetworkDescription.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String string) {
        this.id = string;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String string) {
        this.type = string;
    }

    @Generated
    public List<String> getAddressSpace() {
        return this.addressSpace;
    }

    @Generated
    public void setAddressSpace(List<String> list) {
        this.addressSpace = list;
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public void setResourceId(String string) {
        this.resourceId = string;
    }

    @Generated
    public String getResourceGroup() {
        return this.resourceGroup;
    }

    @Generated
    public void setResourceGroup(String string) {
        this.resourceGroup = string;
    }

    @Override
    @Generated
    public Map<String, Object> getTags() {
        return this.tags;
    }

    @Override
    @Generated
    public void setTags(Map<String, Object> map) {
        this.tags = map;
    }

    @Generated
    public List<AzureSubnetDescription> getSubnets() {
        return this.subnets;
    }

    @Generated
    public void setSubnets(List<AzureSubnetDescription> list) {
        this.subnets = list;
    }

    @Generated
    public int getMaxSubnets() {
        return this.maxSubnets;
    }

    @Generated
    public void setMaxSubnets(int n) {
        this.maxSubnets = n;
    }

    @Generated
    public int getSubnetAddressPrefixLength() {
        return this.subnetAddressPrefixLength;
    }

    @Generated
    public void setSubnetAddressPrefixLength(int n) {
        this.subnetAddressPrefixLength = n;
    }
}

