/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.client;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSet;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMs;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.fluent.models.LoadBalancerInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.azure.resourcemanager.network.models.ApplicationGatewayRequestRoutingRule;
import com.azure.resourcemanager.network.models.InboundNatPool;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.azure.resourcemanager.network.models.LoadBalancerInboundNatPool;
import com.azure.resourcemanager.network.models.LoadBalancingRule;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.trafficmanager.models.CheckProfileDnsNameAvailabilityResult;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.azure.client.AzureBaseClient;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.appgateway.model.AzureAppGatewayDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.loadbalancer.model.AzureLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.network.model.AzureVirtualNetworkDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.securitygroup.model.AzureSecurityGroupDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.subnet.model.AzureSubnetDescription;
import com.netflix.spinnaker.clouddriver.azure.templates.AzureAppGatewayResourceTemplate;
import com.netflix.spinnaker.clouddriver.azure.templates.AzureLoadBalancerResourceTemplate;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureNetworkClient
extends AzureBaseClient {
    private final Integer NAT_POOL_PORT_START;
    private final Integer NAT_POOL_PORT_END;
    private final Integer NAT_POOL_PORT_NUMBER_PER_POOL;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AzureNetworkClient(String subscriptionId, TokenCredential credentials, AzureProfile azureProfile) {
        super(subscriptionId, azureProfile, credentials);
        MetaClass metaClass;
        int n = 50000;
        this.NAT_POOL_PORT_START = n;
        int n2 = 59999;
        this.NAT_POOL_PORT_END = n2;
        int n3 = 100;
        this.NAT_POOL_PORT_NUMBER_PER_POOL = n3;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Collection<AzureLoadBalancerDescription> getLoadBalancersAll(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference(new ArrayList());
        try {
            public final class _getLoadBalancersAll_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLoadBalancersAll_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public List<LoadBalancer> doCall(Object it) {
                    return DefaultGroovyMethods.asList((Iterable)((AzureNetworkClient)this.getThisObject()).getAzure().loadBalancers().list());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public List<LoadBalancer> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLoadBalancersAll_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite loadBalancers = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getLoadBalancersAll_closure1(this, this)));
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            CallSite callSite = loadBalancers;
            public final class _getLoadBalancersAll_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLoadBalancersAll_closure2(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((LoadBalancerInner)((LoadBalancer)item).innerModel()).location(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.region.get()))) {
                        AzureLoadBalancerDescription lbItem = AzureLoadBalancerDescription.build((LoadBalancerInner)IndyInterface.bootstrap("cast", "()", 0, ((LoadBalancer)item).innerModel()));
                        if (DefaultTypeTransformation.booleanUnbox((Object)((LoadBalancer)item).publicIpAddressIds()) && !((LoadBalancer)item).publicIpAddressIds().isEmpty()) {
                            List list;
                            String string = ((AzureNetworkClient)this.getThisObject()).getDnsNameForPublicIp(AzureUtilities.getResourceGroupNameFromResourceId(((LoadBalancer)item).id()), AzureUtilities.getNameFromResourceId((String)((Object)IndyInterface.bootstrap("cast", "()", 0, (list = ((LoadBalancer)item).publicIpAddressIds()) != null ? DefaultGroovyMethods.first((List)list) : null))));
                            lbItem.setDnsName(string);
                        }
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                        lbItem.setLastReadTime((Long)((Object)callSite));
                        List list = DefaultGroovyMethods.plus((List)((Object)IndyInterface.bootstrap("cast", "()", 0, this.result.get())), (Object)lbItem);
                        this.result.set((Object)IndyInterface.bootstrap("cast", "()", 0, list));
                        List list2 = list;
                        try {
                            return list2;
                        }
                        catch (RuntimeException re) {
                            Object v0;
                            if (AzureNetworkClient.pfaccess$0(null).isErrorEnabled()) {
                                AzureNetworkClient.pfaccess$0(null).error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((LoadBalancer)item).name(), re.getMessage()}, new String[]{"Unable to process load balancer ", ": ", ""}))));
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                            Object var9_9 = v0;
                            return var9_9;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                }

                @Generated
                public Long getCurrentTime() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                }

                @Generated
                public ArrayList getResult() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.result.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLoadBalancersAll_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            List list = callSite != null ? DefaultGroovyMethods.each((List)((Object)callSite), (Closure)new _getLoadBalancersAll_closure2(this, this, region2, currentTime, result)) : null;
        }
        catch (Exception e) {
            log.error("getLoadBalancersAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public AzureLoadBalancerDescription getLoadBalancer(String resourceGroupName, String loadBalancerName) {
        block7: {
            List list;
            void var2_2;
            Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
            Reference loadBalancerName2 = new Reference((Object)var2_2);
            long currentTime = System.currentTimeMillis();
            public final class _getLoadBalancer_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference resourceGroupName;
                private /* synthetic */ Reference loadBalancerName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLoadBalancer_closure3(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.resourceGroupName = reference2 = resourceGroupName;
                    this.loadBalancerName = reference = loadBalancerName;
                }

                public LoadBalancer doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().loadBalancers().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()))));
                }

                @Generated
                public String getResourceGroupName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
                }

                @Generated
                public String getLoadBalancerName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public LoadBalancer doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLoadBalancer_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite item = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getLoadBalancer_closure3(this, this, resourceGroupName2, loadBalancerName2)));
            CallSite callSite = item;
            if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) == false) break block7;
            AzureLoadBalancerDescription lbItem = AzureLoadBalancerDescription.build((LoadBalancerInner)IndyInterface.bootstrap("cast", "()", 0, item.innerModel()));
            String string = this.getDnsNameForPublicIp(AzureUtilities.getResourceGroupNameFromResourceId(item.id()), AzureUtilities.getNameFromResourceId((String)((Object)IndyInterface.bootstrap("cast", "()", 0, (list = item.publicIpAddressIds()) != null ? DefaultGroovyMethods.first((List)list) : null))));
            lbItem.setDnsName(string);
            long l = currentTime;
            lbItem.setLastReadTime(l);
            AzureLoadBalancerDescription azureLoadBalancerDescription = lbItem;
            try {
                return azureLoadBalancerDescription;
            }
            catch (ManagementException e) {
                if (log.isErrorEnabled()) {
                    log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{(String)resourceGroupName2.get(), (String)loadBalancerName2.get()}, new String[]{"getLoadBalancer(", ",", ") -> Cloud Exception "}))), (Throwable)e);
                    v1 = null;
                } else {
                    v1 = null;
                }
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public Response deleteLoadBalancer(String resourceGroupName, String loadBalancerName) {
        CallSite loadBalancer = IndyInterface.bootstrap("cast", "()", 0, this.getAzure().loadBalancers().getByResourceGroup(resourceGroupName, loadBalancerName));
        CallSite callSite = loadBalancer;
        List list = callSite != null ? callSite.publicIpAddressIds() : null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
            throw (Throwable)new RuntimeException("Unexpected number of public IP addresses associated with the load balancer (should always be only one)!");
        }
        List list2 = loadBalancer.publicIpAddressIds();
        String publicIpAddressName = AzureUtilities.getNameFromResourceId((String)((Object)IndyInterface.bootstrap("cast", "()", 0, list2 != null ? DefaultGroovyMethods.first((List)list2) : null)));
        AzureBaseClient.deleteAzureResource(ScriptBytecodeAdapter.getMethodPointer((Object)this.getAzure().loadBalancers(), (String)"deleteByResourceGroup"), resourceGroupName, loadBalancerName, null, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Delete Load Balancer ", ""}))), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{loadBalancerName, resourceGroupName}, new String[]{"Failed to delete Load Balancer ", " in ", ""}))));
        return this.deletePublicIp(resourceGroupName, publicIpAddressName);
    }

    public Response deletePublicIp(String resourceGroupName, String publicIpName) {
        return AzureBaseClient.deleteAzureResource(ScriptBytecodeAdapter.getMethodPointer((Object)this.getAzure().publicIpAddresses(), (String)"deleteByResourceGroup"), resourceGroupName, publicIpName, null, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{publicIpName}, new String[]{"Delete PublicIp ", ""}))), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{publicIpName, resourceGroupName}, new String[]{"Failed to delete PublicIp ", " in ", ""}))));
    }

    /*
     * WARNING - void declaration
     */
    public AzureAppGatewayDescription getAppGateway(String resourceGroupName, String appGatewayName) {
        block7: {
            void var2_2;
            Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
            Reference appGatewayName2 = new Reference((Object)var2_2);
            long currentTime = System.currentTimeMillis();
            public final class _getAppGateway_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference resourceGroupName;
                private /* synthetic */ Reference appGatewayName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAppGateway_closure4(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.resourceGroupName = reference2 = resourceGroupName;
                    this.appGatewayName = reference = appGatewayName;
                }

                public ApplicationGateway doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().applicationGateways().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get()))));
                }

                @Generated
                public String getResourceGroupName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
                }

                @Generated
                public String getAppGatewayName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public ApplicationGateway doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAppGateway_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite appGateway = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getAppGateway_closure4(this, this, resourceGroupName2, appGatewayName2)));
            CallSite callSite = appGateway;
            if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) == false) break block7;
            AzureAppGatewayDescription agItem = AzureAppGatewayDescription.getDescriptionForAppGateway((ApplicationGatewayInner)IndyInterface.bootstrap("cast", "()", 0, appGateway.innerModel()));
            String string = this.getDnsNameForPublicIp(AzureUtilities.getResourceGroupNameFromResourceId(appGateway.id()), AzureUtilities.getNameFromResourceId(appGateway.defaultPublicFrontend().publicIpAddressId()));
            agItem.setDnsName(string);
            long l = currentTime;
            agItem.setLastReadTime(l);
            AzureAppGatewayDescription azureAppGatewayDescription = agItem;
            try {
                return azureAppGatewayDescription;
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{(String)resourceGroupName2.get(), (String)appGatewayName2.get()}, new String[]{"getAppGateway(", ",", ") -> Exception "}))), (Throwable)e);
                    v1 = null;
                } else {
                    v1 = null;
                }
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public Collection<AzureAppGatewayDescription> getAppGatewaysAll(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0])));
        try {
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            public final class _getAppGatewaysAll_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAppGatewaysAll_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public PagedIterable<ApplicationGateway> doCall(Object it) {
                    return ((AzureNetworkClient)this.getThisObject()).getAzure().applicationGateways().list();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public PagedIterable<ApplicationGateway> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAppGatewaysAll_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite appGateways = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getAppGatewaysAll_closure5(this, this)));
            public final class _getAppGatewaysAll_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAppGatewaysAll_closure6(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((ApplicationGatewayInner)((ApplicationGateway)item).innerModel()).location(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.region.get()))) {
                        AzureAppGatewayDescription agItem = AzureAppGatewayDescription.getDescriptionForAppGateway((ApplicationGatewayInner)IndyInterface.bootstrap("cast", "()", 0, ((ApplicationGateway)item).innerModel()));
                        String string = ((AzureNetworkClient)this.getThisObject()).getDnsNameForPublicIp(AzureUtilities.getResourceGroupNameFromResourceId(((ApplicationGateway)item).id()), AzureUtilities.getNameFromResourceId(((ApplicationGateway)item).defaultPublicFrontend().publicIpAddressId()));
                        agItem.setDnsName(string);
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                        agItem.setLastReadTime((Long)((Object)callSite));
                        List list = DefaultGroovyMethods.leftShift((List)((Object)IndyInterface.bootstrap("cast", "()", 0, this.result.get())), (Object)agItem);
                        try {
                            return list;
                        }
                        catch (RuntimeException re) {
                            Object v0;
                            if (AzureNetworkClient.pfaccess$0(null).isErrorEnabled()) {
                                AzureNetworkClient.pfaccess$0(null).error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((ApplicationGateway)item).name(), re.getMessage()}, new String[]{"Unable to process application gateway ", ": ", ""}))));
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                            Object var7_7 = v0;
                            return var7_7;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                }

                @Generated
                public Long getCurrentTime() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                }

                @Generated
                public ArrayList getResult() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.result.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAppGatewaysAll_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            DefaultGroovyMethods.each((Iterable)((Object)appGateways), (Closure)new _getAppGatewaysAll_closure6(this, this, region2, currentTime, result));
        }
        catch (Exception e) {
            log.error("getAppGatewaysAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public Response deleteAppGateway(String resourceGroupName, String appGatewayName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        Response result = null;
        public final class _deleteAppGateway_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteAppGateway_closure7(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public ApplicationGateway doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().applicationGateways().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public ApplicationGateway doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteAppGateway_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite appGateway = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _deleteAppGateway_closure7(this, this, resourceGroupName2, appGatewayName2)));
        CallSite callSite = appGateway;
        Map map = callSite != null ? callSite.tags() : null;
        if (map != null) {
            map = map.get("cluster");
        }
        if ((map == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, map)) != false) {
            Object[] objectArray = new Object[2];
            objectArray[0] = (String)appGatewayName2.get();
            CallSite callSite2 = appGateway;
            Map map2 = callSite2 != null ? callSite2.tags() : null;
            if (map2 != null) {
                map2 = map2.get("cluster");
            }
            objectArray[1] = map2;
            GStringImpl errMsg = new GStringImpl(objectArray, new String[]{"Failed to delete ", "; the application gateway is still associated with server groups in ", " cluster. Please delete associated server groups before deleting the load balancer."});
            log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
        }
        CallSite callSite3 = appGateway;
        String publicIpAddressName = AzureUtilities.getNameFromResourceId((callSite3 != null ? callSite3.defaultPublicFrontend() : null).publicIpAddressId());
        result = AzureBaseClient.deleteAzureResource(ScriptBytecodeAdapter.getMethodPointer((Object)this.getAzure().applicationGateways(), (String)"deleteByResourceGroup"), (String)resourceGroupName2.get(), (String)appGatewayName2.get(), null, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{(String)appGatewayName2.get()}, new String[]{"Delete Application Gateway ", ""}))), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{(String)appGatewayName2.get(), (String)resourceGroupName2.get()}, new String[]{"Failed to delete Application Gateway ", " in ", ""}))));
        String string = publicIpAddressName;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            result = this.deletePublicIp((String)resourceGroupName2.get(), publicIpAddressName);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public String createAppGatewayBAPforServerGroup(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _createAppGatewayBAPforServerGroup_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createAppGatewayBAPforServerGroup_closure8(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public ApplicationGateway doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().applicationGateways().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public ApplicationGateway doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createAppGatewayBAPforServerGroup_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite appGateway = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _createAppGatewayBAPforServerGroup_closure8(this, this, resourceGroupName2, appGatewayName2)));
        CallSite callSite = appGateway;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
            AzureAppGatewayDescription agDescription = AzureAppGatewayDescription.getDescriptionForAppGateway((ApplicationGatewayInner)IndyInterface.bootstrap("cast", "()", 0, appGateway.innerModel()));
            Names parsedName = Names.parseName((String)serverGroupName);
            AzureAppGatewayDescription azureAppGatewayDescription = agDescription;
            if ((azureAppGatewayDescription == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, azureAppGatewayDescription)) == false || DefaultTypeTransformation.booleanUnbox((Object)agDescription.getCluster()) && ScriptBytecodeAdapter.compareNotEqual((Object)agDescription.getCluster(), (Object)parsedName.getCluster())) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)appGatewayName2.get(), agDescription.getCluster()}, new String[]{"Failed to associate ", " with ", "; expecting server group to be in ", " cluster"});
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            }
            Map map = appGateway.backends();
            Boolean bl = map != null ? Boolean.valueOf(map.containsKey(serverGroupName)) : null;
            if (!(bl == null ? false : bl)) {
                List<String> list = agDescription.getServerGroups();
                if ((list == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, list)) != false) {
                    DefaultGroovyMethods.leftShift(agDescription.getServerGroups(), (Object)serverGroupName);
                } else {
                    List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{serverGroupName});
                    agDescription.setServerGroups(list2);
                }
                ((ApplicationGateway.Update)((ApplicationGateway.Update)((ApplicationGateway.Update)appGateway.update()).withTag("cluster", parsedName.getCluster())).defineBackend(serverGroupName).attach()).apply();
                if (log.isInfoEnabled()) {
                    log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{appGateway.name(), serverGroupName}, new String[]{"Adding backend address pool to ", " for server group ", ""}))));
                    v4 = null;
                } else {
                    v4 = null;
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{appGateway.id(), serverGroupName}, new String[]{"", "/backendAddressPools/", ""}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    /*
     * WARNING - void declaration
     */
    public String removeAppGatewayBAPforServerGroup(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _removeAppGatewayBAPforServerGroup_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeAppGatewayBAPforServerGroup_closure9(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public ApplicationGateway doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().applicationGateways().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public ApplicationGateway doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeAppGatewayBAPforServerGroup_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite appGateway = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _removeAppGatewayBAPforServerGroup_closure9(this, this, resourceGroupName2, appGatewayName2)));
        CallSite callSite = appGateway;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
            AzureAppGatewayDescription agDescription = AzureAppGatewayDescription.getDescriptionForAppGateway((ApplicationGatewayInner)IndyInterface.bootstrap("cast", "()", 0, appGateway.innerModel()));
            AzureAppGatewayDescription azureAppGatewayDescription = agDescription;
            if ((azureAppGatewayDescription == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, azureAppGatewayDescription)) == false) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)appGatewayName2.get(), (String)appGatewayName2.get()}, new String[]{"Failed to disassociate ", " from ", "; could not find ", ""});
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            }
            CallSite agBAP = IndyInterface.bootstrap("cast", "()", 0, appGateway.backends().get(serverGroupName));
            CallSite callSite2 = agBAP;
            if ((callSite2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite2)) != false) {
                Object chain = ((ApplicationGateway.Update)appGateway.update()).withoutBackend(agBAP.name());
                if (appGateway.backends().size() == 1) {
                    chain = IndyInterface.bootstrap("cast", "()", 0, chain.withoutTag("cluster"));
                }
                chain.apply();
            }
            return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{appGateway.id(), serverGroupName}, new String[]{"", "/backendAddressPools/", ""}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    /*
     * WARNING - void declaration
     */
    public String createLoadBalancerAPforServerGroup(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _createLoadBalancerAPforServerGroup_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createLoadBalancerAPforServerGroup_closure10(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public LoadBalancer doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().loadBalancers().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public LoadBalancer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createLoadBalancerAPforServerGroup_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite loadBalancer = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _createLoadBalancerAPforServerGroup_closure10(this, this, resourceGroupName2, loadBalancerName2)));
        CallSite callSite = loadBalancer;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
            Map map = loadBalancer.backends();
            Boolean bl = map != null ? Boolean.valueOf(map.containsKey(serverGroupName)) : null;
            if (!(bl == null ? false : bl)) {
                ((LoadBalancer.Update)((LoadBalancer.Update)loadBalancer.update()).defineBackend(serverGroupName).attach()).apply();
                if (log.isInfoEnabled()) {
                    log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{loadBalancer.name(), serverGroupName}, new String[]{"Adding backend address pool to ", " for server group ", ""}))));
                    v2 = null;
                } else {
                    v2 = null;
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{loadBalancer.id(), serverGroupName}, new String[]{"", "/backendAddressPools/", ""}));
        }
        throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{(String)loadBalancerName2.get(), (String)resourceGroupName2.get()}, new String[]{"Load balancer ", " not found in resource group ", ""}))));
    }

    /*
     * WARNING - void declaration
     */
    public String removeLoadBalancerAPforServerGroup(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _removeLoadBalancerAPforServerGroup_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeLoadBalancerAPforServerGroup_closure11(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public LoadBalancer doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().loadBalancers().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public LoadBalancer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeLoadBalancerAPforServerGroup_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite loadBalancer = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _removeLoadBalancerAPforServerGroup_closure11(this, this, resourceGroupName2, loadBalancerName2)));
        CallSite callSite = loadBalancer;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
            CallSite lbAP = IndyInterface.bootstrap("cast", "()", 0, loadBalancer.backends().get(serverGroupName));
            CallSite callSite2 = lbAP;
            if ((callSite2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite2)) != false) {
                LoadBalancer.Update chain = ((LoadBalancer.Update)loadBalancer.update()).withoutBackend(lbAP.name());
                chain.apply();
            }
            return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{loadBalancer.id(), serverGroupName}, new String[]{"", "/backendAddressPools/", ""}));
        }
        throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{(String)loadBalancerName2.get(), (String)resourceGroupName2.get()}, new String[]{"Load balancer ", " not found in resource group ", ""}))));
    }

    /*
     * Exception decompiling
     */
    public String createLoadBalancerNatPoolPortRangeforServerGroup(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int findUnusedPortsRange(List<int[]> usedList, int start, int end, int targetLength) {
        Object ret = start;
        int retEnd = ret + targetLength;
        if (retEnd > end) {
            return -1;
        }
        List<int[]> list = usedList;
        Iterator<int[]> iterator = list != null ? list.iterator() : null;
        CallSite p = null;
        Iterator<int[]> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                p = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                if (IndyInterface.staticArrayAccess("get", (int[])p, (int)0) > retEnd) {
                    return ret;
                }
                ret = IndyInterface.staticArrayAccess("get", (int[])p, (int)1) + true;
                int cfr_ignored_0 = ret + targetLength;
                if (!(retEnd > end)) continue;
                return -1;
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public String removeLoadBalancerNatPoolPortRangeforServerGroup(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _removeLoadBalancerNatPoolPortRangeforServerGroup_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeLoadBalancerNatPoolPortRangeforServerGroup_closure13(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public LoadBalancer doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().loadBalancers().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public LoadBalancer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeLoadBalancerNatPoolPortRangeforServerGroup_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite loadBalancer = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _removeLoadBalancerNatPoolPortRangeforServerGroup_closure13(this, this, resourceGroupName2, loadBalancerName2)));
        String id = null;
        CallSite callSite = loadBalancer;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
            Map map = loadBalancer.inboundNatPools();
            Boolean bl = map != null ? Boolean.valueOf(map.containsKey(serverGroupName)) : null;
            if (bl == null ? false : bl) {
                id = ((InboundNatPool)((LoadBalancerInboundNatPool)loadBalancer.inboundNatPools().get(serverGroupName)).innerModel()).id();
                ((LoadBalancer.Update)loadBalancer.update()).withoutInboundNatPool(serverGroupName).apply();
            } else {
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{serverGroupName, (String)loadBalancerName2.get()}, new String[]{"Load balancer nat pool ", " not found in load balancer ", ""}))));
            }
        }
        return id;
    }

    /*
     * WARNING - void declaration
     */
    public void enableServerGroupWithAppGateway(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _enableServerGroupWithAppGateway_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _enableServerGroupWithAppGateway_closure14(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public ApplicationGateway doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().applicationGateways().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public ApplicationGateway doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _enableServerGroupWithAppGateway_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference appGateway = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _enableServerGroupWithAppGateway_closure14(this, this, resourceGroupName2, appGatewayName2))));
        ApplicationGateway applicationGateway = (ApplicationGateway)appGateway.get();
        if ((applicationGateway == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, applicationGateway)) != false) {
            Reference agBAP = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ((ApplicationGateway)appGateway.get()).backends().get(serverGroupName)));
            ApplicationGatewayBackend applicationGatewayBackend = (ApplicationGatewayBackend)agBAP.get();
            if ((applicationGatewayBackend == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, applicationGatewayBackend)) == false) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)appGatewayName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            }
            public final class _enableServerGroupWithAppGateway_closure15
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference appGateway;
                private /* synthetic */ Reference agBAP;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _enableServerGroupWithAppGateway_closure15(Object _outerInstance, Object _thisObject, Reference appGateway, Reference agBAP) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.appGateway = reference2 = appGateway;
                    this.agBAP = reference = agBAP;
                }

                public ApplicationGateway doCall(Object name, Object rule) {
                    return IndyInterface.bootstrap("cast", "()", 0, ((ApplicationGateway.Update)((ApplicationGateway.Update)IndyInterface.bootstrap("cast", "()", 0, this.appGateway.get()).update()).updateRequestRoutingRule((String)((Object)IndyInterface.bootstrap("cast", "()", 0, name))).toBackend(IndyInterface.bootstrap("cast", "()", 0, this.agBAP.get()).name()).parent()).apply());
                }

                @Generated
                public ApplicationGateway call(Object name, Object rule) {
                    return this.doCall(name, rule);
                }

                @Generated
                public ApplicationGateway getAppGateway() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.appGateway.get());
                }

                @Generated
                public ApplicationGatewayBackend getAgBAP() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.agBAP.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _enableServerGroupWithAppGateway_closure15.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            DefaultGroovyMethods.each((Map)((ApplicationGateway)appGateway.get()).requestRoutingRules(), (Closure)new _enableServerGroupWithAppGateway_closure15(this, this, appGateway, agBAP));
            ((ApplicationGateway.Update)((ApplicationGateway.Update)((ApplicationGateway)appGateway.get()).update()).withTag("trafficEnabledSG", serverGroupName)).apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void disableServerGroup(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _disableServerGroup_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _disableServerGroup_closure16(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public ApplicationGateway doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().applicationGateways().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public ApplicationGateway doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _disableServerGroup_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference appGateway = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _disableServerGroup_closure16(this, this, resourceGroupName2, appGatewayName2))));
        ApplicationGateway applicationGateway = (ApplicationGateway)appGateway.get();
        if ((applicationGateway == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, applicationGateway)) != false) {
            Reference defaultBAP = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ((ApplicationGateway)appGateway.get()).backends().get(AzureAppGatewayResourceTemplate.getDefaultAppGatewayBeAddrPoolName())));
            ApplicationGatewayBackend applicationGatewayBackend = (ApplicationGatewayBackend)defaultBAP.get();
            if ((applicationGatewayBackend == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, applicationGatewayBackend)) == false) {
                GStringImpl errMsg = new GStringImpl(new Object[]{AzureAppGatewayResourceTemplate.getDefaultAppGatewayBeAddrPoolName(), (String)appGatewayName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            }
            Reference agBAP = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ((ApplicationGateway)appGateway.get()).backends().get(serverGroupName)));
            ApplicationGatewayBackend applicationGatewayBackend2 = (ApplicationGatewayBackend)agBAP.get();
            if ((applicationGatewayBackend2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, applicationGatewayBackend2)) == false) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)appGatewayName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            }
            Map map = ((ApplicationGateway)appGateway.get()).requestRoutingRules();
            public final class _disableServerGroup_closure17
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference agBAP;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _disableServerGroup_closure17(Object _outerInstance, Object _thisObject, Reference agBAP) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.agBAP = reference = agBAP;
                }

                public Boolean doCall(Object name, Object rule) {
                    return ScriptBytecodeAdapter.compareEqual((Object)((ApplicationGatewayRequestRoutingRule)rule).backend(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.agBAP.get()));
                }

                @Generated
                public Boolean call(Object name, Object rule) {
                    return this.doCall(name, rule);
                }

                @Generated
                public ApplicationGatewayBackend getAgBAP() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.agBAP.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _disableServerGroup_closure17.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Map requestedRoutingRules = map != null ? DefaultGroovyMethods.findAll((Map)map, (Closure)new _disableServerGroup_closure17(this, this, agBAP)) : null;
            Map map2 = requestedRoutingRules;
            if ((map2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, map2)) != false) {
                public final class _disableServerGroup_closure18
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference appGateway;
                    private /* synthetic */ Reference defaultBAP;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _disableServerGroup_closure18(Object _outerInstance, Object _thisObject, Reference appGateway, Reference defaultBAP) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.appGateway = reference2 = appGateway;
                        this.defaultBAP = reference = defaultBAP;
                    }

                    public ApplicationGateway doCall(Object name, Object rule) {
                        return IndyInterface.bootstrap("cast", "()", 0, ((ApplicationGateway.Update)((ApplicationGateway.Update)IndyInterface.bootstrap("cast", "()", 0, this.appGateway.get()).update()).updateRequestRoutingRule((String)((Object)IndyInterface.bootstrap("cast", "()", 0, name))).toBackend(IndyInterface.bootstrap("cast", "()", 0, this.defaultBAP.get()).name()).parent()).apply());
                    }

                    @Generated
                    public ApplicationGateway call(Object name, Object rule) {
                        return this.doCall(name, rule);
                    }

                    @Generated
                    public ApplicationGateway getAppGateway() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.appGateway.get());
                    }

                    @Generated
                    public ApplicationGatewayBackend getDefaultBAP() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.defaultBAP.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _disableServerGroup_closure18.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                DefaultGroovyMethods.each((Map)requestedRoutingRules, (Closure)new _disableServerGroup_closure18(this, this, appGateway, defaultBAP));
                ((ApplicationGateway.Update)((ApplicationGateway.Update)((ApplicationGateway)appGateway.get()).update()).withoutTag("trafficEnabledSG")).apply();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Boolean isServerGroupWithoutLoadBalancerDisabled(String resourceGroupName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference serverGroupName2 = new Reference((Object)var2_2);
        public final class _isServerGroupWithoutLoadBalancerDisabled_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference serverGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isServerGroupWithoutLoadBalancerDisabled_closure19(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference serverGroupName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.serverGroupName = reference = serverGroupName;
            }

            public VirtualMachineScaleSet doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().virtualMachineScaleSets().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getServerGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public VirtualMachineScaleSet doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isServerGroupWithoutLoadBalancerDisabled_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite scaleSet = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _isServerGroupWithoutLoadBalancerDisabled_closure19(this, this, resourceGroupName2, serverGroupName2)));
        VirtualMachineScaleSetVMs machines = scaleSet.virtualMachines();
        return DefaultGroovyMethods.size((Iterable)machines.list()) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public Boolean isServerGroupWithAppGatewayDisabled(String resourceGroupName, String appGatewayName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference appGatewayName2 = new Reference((Object)var2_2);
        public final class _isServerGroupWithAppGatewayDisabled_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference appGatewayName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isServerGroupWithAppGatewayDisabled_closure20(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference appGatewayName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.appGatewayName = reference = appGatewayName;
            }

            public ApplicationGateway doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().applicationGateways().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getAppGatewayName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.appGatewayName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public ApplicationGateway doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isServerGroupWithAppGatewayDisabled_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite appGateway = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _isServerGroupWithAppGatewayDisabled_closure20(this, this, resourceGroupName2, appGatewayName2)));
        CallSite callSite = appGateway;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
            Reference agBAP = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, appGateway.backends().get(serverGroupName)));
            ApplicationGatewayBackend applicationGatewayBackend = (ApplicationGatewayBackend)agBAP.get();
            if ((applicationGatewayBackend == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, applicationGatewayBackend)) != false) {
                Map map = appGateway.requestRoutingRules();
                public final class _isServerGroupWithAppGatewayDisabled_closure21
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference agBAP;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _isServerGroupWithAppGatewayDisabled_closure21(Object _outerInstance, Object _thisObject, Reference agBAP) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.agBAP = reference = agBAP;
                    }

                    public Boolean doCall(Object name, Object rule) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((ApplicationGatewayRequestRoutingRule)rule).backend(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.agBAP.get()));
                    }

                    @Generated
                    public Boolean call(Object name, Object rule) {
                        return this.doCall(name, rule);
                    }

                    @Generated
                    public ApplicationGatewayBackend getAgBAP() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.agBAP.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _isServerGroupWithAppGatewayDisabled_closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Map.Entry requestedRoutingRules = map != null ? DefaultGroovyMethods.find((Map)map, (Closure)new _isServerGroupWithAppGatewayDisabled_closure21(this, this, agBAP)) : null;
                if (requestedRoutingRules != null) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void enableServerGroupWithLoadBalancer(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var3_3;
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        Reference serverGroupName2 = new Reference((Object)var3_3);
        public final class _enableServerGroupWithLoadBalancer_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _enableServerGroupWithLoadBalancer_closure22(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public LoadBalancer doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().loadBalancers().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public LoadBalancer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _enableServerGroupWithLoadBalancer_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference loadBalancer = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _enableServerGroupWithLoadBalancer_closure22(this, this, resourceGroupName2, loadBalancerName2))));
        LoadBalancer loadBalancer2 = (LoadBalancer)loadBalancer.get();
        if ((loadBalancer2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, loadBalancer2)) != false) {
            CallSite lbBAP = IndyInterface.bootstrap("cast", "()", 0, ((LoadBalancer)loadBalancer.get()).backends().get((String)serverGroupName2.get()));
            CallSite callSite = lbBAP;
            if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) == false) {
                GStringImpl errMsg = new GStringImpl(new Object[]{(String)serverGroupName2.get(), (String)loadBalancerName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            }
            public final class _enableServerGroupWithLoadBalancer_closure23
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancer;
                private /* synthetic */ Reference serverGroupName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _enableServerGroupWithLoadBalancer_closure23(Object _outerInstance, Object _thisObject, Reference loadBalancer, Reference serverGroupName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.loadBalancer = reference2 = loadBalancer;
                    this.serverGroupName = reference = serverGroupName;
                }

                /*
                 * Exception decompiling
                 */
                public LoadBalancer doCall(Object name, Object rule) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Generated
                public LoadBalancer call(Object name, Object rule) {
                    return this.doCall(name, rule);
                }

                @Generated
                public LoadBalancer getLoadBalancer() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
                }

                @Generated
                public String getServerGroupName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _enableServerGroupWithLoadBalancer_closure23.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            DefaultGroovyMethods.each((Map)((LoadBalancer)loadBalancer.get()).loadBalancingRules(), (Closure)new _enableServerGroupWithLoadBalancer_closure23(this, this, loadBalancer, serverGroupName2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void disableServerGroupWithLoadBalancer(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _disableServerGroupWithLoadBalancer_closure24
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _disableServerGroupWithLoadBalancer_closure24(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public LoadBalancer doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().loadBalancers().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public LoadBalancer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _disableServerGroupWithLoadBalancer_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference loadBalancer = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _disableServerGroupWithLoadBalancer_closure24(this, this, resourceGroupName2, loadBalancerName2))));
        LoadBalancer loadBalancer2 = (LoadBalancer)loadBalancer.get();
        if ((loadBalancer2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, loadBalancer2)) != false) {
            CallSite defaultBAP = IndyInterface.bootstrap("cast", "()", 0, ((LoadBalancer)loadBalancer.get()).backends().get(AzureLoadBalancerResourceTemplate.getDEFAULT_BACKEND_POOL()));
            CallSite callSite = defaultBAP;
            if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) == false) {
                GStringImpl errMsg = new GStringImpl(new Object[]{AzureLoadBalancerResourceTemplate.getDEFAULT_BACKEND_POOL(), (String)loadBalancerName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            }
            Reference lbBAP = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ((LoadBalancer)loadBalancer.get()).backends().get(serverGroupName)));
            LoadBalancerBackend loadBalancerBackend = (LoadBalancerBackend)lbBAP.get();
            if ((loadBalancerBackend == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, loadBalancerBackend)) == false) {
                GStringImpl errMsg = new GStringImpl(new Object[]{serverGroupName, (String)loadBalancerName2.get()}, new String[]{"Backend address pool ", " not found in ", ""});
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
                throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, errMsg)));
            }
            Map map = ((LoadBalancer)loadBalancer.get()).loadBalancingRules();
            public final class _disableServerGroupWithLoadBalancer_closure25
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference lbBAP;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _disableServerGroupWithLoadBalancer_closure25(Object _outerInstance, Object _thisObject, Reference lbBAP) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.lbBAP = reference = lbBAP;
                }

                public Boolean doCall(Object name, Object rule) {
                    return ScriptBytecodeAdapter.compareEqual((Object)((LoadBalancingRule)rule).backend(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.lbBAP.get()));
                }

                @Generated
                public Boolean call(Object name, Object rule) {
                    return this.doCall(name, rule);
                }

                @Generated
                public LoadBalancerBackend getLbBAP() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.lbBAP.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _disableServerGroupWithLoadBalancer_closure25.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Map requestedRoutingRules = map != null ? DefaultGroovyMethods.findAll((Map)map, (Closure)new _disableServerGroupWithLoadBalancer_closure25(this, this, lbBAP)) : null;
            Map map2 = requestedRoutingRules;
            if ((map2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, map2)) != false) {
                public final class _disableServerGroupWithLoadBalancer_closure26
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference loadBalancer;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _disableServerGroupWithLoadBalancer_closure26(Object _outerInstance, Object _thisObject, Reference loadBalancer) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.loadBalancer = reference = loadBalancer;
                    }

                    /*
                     * Exception decompiling
                     */
                    public LoadBalancer doCall(Object name, Object rule) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }

                    @Generated
                    public LoadBalancer call(Object name, Object rule) {
                        return this.doCall(name, rule);
                    }

                    @Generated
                    public LoadBalancer getLoadBalancer() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _disableServerGroupWithLoadBalancer_closure26.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                DefaultGroovyMethods.each((Map)requestedRoutingRules, (Closure)new _disableServerGroupWithLoadBalancer_closure26(this, this, loadBalancer));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Boolean isServerGroupWithLoadBalancerDisabled(String resourceGroupName, String loadBalancerName, String serverGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference loadBalancerName2 = new Reference((Object)var2_2);
        public final class _isServerGroupWithLoadBalancerDisabled_closure27
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isServerGroupWithLoadBalancerDisabled_closure27(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference loadBalancerName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public LoadBalancer doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().loadBalancers().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public LoadBalancer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isServerGroupWithLoadBalancerDisabled_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite loadBalancer = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _isServerGroupWithLoadBalancerDisabled_closure27(this, this, resourceGroupName2, loadBalancerName2)));
        CallSite callSite = loadBalancer;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) != false) {
            Reference lbBAP = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, loadBalancer.backends().get(serverGroupName)));
            LoadBalancerBackend loadBalancerBackend = (LoadBalancerBackend)lbBAP.get();
            if ((loadBalancerBackend == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, loadBalancerBackend)) != false) {
                Map map = loadBalancer.loadBalancingRules();
                public final class _isServerGroupWithLoadBalancerDisabled_closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference lbBAP;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _isServerGroupWithLoadBalancerDisabled_closure28(Object _outerInstance, Object _thisObject, Reference lbBAP) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.lbBAP = reference = lbBAP;
                    }

                    public Boolean doCall(Object name, Object rule) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((LoadBalancingRule)rule).backend(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.lbBAP.get()));
                    }

                    @Generated
                    public Boolean call(Object name, Object rule) {
                        return this.doCall(name, rule);
                    }

                    @Generated
                    public LoadBalancerBackend getLbBAP() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.lbBAP.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _isServerGroupWithLoadBalancerDisabled_closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Map.Entry requestedRoutingRules = map != null ? DefaultGroovyMethods.find((Map)map, (Closure)new _isServerGroupWithLoadBalancerDisabled_closure28(this, this, lbBAP)) : null;
                if (requestedRoutingRules != null) {
                    return false;
                }
            }
        }
        return true;
    }

    public Response deleteSecurityGroup(String resourceGroupName, String securityGroupName) {
        List associatedSubnets = ((NetworkSecurityGroup)this.getAzure().networkSecurityGroups().getByResourceGroup(resourceGroupName, securityGroupName)).listAssociatedSubnets();
        List list = associatedSubnets;
        public final class _deleteSecurityGroup_closure29
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteSecurityGroup_closure29(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Network doCall(Object associatedSubnet) {
                String subnetName = ((SubnetInner)((Subnet)associatedSubnet).innerModel()).name();
                return IndyInterface.bootstrap("cast", "()", 0, ((Network.Update)((Network.Update)((Network)((Subnet)associatedSubnet).parent()).update()).updateSubnet(subnetName).withoutNetworkSecurityGroup().parent()).apply());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteSecurityGroup_closure29.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each((List)list, (Closure)new _deleteSecurityGroup_closure29(this, this)) : null;
        return AzureBaseClient.deleteAzureResource(ScriptBytecodeAdapter.getMethodPointer((Object)this.getAzure().networkSecurityGroups(), (String)"deleteByResourceGroup"), resourceGroupName, securityGroupName, null, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{securityGroupName}, new String[]{"Delete Security Group ", ""}))), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{securityGroupName, resourceGroupName}, new String[]{"Failed to delete Security Group ", " in ", ""}))));
    }

    public void createVirtualNetwork(String resourceGroupName, String virtualNetworkName, String region, String addressPrefix) {
        try {
            ((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.getAzure().networks().define(virtualNetworkName)).withRegion(region)).withExistingResourceGroup(resourceGroupName)).withAddressSpace(addressPrefix).create();
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{virtualNetworkName, resourceGroupName}, new String[]{"Unable to create Virtual network ", " in Resource Group ", ""}))), (Throwable)((Object)IndyInterface.bootstrap("cast", "()", 0, e)));
        }
    }

    public String createSubnet(String resourceGroupName, String virtualNetworkName, String subnetName, String addressPrefix, String securityGroupName) {
        CallSite virtualNetwork = IndyInterface.bootstrap("cast", "()", 0, this.getAzure().networks().getByResourceGroup(resourceGroupName, virtualNetworkName));
        if (virtualNetwork == null) {
            GStringImpl error = new GStringImpl(new Object[]{virtualNetwork, subnetName}, new String[]{"Virtual network: ", " not found when creating subnet: ", ""});
            log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, error)));
            throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, error)));
        }
        Subnet.UpdateDefinitionStages.WithAttach chain = ((Network.Update)virtualNetwork.update()).defineSubnet(subnetName).withAddressPrefix(addressPrefix);
        String string = securityGroupName;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            CallSite sg = IndyInterface.bootstrap("cast", "()", 0, this.getAzure().networkSecurityGroups().getByResourceGroup(resourceGroupName, securityGroupName));
            chain.withExistingNetworkSecurityGroup((NetworkSecurityGroup)sg);
        }
        ((Network.Update)chain.attach()).apply();
        return ((SubnetInner)((Subnet)virtualNetwork.subnets().get(subnetName)).innerModel()).id();
    }

    public Response<Void> deleteSubnet(String resourceGroupName, String virtualNetworkName, String subnetName) {
        public final class _deleteSubnet_closure30
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteSubnet_closure30(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Network doCall(String _resourceGroupName, String _subnetName, String _virtualNetworkName) {
                return IndyInterface.bootstrap("cast", "()", 0, ((Network.Update)((Network)((AzureNetworkClient)this.getThisObject()).getAzure().networks().getByResourceGroup(_resourceGroupName, _virtualNetworkName)).update()).withoutSubnet(_subnetName).apply());
            }

            @Generated
            public Network call(String _resourceGroupName, String _subnetName, String _virtualNetworkName) {
                return this.doCall(_resourceGroupName, _subnetName, _virtualNetworkName);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteSubnet_closure30.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return AzureBaseClient.deleteAzureResource(new _deleteSubnet_closure30(this, this), resourceGroupName, subnetName, virtualNetworkName, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{subnetName}, new String[]{"Delete subnet ", ""}))), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{subnetName, resourceGroupName}, new String[]{"Failed to delete subnet ", " in ", ""}))));
    }

    public Collection<AzureSecurityGroupDescription> getNetworkSecurityGroupsAll(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference(new ArrayList());
        try {
            public final class _getNetworkSecurityGroupsAll_closure31
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getNetworkSecurityGroupsAll_closure31(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public PagedIterable<NetworkSecurityGroup> doCall(Object it) {
                    return ((AzureNetworkClient)this.getThisObject()).getAzure().networkSecurityGroups().list();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public PagedIterable<NetworkSecurityGroup> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getNetworkSecurityGroupsAll_closure31.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite securityGroups = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getNetworkSecurityGroupsAll_closure31(this, this)));
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            CallSite callSite = securityGroups;
            public final class _getNetworkSecurityGroupsAll_closure32
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getNetworkSecurityGroupsAll_closure32(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((NetworkSecurityGroupInner)((NetworkSecurityGroup)item).innerModel()).location(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.region.get()))) {
                        AzureSecurityGroupDescription sgItem = AzureNetworkClient.getAzureSecurityGroupDescription((NetworkSecurityGroupInner)IndyInterface.bootstrap("cast", "()", 0, ((NetworkSecurityGroup)item).innerModel()));
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                        sgItem.setLastReadTime((Long)((Object)callSite));
                        List list = DefaultGroovyMethods.plus((List)((Object)IndyInterface.bootstrap("cast", "()", 0, this.result.get())), (Object)sgItem);
                        this.result.set((Object)IndyInterface.bootstrap("cast", "()", 0, list));
                        List list2 = list;
                        try {
                            return list2;
                        }
                        catch (RuntimeException re) {
                            Object v0;
                            if (AzureNetworkClient.pfaccess$0(null).isErrorEnabled()) {
                                AzureNetworkClient.pfaccess$0(null).error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((NetworkSecurityGroup)item).name(), re.getMessage()}, new String[]{"Unable to process network security group ", ": ", ""}))));
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                            Object var7_7 = v0;
                            return var7_7;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                }

                @Generated
                public Long getCurrentTime() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                }

                @Generated
                public ArrayList getResult() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.result.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getNetworkSecurityGroupsAll_closure32.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Iterable iterable = callSite != null ? DefaultGroovyMethods.each((Iterable)((Object)callSite), (Closure)new _getNetworkSecurityGroupsAll_closure32(this, this, region2, currentTime, result)) : null;
        }
        catch (Exception e) {
            log.error("getNetworkSecurityGroupsAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public AzureSecurityGroupDescription getNetworkSecurityGroup(String resourceGroupName, String securityGroupName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference securityGroupName2 = new Reference((Object)var2_2);
        public final class _getNetworkSecurityGroup_closure33
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference securityGroupName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getNetworkSecurityGroup_closure33(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference securityGroupName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.securityGroupName = reference = securityGroupName;
            }

            public NetworkSecurityGroup doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().networkSecurityGroups().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.securityGroupName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getSecurityGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.securityGroupName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public NetworkSecurityGroup doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNetworkSecurityGroup_closure33.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite securityGroup = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getNetworkSecurityGroup_closure33(this, this, resourceGroupName2, securityGroupName2)));
        long currentTime = System.currentTimeMillis();
        AzureSecurityGroupDescription sgItem = AzureNetworkClient.getAzureSecurityGroupDescription((NetworkSecurityGroupInner)IndyInterface.bootstrap("cast", "()", 0, securityGroup.innerModel()));
        long l = currentTime;
        sgItem.setLastReadTime(l);
        AzureSecurityGroupDescription azureSecurityGroupDescription = sgItem;
        try {
            return azureSecurityGroupDescription;
        }
        catch (Exception e) {
            log.error("getNetworkSecurityGroupsAll -> Unexpected exception ", (Throwable)e);
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private static AzureSecurityGroupDescription getAzureSecurityGroupDescription(NetworkSecurityGroupInner item) {
        Reference sgItem = new Reference((Object)new AzureSecurityGroupDescription());
        String string = item.name();
        ((AzureSecurityGroupDescription)sgItem.get()).setName(string);
        String string2 = item.name();
        ((AzureSecurityGroupDescription)sgItem.get()).setId(string2);
        String string3 = item.location();
        ((AzureSecurityGroupDescription)sgItem.get()).setLocation(string3);
        String string4 = item.name();
        ((AzureSecurityGroupDescription)sgItem.get()).setRegion(string4);
        String string5 = "azure";
        ((AzureSecurityGroupDescription)sgItem.get()).setCloudProvider(string5);
        ProvisioningState provisioningState = item.provisioningState();
        ((AzureSecurityGroupDescription)sgItem.get()).setProvisioningState((String)((Object)IndyInterface.bootstrap("cast", "()", 0, provisioningState)));
        String string6 = item.id();
        ((AzureSecurityGroupDescription)sgItem.get()).setResourceGuid(string6);
        String string7 = item.id();
        ((AzureSecurityGroupDescription)sgItem.get()).setResourceId(string7);
        ((AzureSecurityGroupDescription)sgItem.get()).getTags().putAll(item.tags());
        Names parsedName = Names.parseName((String)item.name());
        Map map = item.tags();
        if (map != null) {
            map = map.get("stack");
        }
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, map);
        Object object = IndyInterface.bootstrap("cast", "()", 0, map) != false ? callSite : parsedName.getStack();
        ((AzureSecurityGroupDescription)sgItem.get()).setStack((String)object);
        Map map2 = item.tags();
        if (map2 != null) {
            map2 = map2.get("detail");
        }
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, map2);
        Object object2 = IndyInterface.bootstrap("cast", "()", 0, map2) != false ? callSite2 : parsedName.getDetail();
        ((AzureSecurityGroupDescription)sgItem.get()).setDetail((String)object2);
        Map map3 = item.tags();
        if (map3 != null) {
            map3 = map3.get("appName");
        }
        CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, map3);
        Object object3 = IndyInterface.bootstrap("cast", "()", 0, map3) != false ? callSite3 : parsedName.getApp();
        ((AzureSecurityGroupDescription)sgItem.get()).setAppName((String)object3);
        Map map4 = item.tags();
        if (map4 != null) {
            map4 = map4.get("createdTime");
        }
        Map map5 = map4;
        Long l = map4 != null ? StringGroovyMethods.toLong((CharSequence)((Object)IndyInterface.bootstrap("cast", "()", 0, map5))) : null;
        ((AzureSecurityGroupDescription)sgItem.get()).setCreatedTime(l);
        String string8 = item.type();
        ((AzureSecurityGroupDescription)sgItem.get()).setType(string8);
        ArrayList<AzureSecurityGroupDescription.AzureSGRule> arrayList = new ArrayList<AzureSecurityGroupDescription.AzureSGRule>();
        ((AzureSecurityGroupDescription)sgItem.get()).setSecurityRules(arrayList);
        public final class _getAzureSecurityGroupDescription_closure34
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sgItem;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAzureSecurityGroupDescription_closure34(Object _outerInstance, Object _thisObject, Reference sgItem) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.sgItem = reference = sgItem;
            }

            public List<AzureSecurityGroupDescription.AzureSGRule> doCall(Object rule) {
                String string;
                String string2;
                List<AzureSecurityGroupDescription.AzureSGRule> list = ((AzureSecurityGroupDescription)((Object)IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get()))).getSecurityRules();
                AzureSecurityGroupDescription.AzureSGRule azureSGRule = new AzureSecurityGroupDescription.AzureSGRule();
                String string3 = ((SecurityRuleInner)rule).id();
                azureSGRule.setResourceId(string3);
                String string4 = ((SecurityRuleInner)rule).name();
                azureSGRule.setId(string4);
                String string5 = ((SecurityRuleInner)rule).name();
                azureSGRule.setName(string5);
                String string6 = ((SecurityRuleInner)rule).access().toString();
                azureSGRule.setAccess(string6);
                Integer n = ((SecurityRuleInner)rule).priority();
                azureSGRule.setPriority(n);
                String string7 = ((SecurityRuleInner)rule).protocol().toString();
                azureSGRule.setProtocol(string7);
                String string8 = ((SecurityRuleInner)rule).direction().toString();
                azureSGRule.setDirection(string8);
                String string9 = ((SecurityRuleInner)rule).destinationAddressPrefix();
                azureSGRule.setDestinationAddressPrefix(string9);
                String string10 = ((SecurityRuleInner)rule).destinationPortRange();
                azureSGRule.setDestinationPortRange(string10);
                List list2 = ((SecurityRuleInner)rule).destinationPortRanges();
                azureSGRule.setDestinationPortRanges(list2);
                String string11 = ((SecurityRuleInner)rule).destinationPortRange();
                if ((string11 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string11)) != false) {
                    string2 = ((SecurityRuleInner)rule).destinationPortRange();
                } else {
                    List list3 = ((SecurityRuleInner)rule).destinationPortRanges();
                    String string12 = list3 != null ? list3.toString() : null;
                    string2 = string12 != null ? string12.replaceAll("[^(0-9),-]", "") : null;
                }
                String string13 = string2;
                azureSGRule.setDestinationPortRangeModel(string13);
                String string14 = ((SecurityRuleInner)rule).sourceAddressPrefix();
                azureSGRule.setSourceAddressPrefix(string14);
                List list4 = ((SecurityRuleInner)rule).sourceAddressPrefixes();
                azureSGRule.setSourceAddressPrefixes(list4);
                String string15 = ((SecurityRuleInner)rule).sourceAddressPrefix();
                if ((string15 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string15)) != false) {
                    string = ((SecurityRuleInner)rule).sourceAddressPrefix();
                } else {
                    List list5 = ((SecurityRuleInner)rule).sourceAddressPrefixes();
                    String string16 = list5 != null ? list5.toString() : null;
                    string = string16 != null ? string16.replaceAll("[^(0-9a-zA-Z)./,:]", "") : null;
                }
                String string17 = string;
                azureSGRule.setSourceAddressPrefixModel(string17);
                String string18 = ((SecurityRuleInner)rule).sourcePortRange();
                azureSGRule.setSourcePortRange(string18);
                List list6 = DefaultGroovyMethods.plus(list, (Object)azureSGRule);
                ((AzureSecurityGroupDescription)((Object)IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get()))).setSecurityRules(list6);
                return list6;
            }

            @Generated
            public AzureSecurityGroupDescription getSgItem() {
                return IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAzureSecurityGroupDescription_closure34.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        DefaultGroovyMethods.each((List)item.securityRules(), (Closure)new _getAzureSecurityGroupDescription_closure34(AzureNetworkClient.class, AzureNetworkClient.class, sgItem));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ((AzureSecurityGroupDescription)sgItem.get()).setSubnets(arrayList2);
        List list = item.subnets();
        public final class _getAzureSecurityGroupDescription_closure35
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sgItem;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAzureSecurityGroupDescription_closure35(Object _outerInstance, Object _thisObject, Reference sgItem) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.sgItem = reference = sgItem;
            }

            public List<String> doCall(Object it) {
                List list = DefaultGroovyMethods.plus(((AzureSecurityGroupDescription)((Object)IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get()))).getSubnets(), (Object)AzureUtilities.getNameFromResourceId(((SubnetInner)it).id()));
                ((AzureSecurityGroupDescription)((Object)IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get()))).setSubnets(list);
                return list;
            }

            @Generated
            public AzureSecurityGroupDescription getSgItem() {
                return IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public List<String> doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAzureSecurityGroupDescription_closure35.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each((List)list, (Closure)new _getAzureSecurityGroupDescription_closure35(AzureNetworkClient.class, AzureNetworkClient.class, sgItem)) : null;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ((AzureSecurityGroupDescription)sgItem.get()).setNetworkInterfaces(arrayList3);
        List list3 = item.networkInterfaces();
        public final class _getAzureSecurityGroupDescription_closure36
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sgItem;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAzureSecurityGroupDescription_closure36(Object _outerInstance, Object _thisObject, Reference sgItem) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.sgItem = reference = sgItem;
            }

            public List<String> doCall(Object it) {
                List list = DefaultGroovyMethods.plus(((AzureSecurityGroupDescription)((Object)IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get()))).getNetworkInterfaces(), (Object)((NetworkInterfaceInner)it).id());
                ((AzureSecurityGroupDescription)((Object)IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get()))).setNetworkInterfaces(list);
                return list;
            }

            @Generated
            public AzureSecurityGroupDescription getSgItem() {
                return IndyInterface.bootstrap("cast", "()", 0, this.sgItem.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public List<String> doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAzureSecurityGroupDescription_closure36.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        List list4 = list3 != null ? DefaultGroovyMethods.each((List)list3, (Closure)new _getAzureSecurityGroupDescription_closure36(AzureNetworkClient.class, AzureNetworkClient.class, sgItem)) : null;
        return (AzureSecurityGroupDescription)sgItem.get();
    }

    public Collection<AzureSubnetDescription> getSubnetsInRegion(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference(new ArrayList());
        try {
            public final class _getSubnetsInRegion_closure37
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSubnetsInRegion_closure37(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public PagedIterable<Network> doCall(Object it) {
                    return ((AzureNetworkClient)this.getThisObject()).getAzure().networks().list();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public PagedIterable<Network> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSubnetsInRegion_closure37.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite vnets = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getSubnetsInRegion_closure37(this, this)));
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            CallSite callSite = vnets;
            public final class _getSubnetsInRegion_closure38
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSubnetsInRegion_closure38(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((VirtualNetworkInner)((Network)item).innerModel()).location(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.region.get()))) {
                        public final class _closure43
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference currentTime;
                            private /* synthetic */ Reference result;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure43(Object _outerInstance, Object _thisObject, Reference currentTime, Reference result) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.currentTime = reference2 = currentTime;
                                this.result = reference = result;
                            }

                            public ArrayList<AzureSubnetDescription> doCall(AzureSubnetDescription subnet) {
                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                                subnet.setLastReadTime((Long)((Object)callSite));
                                List list = DefaultGroovyMethods.plus((List)((Object)IndyInterface.bootstrap("cast", "()", 0, this.result.get())), (Object)subnet);
                                this.result.set((Object)IndyInterface.bootstrap("cast", "()", 0, list));
                                return IndyInterface.bootstrap("cast", "()", 0, list);
                            }

                            @Generated
                            public ArrayList<AzureSubnetDescription> call(AzureSubnetDescription subnet) {
                                return this.doCall(subnet);
                            }

                            @Generated
                            public Long getCurrentTime() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                            }

                            @Generated
                            public ArrayList getResult() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.result.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure43.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        Collection collection = DefaultGroovyMethods.each(AzureSubnetDescription.getSubnetsForVirtualNetwork((VirtualNetworkInner)IndyInterface.bootstrap("cast", "()", 0, ((Network)item).innerModel())), (Closure)new _closure43((Object)this, this.getThisObject(), this.currentTime, this.result));
                        try {
                            return collection;
                        }
                        catch (RuntimeException re) {
                            Object v0;
                            if (AzureNetworkClient.pfaccess$0(null).isErrorEnabled()) {
                                AzureNetworkClient.pfaccess$0(null).error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((Network)item).name()}, new String[]{"Unable to process subnets for virtual network ", ""}))), (Throwable)re);
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                            Object var4_4 = v0;
                            return var4_4;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                }

                @Generated
                public Long getCurrentTime() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                }

                @Generated
                public ArrayList getResult() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.result.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSubnetsInRegion_closure38.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Iterable iterable = callSite != null ? DefaultGroovyMethods.each((Iterable)((Object)callSite), (Closure)new _getSubnetsInRegion_closure38(this, this, region2, currentTime, result)) : null;
        }
        catch (Exception e) {
            log.error("getSubnetsAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public Network getVirtualNetwork(String resourceGroupName, String virtualNetworkName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference virtualNetworkName2 = new Reference((Object)var2_2);
        public final class _getVirtualNetwork_closure39
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference virtualNetworkName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getVirtualNetwork_closure39(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference virtualNetworkName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.virtualNetworkName = reference = virtualNetworkName;
            }

            public Network doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().networks().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.virtualNetworkName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getVirtualNetworkName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.virtualNetworkName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Network doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getVirtualNetwork_closure39.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getVirtualNetwork_closure39(this, this, resourceGroupName2, virtualNetworkName2)));
    }

    public Collection<AzureVirtualNetworkDescription> getVirtualNetworksAll(String region) {
        Reference region2 = new Reference((Object)region);
        Reference result = new Reference(new ArrayList());
        try {
            public final class _getVirtualNetworksAll_closure40
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getVirtualNetworksAll_closure40(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public PagedIterable<Network> doCall(Object it) {
                    return ((AzureNetworkClient)this.getThisObject()).getAzure().networks().list();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public PagedIterable<Network> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getVirtualNetworksAll_closure40.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite vnetList = IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getVirtualNetworksAll_closure40(this, this)));
            Reference currentTime = new Reference((Object)System.currentTimeMillis());
            CallSite callSite = vnetList;
            public final class _getVirtualNetworksAll_closure41
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference currentTime;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getVirtualNetworksAll_closure41(Object _outerInstance, Object _thisObject, Reference region, Reference currentTime, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.region = reference3 = region;
                    this.currentTime = reference2 = currentTime;
                    this.result = reference = result;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)((VirtualNetworkInner)((Network)item).innerModel()).location(), (Object)IndyInterface.bootstrap("cast", "()", 0, this.region.get()))) {
                        Object object = item;
                        AddressSpace addressSpace = ((VirtualNetworkInner)(object != null ? ((HasInnerModel)object).innerModel() : null)).addressSpace();
                        List list = addressSpace != null ? addressSpace.addressPrefixes() : null;
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                            if (AzureNetworkClient.pfaccess$0(null).isWarnEnabled()) {
                                Object[] objectArray = new Object[1];
                                Object object2 = item;
                                AddressSpace addressSpace2 = ((VirtualNetworkInner)(object2 != null ? ((HasInnerModel)object2).innerModel() : null)).addressSpace();
                                List list2 = addressSpace2 != null ? addressSpace2.addressPrefixes() : null;
                                objectArray[0] = list2 != null ? Integer.valueOf(list2.size()) : null;
                                AzureNetworkClient.pfaccess$0(null).warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(objectArray, new String[]{"Virtual Network found with ", " address spaces; expected: 1"}))));
                                v1 = null;
                            } else {
                                v1 = null;
                            }
                        }
                        AzureVirtualNetworkDescription vnet = AzureVirtualNetworkDescription.getDescriptionForVirtualNetwork((VirtualNetworkInner)IndyInterface.bootstrap("cast", "()", 0, ((Network)item).innerModel()));
                        List list3 = DefaultGroovyMethods.toList(AzureSubnetDescription.getSubnetsForVirtualNetwork((VirtualNetworkInner)IndyInterface.bootstrap("cast", "()", 0, ((Network)item).innerModel())));
                        vnet.setSubnets(list3);
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                        vnet.setLastReadTime((Long)((Object)callSite));
                        List list4 = DefaultGroovyMethods.plus((List)((Object)IndyInterface.bootstrap("cast", "()", 0, this.result.get())), (Object)vnet);
                        this.result.set((Object)IndyInterface.bootstrap("cast", "()", 0, list4));
                        List list5 = list4;
                        try {
                            return list5;
                        }
                        catch (RuntimeException re) {
                            Object v2;
                            if (AzureNetworkClient.pfaccess$0(null).isErrorEnabled()) {
                                AzureNetworkClient.pfaccess$0(null).error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((VirtualNetworkInner)((Network)item).innerModel()).name()}, new String[]{"Unable to process virtual network ", ""}))), (Throwable)re);
                                v2 = null;
                            } else {
                                v2 = null;
                            }
                            Object var14_14 = v2;
                            return var14_14;
                        }
                    }
                    return null;
                }

                @Generated
                public String getRegion() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                }

                @Generated
                public Long getCurrentTime() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.currentTime.get());
                }

                @Generated
                public ArrayList getResult() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.result.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getVirtualNetworksAll_closure41.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Iterable iterable = callSite != null ? DefaultGroovyMethods.each((Iterable)((Object)callSite), (Closure)new _getVirtualNetworksAll_closure41(this, this, region2, currentTime, result)) : null;
        }
        catch (Exception e) {
            log.error("getVirtualNetworksAll -> Unexpected exception ", (Throwable)e);
        }
        return (ArrayList)result.get();
    }

    /*
     * WARNING - void declaration
     */
    public String getDnsNameForPublicIp(String resourceGroupName, String publicIpName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference publicIpName2 = new Reference((Object)var2_2);
        String dnsName = "dns-not-found";
        try {
            String string = (String)publicIpName2.get();
            public final class _getDnsNameForPublicIp_closure42
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference resourceGroupName;
                private /* synthetic */ Reference publicIpName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getDnsNameForPublicIp_closure42(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference publicIpName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.resourceGroupName = reference2 = resourceGroupName;
                    this.publicIpName = reference = publicIpName;
                }

                public PublicIpAddress doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, ((AzureNetworkClient)this.getThisObject()).getAzure().publicIpAddresses().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.publicIpName.get()))));
                }

                @Generated
                public String getResourceGroupName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
                }

                @Generated
                public String getPublicIpName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.publicIpName.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public PublicIpAddress doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getDnsNameForPublicIp_closure42.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite publicIp = IndyInterface.bootstrap("cast", "()", 0, (string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false ? AzureBaseClient.executeOp(new _getDnsNameForPublicIp_closure42(this, this, resourceGroupName2, publicIpName2)) : null);
            CallSite callSite = publicIp;
            String string2 = callSite != null ? callSite.fqdn() : null;
            if ((string2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string2)) != false) {
                dnsName = publicIp.fqdn();
            }
        }
        catch (Exception e) {
            log.error("getDnsNameForPublicIp -> Unexpected exception ", (Throwable)e);
        }
        return dnsName;
    }

    public Boolean checkDnsNameAvailability(String dnsName) {
        CheckProfileDnsNameAvailabilityResult isAvailable = this.getAzure().trafficManagerProfiles().checkDnsNameAvailability(dnsName);
        return IndyInterface.bootstrap("cast", "()", 0, isAvailable);
    }

    @Override
    public String getProviderNamespace() {
        return "Microsoft.Network";
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureNetworkClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureNetworkClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureNetworkClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureNetworkClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureNetworkClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureNetworkClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public static /* synthetic */ Logger pfaccess$0(AzureNetworkClient $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(AzureNetworkClient.class, AzureNetworkClient.class, (String)"log"));
    }

    @Generated
    public void createVirtualNetwork(String resourceGroupName, String virtualNetworkName, String region) {
        this.createVirtualNetwork(resourceGroupName, virtualNetworkName, region, AzureUtilities.getVNET_DEFAULT_ADDRESS_PREFIX());
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.azure.client.AzureNetworkClient");
    }
}

