/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.azure.resources.common.AzureResourceOpsDescription;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class AzureUtilities
implements GroovyObject {
    private static final String PATH_SEPARATOR;
    private static final String NAME_SEPARATOR;
    private static final String VNET_NAME_PREFIX = "vnet-";
    private static final String SUBNET_NAME_PREFIX = "subnet-";
    private static final String PUBLICIP_NAME_PREFIX = "pip-";
    private static final String LBFRONTEND_NAME_PREFIX = "fe-";
    private static final String LBBACKEND_NAME_PREFIX = "be-";
    private static final String DNS_NAME_PREFIX = "dns-";
    private static final String IPCONFIG_NAME_PREFIX = "ipc-";
    private static final String NETWORK_INTERFACE_PREFIX = "nic-";
    private static final Pattern IPV4_PREFIX_REGEX;
    private static final String LB_NAME_PREFIX = "lb-";
    private static final String INBOUND_NATPOOL_PREFIX = "np-";
    private static final String VNET_DEFAULT_ADDRESS_PREFIX = "10.0.0.0/8";
    private static final int SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH = 24;
    private static final int PROVIDER_TYPE_INDEX_IN_RESOURCEID = 6;
    private static final String AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX = "CustomScript";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_VERSION_LINUX = "2.0";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_LINUX = "Microsoft.Azure.Extensions";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS = "CustomScriptExtension";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_WINDOWS = "Microsoft.Compute";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_VERSION_WINDOWS = "1.8";
    private static final String AZURE_HEALTH_EXT_TYPE_WINDOWS = "ApplicationHealthWindows";
    private static final String AZURE_HEALTH_EXT_TYPE_LINUX = "ApplicationHealthLinux";
    private static final String AZURE_HEALTH_EXT_VERSION = "1.0";
    private static final String AZURE_HEALTH_EXT_PUBLISHER = "Microsoft.ManagedServices";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AzureUtilities() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String getResourceGroupName(AzureResourceOpsDescription description) {
        if (ScriptBytecodeAdapter.compareEqual((Object)description, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "appName", 4, description), NAME_SEPARATOR), IndyInterface.bootstrap("getProperty", "region", 4, description)));
    }

    public static String getVirtualNetworkName(String resourceGroupName) {
        if (ScriptBytecodeAdapter.compareEqual((Object)resourceGroupName, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, VNET_NAME_PREFIX, resourceGroupName));
    }

    public static String getSubnetName(String virtualNetworkName, String addressPrefix) {
        if (ScriptBytecodeAdapter.compareEqual((Object)virtualNetworkName, null) || ScriptBytecodeAdapter.compareEqual((Object)addressPrefix, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite addressPrefixSanitized = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, addressPrefix, "[\\./]", "_"));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, virtualNetworkName, NAME_SEPARATOR), SUBNET_NAME_PREFIX), addressPrefixSanitized));
    }

    public static String getResourceGroupName(String appName, String region) {
        if (ScriptBytecodeAdapter.compareEqual((Object)appName, null) || ScriptBytecodeAdapter.compareEqual((Object)region, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, appName, NAME_SEPARATOR), IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "replace", 0, region, " ", ""))));
    }

    public static String getResourceGroupNameFromResourceId(String resourceId) {
        if (ScriptBytecodeAdapter.compareEqual((Object)resourceId, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite parts = IndyInterface.bootstrap("invoke", "split", 0, resourceId, PATH_SEPARATOR);
        public final class _getResourceGroupNameFromResourceId_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getResourceGroupNameFromResourceId_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)it, (Object)"resourceGroups");
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getResourceGroupNameFromResourceId_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite idx = IndyInterface.bootstrap("invoke", "findIndexOf", 0, parts, new _getResourceGroupNameFromResourceId_closure1(AzureUtilities.class, AzureUtilities.class));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)idx, (Object)0)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, parts, IndyInterface.bootstrap("invoke", "plus", 0, idx, true)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public static String getAppNameFromAzureResourceName(String azureResourceName) {
        if (ScriptBytecodeAdapter.compareEqual((Object)azureResourceName, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "split", 0, azureResourceName, NAME_SEPARATOR)));
    }

    public static String getNameFromResourceId(String resourceId) {
        if (ScriptBytecodeAdapter.compareEqual((Object)resourceId, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "last", 0, IndyInterface.bootstrap("invoke", "split", 0, resourceId, PATH_SEPARATOR)));
    }

    public static String getResourceNameFromId(String id) {
        if (ScriptBytecodeAdapter.compareEqual((Object)id, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite vals = IndyInterface.bootstrap("invoke", "split", 0, id, PATH_SEPARATOR);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "length", 0, vals), (Object)IndyInterface.bootstrap("invoke", "plus", 0, PROVIDER_TYPE_INDEX_IN_RESOURCEID, 2))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, vals, IndyInterface.bootstrap("invoke", "plus", 0, PROVIDER_TYPE_INDEX_IN_RESOURCEID, 2)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public static String getResourceTypeFromId(String id) {
        if (ScriptBytecodeAdapter.compareEqual((Object)id, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite vals = IndyInterface.bootstrap("invoke", "split", 0, id, PATH_SEPARATOR);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "length", 0, vals), (Object)IndyInterface.bootstrap("invoke", "plus", 0, PROVIDER_TYPE_INDEX_IN_RESOURCEID, true))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, vals, IndyInterface.bootstrap("invoke", "plus", 0, PROVIDER_TYPE_INDEX_IN_RESOURCEID, true)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private static boolean validateIpv4PrefixMatch(Matcher matchResult) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, matchResult)) == false) {
            return false;
        }
        if ((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, matchResult, "length"), Integer.class)) > 32) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            if ((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, matchResult, new GStringImpl(new Object[]{i}, new String[]{"addr", ""})), Integer.class)) > 255) {
                return false;
            }
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        return true;
    }

    public static int convertIpv4PrefixToInt(String addrPrefix) {
        if (IndyInterface.bootstrap("cast", "()", 0, addrPrefix) == false) {
            return -1;
        }
        CallSite matchResult = IndyInterface.bootstrap("invoke", "matcher", 0, IPV4_PREFIX_REGEX, addrPrefix);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateIpv4PrefixMatch", 0, AzureUtilities.class, matchResult)) == false) {
            return -1;
        }
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "convertIpv4PrefixToInt", 0, AzureUtilities.class, matchResult, ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, matchResult, "length"), Integer.class))), Integer.TYPE)));
    }

    public static int getSubnetRangeMax(String vnetAddressPrefix, int subnetAddressPrefixLength) {
        if (IndyInterface.bootstrap("cast", "()", 0, vnetAddressPrefix) == false) {
            return 0;
        }
        CallSite matchResult = IndyInterface.bootstrap("invoke", "matcher", 0, IPV4_PREFIX_REGEX, vnetAddressPrefix);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateIpv4PrefixMatch", 0, AzureUtilities.class, matchResult)) == false) {
            return 0;
        }
        int vnetAddrPrefixLength = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, matchResult, "length"), Integer.class));
        if (vnetAddrPrefixLength >= subnetAddressPrefixLength) {
            return 0;
        }
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "leftShift", 0, true, IndyInterface.bootstrap("invoke", "minus", 0, subnetAddressPrefixLength, vnetAddrPrefixLength)));
    }

    public static int getAddressPrefixLength(String addrPrefix) {
        if (IndyInterface.bootstrap("cast", "()", 0, addrPrefix) == false) {
            return 0;
        }
        CallSite matchResult = IndyInterface.bootstrap("invoke", "matcher", 0, IPV4_PREFIX_REGEX, addrPrefix);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateIpv4PrefixMatch", 0, AzureUtilities.class, matchResult)) == false) {
            return 0;
        }
        return (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, matchResult, "length"), Integer.class));
    }

    public static int convertIpv4PrefixToInt(Matcher matchResult, int length) {
        int lengthMask = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "leftShift", 0, -1, IndyInterface.bootstrap("invoke", "minus", 0, 32, length)));
        int val = 0;
        int i = 0;
        while (i < 4) {
            val = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "or", 0, val, IndyInterface.bootstrap("invoke", "leftShift", 0, ((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, matchResult, new GStringImpl(new Object[]{i}, new String[]{"addr", ""})), Integer.class))).intValue(), IndyInterface.bootstrap("invoke", "multiply", 0, i, 8))));
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        val = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "and", 0, val, lengthMask));
        return val;
    }

    public static String convertIntToIpv4Prefix(int prefix, int length) {
        int lowMask = 255;
        int[] addr = new int[4];
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("getProperty", "length", 0, addr))) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "and", 0, IndyInterface.bootstrap("invoke", "rightShiftUnsigned", 0, prefix, IndyInterface.bootstrap("invoke", "multiply", 0, i, 8)), lowMask);
            IndyInterface.bootstrap("invoke", "putAt", 0, addr, i, callSite);
            int n = i;
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        }
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, addr, 3), IndyInterface.bootstrap("invoke", "getAt", 0, addr, 2), IndyInterface.bootstrap("invoke", "getAt", 0, addr, true), IndyInterface.bootstrap("invoke", "getAt", 0, addr, false), length}, new String[]{"", ".", ".", ".", "/", ""}));
    }

    public static int compareIpv4AddrPrefixes(String leftAddrPrefix, String rightAddrPrefix) {
        CallSite leftMatchResult = IndyInterface.bootstrap("invoke", "matcher", 0, IPV4_PREFIX_REGEX, leftAddrPrefix);
        CallSite rightMatchResult = IndyInterface.bootstrap("invoke", "matcher", 0, IPV4_PREFIX_REGEX, rightAddrPrefix);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateIpv4PrefixMatch", 0, AzureUtilities.class, leftMatchResult)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{leftAddrPrefix}, new String[]{"Invalid IPv4 address prefix: ", ""})));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateIpv4PrefixMatch", 0, AzureUtilities.class, rightMatchResult)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{rightAddrPrefix}, new String[]{"Invalid IPv4 address prefix: ", ""})));
        }
        int length = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "min", 0, Math.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, leftMatchResult, "length"), Integer.class))), Integer.TYPE), ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, rightMatchResult, "length"), Integer.class))), Integer.TYPE)));
        int leftNum = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "convertIpv4PrefixToInt", 0, AzureUtilities.class, leftMatchResult, length));
        int rightNum = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "convertIpv4PrefixToInt", 0, AzureUtilities.class, rightMatchResult, length));
        if (leftNum < 0 && rightNum >= 0) {
            return 1;
        }
        if (rightNum < 0 && leftNum >= 0) {
            return -1;
        }
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "minus", 0, leftNum, rightNum));
    }

    public static String getNextSubnet(String vnetAddrPrefix, String subnetAddrPrefix) {
        if (IndyInterface.bootstrap("cast", "()", 0, subnetAddrPrefix) == false) {
            CallSite vnetMatchResult = IndyInterface.bootstrap("invoke", "matcher", 0, IPV4_PREFIX_REGEX, vnetAddrPrefix);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, vnetMatchResult)) != false) {
                int adjustedLength = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "max", 0, Math.class, IndyInterface.bootstrap("invoke", "plus", 0, ((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, vnetMatchResult, "length"), Integer.class))).intValue(), 8), SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH));
                subnetAddrPrefix = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, vnetAddrPrefix, "/\\d+$", new GStringImpl(new Object[]{adjustedLength}, new String[]{"/", ""})));
            }
        }
        CallSite subnetMatchResult = IndyInterface.bootstrap("invoke", "matcher", 0, IPV4_PREFIX_REGEX, subnetAddrPrefix);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateIpv4PrefixMatch", 0, AzureUtilities.class, subnetMatchResult)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{subnetAddrPrefix}, new String[]{"Invalid subnet address prefix: ", ""})));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "compareIpv4AddrPrefixes", 0, AzureUtilities.class, subnetAddrPrefix, vnetAddrPrefix), (Object)0)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{subnetAddrPrefix, vnetAddrPrefix}, new String[]{"Subnet ", " is not in vnet ", ""})));
        }
        int length = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "group", 0, subnetMatchResult, "length"), Integer.class));
        int prefix = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "convertIpv4PrefixToInt", 0, AzureUtilities.class, subnetMatchResult, length));
        prefix = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "rightShiftUnsigned", 0, prefix, IndyInterface.bootstrap("invoke", "minus", 0, 32, length)));
        prefix = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, prefix, true));
        prefix = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "leftShift", 0, prefix, IndyInterface.bootstrap("invoke", "minus", 0, 32, length)));
        CallSite resultPrefix = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertIntToIpv4Prefix", 0, AzureUtilities.class, prefix, length));
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)IndyInterface.bootstrap("invoke", "compareIpv4AddrPrefixes", 0, AzureUtilities.class, subnetAddrPrefix, resultPrefix), (Object)0)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, ArithmeticException.class, new GStringImpl(new Object[]{subnetAddrPrefix}, new String[]{"Overflow occurred getting next valid subnet after ", ""})));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "compareIpv4AddrPrefixes", 0, AzureUtilities.class, resultPrefix, vnetAddrPrefix), (Object)0)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, ArithmeticException.class, new GStringImpl(new Object[]{subnetAddrPrefix, vnetAddrPrefix}, new String[]{"Overflow occurred getting next valid subnet after ", " within vnet ", ""})));
        }
        return resultPrefix;
    }

    public static String convertParametersToTemplateJSON(ObjectMapper mapper, Map<String, Object> sourceParameters) {
        CallSite map = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, sourceParameters), (Object)0)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "writeValueAsString", 0, mapper, sourceParameters));
        }
        CallSite entry = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "entrySet", 0, sourceParameters)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                entry = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry)) == false) continue;
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "class", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry)), String.class)) {
                    IndyInterface.bootstrap("invoke", "put", 0, map, IndyInterface.bootstrap("getProperty", "key", 0, entry), IndyInterface.bootstrap("init", "<init>", 0, ValueParameter.class, IndyInterface.bootstrap("getProperty", "value", 0, entry)));
                    continue;
                }
                IndyInterface.bootstrap("invoke", "put", 0, map, IndyInterface.bootstrap("getProperty", "key", 0, entry), IndyInterface.bootstrap("init", "<init>", 0, ReferenceParameter.class, IndyInterface.bootstrap("getProperty", "value", 0, entry)));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "writeValueAsString", 0, mapper, map));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureUtilities.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureUtilities.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureUtilities.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureUtilities.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureUtilities.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureUtilities.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    public static int getSubnetRangeMax(String vnetAddressPrefix) {
        return AzureUtilities.getSubnetRangeMax(vnetAddressPrefix, SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH);
    }

    @Generated
    public static String getNextSubnet(String vnetAddrPrefix) {
        return AzureUtilities.getNextSubnet(vnetAddrPrefix, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        String string2;
        NAME_SEPARATOR = string2 = "-";
        PATH_SEPARATOR = string = "/";
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(?<addr3>\\d+)\\.(?<addr2>\\d+)\\.(?<addr1>\\d+)\\.(?<addr0>\\d+)/(?<length>\\d+)$");
        IPV4_PREFIX_REGEX = IndyInterface.bootstrap("cast", "()", 0, object);
    }

    @Generated
    public static String getPATH_SEPARATOR() {
        return PATH_SEPARATOR;
    }

    @Generated
    public static String getNAME_SEPARATOR() {
        return NAME_SEPARATOR;
    }

    @Generated
    public static String getVNET_NAME_PREFIX() {
        return VNET_NAME_PREFIX;
    }

    @Generated
    public static String getSUBNET_NAME_PREFIX() {
        return SUBNET_NAME_PREFIX;
    }

    @Generated
    public static String getPUBLICIP_NAME_PREFIX() {
        return PUBLICIP_NAME_PREFIX;
    }

    @Generated
    public static String getLBFRONTEND_NAME_PREFIX() {
        return LBFRONTEND_NAME_PREFIX;
    }

    @Generated
    public static String getLBBACKEND_NAME_PREFIX() {
        return LBBACKEND_NAME_PREFIX;
    }

    @Generated
    public static String getDNS_NAME_PREFIX() {
        return DNS_NAME_PREFIX;
    }

    @Generated
    public static String getIPCONFIG_NAME_PREFIX() {
        return IPCONFIG_NAME_PREFIX;
    }

    @Generated
    public static String getNETWORK_INTERFACE_PREFIX() {
        return NETWORK_INTERFACE_PREFIX;
    }

    @Generated
    public static Pattern getIPV4_PREFIX_REGEX() {
        return IPV4_PREFIX_REGEX;
    }

    @Generated
    public static String getLB_NAME_PREFIX() {
        return LB_NAME_PREFIX;
    }

    @Generated
    public static String getINBOUND_NATPOOL_PREFIX() {
        return INBOUND_NATPOOL_PREFIX;
    }

    @Generated
    public static String getVNET_DEFAULT_ADDRESS_PREFIX() {
        return VNET_DEFAULT_ADDRESS_PREFIX;
    }

    @Generated
    public static int getSUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH() {
        return SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH;
    }

    @Generated
    public static int getPROVIDER_TYPE_INDEX_IN_RESOURCEID() {
        return PROVIDER_TYPE_INDEX_IN_RESOURCEID;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX() {
        return AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_VERSION_LINUX() {
        return AZURE_CUSTOM_SCRIPT_EXT_VERSION_LINUX;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_LINUX() {
        return AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_LINUX;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS() {
        return AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_WINDOWS() {
        return AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_WINDOWS;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_VERSION_WINDOWS() {
        return AZURE_CUSTOM_SCRIPT_EXT_VERSION_WINDOWS;
    }

    @Generated
    public static String getAZURE_HEALTH_EXT_TYPE_WINDOWS() {
        return AZURE_HEALTH_EXT_TYPE_WINDOWS;
    }

    @Generated
    public static String getAZURE_HEALTH_EXT_TYPE_LINUX() {
        return AZURE_HEALTH_EXT_TYPE_LINUX;
    }

    @Generated
    public static String getAZURE_HEALTH_EXT_VERSION() {
        return AZURE_HEALTH_EXT_VERSION;
    }

    @Generated
    public static String getAZURE_HEALTH_EXT_PUBLISHER() {
        return AZURE_HEALTH_EXT_PUBLISHER;
    }

    public static class ValueParameter
    implements GroovyObject {
        private Object value;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ValueParameter(Object value) {
            Object object;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.value = object = value;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ValueParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ValueParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ValueParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(ValueParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(ValueParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ValueParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ValueParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), ValueParameter.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ValueParameter.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ValueParameter.class, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ValueParameter.class, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ValueParameter.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public void setValue(Object object) {
            this.value = object;
        }
    }

    public static class ReferenceParameter
    implements GroovyObject {
        private Object reference;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ReferenceParameter(Object reference) {
            Object object;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.reference = object = reference;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ReferenceParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ReferenceParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ReferenceParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(ReferenceParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(ReferenceParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ReferenceParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ReferenceParameter.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), ReferenceParameter.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ReferenceParameter.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ReferenceParameter.class, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ReferenceParameter.class, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ReferenceParameter.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Object getReference() {
            return this.reference;
        }

        @Generated
        public void setReference(Object object) {
            this.reference = object;
        }
    }

    public static class ProvisioningState
    implements GroovyObject {
        public static final String SUCCEEDED = "Succeeded";
        public static final String FAILED = "Failed";
        public static final String CANCELED = "Canceled";
        public static final String READY = "Ready";
        public static final String DELETED = "Deleted";
        public static final String ACCEPTED = "Accepted";
        public static final String DEPLOYING = "Deploying";
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ProvisioningState() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProvisioningState.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ProvisioningState.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ProvisioningState.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(ProvisioningState.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(ProvisioningState.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ProvisioningState.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ProvisioningState.class, AzureUtilities.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), ProvisioningState.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ProvisioningState.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ProvisioningState.class, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ProvisioningState.class, AzureUtilities.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ProvisioningState.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

