/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.appgateway.ops;

import com.azure.core.management.exception.ManagementException;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.appgateway.model.AzureAppGatewayDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.common.model.AzureDeploymentOperation;
import com.netflix.spinnaker.clouddriver.azure.resources.network.model.AzureVirtualNetworkDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.network.view.AzureNetworkProvider;
import com.netflix.spinnaker.clouddriver.azure.templates.AzureAppGatewayResourceTemplate;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertAzureAppGatewayAtomicOperation
implements AtomicOperation<Map>,
GroovyObject {
    private static final String BASE_PHASE = "UPSERT_APP_GATEWAY";
    private final AzureAppGatewayDescription description;
    @Autowired
    private AzureNetworkProvider networkProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public UpsertAzureAppGatewayAtomicOperation(AzureAppGatewayDescription description) {
        AzureAppGatewayDescription azureAppGatewayDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = azureAppGatewayDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Map operate(List priorOutputs) {
        CallSite loadBalancerName;
        Reference subnetName;
        CallSite virtualNetworkName;
        CallSite resourceGroupName;
        CallSite errList;
        block23: {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Initializing upsert of load balancer ", " "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"in ", "..."})));
            errList = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
            resourceGroupName = null;
            virtualNetworkName = null;
            subnetName = new Reference(null);
            loadBalancerName = null;
            try {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Beginning load balancer deployment");
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "dnsName", 4, this.description)) != false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isBlank", 0, IndyInterface.bootstrap("getProperty", "dnsName", 4, this.description))) != false) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "dnsName", 4, this.description)}, new String[]{"Specified dns name ", " cannot be blank"})));
                    }
                    CallSite isDnsNameAvailable = IndyInterface.bootstrap("invoke", "checkDnsNameAvailability", 0, IndyInterface.bootstrap("getProperty", "networkClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "dnsName", 4, this.description));
                    if (IndyInterface.bootstrap("cast", "()", 0, isDnsNameAvailable) == false) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "dnsName", 4, this.description)}, new String[]{"Specified dns name ", " has conflict"})));
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"name");
                resourceGroupName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResourceGroupName", 0, AzureUtilities.class, IndyInterface.bootstrap("getProperty", "appName", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description)));
                virtualNetworkName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getVirtualNetworkName", 0, AzureUtilities.class, resourceGroupName));
                CallSite appGatewayDescription = IndyInterface.bootstrap("invoke", "getAppGateway", 0, IndyInterface.bootstrap("getProperty", "networkClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), resourceGroupName, IndyInterface.bootstrap("getProperty", "name", 4, this.description));
                if (IndyInterface.bootstrap("cast", "()", 0, appGatewayDescription) != false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, appGatewayDescription), IndyInterface.bootstrap("getProperty", "region", 0, appGatewayDescription)}, new String[]{"Update existing application gateway ", " in ", "..."}));
                    CallSite callSite2 = IndyInterface.bootstrap("getProperty", "publicIpName", 0, appGatewayDescription);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"publicIpName");
                    CallSite callSite3 = IndyInterface.bootstrap("getProperty", "subnetResourceId", 0, appGatewayDescription);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite3, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"subnetResourceId");
                    CallSite callSite4 = IndyInterface.bootstrap("getProperty", "serverGroups", 0, appGatewayDescription);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite4, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"serverGroups");
                    CallSite callSite5 = IndyInterface.bootstrap("getProperty", "trafficEnabledSG", 0, appGatewayDescription);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite5, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"trafficEnabledSG");
                    CallSite callSite6 = IndyInterface.bootstrap("getProperty", "vnetResourceGroup", 0, appGatewayDescription);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite6, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"vnetResourceGroup");
                    CallSite callSite7 = IndyInterface.bootstrap("getProperty", "sku", 0, appGatewayDescription);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite7, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"sku");
                    CallSite callSite8 = IndyInterface.bootstrap("getProperty", "tier", 0, appGatewayDescription);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite8, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"tier");
                    CallSite deployment = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createResourceFromTemplate", 0, IndyInterface.bootstrap("getProperty", "resourceManagerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("invoke", "getTemplate", 0, AzureAppGatewayResourceTemplate.class, this.description), resourceGroupName, IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), "appGateway"));
                    errList = IndyInterface.bootstrap("invoke", "checkDeploymentOperationStatus", 0, AzureDeploymentOperation.class, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), resourceGroupName, IndyInterface.bootstrap("invoke", "name", 0, deployment));
                    break block23;
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "sku", 4, this.description), (Object)"Standard_v2")) {
                    String string = "Standard_v2";
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"tier");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "useDefaultVnet", 4, this.description)) == false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "vnet", 4, this.description), IndyInterface.bootstrap("getProperty", "subnet", 4, this.description), IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Create ApplicationGateway using virtual network ", " and subnet ", " for server group ", ""}));
                    IndyInterface.bootstrap("invoke", "initializeResourceGroupAndVNet", 0, IndyInterface.bootstrap("getProperty", "resourceManagerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), resourceGroupName, null, IndyInterface.bootstrap("getProperty", "region", 4, this.description));
                    boolean bl = false;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"hasNewSubnet");
                    CallSite vnetDescription = IndyInterface.bootstrap("invoke", "get", 0, this.networkProvider, IndyInterface.bootstrap("getProperty", "accountName", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "vnetResourceGroup", 4, this.description), IndyInterface.bootstrap("getProperty", "vnet", 4, this.description));
                    if (IndyInterface.bootstrap("cast", "()", 0, vnetDescription) == false) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "vnet", 4, this.description)}, new String[]{"Selected virtual network ", " does not exist"})));
                    }
                    public final class _operate_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _operate_closure1(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object subnet) {
                            public final class _closure3
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure3(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)"applicationGateways");
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, subnet), (Object)IndyInterface.bootstrap("getProperty", "subnet", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))) && (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "connectedDevices", 0, subnet)) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "connectedDevices", 0, subnet), new _closure3((Object)this, this.getThisObject()))) == false);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite9 = IndyInterface.bootstrap("getProperty", "resourceId", 1, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "subnets", 0, vnetDescription), new _operate_closure1(this, this)));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite9, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"subnetResourceId");
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetResourceId", 4, this.description)) == false) {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Failed to select subnet for Application Gateway ", ""}));
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "subnet", 4, this.description), IndyInterface.bootstrap("getProperty", "vnet", 4, this.description)}, new String[]{"Selected subnet ", " in virtual network ", " is not valid"})));
                    }
                } else {
                    IndyInterface.bootstrap("invoke", "initializeResourceGroupAndVNet", 0, IndyInterface.bootstrap("getProperty", "resourceManagerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), resourceGroupName, virtualNetworkName, IndyInterface.bootstrap("getProperty", "region", 4, this.description));
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Creating subnet for application gateway");
                    CallSite vnetDescription = IndyInterface.bootstrap("invoke", "get", 0, this.networkProvider, IndyInterface.bootstrap("getProperty", "accountName", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "vnetResourceGroup", 4, this.description), virtualNetworkName);
                    CallSite rand = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Random.class));
                    CallSite callSite10 = IndyInterface.bootstrap("getProperty", "maxSubnets", 1, vnetDescription);
                    CallSite nextSubnetAddressPrefix = IndyInterface.bootstrap("invoke", "getNextSubnetAddressPrefix", 0, AzureVirtualNetworkDescription.class, vnetDescription, IndyInterface.bootstrap("invoke", "nextInt", 0, rand, IndyInterface.bootstrap("cast", "()", 0, callSite10) != false ? callSite10 : Integer.valueOf(1)));
                    subnetName.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSubnetName", 0, AzureUtilities.class, virtualNetworkName, nextSubnetAddressPrefix)));
                    CallSite vnet = IndyInterface.bootstrap("invoke", "getVirtualNetwork", 0, IndyInterface.bootstrap("getProperty", "networkClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), resourceGroupName, virtualNetworkName);
                    public final class _operate_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference subnetName;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _operate_closure2(Object _outerInstance, Object _thisObject, Reference subnetName) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.subnetName = reference = subnetName;
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.subnetName.get()));
                        }

                        @Generated
                        public String getSubnetName() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.subnetName.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, (String)subnetName.get()) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("invoke", "subnets", 1, vnet), new _operate_closure2(this, this, subnetName)))) {
                        vnetDescription = IndyInterface.bootstrap("invoke", "getDescriptionForVirtualNetwork", 0, AzureVirtualNetworkDescription.class, IndyInterface.bootstrap("invoke", "innerModel", 0, vnet));
                        CallSite callSite11 = IndyInterface.bootstrap("getProperty", "maxSubnets", 1, vnetDescription);
                        nextSubnetAddressPrefix = IndyInterface.bootstrap("invoke", "getNextSubnetAddressPrefix", 0, AzureVirtualNetworkDescription.class, vnetDescription, IndyInterface.bootstrap("invoke", "nextInt", 0, rand, IndyInterface.bootstrap("cast", "()", 0, callSite11) != false ? callSite11 : Integer.valueOf(1)));
                        subnetName.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSubnetName", 0, AzureUtilities.class, virtualNetworkName, nextSubnetAddressPrefix)));
                    }
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{(String)subnetName.get(), IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Creating new subnet ", " for ", ""}));
                    CallSite callSite12 = IndyInterface.bootstrap("invoke", "createSubnet", 0, IndyInterface.bootstrap("getProperty", "networkClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), resourceGroupName, virtualNetworkName, (String)subnetName.get(), nextSubnetAddressPrefix, IndyInterface.bootstrap("getProperty", "securityGroup", 4, this.description));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite12, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"subnetResourceId");
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetResourceId", 4, this.description)) == false) {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Failed to create new subnet for Application Gateway ", ""}));
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{(String)subnetName.get(), virtualNetworkName}, new String[]{"Could not create subnet ", " in virtual network ", ""})));
                    }
                    CallSite callSite13 = virtualNetworkName;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite13, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"vnet");
                    String string = (String)subnetName.get();
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"subnet");
                    CallSite callSite14 = resourceGroupName;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite14, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"vnetResourceGroup");
                    boolean bl = true;
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, UpsertAzureAppGatewayAtomicOperation.class, (GroovyObject)this.description, (String)"hasNewSubnet");
                }
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"Create new application gateway ", " in ", "..."}));
                CallSite deployment = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createResourceFromTemplate", 0, IndyInterface.bootstrap("getProperty", "resourceManagerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("invoke", "getTemplate", 0, AzureAppGatewayResourceTemplate.class, this.description), resourceGroupName, IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), "appGateway"));
                errList = IndyInterface.bootstrap("invoke", "checkDeploymentOperationStatus", 0, AzureDeploymentOperation.class, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), resourceGroupName, IndyInterface.bootstrap("invoke", "name", 0, deployment));
                loadBalancerName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, this.description));
            }
            catch (ManagementException e) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{resourceGroupName, IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"One or more deployment operations have failed. Please see Azure portal for more information. Resource Group: ", " Application Gateway: ", ""}));
                IndyInterface.bootstrap("invoke", "add", 0, errList, IndyInterface.bootstrap("getProperty", "message", 0, IndyInterface.bootstrap("getProperty", "ce", 12, this)));
            }
            catch (Throwable e) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Deployment of application gateway ", " failed: ", ""}));
                IndyInterface.bootstrap("invoke", "add", 0, errList, IndyInterface.bootstrap("getProperty", "message", 0, e));
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, errList)) == false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Cleanup any resources created as part of server group upsert");
            try {
                if (IndyInterface.bootstrap("cast", "()", 0, loadBalancerName) != false) {
                    IndyInterface.bootstrap("invoke", "deleteAppGateway", 0, IndyInterface.bootstrap("getProperty", "networkClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), resourceGroupName, loadBalancerName);
                }
                if (IndyInterface.bootstrap("cast", "()", 0, (String)subnetName.get()) != false) {
                    IndyInterface.bootstrap("invoke", "deleteSubnet", 0, IndyInterface.bootstrap("getProperty", "networkClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), resourceGroupName, virtualNetworkName, (String)subnetName.get());
                }
            }
            catch (Exception e) {
                GStringImpl errMessage = new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e), (String)subnetName.get(), loadBalancerName, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "PUBLICIP_NAME_PREFIX", 0, AzureUtilities.class), loadBalancerName)}, new String[]{"Unexpected exception: ", "; please log in into the Azure Portal and manually remove the following resources: ", " ", " ", ""});
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, errMessage);
                IndyInterface.bootstrap("invoke", "add", 0, errList, errMessage);
            }
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AtomicOperationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"", " deployment failed"}), errList));
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"Deployment for load balancer ", " in ", " has succeeded."}));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)})})});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertAzureAppGatewayAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AzureNetworkProvider getNetworkProvider() {
        return this.networkProvider;
    }

    @Generated
    public void setNetworkProvider(AzureNetworkProvider azureNetworkProvider) {
        this.networkProvider = azureNetworkProvider;
    }
}

