/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.appgateway.view;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.azure.AzureCloudProvider;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.appgateway.model.AzureAppGatewayDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.cluster.view.AzureClusterProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.common.cache.Keys;
import com.netflix.spinnaker.clouddriver.azure.resources.loadbalancer.model.AzureLoadBalancer;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerServerGroup;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AzureAppGatewayProvider
implements LoadBalancerProvider<AzureLoadBalancer>,
GroovyObject {
    private final String cloudProvider;
    private final AzureCloudProvider azureCloudProvider;
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    @Autowired
    private AccountCredentialsProvider accountCredentialsProvider;
    @Autowired
    private AzureClusterProvider clusterProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public AzureAppGatewayProvider(AzureCloudProvider azureCloudProvider, Cache cacheView, ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        AzureCloudProvider azureCloudProvider2;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, AzureCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.azureCloudProvider = azureCloudProvider2 = azureCloudProvider;
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public Set<AzureLoadBalancer> getApplicationLoadBalancers(String application) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getAppGatewayKey", 0, Keys.class, this.azureCloudProvider, application, "*", "*", "*")));
    }

    public Set<AzureLoadBalancer> getAllMatchingKeyPattern(String pattern) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadResults", 2, this, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_APP_GATEWAYS", 0, Keys.Namespace.class)), pattern)));
    }

    public Set<AzureLoadBalancer> loadResults(Collection<String> identifiers) {
        Closure transform = ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData");
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_APP_GATEWAYS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        CallSite transformed = IndyInterface.bootstrap("invoke", "collect", 0, data, transform);
        return IndyInterface.bootstrap("cast", "()", 0, transformed);
    }

    public AzureLoadBalancer fromCacheData(CacheData cacheData) {
        CallSite description = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), "appgateway"), AzureAppGatewayDescription.class));
        CallSite parts = IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, this.azureCloudProvider, IndyInterface.bootstrap("getProperty", "id", 0, cacheData));
        Object[] objectArray = new Object[14];
        objectArray[0] = "account";
        CallSite callSite = IndyInterface.bootstrap("getProperty", "account", 0, parts);
        objectArray[1] = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "none";
        objectArray[2] = "name";
        objectArray[3] = IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, description);
        objectArray[4] = "region";
        objectArray[5] = IndyInterface.bootstrap("getProperty", "region", 4, description);
        objectArray[6] = "vnet";
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "vnet", 4, description);
        objectArray[7] = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : "vnet-unassigned";
        objectArray[8] = "subnet";
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "subnet", 4, description);
        objectArray[9] = IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : "subnet-unassigned";
        objectArray[10] = "cluster";
        CallSite callSite4 = IndyInterface.bootstrap("getProperty", "cluster", 4, description);
        objectArray[11] = IndyInterface.bootstrap("cast", "()", 0, callSite4) != false ? callSite4 : "unassigned";
        objectArray[12] = "loadBalancerType";
        objectArray[13] = IndyInterface.bootstrap("getProperty", "AZURE_APPLICATION_GATEWAY", 0, AzureLoadBalancer.AzureLoadBalancerType.class);
        Reference loadBalancer = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, AzureLoadBalancer.class, ScriptBytecodeAdapter.createMap((Object[])objectArray)));
        public final class _fromCacheData_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancer;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromCacheData_closure1(Object _outerInstance, Object _thisObject, Reference loadBalancer) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.loadBalancer = reference = loadBalancer;
            }

            public Object doCall(Object serverGroup) {
                CallSite asg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroup", 0, IndyInterface.bootstrap("getProperty", "clusterProvider", 12, this), IndyInterface.bootstrap("getProperty", "account", 0, this.loadBalancer.get()), IndyInterface.bootstrap("getProperty", "region", 0, this.loadBalancer.get()), serverGroup));
                return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "serverGroups", 0, this.loadBalancer.get()), IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerServerGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", serverGroup, "isDisabled", IndyInterface.bootstrap("invoke", "isDisabled", 1, asg), "detachedInstances", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "instances", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "cloudProvider", IndyInterface.bootstrap("getProperty", "ID", 0, AzureCloudProvider.class)})));
            }

            @Generated
            public Object getLoadBalancer() {
                return this.loadBalancer.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromCacheData_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "serverGroups", 4, description), new _fromCacheData_closure1(this, this, loadBalancer));
        return IndyInterface.bootstrap("cast", "()", 0, loadBalancer.get());
    }

    public AzureAppGatewayDescription getAppGatewayDescription(String account, String appName, String region, String appGatewayName) {
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_APP_GATEWAYS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_APP_GATEWAYS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "getAppGatewayKey", 0, Keys.class, this.azureCloudProvider, appName, appGatewayName, region, account)), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        CallSite cacheData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, data) != false ? IndyInterface.bootstrap("invoke", "first", 0, data) : null);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, cacheData) != false ? IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), "appgateway"), AzureAppGatewayDescription.class) : null);
    }

    public List<AzureAppGatewaySummary> list() {
        return (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("invoke", "getSummaryForAppGateways", 2, this)), List.class));
    }

    private Map<String, AzureAppGatewaySummary> getSummaryForAppGateways() {
        Reference map = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        CallSite loadBalancers = IndyInterface.bootstrap("invoke", "getApplicationLoadBalancers", 2, this, "*");
        public final class _getSummaryForAppGateways_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference map;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSummaryForAppGateways_closure2(Object _outerInstance, Object _thisObject, Reference map) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.map = reference = map;
            }

            public Object doCall(Object lb) {
                CallSite summary = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.map.get()), IndyInterface.bootstrap("getProperty", "name", 0, lb));
                if (IndyInterface.bootstrap("cast", "()", 0, summary) == false) {
                    summary = IndyInterface.bootstrap("init", "<init>", 0, AzureAppGatewaySummary.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "name", 0, lb)}));
                    IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.map.get()), IndyInterface.bootstrap("getProperty", "name", 0, lb), summary);
                }
                CallSite loadBalancerDetail = IndyInterface.bootstrap("init", "<init>", 0, AzureAppGatewayAccountRegionDetail.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", IndyInterface.bootstrap("getProperty", "account", 0, lb), "name", IndyInterface.bootstrap("getProperty", "name", 0, lb), "region", IndyInterface.bootstrap("getProperty", "region", 0, lb)}));
                return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, IndyInterface.bootstrap("invoke", "getOrCreateRegion", 0, IndyInterface.bootstrap("invoke", "getOrCreateAccount", 0, summary, IndyInterface.bootstrap("getProperty", "account", 0, lb)), IndyInterface.bootstrap("getProperty", "region", 0, lb))), loadBalancerDetail);
            }

            @Generated
            public Map getMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.map.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSummaryForAppGateways_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 1, loadBalancers, new _getSummaryForAppGateways_closure2(this, this, map));
        return (Map)map.get();
    }

    public LoadBalancerProvider.Item get(String name) {
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, UnsupportedOperationException.class, "TODO: Implement single getter."));
    }

    public List<Map> byAccountAndRegionAndName(String account, String region, String name) {
        CallSite appName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAppNameFromAzureResourceName", 0, AzureUtilities.class, name));
        CallSite description = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAppGatewayDescription", 2, this, account, appName, region, name));
        if (IndyInterface.bootstrap("cast", "()", 0, description) != false) {
            Map lbDetail = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, description)});
            String string = account;
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)lbDetail, (String)"account");
            String string2 = region;
            ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)lbDetail, (String)"region");
            CallSite callSite = appName;
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)lbDetail, (String)"application");
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "stack", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)lbDetail, (String)"stack");
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "detail", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)lbDetail, (String)"detail");
            CallSite callSite4 = IndyInterface.bootstrap("getProperty", "createdTime", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)lbDetail, (String)"createdTime");
            CallSite callSite5 = IndyInterface.bootstrap("getProperty", "cluster", 4, description);
            Object object = IndyInterface.bootstrap("cast", "()", 0, callSite5) != false ? callSite5 : "unassigned";
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)lbDetail, (String)"cluster");
            CallSite callSite6 = IndyInterface.bootstrap("invoke", "join", 1, IndyInterface.bootstrap("getProperty", "serverGroups", 4, description), " ");
            Object object2 = IndyInterface.bootstrap("cast", "()", 0, callSite6) != false ? callSite6 : "unassigned";
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)lbDetail, (String)"serverGroups");
            CallSite callSite7 = IndyInterface.bootstrap("getProperty", "securityGroup", 4, description);
            Object object3 = IndyInterface.bootstrap("cast", "()", 0, callSite7) != false ? callSite7 : "unassigned";
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)lbDetail, (String)"securityGroup");
            CallSite callSite8 = IndyInterface.bootstrap("getProperty", "vnet", 4, description);
            Object object4 = IndyInterface.bootstrap("cast", "()", 0, callSite8) != false ? callSite8 : "vnet-unassigned";
            ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)lbDetail, (String)"vnet");
            CallSite callSite9 = IndyInterface.bootstrap("getProperty", "subnet", 4, description);
            Object object5 = IndyInterface.bootstrap("cast", "()", 0, callSite9) != false ? callSite9 : "subnet-unassigned";
            ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)lbDetail, (String)"subnet");
            CallSite callSite10 = IndyInterface.bootstrap("getProperty", "dnsName", 4, description);
            Object object6 = IndyInterface.bootstrap("cast", "()", 0, callSite10) != false ? callSite10 : "dnsname-unassigned";
            ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)lbDetail, (String)"dnsName");
            CallSite callSite11 = IndyInterface.bootstrap("getProperty", "probes", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite11, null, (Object)lbDetail, (String)"probes");
            CallSite callSite12 = IndyInterface.bootstrap("getProperty", "loadBalancingRules", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite12, null, (Object)lbDetail, (String)"loadBalancingRules");
            CallSite callSite13 = IndyInterface.bootstrap("getProperty", "tags", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite13, null, (Object)lbDetail, (String)"tags");
            CallSite callSite14 = IndyInterface.bootstrap("getProperty", "sku", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite14, null, (Object)lbDetail, (String)"sku");
            CallSite callSite15 = IndyInterface.bootstrap("getProperty", "tier", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite15, null, (Object)lbDetail, (String)"tier");
            CallSite callSite16 = IndyInterface.bootstrap("getProperty", "capacity", 4, description);
            ScriptBytecodeAdapter.setProperty((Object)callSite16, null, (Object)lbDetail, (String)"capacity");
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{lbDetail});
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureAppGatewayProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureAppGatewayProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureAppGatewayProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureAppGatewayProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureAppGatewayProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureAppGatewayProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public AccountCredentialsProvider getAccountCredentialsProvider() {
        return this.accountCredentialsProvider;
    }

    @Generated
    public void setAccountCredentialsProvider(AccountCredentialsProvider accountCredentialsProvider) {
        this.accountCredentialsProvider = accountCredentialsProvider;
    }

    @Generated
    public AzureClusterProvider getClusterProvider() {
        return this.clusterProvider;
    }

    @Generated
    public void setClusterProvider(AzureClusterProvider azureClusterProvider) {
        this.clusterProvider = azureClusterProvider;
    }

    public static class AzureAppGatewaySummary
    implements LoadBalancerProvider.Item,
    GroovyObject {
        private Map<String, AzureAppGatewayAccount> mappedAccounts;
        private String name;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public AzureAppGatewaySummary() {
            MetaClass metaClass;
            Map map;
            this.mappedAccounts = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public AzureAppGatewayAccount getOrCreateAccount(String name) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.mappedAccounts, name)) == false) {
                CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, AzureAppGatewayAccount.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name}));
                IndyInterface.bootstrap("invoke", "putAt", 0, this.mappedAccounts, name, callSite);
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.mappedAccounts, name));
        }

        @JsonProperty(value="accounts")
        public List<AzureAppGatewayAccount> getByAccounts() {
            return (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "values", 0, this.mappedAccounts), List.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureAppGatewaySummary.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewaySummary.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewaySummary.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewaySummary.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewaySummary.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewaySummary.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewaySummary.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AzureAppGatewaySummary.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AzureAppGatewaySummary.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AzureAppGatewaySummary.class, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AzureAppGatewaySummary.class, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AzureAppGatewaySummary.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }
    }

    public static class AzureAppGatewayAccount
    implements LoadBalancerProvider.ByAccount,
    GroovyObject {
        private Map<String, AzureAppGatewayAccountRegion> mappedRegions;
        private String name;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public AzureAppGatewayAccount() {
            MetaClass metaClass;
            Map map;
            this.mappedRegions = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public AzureAppGatewayAccountRegion getOrCreateRegion(String name) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.mappedRegions, name)) == false) {
                CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, AzureAppGatewayAccountRegion.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name, "loadBalancers", ScriptBytecodeAdapter.createList((Object[])new Object[0])}));
                IndyInterface.bootstrap("invoke", "putAt", 0, this.mappedRegions, name, callSite);
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.mappedRegions, name));
        }

        @JsonProperty(value="regions")
        public List<AzureAppGatewayAccountRegion> getByRegions() {
            return (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "values", 0, this.mappedRegions), List.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureAppGatewayAccount.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccount.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccount.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccount.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccount.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccount.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccount.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AzureAppGatewayAccount.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AzureAppGatewayAccount.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AzureAppGatewayAccount.class, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AzureAppGatewayAccount.class, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AzureAppGatewayAccount.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }
    }

    public static class AzureAppGatewayAccountRegion
    implements LoadBalancerProvider.Details,
    GroovyObject {
        private String name;
        private List<AzureAppGatewayAccountRegionDetail> loadBalancers;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public AzureAppGatewayAccountRegion() {
            MetaClass metaClass;
            List list;
            this.loadBalancers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureAppGatewayAccountRegion.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegion.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegion.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegion.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegion.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegion.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegion.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AzureAppGatewayAccountRegion.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AzureAppGatewayAccountRegion.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AzureAppGatewayAccountRegion.class, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AzureAppGatewayAccountRegion.class, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AzureAppGatewayAccountRegion.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public List<AzureAppGatewayAccountRegionDetail> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Generated
        public void setLoadBalancers(List<AzureAppGatewayAccountRegionDetail> list) {
            this.loadBalancers = list;
        }
    }

    public static class AzureAppGatewayAccountRegionDetail
    implements LoadBalancerProvider.Details,
    GroovyObject {
        private String type;
        private String account;
        private String region;
        private String name;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public AzureAppGatewayAccountRegionDetail() {
            MetaClass metaClass;
            String string;
            this.type = string = "azure";
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AzureAppGatewayAccountRegionDetail.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegionDetail.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegionDetail.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegionDetail.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegionDetail.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegionDetail.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(AzureAppGatewayAccountRegionDetail.class, AzureAppGatewayProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), AzureAppGatewayAccountRegionDetail.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AzureAppGatewayAccountRegionDetail.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AzureAppGatewayAccountRegionDetail.class, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(AzureAppGatewayAccountRegionDetail.class, AzureAppGatewayProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), AzureAppGatewayAccountRegionDetail.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String string) {
            this.type = string;
        }

        @Generated
        public String getAccount() {
            return this.account;
        }

        @Generated
        public void setAccount(String string) {
            this.account = string;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public void setRegion(String string) {
            this.region = string;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }
    }
}

