/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.securitygroup.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.azure.AzureCloudProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.common.cache.Keys;
import com.netflix.spinnaker.clouddriver.azure.resources.securitygroup.model.AzureSecurityGroup;
import com.netflix.spinnaker.clouddriver.azure.resources.securitygroup.model.AzureSecurityGroupDescription;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupProvider;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AzureSecurityGroupProvider
implements SecurityGroupProvider<AzureSecurityGroup>,
GroovyObject {
    private final String cloudProvider;
    private final AzureCloudProvider azureCloudProvider;
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public AzureSecurityGroupProvider(AzureCloudProvider azureCloudProvider, Cache cacheView, ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        AzureCloudProvider azureCloudProvider2;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, AzureCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.azureCloudProvider = azureCloudProvider2 = azureCloudProvider;
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public Set<AzureSecurityGroup> getAll(boolean includeRules) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, this.azureCloudProvider, "*", "*", "*", "*"), includeRules));
    }

    public Set<AzureSecurityGroup> getAllByRegion(boolean includeRules, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, this.azureCloudProvider, "*", "*", region, "*"), includeRules));
    }

    public Set<AzureSecurityGroup> getAllByAccount(boolean includeRules, String account) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, this.azureCloudProvider, "*", "*", "*", account), includeRules));
    }

    public Set<AzureSecurityGroup> getAllByAccountAndName(boolean includeRules, String account, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, this.azureCloudProvider, name, "*", "*", account), includeRules));
    }

    public Set<AzureSecurityGroup> getAllByAccountAndRegion(boolean includeRules, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, this.azureCloudProvider, "*", "*", region, account), includeRules));
    }

    public AzureSecurityGroup get(String account, String region, String name, String vnet) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, this.azureCloudProvider, name, "*", region, account), true), false));
    }

    public AzureSecurityGroup getById(String account, String region, String id, String vnet) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, this.azureCloudProvider, "*", id, region, account), true), false));
    }

    public Set<AzureSecurityGroup> getAllMatchingKeyPattern(String pattern, boolean includeRules) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadResults", 2, this, includeRules, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), pattern)));
    }

    public Set<AzureSecurityGroup> loadResults(boolean includeRules, Collection<String> identifiers) {
        CallSite transform = IndyInterface.bootstrap("invoke", "curry", 0, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData"), includeRules);
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        CallSite transformed = IndyInterface.bootstrap("invoke", "collect", 0, data, transform);
        return IndyInterface.bootstrap("cast", "()", 0, transformed);
    }

    public AzureSecurityGroup fromCacheData(boolean includeRules, CacheData cacheData) {
        CallSite sg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), "securitygroup"), AzureSecurityGroupDescription.class));
        CallSite parts = IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, this.azureCloudProvider, IndyInterface.bootstrap("getProperty", "id", 0, cacheData));
        Object[] objectArray = new Object[26];
        objectArray[0] = "type";
        objectArray[1] = "azure";
        objectArray[2] = "id";
        objectArray[3] = IndyInterface.bootstrap("getProperty", "name", 4, sg);
        objectArray[4] = "name";
        objectArray[5] = IndyInterface.bootstrap("getProperty", "name", 4, sg);
        objectArray[6] = "account";
        CallSite callSite = IndyInterface.bootstrap("getProperty", "account", 0, parts);
        objectArray[7] = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "none";
        objectArray[8] = "accountName";
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "account", 0, parts);
        objectArray[9] = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : "none";
        objectArray[10] = "application";
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "application", 0, parts);
        objectArray[11] = IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : IndyInterface.bootstrap("getProperty", "name", 4, sg);
        objectArray[12] = "region";
        objectArray[13] = IndyInterface.bootstrap("getProperty", "location", 4, sg);
        objectArray[14] = "network";
        objectArray[15] = "na";
        objectArray[16] = "tags";
        objectArray[17] = IndyInterface.bootstrap("getProperty", "tags", 4, sg);
        objectArray[18] = "subnets";
        objectArray[19] = IndyInterface.bootstrap("getProperty", "subnets", 4, sg);
        objectArray[20] = "inboundRules";
        objectArray[21] = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        objectArray[22] = "outboundRules";
        objectArray[23] = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        objectArray[24] = "securityRules";
        objectArray[25] = IndyInterface.bootstrap("getProperty", "securityRules", 4, sg);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AzureSecurityGroup.class, ScriptBytecodeAdapter.createMap((Object[])objectArray)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureSecurityGroupProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

