/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.servergroup.ops;

import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageInner;
import com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.azure.resourcemanager.resources.models.Deployment;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.common.model.AzureDeploymentOperation;
import com.netflix.spinnaker.clouddriver.azure.resources.common.model.KeyVaultSecret;
import com.netflix.spinnaker.clouddriver.azure.resources.network.model.AzureVirtualNetworkDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.network.view.AzureNetworkProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureServerGroupDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.ops.AzureServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.azure.resources.subnet.model.AzureSubnetDescription;
import com.netflix.spinnaker.clouddriver.azure.templates.AzureServerGroupResourceTemplate;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation
implements AtomicOperation<Map> {
    private static final String BASE_PHASE = "CREATE_SERVER_GROUP";
    private final AzureServerGroupDescription description;
    @Autowired
    AzureNetworkProvider networkProvider;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation(AzureServerGroupDescription description) {
        this.description = description;
    }

    public Map operate(List priorOutputs) {
        CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Initializing deployment of server group with Azure Load Balancer %s in %s", this.description.getName(), this.description.getRegion()));
        ArrayList<String> errList = new ArrayList<String>();
        String resourceGroupName = null;
        String virtualNetworkName = null;
        String loadBalancerPoolID = null;
        String inboundNatPoolID = null;
        String subnetId = null;
        try {
            CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Beginning server group deployment");
            if (!this.description.getImage().getIsCustom().booleanValue()) {
                VirtualMachineImage virtualMachineImage = this.description.getCredentials().getComputeClient().getVMImage(this.description.getRegion(), this.description.getImage().getPublisher(), this.description.getImage().getOffer(), this.description.getImage().getSku(), this.description.getImage().getVersion());
                if (virtualMachineImage != null) {
                    throw new RuntimeException(String.format("Invalid published image was selected; %s:%s:%s:%s does not exist", this.description.getImage().getPublisher(), this.description.getImage().getOffer(), this.description.getImage().getSku(), this.description.getImage().getVersion()));
                }
                if (this.description.getImage().getImageName() == null) {
                    this.description.getImage().setImageName(((VirtualMachineImageInner)virtualMachineImage.innerModel()).name());
                }
                if (this.description.getImage().getOstype() == null) {
                    this.description.getImage().setOstype(virtualMachineImage.osDiskImage().operatingSystem().name());
                }
            }
            resourceGroupName = AzureUtilities.getResourceGroupName(this.description.getApplication(), this.description.getRegion());
            String loadBalancerName = this.description.getLoadBalancerName();
            virtualNetworkName = this.description.getVnet();
            String subnetName = this.description.getSubnet();
            AzureVirtualNetworkDescription vnetDescription = this.networkProvider.get(this.description.getAccountName(), this.description.getRegion(), this.description.getVnetResourceGroup(), virtualNetworkName);
            if (vnetDescription == null) {
                throw new RuntimeException("Selected virtual network " + virtualNetworkName + " does not exist");
            }
            List<AzureSubnetDescription> subnets = vnetDescription.getSubnets();
            if (subnets == null || subnets.size() == 0) {
                throw new RuntimeException("Cannot find any subnets in virtual network " + virtualNetworkName);
            }
            Optional<AzureSubnetDescription> filteredSubnet = subnets.stream().filter(subnet -> subnet.getName().equals(subnetName)).findFirst();
            if (!filteredSubnet.isPresent()) {
                throw new RuntimeException("Selected subnet " + subnetName + " in virtual network " + virtualNetworkName + " is not valid");
            }
            subnetId = filteredSubnet.get().getResourceId();
            CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Using virtual network %s and subnet %s for server group %s", virtualNetworkName, subnetName, this.description.getName()));
            this.description.setHasNewSubnet(false);
            AzureServerGroupNameResolver nameResolver = new AzureServerGroupNameResolver(this.description.getAccountName(), this.description.getRegion(), this.description.getCredentials());
            this.description.setName(nameResolver.resolveNextServerGroupName(this.description.getApplication(), this.description.getStack(), this.description.getDetail(), false));
            this.description.setClusterName(this.description.getClusterName());
            this.description.setAppName(this.description.getApplication());
            CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Create new backend address pool in Load Balancer: %s", loadBalancerName));
            loadBalancerPoolID = this.description.getCredentials().getNetworkClient().createLoadBalancerAPforServerGroup(resourceGroupName, this.description.getLoadBalancerName(), this.description.getName());
            if (loadBalancerPoolID == null) {
                throw new RuntimeException(String.format("Selected Load Balancer %s does not exist", this.description.getLoadBalancerName()));
            }
            CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Create new inbound NAT pool in Load Balancer: %s", loadBalancerName));
            inboundNatPoolID = this.description.getCredentials().getNetworkClient().createLoadBalancerNatPoolPortRangeforServerGroup(resourceGroupName, this.description.getLoadBalancerName(), this.description.getName());
            if (inboundNatPoolID == null) {
                CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Failed to create new inbound NAT pool in Load Balancer: %s, the task will continue", loadBalancerName));
            }
            HashMap<String, Object> templateParameters = new HashMap<String, Object>();
            templateParameters.put(AzureServerGroupResourceTemplate.getSubnetParameterName(), subnetId);
            templateParameters.put(AzureServerGroupResourceTemplate.getAppGatewayAddressPoolParameterName(), loadBalancerPoolID);
            templateParameters.put(AzureServerGroupResourceTemplate.getVmUserNameParameterName(), new KeyVaultSecret("VMUsername", this.description.getCredentials().getSubscriptionId(), this.description.getCredentials().getDefaultResourceGroup(), this.description.getCredentials().getDefaultKeyVault()));
            if (this.description.getCredentials().getUseSshPublicKey() != null && this.description.getCredentials().getUseSshPublicKey().booleanValue()) {
                templateParameters.put(AzureServerGroupResourceTemplate.getVmSshPublicKeyParameterName(), new KeyVaultSecret("VMSshPublicKey", this.description.getCredentials().getSubscriptionId(), this.description.getCredentials().getDefaultResourceGroup(), this.description.getCredentials().getDefaultKeyVault()));
            } else {
                templateParameters.put(AzureServerGroupResourceTemplate.getVmPasswordParameterName(), new KeyVaultSecret("VMPassword", this.description.getCredentials().getSubscriptionId(), this.description.getCredentials().getDefaultResourceGroup(), this.description.getCredentials().getDefaultKeyVault()));
            }
            templateParameters.put(AzureServerGroupResourceTemplate.getLoadBalancerAddressPoolParameterName(), loadBalancerPoolID);
            templateParameters.put(AzureServerGroupResourceTemplate.getLoadBalancerNatPoolParameterName(), inboundNatPoolID);
            if (this.description.getOsConfig().getCustomData() != null && this.description.getOsConfig().getCustomData().length() > 0) {
                templateParameters.put(AzureServerGroupResourceTemplate.getCustomDataParameterName(), this.description.getOsConfig().getCustomData());
            }
            if (errList.isEmpty()) {
                CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Deploying server group");
                Deployment deployment = this.description.getCredentials().getResourceManagerClient().createResourceFromTemplate(AzureServerGroupResourceTemplate.getTemplate(this.description), resourceGroupName, this.description.getRegion(), this.description.getName(), "serverGroup", templateParameters);
                errList.addAll(AzureDeploymentOperation.checkDeploymentOperationStatus(CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask(), BASE_PHASE, this.description.getCredentials(), resourceGroupName, deployment.name()));
            }
        }
        catch (Exception e) {
            CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Unexpected exception: Deployment of server group %s failed: %s", this.description.getName(), e.getMessage()));
            errList.add(e.getMessage());
        }
        if (errList.isEmpty()) {
            if (this.description.getCredentials().getNetworkClient().isServerGroupWithAppGatewayDisabled(resourceGroupName, this.description.getLoadBalancerName(), this.description.getName()).booleanValue()) {
                this.description.getCredentials().getNetworkClient().enableServerGroupWithLoadBalancer(resourceGroupName, this.description.getLoadBalancerName(), this.description.getName());
                Boolean healthy = this.description.getCredentials().getComputeClient().waitForScaleSetHealthy(resourceGroupName, this.description.getName(), 3600000L);
                if (healthy.booleanValue()) {
                    CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Done enabling Azure server group %s in %s.", this.description.getName(), this.description.getRegion()));
                } else {
                    errList.add("Server group did not come up in time");
                }
            } else {
                CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Azure server group %s in %s is already enabled.", this.description.getName(), this.description.getRegion()));
            }
            CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deployment for server group %s in %s has succeeded.", this.description.getName(), this.description.getRegion()));
        }
        if (!errList.isEmpty()) {
            String errMessage;
            CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Cleanup any resources created as part of server group upsert");
            try {
                AzureServerGroupDescription sgDescription;
                if (this.description.getName() != null && this.description.getName().length() > 0 && (sgDescription = this.description.getCredentials().getComputeClient().getServerGroup(resourceGroupName, this.description.getName())) != null) {
                    this.description.getCredentials().getComputeClient().destroyServerGroup(resourceGroupName, this.description.getName());
                }
            }
            catch (Exception e) {
                errMessage = String.format("Unexpected exception: %s! Please log in into Azure Portal and manually delete any resource associated with the %s server group such as storage accounts, internal load balancer, public IP and subnets", e.getMessage(), this.description.getName());
                CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, errMessage);
                errList.add(errMessage);
            }
            try {
                if (loadBalancerPoolID != null) {
                    this.description.getCredentials().getNetworkClient().removeLoadBalancerAPforServerGroup(resourceGroupName, this.description.getLoadBalancerName(), this.description.getName());
                }
            }
            catch (Exception e) {
                errMessage = String.format("Unexpected exception: %s! Load balancer backend address pool entry %s associated with the %s server group could not be deleted", e.getMessage(), loadBalancerPoolID, this.description.getName());
                CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, errMessage);
                errList.add(errMessage);
            }
            try {
                if (inboundNatPoolID != null) {
                    this.description.getCredentials().getNetworkClient().removeLoadBalancerNatPoolPortRangeforServerGroup(resourceGroupName, this.description.getLoadBalancerName(), this.description.getName());
                }
            }
            catch (Exception e) {
                errMessage = String.format("Unexpected exception: %s! Load balancer inbound nat pool entry %s associated with the %s server group could not be deleted", e.getMessage(), inboundNatPoolID, this.description.getName());
                CreateAzureServerGroupWithAzureLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, errMessage);
                errList.add(errMessage);
            }
            throw new AtomicOperationException(String.format("%s deployment failed", this.description.getName()), errList);
        }
        LinkedHashMap<String, Cloneable> map = new LinkedHashMap<String, Cloneable>(2);
        LinkedHashMap map1 = new LinkedHashMap(1);
        LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>(1);
        map2.put("name", this.description.getName());
        map1.put(this.description.getRegion(), map2);
        map.put("serverGroups", map1);
        map.put("serverGroupNames", new ArrayList<String>(Arrays.asList(this.description.getRegion() + ":" + this.description.getName().toString())));
        return map;
    }
}

