/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.vmimage.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.azure.AzureCloudProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.common.cache.Keys;
import com.netflix.spinnaker.clouddriver.azure.resources.common.cache.provider.AzureInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.vmimage.model.AzureManagedVMImage;
import com.netflix.spinnaker.clouddriver.azure.security.AzureCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureManagedImageCachingAgent
implements CachingAgent,
CustomScheduledAgent,
AccountAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_POLL_INTERVAL_MILLIS = TimeUnit.HOURS.toMillis(2L);
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    private final AzureCloudProvider azureCloudProvider;
    private final String accountName;
    private final AzureCredentials creds;
    private final String region;
    private final ObjectMapper objectMapper;
    private final long pollIntervalMillis;
    private final long timeoutMillis;
    private static final Set<AgentDataType> types = Set.of(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.AZURE_MANAGEDIMAGES.toString()));

    public AzureManagedImageCachingAgent(AzureCloudProvider azureCloudProvider, String accountName, AzureCredentials creds, String region, ObjectMapper objectMapper) {
        this(azureCloudProvider, accountName, creds, region, objectMapper, DEFAULT_POLL_INTERVAL_MILLIS, DEFAULT_TIMEOUT_MILLIS);
    }

    AzureManagedImageCachingAgent(AzureCloudProvider azureCloudProvider, String accountName, AzureCredentials creds, String region, ObjectMapper objectMapper, long pollIntervalMillis, long timeoutMillis) {
        this.azureCloudProvider = azureCloudProvider;
        this.accountName = accountName;
        this.creds = creds;
        this.region = region;
        this.objectMapper = objectMapper;
        this.pollIntervalMillis = pollIntervalMillis;
        this.timeoutMillis = timeoutMillis;
    }

    public String getProviderName() {
        return AzureInfrastructureProvider.PROVIDER_NAME;
    }

    public String getAgentType() {
        return new StringJoiner("/").add(this.accountName).add(this.creds.getDefaultResourceGroup()).add(this.region).add(this.getClass().getSimpleName()).toString();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        this.log.info("Describing items in {}", (Object)this.getAgentType());
        List<AzureManagedVMImage> vmImages = this.creds.getComputeClient().getAllVMCustomImages(this.creds.getDefaultResourceGroup(), this.region);
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        List data = vmImages.stream().map(arg_0 -> this.lambda$loadData$0((TypeReference)typeRef, arg_0)).collect(Collectors.toList());
        this.log.info("Caching {} items in {}", (Object)data.size(), (Object)this.getAgentType());
        return new DefaultCacheResult(Map.of(Keys.Namespace.AZURE_MANAGEDIMAGES.toString(), data));
    }

    public long getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    private /* synthetic */ DefaultCacheData lambda$loadData$0(TypeReference typeRef, AzureManagedVMImage vmImage) {
        Map attributes = (Map)this.objectMapper.convertValue((Object)vmImage, typeRef);
        return new DefaultCacheData(Keys.getManagedVMImageKey(this.azureCloudProvider, this.accountName, vmImage.getRegion(), vmImage.getResourceGroup(), vmImage.getName(), vmImage.getOsType()), Map.of("vmimage", attributes), Map.of());
    }
}

