/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.client;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.resourcemanager.AzureResourceManager;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spinnaker.clouddriver.azure.client.AzureResourceManagerClient;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureBaseClient
implements GroovyObject {
    private final String subscriptionId;
    private static final long AZURE_ATOMICOPERATION_RETRY = 5L;
    private static ObjectMapper mapper;
    private final AzureResourceManager azure;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected AzureBaseClient(String subscriptionId, AzureProfile azureProfile, TokenCredential credentials) {
        AzureResourceManager azureResourceManager;
        ObjectMapper objectMapper;
        String string;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.subscriptionId = string = subscriptionId;
        mapper = objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.azure = azureResourceManager = this.initialize(credentials, subscriptionId, azureProfile);
    }

    private AzureResourceManager initialize(TokenCredential credentials, String subscriptionId, AzureProfile azureProfile) {
        return ((AzureResourceManager.Configurable)AzureResourceManager.configure().withLogLevel(HttpLogDetailLevel.NONE)).authenticate(credentials, azureProfile).withSubscription(subscriptionId);
    }

    public static TokenCredential getTokenCredentials(String clientId, String tenantId, String secret, String configuredAzureEnvironment) {
        AzureProfile azureProfile = AzureBaseClient.getAzureProfile(configuredAzureEnvironment);
        return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(tenantId)).authorityHost(azureProfile.getEnvironment().getActiveDirectoryEndpoint())).build();
    }

    public static AzureProfile getAzureProfile(String configuredAzureEnvironment) {
        String string = configuredAzureEnvironment;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"AZURE_US_GOVERNMENT")) {
            return new AzureProfile(AzureEnvironment.AZURE_US_GOVERNMENT);
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"AZURE_CHINA")) {
            return new AzureProfile(AzureEnvironment.AZURE_CHINA);
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"AZURE_GERMANY")) {
            return new AzureProfile(AzureEnvironment.AZURE_GERMANY);
        }
        return new AzureProfile(AzureEnvironment.AZURE);
    }

    public static <T> T executeOp(Closure<T> operation, long count) {
        long retryCount = count <= (long)0 ? count - (long)1 : (long)0;
        long interval = $const$0;
        while (retryCount < count) {
            long l = retryCount;
            long cfr_ignored_0 = l + 1L;
            Object object = operation.call();
            try {
                return (T)object;
            }
            catch (Exception e) {
                Boolean bl = AzureBaseClient.resourceNotFound(e);
                if (bl == null ? false : bl) {
                    if (log.isWarnEnabled()) {
                        log.warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Azure resource(s) not found: ", ""}))));
                        v1 = null;
                    } else {
                        v1 = null;
                    }
                    T t = null;
                    return t;
                }
                if (retryCount < count) {
                    if (!(!AzureBaseClient.handleTooManyRequestsResponse(e)) || !AzureBaseClient.canRetry(e)) continue;
                    if (log.isWarnEnabled()) {
                        log.warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Retrying Azure operation: ", ""}))));
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                    DefaultGroovyStaticMethods.sleep(null, (long)(interval * retryCount));
                    continue;
                }
                throw (Throwable)e;
            }
        }
        return null;
    }

    private static boolean canRetry(Exception e) {
        boolean retry = false;
        if (ScriptBytecodeAdapter.compareEqual(e.getClass(), ManagementException.class)) {
            int code = ((ManagementException)((Object)IndyInterface.bootstrap("invoke", "asType", 0, e, ManagementException.class))).getResponse().getStatusCode();
            retry = code == HttpURLConnection.HTTP_CLIENT_TIMEOUT || code >= HttpURLConnection.HTTP_INTERNAL_ERROR && code <= HttpURLConnection.HTTP_GATEWAY_TIMEOUT;
        } else if (ScriptBytecodeAdapter.compareEqual(e.getClass(), SocketTimeoutException.class)) {
            retry = true;
        }
        return retry;
    }

    private static boolean handleTooManyRequestsResponse(Exception e) {
        if (ScriptBytecodeAdapter.compareEqual(e.getClass(), ManagementException.class) && ((ManagementException)((Object)IndyInterface.bootstrap("invoke", "asType", 0, e, ManagementException.class))).getResponse().getStatusCode() == 429) {
            int retryAfterIntervalSec = StringGroovyMethods.toInteger((CharSequence)((ManagementException)((Object)IndyInterface.bootstrap("invoke", "asType", 0, e, ManagementException.class))).getResponse().getHeaderValue("Retry-After"));
            if (retryAfterIntervalSec != 0) {
                if (log.isWarnEnabled()) {
                    log.warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{retryAfterIntervalSec}, new String[]{"Received 'Too Many Requests' (429) response from Azure. Retrying in ", " seconds"}))));
                    v0 = null;
                } else {
                    v0 = null;
                }
                DefaultGroovyStaticMethods.sleep(null, (long)(retryAfterIntervalSec * 1000));
                return true;
            }
        }
        return false;
    }

    public static Response<Void> deleteAzureResource(Closure azureOps, String resourceGroup, String resourceName, String parentResourceName, String msgRetry, String msgFail, long count) {
        Response<Void> result = null;
        long operationRetry = 0L;
        while (operationRetry < count) {
            try {
                long l = operationRetry;
                operationRetry = l + 1L;
                String string = parentResourceName;
                if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
                    azureOps.call(new Object[]{resourceGroup, parentResourceName, resourceName});
                } else {
                    azureOps.call(new Object[]{resourceGroup, resourceName});
                }
                operationRetry = count;
            }
            catch (ManagementException e) {
                Boolean bl = AzureBaseClient.resourceNotFound((Exception)((Object)e));
                if (bl == null ? false : bl) {
                    continue;
                }
                if (!(operationRetry >= count)) continue;
                throw (Throwable)e;
            }
            catch (Exception e) {
                DefaultGroovyStaticMethods.sleep(null, (long)200);
                if (log.isWarnEnabled()) {
                    log.warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{msgRetry, e.getMessage()}, new String[]{"", ": ", ""}))));
                    v2 = null;
                } else {
                    v2 = null;
                }
                if (!(operationRetry >= count)) continue;
                log.error(msgFail);
                throw (Throwable)e;
            }
        }
        return result;
    }

    public static Boolean resourceNotFound(Exception e) {
        return ScriptBytecodeAdapter.compareEqual(e.getClass(), ManagementException.class) ? ((ManagementException)((Object)IndyInterface.bootstrap("invoke", "asType", 0, e, ManagementException.class))).getResponse().getStatusCode() == HttpURLConnection.HTTP_NOT_FOUND : false;
    }

    public void register(AzureResourceManagerClient resourceManagerClient) {
        if (DefaultTypeTransformation.booleanUnbox((Object)resourceManagerClient) && DefaultTypeTransformation.booleanUnbox((Object)this.getProviderNamespace())) {
            resourceManagerClient.registerProvider(this.getProviderNamespace());
        }
    }

    protected abstract String getProviderNamespace();

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureBaseClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public static <T> T executeOp(Closure<T> operation) {
        return AzureBaseClient.executeOp(operation, AZURE_ATOMICOPERATION_RETRY);
    }

    @Generated
    public static Response<Void> deleteAzureResource(Closure azureOps, String resourceGroup, String resourceName, String parentResourceName, String msgRetry, String msgFail) {
        return AzureBaseClient.deleteAzureResource(azureOps, resourceGroup, resourceName, parentResourceName, msgRetry, msgFail, AZURE_ATOMICOPERATION_RETRY);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        $const$0 = l = 200L;
    }

    static {
        Logger logger;
        AzureBaseClient.__$swapInit();
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.azure.client.AzureBaseClient");
    }

    @Generated
    public final String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public static long getAZURE_ATOMICOPERATION_RETRY() {
        return AZURE_ATOMICOPERATION_RETRY;
    }

    @Generated
    public static ObjectMapper getMapper() {
        return mapper;
    }

    @Generated
    public static void setMapper(ObjectMapper objectMapper) {
        mapper = objectMapper;
    }

    @Generated
    public final AzureResourceManager getAzure() {
        return this.azure;
    }
}

