/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.client;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.DeploymentOperation;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.netflix.spinnaker.clouddriver.azure.client.AzureBaseClient;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureResourceManagerClient
extends AzureBaseClient {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AzureResourceManagerClient(String subscriptionId, TokenCredential credentials, AzureProfile azureProfile) {
        super(subscriptionId, azureProfile, credentials);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Deployment createResourceFromTemplate(String template, String resourceGroupName, String region, String resourceName, String resourceType, Map<String, Object> templateParams) {
        String deploymentName = DefaultGroovyMethods.join((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{resourceName, resourceType, "deployment"}), (String)AzureUtilities.getNAME_SEPARATOR());
        if (IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt(templateParams, (Object)"location")) == false) {
            String string = region;
            ScriptBytecodeAdapter.invokeMethodN(AzureResourceManagerClient.class, templateParams, (String)"putAt", (Object[])new Object[]{"location", string});
        }
        return this.createTemplateDeployment(resourceGroupName, DeploymentMode.INCREMENTAL, deploymentName, template, templateParams);
    }

    public ResourceGroup createResourceGroup(String resourceGroupName, String region) {
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, ((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)this.getAzure().resourceGroups().define(resourceGroupName)).withRegion(region)).create());
        try {
            return callSite;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{resourceGroupName, region}, new String[]{"Unable to create Resource Group ", " in region ", ""}))), (Throwable)((Object)IndyInterface.bootstrap("cast", "()", 0, e)));
        }
    }

    public ResourceGroup initializeResourceGroupAndVNet(String resourceGroupName, String virtualNetworkName, String region) {
        ResourceGroup resourceGroup = null;
        resourceGroup = !this.resourceGroupExists(resourceGroupName) ? this.createResourceGroup(resourceGroupName, region) : this.getResourceGroup(resourceGroupName);
        String string = virtualNetworkName;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            this.initializeResourceGroupVNet(resourceGroupName, virtualNetworkName, region);
        }
        return resourceGroup;
    }

    public boolean resourceGroupExists(String resourceGroupName) {
        return this.getAzure().resourceGroups().contain(resourceGroupName);
    }

    private ResourceGroup getResourceGroup(String resourceGroupName) {
        return IndyInterface.bootstrap("cast", "()", 0, this.getAzure().resourceGroups().getByName(resourceGroupName));
    }

    /*
     * WARNING - void declaration
     */
    public List<DeploymentOperation> getDeploymentOperations(String resourceGroupName, String deploymentName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference deploymentName2 = new Reference((Object)var2_2);
        public final class _getDeploymentOperations_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference deploymentName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDeploymentOperations_closure1(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference deploymentName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.deploymentName = reference = deploymentName;
            }

            public List<DeploymentOperation> doCall(Object it) {
                PagedIterable list = ((Deployment)((AzureResourceManagerClient)this.getThisObject()).getAzure().deployments().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.deploymentName.get())))).deploymentOperations().list();
                return DefaultGroovyMethods.asList((Iterable)list);
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getDeploymentName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.deploymentName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public List<DeploymentOperation> doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDeploymentOperations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getDeploymentOperations_closure1(this, this, resourceGroupName2, deploymentName2)));
    }

    /*
     * WARNING - void declaration
     */
    public Deployment getDeployment(String resourceGroupName, String deploymentName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference deploymentName2 = new Reference((Object)var2_2);
        public final class _getDeployment_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference deploymentName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDeployment_closure2(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference deploymentName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.deploymentName = reference = deploymentName;
            }

            public Deployment doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((AzureResourceManagerClient)this.getThisObject()).getAzure().deployments().getByResourceGroup((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.deploymentName.get()))));
            }

            @Generated
            public String getResourceGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
            }

            @Generated
            public String getDeploymentName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.deploymentName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Deployment doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDeployment_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, AzureBaseClient.executeOp(new _getDeployment_closure2(this, this, resourceGroupName2, deploymentName2)));
    }

    public void healthCheck() {
        try {
            this.getAzure().genericResources().list();
        }
        catch (Exception e) {
            throw (Throwable)new Exception("Unable to ping Azure", e);
        }
    }

    private void initializeResourceGroupVNet(String resourceGroupName, String virtualNetworkName, String region) {
        CallSite vNet;
        block6: {
            vNet = null;
            try {
                vNet = IndyInterface.bootstrap("cast", "()", 0, this.getAzure().networks().getByResourceGroup(resourceGroupName, virtualNetworkName));
            }
            catch (ManagementException ignore) {
                Object v0;
                if (log.isWarnEnabled()) {
                    log.warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{virtualNetworkName}, new String[]{"Failed to locate Azure Virtual Network ", ""}))));
                    v0 = null;
                    break block6;
                }
                v0 = null;
            }
        }
        CallSite callSite = vNet;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) == false) {
            ((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.getAzure().networks().define(virtualNetworkName)).withRegion(region)).withExistingResourceGroup(resourceGroupName)).create();
        }
    }

    /*
     * Unable to fully structure code
     */
    private Deployment createTemplateDeployment(String resourceGroupName, DeploymentMode deploymentMode, String deploymentName, String template, Map<String, Object> templateParameters) {
        try {
            parameters = AzureUtilities.convertParametersToTemplateJSON(AzureBaseClient.getMapper(), templateParameters);
            var7_7 = IndyInterface.bootstrap("cast", "()", 0, ((Deployment.DefinitionStages.WithTemplate)((Deployment.DefinitionStages.Blank)this.getAzure().deployments().define(deploymentName)).withExistingResourceGroup(resourceGroupName)).withTemplate(template).withParameters(parameters).withMode(deploymentMode).create());
            ** try [egrp 1[TRYBLOCK] [3 : 82->157)] { 
        }
lbl16:
        // 1 sources

        catch (Throwable var9_9) {
            throw var9_9;
        }
        finally {
            AzureResourceManagerClient.logDeploymentTemplate(deploymentName, template, templateParameters);
        }
lbl-1000:
        // 1 sources

        {
            try {
                return var7_7;
            }
            catch (Throwable e) {
                if (AzureResourceManagerClient.log.isErrorEnabled()) {
                    AzureResourceManagerClient.log.error((String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Exception occured during deployment ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                throw e;
            }
        }
    }

    public static void logDeploymentTemplate(String deploymentName, String template, Map<String, Object> parameters) {
        if (log.isInfoEnabled()) {
            log.info("Template for deployment {}: {}\nTemplate Parameters: {}", new Object[]{deploymentName, template, DefaultGroovyMethods.toMapString(parameters)});
            v0 = null;
        } else {
            v0 = null;
        }
    }

    public void registerProvider(String namespace) {
        try {
            CallSite provider = IndyInterface.bootstrap("cast", "()", 0, this.getAzure().providers().getByName(namespace));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)provider.registrationState(), (Object)"Registered")) {
                if (log.isInfoEnabled()) {
                    log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{namespace}, new String[]{"Registering Azure provider: ", ""}))));
                    v0 = null;
                } else {
                    v0 = null;
                }
                this.getAzure().providers().register(namespace);
                if (log.isInfoEnabled()) {
                    log.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{namespace}, new String[]{"Azure provider ", " registered"}))));
                    v1 = null;
                } else {
                    v1 = null;
                }
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{namespace}, new String[]{"Unable to register Azure Provider: ", ""}))), (Throwable)e);
                v2 = null;
            } else {
                v2 = null;
            }
            throw (Throwable)e;
        }
    }

    @Override
    public String getProviderNamespace() {
        return "Microsoft.Resources";
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureResourceManagerClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public Deployment createResourceFromTemplate(String template, String resourceGroupName, String region, String resourceName, String resourceType) {
        return this.createResourceFromTemplate(template, resourceGroupName, region, resourceName, resourceType, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.azure.client.AzureResourceManagerClient");
    }
}

