/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.cluster.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.azure.AzureCloudProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.application.model.AzureApplication;
import com.netflix.spinnaker.clouddriver.azure.resources.application.view.AzureApplicationProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.cluster.model.AzureCluster;
import com.netflix.spinnaker.clouddriver.azure.resources.common.cache.Keys;
import com.netflix.spinnaker.clouddriver.azure.resources.loadbalancer.model.AzureLoadBalancer;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureInstance;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureServerGroupDescription;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AzureClusterProvider
implements ClusterProvider<AzureCluster>,
GroovyObject {
    @Autowired
    private AzureCloudProvider azureCloudProvider;
    @Autowired
    private AzureApplicationProvider applicationProvider;
    @Autowired
    private Cache cacheView;
    @Autowired
    private ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AzureClusterProvider() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Set<AzureCluster> getClusters(String applicationName, String account) {
        Reference azureApplication = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getApplication", 0, this.applicationProvider, applicationName)));
        if (IndyInterface.bootstrap("cast", "()", 0, (AzureApplication)azureApplication.get()) == false) {
            return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        }
        Reference clusterKeys = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getClusters_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clusterKeys;
            private /* synthetic */ Reference azureApplication;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClusters_closure1(Object _outerInstance, Object _thisObject, Reference clusterKeys, Reference azureApplication) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.clusterKeys = reference2 = clusterKeys;
                this.azureApplication = reference = azureApplication;
            }

            public Object doCall(String accountName, Set<String> clusterNames) {
                Reference accountName2 = new Reference((Object)accountName);
                public final class _closure10
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference clusterKeys;
                    private /* synthetic */ Reference azureApplication;
                    private /* synthetic */ Reference accountName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure10(Object _outerInstance, Object _thisObject, Reference clusterKeys, Reference azureApplication, Reference accountName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.clusterKeys = reference3 = clusterKeys;
                        this.azureApplication = reference2 = azureApplication;
                        this.accountName = reference = accountName;
                    }

                    public Object doCall(String clusterName) {
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, this.clusterKeys.get(), IndyInterface.bootstrap("invoke", "getClusterKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "azureCloudProvider", 12, this), IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.azureApplication.get())), clusterName, IndyInterface.bootstrap("cast", "()", 0, this.accountName.get())));
                    }

                    @Generated
                    public Object call(String clusterName) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, clusterName);
                    }

                    @Generated
                    public Object getClusterKeys() {
                        return this.clusterKeys.get();
                    }

                    @Generated
                    public AzureApplication getAzureApplication() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.azureApplication.get());
                    }

                    @Generated
                    public String getAccountName() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.accountName.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, clusterNames, new _closure10((Object)this, this.getThisObject(), this.clusterKeys, this.azureApplication, accountName2));
            }

            @Generated
            public Object call(String accountName, Set<String> clusterNames) {
                Reference accountName2 = new Reference((Object)accountName);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (String)accountName2.get(), clusterNames);
            }

            @Generated
            public Object getClusterKeys() {
                return this.clusterKeys.get();
            }

            @Generated
            public AzureApplication getAzureApplication() {
                return IndyInterface.bootstrap("cast", "()", 0, this.azureApplication.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClusters_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "clusterNames", 4, (AzureApplication)azureApplication.get()), new _getClusters_closure1(this, this, clusterKeys, azureApplication));
        CallSite clusters = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_CLUSTERS", 0, Keys.Namespace.class)), clusterKeys.get());
        return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "translateClusters", 2, this, clusters, true), Set.class));
    }

    public Map<String, Set<AzureCluster>> getClusters() {
        CallSite clusterData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_CLUSTERS", 0, Keys.Namespace.class))));
        CallSite clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateClusters", 2, this, clusterData, true));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mapResponse", 0, AzureClusterProvider.class, clusters));
    }

    public Map<String, Set<AzureCluster>> getClusterSummaries(String applicationName) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getClusters", 2, this, applicationName, false));
    }

    public Map<String, Set<AzureCluster>> getClusterDetails(String applicationName) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getClusters", 2, this, applicationName, true));
    }

    public Map<String, Set<AzureCluster>> getClusters(String applicationName, Boolean includeInstanceDetails) {
        CallSite appData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_APPLICATIONS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "getApplicationKey", 0, Keys.class, this.azureCloudProvider, applicationName)));
        if (IndyInterface.bootstrap("cast", "()", 0, appData) == false) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        CallSite clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateClusters", 2, this, IndyInterface.bootstrap("invoke", "resolveRelationshipData", 2, this, appData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_CLUSTERS", 0, Keys.Namespace.class))), includeInstanceDetails));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mapResponse", 0, AzureClusterProvider.class, clusters));
    }

    public AzureCluster getCluster(String application, String account, String name, boolean includeDetails) {
        CallSite cluster = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_CLUSTERS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "getClusterKey", 0, Keys.class, this.azureCloudProvider, application, name, account)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, cluster) != false ? IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "translateClusters", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{cluster}), includeDetails), false) : null);
    }

    public AzureCluster getCluster(String applicationName, String account, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCluster", 2, this, applicationName, account, name, true));
    }

    public AzureServerGroupDescription getServerGroup(String account, String region, String name, boolean includeDetails) {
        CallSite serverGroupKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "ID", 0, AzureCloudProvider.class), name, region, account));
        CallSite serverGroupData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_SERVER_GROUPS", 0, Keys.Namespace.class)), serverGroupKey));
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroupData) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateServerGroup", 2, this, serverGroupData));
    }

    public AzureServerGroupDescription getServerGroup(String account, String region, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroup", 2, this, account, region, name, true));
    }

    public String getCloudProviderId() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 4, this.azureCloudProvider));
    }

    public boolean supportsMinimalClusters() {
        return false;
    }

    private Collection<AzureCluster> translateClusters(Collection<CacheData> clusterData, boolean includeDetails) {
        Reference includeDetails2 = new Reference((Object)includeDetails);
        Reference loadBalancers = new Reference(null);
        Map cfr_ignored_0 = (Map)loadBalancers.get();
        Reference serverGroups = new Reference(null);
        Map cfr_ignored_1 = (Map)serverGroups.get();
        if (DefaultTypeTransformation.booleanUnbox((Object)includeDetails2.get())) {
            CallSite allLoadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, clusterData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_APP_GATEWAYS", 0, Keys.Namespace.class))));
            CallSite allServerGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, clusterData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_SERVER_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_INSTANCES", 0, Keys.Namespace.class)))));
            loadBalancers.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateLoadBalancers", 2, this, allLoadBalancers)));
            serverGroups.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateServerGroups", 2, this, allServerGroups)));
        }
        public final class _translateClusters_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDetails;
            private /* synthetic */ Reference loadBalancers;
            private /* synthetic */ Reference serverGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateClusters_closure2(Object _outerInstance, Object _thisObject, Reference includeDetails, Reference loadBalancers, Reference serverGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.includeDetails = reference3 = includeDetails;
                this.loadBalancers = reference2 = loadBalancers;
                this.serverGroups = reference = serverGroups;
            }

            public Object doCall(CacheData clusterDataEntry) {
                CallSite clusterKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "azureCloudProvider", 12, this), IndyInterface.bootstrap("getProperty", "id", 0, clusterDataEntry)));
                CallSite cluster = IndyInterface.bootstrap("init", "<init>", 0, AzureCluster.class);
                CallSite callSite = IndyInterface.bootstrap("getProperty", "account", 0, clusterKey);
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)cluster, (String)"accountName");
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "name", 0, clusterKey);
                ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)cluster, (String)"name");
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.includeDetails.get())) != false) {
                    public final class _closure11
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference loadBalancers;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure11(Object _outerInstance, Object _thisObject, Reference loadBalancers) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.loadBalancers = reference = loadBalancers;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get()), it);
                        }

                        @Generated
                        public Map getLoadBalancers() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure11.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite3 = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_APP_GATEWAYS", 0, Keys.Namespace.class))), new _closure11((Object)this, this.getThisObject(), this.loadBalancers));
                    ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)cluster, (String)"loadBalancers");
                    public final class _closure12
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference serverGroups;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure12(Object _outerInstance, Object _thisObject, Reference serverGroups) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.serverGroups = reference = serverGroups;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get()), it);
                        }

                        @Generated
                        public Map getServerGroups() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure12.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite4 = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_SERVER_GROUPS", 0, Keys.Namespace.class))), new _closure12((Object)this, this.getThisObject(), this.serverGroups));
                    ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)cluster, (String)"serverGroups");
                } else {
                    public final class _closure13
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure13(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object loadBalancerKey) {
                            CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "azureCloudProvider", 12, this), loadBalancerKey));
                            return IndyInterface.bootstrap("init", "<init>", 0, AzureLoadBalancer.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "name", 0, parts), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts), "account", IndyInterface.bootstrap("getProperty", "account", 0, parts)}));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure13.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite5 = IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_APP_GATEWAYS", 0, Keys.Namespace.class))), new _closure13((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)cluster, (String)"loadBalancers");
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure14(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object serverGroupKey) {
                            CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "azureCloudProvider", 12, this), serverGroupKey));
                            return IndyInterface.bootstrap("init", "<init>", 0, AzureServerGroupDescription.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "serverGroup", 0, parts), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts), "application", IndyInterface.bootstrap("getProperty", "application", 0, parts), "appName", IndyInterface.bootstrap("getProperty", "application", 0, parts)}));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite6 = IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_SERVER_GROUPS", 0, Keys.Namespace.class))), new _closure14((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)cluster, (String)"serverGroups");
                }
                return cluster;
            }

            @Generated
            public Object call(CacheData clusterDataEntry) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, clusterDataEntry);
            }

            @Generated
            public boolean getIncludeDetails() {
                return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("cast", "()", 0, this.includeDetails.get()));
            }

            @Generated
            public Map getLoadBalancers() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get());
            }

            @Generated
            public Map getServerGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateClusters_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, clusterData, new _translateClusters_closure2(this, this, includeDetails2, loadBalancers, serverGroups)));
        return clusters;
    }

    private Map<String, AzureLoadBalancer> translateLoadBalancers(Collection<CacheData> loadBalancerData) {
        public final class _translateLoadBalancers_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateLoadBalancers_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object loadBalancerEntry) {
                CallSite lbKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "azureCloudProvider", 12, this), IndyInterface.bootstrap("getProperty", "id", 0, loadBalancerEntry)));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, loadBalancerEntry), IndyInterface.bootstrap("init", "<init>", 0, AzureLoadBalancer.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "name", 0, lbKey), "account", IndyInterface.bootstrap("getProperty", "account", 0, lbKey), "region", IndyInterface.bootstrap("getProperty", "region", 0, lbKey)}))});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateLoadBalancers_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, loadBalancerData, new _translateLoadBalancers_closure3(this, this)));
    }

    private Map<String, AzureServerGroupDescription> translateServerGroups(Collection<CacheData> serverGroupData) {
        public final class _translateServerGroups_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object serverGroupEntry) {
                CallSite serverGroup = IndyInterface.bootstrap("invoke", "translateServerGroup", 2, this, serverGroupEntry);
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, serverGroupEntry), serverGroup});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, serverGroupData, new _translateServerGroups_closure4(this, this)));
    }

    private AzureServerGroupDescription translateServerGroup(CacheData serverGroupData) {
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "serverGroup", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, serverGroupData)), AzureServerGroupDescription.class);
        CallSite instances = IndyInterface.bootstrap("invoke", "resolveRelationshipData", 2, this, serverGroupData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "AZURE_INSTANCES", 0, Keys.Namespace.class)));
        CallSite callSite = IndyInterface.bootstrap("invoke", "translateInstances", 2, this, instances);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)serverGroup, (String)"instances");
        return IndyInterface.bootstrap("cast", "()", 0, serverGroup);
    }

    private Set<AzureInstance> translateInstances(Collection<CacheData> instanceData) {
        public final class _translateInstances_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateInstances_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object instanceEntry) {
                return IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "instance", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, instanceEntry)), AzureInstance.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateInstances_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "collect", 1, instanceData, new _translateInstances_closure5(this, this));
        CallSite instances = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, instances, Set.class));
    }

    private static Map<String, Set<AzureCluster>> mapResponse(Collection<AzureCluster> clusters) {
        public final class _mapResponse_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapResponse_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "accountName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapResponse_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _mapResponse_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapResponse_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class, v)});
            }

            @Generated
            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapResponse_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, clusters, new _mapResponse_closure6(AzureClusterProvider.class, AzureClusterProvider.class)), new _mapResponse_closure7(AzureClusterProvider.class, AzureClusterProvider.class)));
    }

    private Collection<CacheData> resolveRelationshipDataForCollection(Collection<CacheData> sources, String relationship, CacheFilter cacheFilter) {
        Reference relationship2 = new Reference((Object)relationship);
        public final class _resolveRelationshipDataForCollection_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference relationship;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveRelationshipDataForCollection_closure8(Object _outerInstance, Object _thisObject, Reference relationship) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.relationship = reference = relationship;
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, it), IndyInterface.bootstrap("cast", "()", 0, this.relationship.get()));
                return IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public String getRelationship() {
                return IndyInterface.bootstrap("cast", "()", 0, this.relationship.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveRelationshipDataForCollection_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "flatten", 1, IndyInterface.bootstrap("invoke", "findResults", 1, sources, new _resolveRelationshipDataForCollection_closure8(this, this, relationship2)));
        CallSite relationships = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, relationships) != false ? IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, (String)relationship2.get(), relationships, cacheFilter) : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private Collection<CacheData> resolveRelationshipData(CacheData source, String relationship) {
        public final class _resolveRelationshipData_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveRelationshipData_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return true;
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveRelationshipData_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipData", 2, this, source, relationship, new _resolveRelationshipData_closure9(this, this)));
    }

    private Collection<CacheData> resolveRelationshipData(CacheData source, String relationship, Closure<Boolean> relFilter) {
        CallSite filteredRelationships = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, source), relationship), relFilter));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, filteredRelationships) != false ? IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, relationship, filteredRelationships) : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureClusterProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    private Collection<CacheData> resolveRelationshipDataForCollection(Collection<CacheData> sources, String relationship) {
        Reference relationship2 = new Reference((Object)relationship);
        return this.resolveRelationshipDataForCollection(sources, (String)relationship2.get(), null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AzureCloudProvider getAzureCloudProvider() {
        return this.azureCloudProvider;
    }

    @Generated
    public void setAzureCloudProvider(AzureCloudProvider azureCloudProvider) {
        this.azureCloudProvider = azureCloudProvider;
    }

    @Generated
    public AzureApplicationProvider getApplicationProvider() {
        return this.applicationProvider;
    }

    @Generated
    public void setApplicationProvider(AzureApplicationProvider azureApplicationProvider) {
        this.applicationProvider = azureApplicationProvider;
    }

    @Generated
    public Cache getCacheView() {
        return this.cacheView;
    }

    @Generated
    public void setCacheView(Cache cache) {
        this.cacheView = cache;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

