/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.resources.servergroup.ops;

import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import com.netflix.spinnaker.clouddriver.azure.resources.common.model.AzureDeploymentOperation;
import com.netflix.spinnaker.clouddriver.azure.resources.common.model.KeyVaultSecret;
import com.netflix.spinnaker.clouddriver.azure.resources.network.view.AzureNetworkProvider;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.model.AzureServerGroupDescription;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.ops.AzureServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.azure.resources.servergroup.ops.CreateAzureServerGroupAtomicOperation;
import com.netflix.spinnaker.clouddriver.azure.templates.AzureServerGroupResourceTemplate;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateAzureServerGroupWithoutLoadBalancersAtomicOperation
implements AtomicOperation<Map>,
GroovyObject {
    private static final String BASE_PHASE = "CREATE_SERVER_GROUP";
    private final AzureServerGroupDescription description;
    @Autowired
    private AzureNetworkProvider networkProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public CreateAzureServerGroupWithoutLoadBalancersAtomicOperation(AzureServerGroupDescription description) {
        AzureServerGroupDescription azureServerGroupDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = azureServerGroupDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Map operate(List<Map> priorOutputs) {
        CallSite errList = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
        Reference resourceGroupName = new Reference(null);
        CallSite virtualNetworkName = null;
        Object subnetName = null;
        CallSite subnetId = null;
        CallSite serverGroupName = null;
        try {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Beginning server group deployment");
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "isCustom", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description))) == false) {
                CallSite virtualMachineImage = IndyInterface.bootstrap("invoke", "getVMImage", 0, IndyInterface.bootstrap("getProperty", "computeClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "publisher", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description)), IndyInterface.bootstrap("getProperty", "offer", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description)), IndyInterface.bootstrap("getProperty", "sku", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description)), IndyInterface.bootstrap("getProperty", "version", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description)));
                if (IndyInterface.bootstrap("cast", "()", 0, virtualMachineImage) == false) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "publisher", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description)), IndyInterface.bootstrap("getProperty", "offer", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description)), IndyInterface.bootstrap("getProperty", "sku", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description)), IndyInterface.bootstrap("getProperty", "version", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description))}, new String[]{"Invalid published image was selected; ", ":", ":", ":", " does not exist"})));
                }
                CallSite callSite = IndyInterface.bootstrap("getProperty", "imageName", 0, IndyInterface.bootstrap("getProperty", "image", 4, this.description));
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "name", 0, virtualMachineImage);
                CallSite callSite3 = IndyInterface.bootstrap("getProperty", "operatingSystem", 1, IndyInterface.bootstrap("getProperty", "osDiskImage", 1, virtualMachineImage));
                ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)IndyInterface.bootstrap("getProperty", "image", 4, this.description), (String)"ostype");
            }
            resourceGroupName.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResourceGroupName", 0, AzureUtilities.class, IndyInterface.bootstrap("getProperty", "application", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description))));
            IndyInterface.bootstrap("invoke", "initializeResourceGroupAndVNet", 0, IndyInterface.bootstrap("getProperty", "resourceManagerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), (String)resourceGroupName.get(), null, IndyInterface.bootstrap("getProperty", "region", 4, this.description));
            virtualNetworkName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "vnet", 4, this.description));
            CallSite vnetDescription = IndyInterface.bootstrap("invoke", "get", 0, this.networkProvider, IndyInterface.bootstrap("getProperty", "accountName", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "vnetResourceGroup", 4, this.description), virtualNetworkName);
            if (IndyInterface.bootstrap("cast", "()", 0, vnetDescription) == false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{virtualNetworkName}, new String[]{"Selected virtual network ", " does not exist"})));
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{virtualNetworkName, IndyInterface.bootstrap("getProperty", "subnet", 4, this.description), IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Using virtual network ", " and subnet ", " for server group ", ""}));
            boolean bl = false;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class, (GroovyObject)this.description, (String)"hasNewSubnet");
            public final class _operate_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object subnet) {
                    public final class _closure3
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure3(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)"applicationGateways");
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, subnet), (Object)IndyInterface.bootstrap("getProperty", "subnet", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))) && (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "connectedDevices", 0, subnet)) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "connectedDevices", 0, subnet), new _closure3((Object)this, this.getThisObject()))) == false);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            subnetId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "resourceId", 1, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "subnets", 0, vnetDescription), new _operate_closure1(this, this))));
            if (IndyInterface.bootstrap("cast", "()", 0, subnetId) == false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "subnet", 4, this.description), IndyInterface.bootstrap("getProperty", "vnet", 4, this.description)}, new String[]{"Selected subnet ", " in virtual network ", " is not valid"})));
            }
            CallSite nameResolver = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AzureServerGroupNameResolver.class, IndyInterface.bootstrap("getProperty", "accountName", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
            CallSite callSite = IndyInterface.bootstrap("invoke", "resolveNextServerGroupName", 0, nameResolver, IndyInterface.bootstrap("getProperty", "application", 4, this.description), IndyInterface.bootstrap("getProperty", "stack", 4, this.description), IndyInterface.bootstrap("getProperty", "detail", 4, this.description), false);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class, (GroovyObject)this.description, (String)"name");
            CallSite callSite4 = IndyInterface.bootstrap("invoke", "getClusterName", 0, this.description);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite4, CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class, (GroovyObject)this.description, (String)"clusterName");
            CallSite callSite5 = IndyInterface.bootstrap("getProperty", "application", 4, this.description);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite5, CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class, (GroovyObject)this.description, (String)"appName");
            CallSite callSite6 = virtualNetworkName;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite6, CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class, (GroovyObject)this.description, (String)"vnet");
            Object var18_18 = subnetName;
            ScriptBytecodeAdapter.setGroovyObjectProperty(var18_18, CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class, (GroovyObject)this.description, (String)"subnet");
            Map templateParameters = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            CallSite callSite7 = subnetId;
            IndyInterface.bootstrap("invoke", "putAt", 0, templateParameters, IndyInterface.bootstrap("getProperty", "subnetParameterName", 0, AzureServerGroupResourceTemplate.class), callSite7);
            CallSite callSite8 = IndyInterface.bootstrap("init", "<init>", 0, KeyVaultSecret.class, "VMUsername", IndyInterface.bootstrap("getProperty", "subscriptionId", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "defaultResourceGroup", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "defaultKeyVault", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
            IndyInterface.bootstrap("invoke", "putAt", 0, templateParameters, IndyInterface.bootstrap("getProperty", "vmUserNameParameterName", 0, AzureServerGroupResourceTemplate.class), callSite8);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "useSshPublicKey", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description))) != false) {
                CallSite callSite9 = IndyInterface.bootstrap("init", "<init>", 0, KeyVaultSecret.class, "VMSshPublicKey", IndyInterface.bootstrap("getProperty", "subscriptionId", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "defaultResourceGroup", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "defaultKeyVault", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
                IndyInterface.bootstrap("invoke", "putAt", 0, templateParameters, IndyInterface.bootstrap("getProperty", "vmSshPublicKeyParameterName", 0, AzureServerGroupResourceTemplate.class), callSite9);
            } else {
                CallSite callSite10 = IndyInterface.bootstrap("init", "<init>", 0, KeyVaultSecret.class, "VMPassword", IndyInterface.bootstrap("getProperty", "subscriptionId", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "defaultResourceGroup", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "defaultKeyVault", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
                IndyInterface.bootstrap("invoke", "putAt", 0, templateParameters, IndyInterface.bootstrap("getProperty", "vmPasswordParameterName", 0, AzureServerGroupResourceTemplate.class), callSite10);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "customData", 0, IndyInterface.bootstrap("getProperty", "osConfig", 4, this.description))) != false) {
                CallSite callSite11 = IndyInterface.bootstrap("getProperty", "customData", 0, IndyInterface.bootstrap("getProperty", "osConfig", 4, this.description));
                IndyInterface.bootstrap("invoke", "putAt", 0, templateParameters, IndyInterface.bootstrap("getProperty", "customDataParameterName", 0, AzureServerGroupResourceTemplate.class), callSite11);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, errList)) != false) {
                CallSite callSite12 = subnetId;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite12, CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class, (GroovyObject)this.description, (String)"subnetId");
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Deploying server group");
                CallSite template = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTemplate", 0, AzureServerGroupResourceTemplate.class, this.description));
                CallSite deployment = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createResourceFromTemplate", 0, IndyInterface.bootstrap("getProperty", "resourceManagerClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), template, (String)resourceGroupName.get(), IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "name", 4, this.description), "serverGroup", templateParameters));
                CallSite healthy = IndyInterface.bootstrap("invoke", "waitForScaleSetHealthy", 0, IndyInterface.bootstrap("getProperty", "computeClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), (String)resourceGroupName.get(), IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "SERVER_WAIT_TIMEOUT", 0, CreateAzureServerGroupAtomicOperation.class));
                if (IndyInterface.bootstrap("cast", "()", 0, healthy) != false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("invoke", "getTask", 0, CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class), BASE_PHASE, IndyInterface.bootstrap("invoke", "format", 0, String.class, "Done enabling Azure server group %s in %s.", IndyInterface.bootstrap("invoke", "getName", 0, this.description), IndyInterface.bootstrap("invoke", "getRegion", 0, this.description)));
                } else {
                    IndyInterface.bootstrap("invoke", "add", 0, errList, "Server group did not come up in time");
                }
                IndyInterface.bootstrap("invoke", "addAll", 0, errList, IndyInterface.bootstrap("invoke", "checkDeploymentOperationStatus", 0, AzureDeploymentOperation.class, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), (String)resourceGroupName.get(), IndyInterface.bootstrap("invoke", "name", 0, deployment)));
                serverGroupName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, errList)) != false ? IndyInterface.bootstrap("getProperty", "name", 4, this.description) : null);
            }
        }
        catch (Exception e) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Unexpected exception: Deployment of server group ", " failed: ", ""}));
            IndyInterface.bootstrap("invoke", "add", 0, errList, IndyInterface.bootstrap("getProperty", "message", 0, e));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, errList)) == false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Cleanup any resources created as part of server group upsert");
            try {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, this.description)) != false) {
                    CallSite sgDescription = IndyInterface.bootstrap("invoke", "getServerGroup", 0, IndyInterface.bootstrap("getProperty", "computeClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), (String)resourceGroupName.get(), IndyInterface.bootstrap("getProperty", "name", 4, this.description));
                    if (IndyInterface.bootstrap("cast", "()", 0, sgDescription) != false) {
                        IndyInterface.bootstrap("invoke", "destroyServerGroup", 0, IndyInterface.bootstrap("getProperty", "computeClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), (String)resourceGroupName.get(), IndyInterface.bootstrap("getProperty", "name", 4, this.description));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "isCustom", 0, IndyInterface.bootstrap("getProperty", "image", 0, sgDescription))) == false) {
                            public final class _operate_closure2
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference resourceGroupName;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _operate_closure2(Object _outerInstance, Object _thisObject, Reference resourceGroupName) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.resourceGroupName = reference = resourceGroupName;
                                }

                                public Object doCall(Object storageAccountName) {
                                    return IndyInterface.bootstrap("invoke", "deleteStorageAccount", 0, IndyInterface.bootstrap("getProperty", "storageClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))), IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get()), storageAccountName);
                                }

                                @Generated
                                public String getResourceGroupName() {
                                    return IndyInterface.bootstrap("cast", "()", 0, this.resourceGroupName.get());
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "storageAccountNames", 0, sgDescription), new _operate_closure2(this, this, resourceGroupName));
                        }
                    }
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "hasNewSubnet", 4, this.description)) != false) {
                    IndyInterface.bootstrap("invoke", "deleteSubnet", 0, IndyInterface.bootstrap("getProperty", "networkClient", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "vnetResourceGroup", 4, this.description), virtualNetworkName, subnetName);
                }
            }
            catch (Exception e) {
                GStringImpl errMessage = new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e), IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"Unexpected exception: ", "! Please log in into Azure Portal and manually delete any resource associated with the ", " server group such as storage accounts, internal load balancer, public IP and subnets"});
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, errMessage);
                IndyInterface.bootstrap("invoke", "add", 0, errList, errMessage);
            }
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AtomicOperationException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"", " deployment failed"}), errList));
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"Deployment for server group ", " in ", " has succeeded."}));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"serverGroups", ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "name", 4, this.description)})}), "serverGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description), IndyInterface.bootstrap("getProperty", "name", 4, this.description)}, new String[]{"", ":", ""}))})});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CreateAzureServerGroupWithoutLoadBalancersAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AzureNetworkProvider getNetworkProvider() {
        return this.networkProvider;
    }

    @Generated
    public void setNetworkProvider(AzureNetworkProvider azureNetworkProvider) {
        this.networkProvider = azureNetworkProvider;
    }
}

