/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Applications;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Domains;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Logs;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Organizations;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Processes;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Routes;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ServiceInstances;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ServiceKeys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Spaces;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Tasks;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ApplicationService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.AuthenticationService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ConfigService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.DomainService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.DopplerService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.OrganizationService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ProcessesService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.RouteService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ServiceInstanceService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ServiceKeyService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.SpaceService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.TaskService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.retry.RetryInterceptor;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.tokens.AccessTokenAuthenticator;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.tokens.AccessTokenInterceptor;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.tokens.AccessTokenProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.config.CloudFoundryConfigurationProperties;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.ForkJoinPool;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.converter.protobuf.ProtoConverterFactory;

public class HttpCloudFoundryClient
implements CloudFoundryClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpCloudFoundryClient.class);
    private final String apiHost;
    private final String user;
    private final String password;
    private Logger logger = LoggerFactory.getLogger(HttpCloudFoundryClient.class);
    private AuthenticationService uaaService;
    private Spaces spaces;
    private Organizations organizations;
    private Domains domains;
    private Routes routes;
    private Applications applications;
    private ServiceInstances serviceInstances;
    private ServiceKeys serviceKeys;
    private Tasks tasks;
    private Logs logs;
    private Processes processes;

    public HttpCloudFoundryClient(String account, String appsManagerUri, String metricsUri, String apiHost, String user, String password, boolean useHttps, boolean skipSslValidation, boolean onlySpinnakerManaged, Integer resultsPerPage, ForkJoinPool forkJoinPool, OkHttpClient.Builder okHttpClientBuilder, CloudFoundryConfigurationProperties.ClientConfig clientConfig) {
        this.apiHost = apiHost;
        this.user = user;
        this.password = password;
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.registerModule((Module)new JavaTimeModule());
        OkHttpClient okHttpClient = HttpCloudFoundryClient.applySslValidator(okHttpClientBuilder, skipSslValidation);
        this.uaaService = (AuthenticationService)new Retrofit.Builder().baseUrl((useHttps ? "https://" : "http://") + this.apiHost.replaceAll("^api\\.", "login.")).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).build().create(AuthenticationService.class);
        AccessTokenProvider accessTokenProvider = new AccessTokenProvider(user, password, this.uaaService);
        okHttpClient = okHttpClient.newBuilder().authenticator((Authenticator)new AccessTokenAuthenticator(accessTokenProvider)).addInterceptor((Interceptor)new AccessTokenInterceptor(accessTokenProvider)).addInterceptor((Interceptor)new RetryInterceptor(clientConfig.getMaxRetries())).build();
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl((useHttps ? "https://" : "http://") + this.apiHost).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).build();
        this.organizations = new Organizations((OrganizationService)retrofit.create(OrganizationService.class));
        this.spaces = new Spaces((SpaceService)retrofit.create(SpaceService.class), this.organizations);
        this.processes = new Processes((ProcessesService)retrofit.create(ProcessesService.class));
        this.applications = new Applications(account, appsManagerUri, metricsUri, (ApplicationService)retrofit.create(ApplicationService.class), this.spaces, this.processes, resultsPerPage, onlySpinnakerManaged, forkJoinPool);
        this.domains = new Domains((DomainService)retrofit.create(DomainService.class), this.organizations);
        this.serviceInstances = new ServiceInstances((ServiceInstanceService)retrofit.create(ServiceInstanceService.class), (ConfigService)retrofit.create(ConfigService.class), this.spaces);
        this.routes = new Routes(account, (RouteService)retrofit.create(RouteService.class), this.applications, this.domains, this.spaces, resultsPerPage, forkJoinPool);
        this.serviceKeys = new ServiceKeys((ServiceKeyService)retrofit.create(ServiceKeyService.class), this.spaces);
        this.tasks = new Tasks((TaskService)retrofit.create(TaskService.class));
        this.logs = new Logs((DopplerService)new Retrofit.Builder().client(okHttpClient).baseUrl((useHttps ? "https://" : "http://") + apiHost.replaceAll("^api\\.", "doppler.")).addConverterFactory((Converter.Factory)ProtoConverterFactory.create()).build().create(DopplerService.class));
    }

    private static OkHttpClient applySslValidator(OkHttpClient.Builder builder, boolean skipSslValidation) {
        if (skipSslValidation) {
            SSLContext sslContext;
            builder.hostnameVerifier((s, sslSession) -> true);
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            try {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        return builder.build();
    }

    @Generated
    public AuthenticationService getUaaService() {
        return this.uaaService;
    }

    @Override
    @Generated
    public Spaces getSpaces() {
        return this.spaces;
    }

    @Override
    @Generated
    public Organizations getOrganizations() {
        return this.organizations;
    }

    @Override
    @Generated
    public Domains getDomains() {
        return this.domains;
    }

    @Override
    @Generated
    public Routes getRoutes() {
        return this.routes;
    }

    @Override
    @Generated
    public Applications getApplications() {
        return this.applications;
    }

    @Override
    @Generated
    public ServiceInstances getServiceInstances() {
        return this.serviceInstances;
    }

    @Override
    @Generated
    public ServiceKeys getServiceKeys() {
        return this.serviceKeys;
    }

    @Override
    @Generated
    public Tasks getTasks() {
        return this.tasks;
    }

    @Override
    @Generated
    public Logs getLogs() {
        return this.logs;
    }

    @Override
    @Generated
    public Processes getProcesses() {
        return this.processes;
    }
}

