/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ProcessesService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Process;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessStats;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ScaleProcess;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.UpdateProcess;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class Processes {
    private final ProcessesService api;

    public List<Process> getAllProcessesByAppId(String appGuid) {
        if (appGuid == null || appGuid.isEmpty()) {
            throw new IllegalArgumentException("An application guid must be provided in order to return processes by app.");
        }
        return CloudFoundryClientUtils.collectPages("processes", page -> this.api.getProcesses((Integer)page, appGuid));
    }

    public void scaleProcess(String guid, @Nullable Integer instances, @Nullable Integer memInMb, @Nullable Integer diskInMb) throws CloudFoundryApiException {
        if (memInMb == null && diskInMb == null && instances == null || Integer.valueOf(0).equals(memInMb) && Integer.valueOf(0).equals(diskInMb) && Integer.valueOf(0).equals(instances)) {
            return;
        }
        CloudFoundryClientUtils.safelyCall(() -> this.api.scaleProcess(guid, new ScaleProcess(instances, memInMb, diskInMb)));
    }

    public Optional<Process> findProcessById(String guid) {
        return CloudFoundryClientUtils.safelyCall(() -> this.api.findProcessById(guid));
    }

    public void updateProcess(String guid, @Nullable String command, @Nullable String healthCheckType, @Nullable String healthCheckEndpoint, @Nullable Integer healthCheckTimeout, @Nullable Integer healthCheckInvocationTimeout) throws CloudFoundryApiException {
        Process.HealthCheck healthCheck;
        Process.HealthCheck healthCheck2 = healthCheck = !StringUtils.isEmpty((Object)healthCheckType) ? new Process.HealthCheck.HealthCheckBuilder().type(healthCheckType).build() : null;
        if (healthCheck != null) {
            healthCheck.setData(new Process.HealthCheckData.HealthCheckDataBuilder().endpoint(healthCheckEndpoint).timeout(healthCheckTimeout).invocationTimeout(healthCheckInvocationTimeout).build());
        }
        if (command != null && command.isEmpty()) {
            throw new IllegalArgumentException("Buildpack commands cannot be empty. Please specify a custom command or set it to null to use the original buildpack command.");
        }
        CloudFoundryClientUtils.safelyCall(() -> this.api.updateProcess(guid, new UpdateProcess(command, healthCheck)));
    }

    @Nullable
    public Optional<ProcessStats.State> getProcessState(String guid) throws CloudFoundryApiException {
        return CloudFoundryClientUtils.safelyCall(() -> this.api.findProcessStatsById(guid)).map(pr -> pr.getResources().stream().findAny().map(ProcessStats::getState)).orElse(Optional.empty());
    }

    @Generated
    public Processes(ProcessesService api) {
        this.api = api;
    }
}

