/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Applications;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Domains;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Spaces;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.RouteService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.RouteId;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Route;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.RouteMapping;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryDomain;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryLoadBalancer;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Routes {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Routes.class);
    private static final Pattern VALID_ROUTE_REGEX = Pattern.compile("^([a-zA-Z0-9_-]+)\\.([a-zA-Z0-9_.-]+)(:[0-9]+)?([/a-zA-Z0-9_.-]+)?$");
    private final String account;
    private final RouteService api;
    private final Applications applications;
    private final Domains domains;
    private final Spaces spaces;
    private final Integer resultsPerPage;
    private final ForkJoinPool forkJoinPool;
    private LoadingCache<String, List<RouteMapping>> routeMappings;

    public Routes(String account, final RouteService api, Applications applications, Domains domains, Spaces spaces, Integer resultsPerPage, ForkJoinPool forkJoinPool) {
        this.account = account;
        this.api = api;
        this.applications = applications;
        this.domains = domains;
        this.spaces = spaces;
        this.resultsPerPage = resultsPerPage;
        this.forkJoinPool = forkJoinPool;
        this.routeMappings = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<RouteMapping>>(){

            public List<RouteMapping> load(@Nonnull String guid) throws CloudFoundryApiException, ResourceNotFoundException {
                return CloudFoundryClientUtils.collectPageResources("route mappings", pg -> api.routeMappings(guid, (Integer)pg)).stream().map(Resource::getEntity).collect(Collectors.toList());
            }
        });
    }

    private CloudFoundryLoadBalancer map(Resource<Route> res) throws CloudFoundryApiException {
        Set<CloudFoundryServerGroup> mappedApps;
        Route route;
        block2: {
            route = res.getEntity();
            mappedApps = Collections.emptySet();
            try {
                mappedApps = ((List)this.routeMappings.get((Object)res.getMetadata().getGuid())).stream().map((? super T rm) -> {
                    try {
                        return this.applications.findById(rm.getAppGuid());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            catch (Exception e) {
                if (e.getCause() instanceof ResourceNotFoundException) break block2;
                throw new CloudFoundryApiException(e.getCause(), "Unable to find route mappings by id");
            }
        }
        return CloudFoundryLoadBalancer.builder().account(this.account).id(res.getMetadata().getGuid()).host(route.getHost()).path(route.getPath()).port(route.getPort()).space(this.spaces.findById(route.getSpaceGuid())).domain(this.domains.findById(route.getDomainGuid())).mappedApps(mappedApps).build();
    }

    @Nullable
    public CloudFoundryLoadBalancer find(RouteId routeId, String spaceId) throws CloudFoundryApiException {
        CloudFoundrySpace id = this.spaces.findById(spaceId);
        String orgId = id.getOrganization().getId();
        ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
        queryParams.add((CallSite)((Object)("host:" + routeId.getHost())));
        queryParams.add((CallSite)((Object)("organization_guid:" + orgId)));
        queryParams.add((CallSite)((Object)("domain_guid:" + routeId.getDomainGuid())));
        if (routeId.getPath() != null) {
            queryParams.add((CallSite)((Object)("path:" + routeId.getPath())));
        }
        if (routeId.getPort() != null) {
            queryParams.add((CallSite)((Object)("port:" + routeId.getPort().toString())));
        }
        return CloudFoundryClientUtils.collectPageResources("route mappings", pg -> this.api.all((Integer)pg, 1, (List<String>)queryParams)).stream().filter(routeResource -> !(routeId.getPath() == null && !((Route)routeResource.getEntity()).getPath().isEmpty() || routeId.getPort() == null && ((Route)routeResource.getEntity()).getPort() != null)).findFirst().map(this::map).orElse(null);
    }

    @Nullable
    public RouteId toRouteId(String uri) throws CloudFoundryApiException {
        Matcher matcher = VALID_ROUTE_REGEX.matcher(uri);
        if (matcher.find()) {
            CloudFoundryDomain domain = this.domains.findByName(matcher.group(2)).orElse(null);
            if (domain == null) {
                return null;
            }
            RouteId routeId = new RouteId();
            routeId.setHost(matcher.group(1));
            routeId.setDomainGuid(domain.getId());
            routeId.setPort(matcher.group(3) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(3).substring(1))));
            routeId.setPath(matcher.group(4));
            return routeId;
        }
        return null;
    }

    public List<CloudFoundryLoadBalancer> all(List<CloudFoundrySpace> spaces) throws CloudFoundryApiException {
        try {
            if (!spaces.isEmpty()) {
                List spaceGuids = spaces.stream().map((? super T s) -> s.getId()).collect(Collectors.toList());
                String orgFilter = "organization_guid IN " + spaces.stream().map((? super T s) -> s.getOrganization().getId()).collect(Collectors.joining(","));
                return (List)((ForkJoinTask)this.forkJoinPool.submit(() -> CloudFoundryClientUtils.collectPageResources("routes", pg -> this.api.all((Integer)pg, this.resultsPerPage, Collections.singletonList(orgFilter))).parallelStream().map(this::map).filter(lb -> spaceGuids.contains(lb.getSpace().getId())).collect(Collectors.toList()))).get();
            }
            return (List)((ForkJoinTask)this.forkJoinPool.submit(() -> CloudFoundryClientUtils.collectPageResources("routes", pg -> this.api.all((Integer)pg, this.resultsPerPage, null)).parallelStream().map(this::map).collect(Collectors.toList()))).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CloudFoundryLoadBalancer createRoute(RouteId routeId, String spaceId) throws CloudFoundryApiException {
        Route route = new Route(routeId, spaceId);
        try {
            Resource newRoute = (Resource)CloudFoundryClientUtils.safelyCall(() -> this.api.createRoute(route)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cloud Foundry signaled that route creation succeeded but failed to provide a response."}));
            return this.map(newRoute);
        }
        catch (CloudFoundryApiException e) {
            if (e.getErrorCode() == null) {
                throw e;
            }
            switch (e.getErrorCode()) {
                case ROUTE_HOST_TAKEN: 
                case ROUTE_PATH_TAKEN: 
                case ROUTE_PORT_TAKEN: {
                    return this.find(routeId, spaceId);
                }
            }
            throw e;
        }
    }

    public void deleteRoute(String loadBalancerGuid) throws CloudFoundryApiException {
        CloudFoundryClientUtils.safelyCall(() -> this.api.deleteRoute(loadBalancerGuid));
    }

    public static boolean isValidRouteFormat(String route) {
        return VALID_ROUTE_REGEX.matcher(route).find();
    }
}

