/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;

public class ErrorDescription {
    @Nullable
    private String description;
    @JsonProperty(value="error_code")
    @Nullable
    private Code errorCode;
    @Nullable
    private int code;
    @JsonProperty(value="error_description")
    @Nullable
    private String errorDescription;
    @Nullable
    private List<ErrorDescription> errors;
    @Nullable
    private Code title;
    @Nullable
    private String detail;

    @Nullable
    public Code getCode() {
        return this.errors != null && !this.errors.isEmpty() ? this.errors.get(0).getTitle() : this.errorCode;
    }

    public List<String> getErrors() {
        if (this.description != null) {
            return Collections.singletonList(this.description);
        }
        if (this.errors != null && !this.errors.isEmpty()) {
            return this.errors.stream().map(e -> e.getDetail()).collect(Collectors.toList());
        }
        if (this.errorDescription != null) {
            return Collections.singletonList(this.errorDescription);
        }
        return Collections.emptyList();
    }

    @Generated
    public ErrorDescription setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="error_code")
    @Generated
    public ErrorDescription setErrorCode(@Nullable Code errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Generated
    public ErrorDescription setCode(@Nullable int code) {
        this.code = code;
        return this;
    }

    @JsonProperty(value="error_description")
    @Generated
    public ErrorDescription setErrorDescription(@Nullable String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    @Generated
    public ErrorDescription setErrors(@Nullable List<ErrorDescription> errors) {
        this.errors = errors;
        return this;
    }

    @Generated
    public ErrorDescription setTitle(@Nullable Code title) {
        this.title = title;
        return this;
    }

    @Generated
    public ErrorDescription setDetail(@Nullable String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    @Generated
    public Code getTitle() {
        return this.title;
    }

    @Nullable
    @Generated
    public String getDetail() {
        return this.detail;
    }

    public static enum Code {
        ROUTE_HOST_TAKEN("CF-RouteHostTaken"),
        ROUTE_PATH_TAKEN("CF-RoutePathTaken"),
        ROUTE_PORT_TAKEN("CF-RoutePortTaken"),
        RESOURCE_NOT_FOUND("CF-ResourceNotFound"),
        SERVICE_ALREADY_EXISTS("60002"),
        SERVICE_INSTANCE_ALREADY_BOUND("CF-ServiceBindingAppServiceTaken");

        private final String code;

        private Code(String code) {
            this.code = code;
        }

        @Nullable
        @JsonCreator
        public static Code fromCode(String code) {
            return Arrays.stream(Code.values()).filter(st -> st.code.equals(code)).findFirst().orElse(null);
        }
    }
}

