/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.AbstractServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DeployCloudFoundryServiceDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.DeployCloudFoundryServiceAtomicOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@CloudFoundryOperation(value="deployService")
@Component
public class DeployCloudFoundryServiceAtomicOperationConverter
extends AbstractCloudFoundryAtomicOperationConverter {
    private static final ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Pattern r = Pattern.compile(".*?-v(\\d+)");

    public AtomicOperation convertOperation(Map input) {
        return new DeployCloudFoundryServiceAtomicOperation(this.convertDescription(input));
    }

    public DeployCloudFoundryServiceDescription convertDescription(Map input) {
        DeployCloudFoundryServiceDescription converted = (DeployCloudFoundryServiceDescription)this.getObjectMapper().convertValue((Object)input, DeployCloudFoundryServiceDescription.class);
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString());
        converted.setCredentials(credentials);
        converted.setClient(this.getClient(input));
        converted.setSpace(this.findSpace(converted.getRegion(), converted.getClient()).orElseThrow(() -> new IllegalArgumentException("Unable to find space '" + converted.getRegion() + "'.")));
        List<Map<Object, Object>> manifest = converted.getManifest();
        if (converted.isUserProvided()) {
            converted.setUserProvidedServiceAttributes(this.convertUserProvidedServiceManifest(manifest.stream().findFirst().orElse(null)));
            if (converted.getUserProvidedServiceAttributes() != null && converted.getUserProvidedServiceAttributes().isVersioned()) {
                DeployCloudFoundryServiceDescription.UserProvidedServiceAttributes attributes = converted.getUserProvidedServiceAttributes();
                attributes.setPreviousInstanceName(this.getLatestInstanceName(attributes.getServiceInstanceName(), converted.getClient(), converted.getSpace()));
                attributes.setServiceInstanceName(this.getNextInstanceName(attributes.getServiceInstanceName(), attributes.getPreviousInstanceName()));
                converted.setUserProvidedServiceAttributes(attributes);
            }
        } else {
            converted.setServiceAttributes(this.convertManifest(manifest.stream().findFirst().orElse(null)));
            if (converted.getServiceAttributes() != null && converted.getServiceAttributes().isVersioned()) {
                DeployCloudFoundryServiceDescription.ServiceAttributes attributes = converted.getServiceAttributes();
                attributes.setPreviousInstanceName(this.getLatestInstanceName(attributes.getServiceInstanceName(), converted.getClient(), converted.getSpace()));
                attributes.setServiceInstanceName(this.getNextInstanceName(attributes.getServiceInstanceName(), attributes.getPreviousInstanceName()));
                converted.setServiceAttributes(attributes);
            }
        }
        return converted;
    }

    @Nullable
    private String getLatestInstanceName(String serviceInstanceName, CloudFoundryClient client, CloudFoundrySpace space) {
        if (serviceInstanceName == null || serviceInstanceName.isEmpty()) {
            throw new IllegalArgumentException("Service Instance Name must not be null or empty.");
        }
        List serviceInstances = client.getServiceInstances().findAllVersionedServiceInstancesBySpaceAndName(space, String.format("%s-v%03d", serviceInstanceName, 0)).stream().filter(n -> ((AbstractServiceInstance)n.getEntity()).getName().startsWith(serviceInstanceName)).map(rs -> ((AbstractServiceInstance)rs.getEntity()).getName()).filter(n -> this.isVersioned((String)n)).collect(Collectors.toList());
        if (serviceInstances.isEmpty()) {
            return null;
        }
        Integer latestVersion = serviceInstances.stream().map(v -> {
            Matcher m = this.r.matcher((CharSequence)v);
            m.find();
            return Integer.parseInt(m.group(1));
        }).mapToInt(n -> n).max().orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to determine latest version for service instance: " + serviceInstanceName}));
        return String.format("%s-v%03d", serviceInstanceName, latestVersion);
    }

    private String getNextInstanceName(String serviceInstanceName, String latestInstanceName) {
        if (latestInstanceName == null) {
            return String.format("%s-v%03d", serviceInstanceName, 0);
        }
        Matcher m = this.r.matcher(latestInstanceName);
        m.find();
        int latestVersion = Integer.parseInt(m.group(1));
        return String.format("%s-v%03d", serviceInstanceName, latestVersion + 1);
    }

    private boolean isVersioned(String name) {
        Matcher m = this.r.matcher(name);
        return m.find();
    }

    DeployCloudFoundryServiceDescription.ServiceAttributes convertManifest(Object manifestMap) {
        if (manifestMap == null) {
            throw new IllegalArgumentException("No configurations detected");
        }
        ServiceManifest manifest = (ServiceManifest)objectMapper.convertValue(manifestMap, ServiceManifest.class);
        if (manifest.getService() == null) {
            throw new IllegalArgumentException("Manifest is missing the service");
        }
        if (manifest.getServiceInstanceName() == null) {
            throw new IllegalArgumentException("Manifest is missing the service instance name");
        }
        if (manifest.getServicePlan() == null) {
            throw new IllegalArgumentException("Manifest is missing the service plan");
        }
        DeployCloudFoundryServiceDescription.ServiceAttributes attrs = new DeployCloudFoundryServiceDescription.ServiceAttributes();
        attrs.setService(manifest.getService());
        attrs.setServiceInstanceName(manifest.getServiceInstanceName());
        attrs.setServicePlan(manifest.getServicePlan());
        attrs.setTags(manifest.getTags());
        attrs.setUpdatable(manifest.isUpdatable());
        attrs.setVersioned(manifest.isVersioned());
        attrs.setParameterMap(manifest.getParameters());
        return attrs;
    }

    DeployCloudFoundryServiceDescription.UserProvidedServiceAttributes convertUserProvidedServiceManifest(Object manifestMap) {
        if (manifestMap == null) {
            throw new IllegalArgumentException("No configurations detected");
        }
        UserProvidedServiceManifest manifest = (UserProvidedServiceManifest)objectMapper.convertValue(manifestMap, UserProvidedServiceManifest.class);
        if (manifest.getServiceInstanceName() == null) {
            throw new IllegalArgumentException("Manifest is missing the service name");
        }
        DeployCloudFoundryServiceDescription.UserProvidedServiceAttributes attrs = new DeployCloudFoundryServiceDescription.UserProvidedServiceAttributes();
        attrs.setServiceInstanceName(manifest.getServiceInstanceName());
        attrs.setSyslogDrainUrl(manifest.getSyslogDrainUrl());
        attrs.setRouteServiceUrl(manifest.getRouteServiceUrl());
        attrs.setTags(manifest.getTags());
        attrs.setUpdatable(manifest.isUpdatable());
        attrs.setVersioned(manifest.isVersioned());
        attrs.setCredentials(manifest.getCredentials());
        return attrs;
    }

    public static class OptionallySerializedMapDeserializer
    extends JsonDeserializer<Map<String, Object>> {
        private final TypeReference<Map<String, Object>> mapTypeReference = new TypeReference<Map<String, Object>>(){};
        private final ObjectMapper yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

        public Map<String, Object> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            String serizalizedMap;
            JsonToken currentToken = parser.currentToken();
            Map<String, Object> deserializedMap = null;
            if (currentToken == JsonToken.START_OBJECT) {
                deserializedMap = (Map<String, Object>)context.readValue(parser, context.getTypeFactory().constructType(this.mapTypeReference));
            } else if (currentToken == JsonToken.VALUE_STRING && StringUtils.isNotBlank((CharSequence)(serizalizedMap = parser.getValueAsString()))) {
                deserializedMap = this.deserializeWithMappers(serizalizedMap, this.mapTypeReference, this.yamlObjectMapper, (ObjectMapper)parser.getCodec());
            }
            return deserializedMap;
        }

        private <T> T deserializeWithMappers(String serialized, TypeReference<T> typeReference, ObjectMapper ... mappers) throws IOException {
            IOException deserializationFailed = new IOException("Could not deserialize value using the provided objectMappers");
            for (ObjectMapper mapper : mappers) {
                try {
                    return (T)mapper.readValue(serialized, typeReference);
                }
                catch (IOException e) {
                    deserializationFailed.addSuppressed(e);
                }
            }
            throw deserializationFailed;
        }
    }

    private static class UserProvidedServiceManifest {
        private boolean updatable = true;
        private boolean versioned = false;
        @JsonAlias(value={"service_instance_name", "serviceInstanceName"})
        private String serviceInstanceName;
        @Nullable
        @JsonAlias(value={"syslog_drain_url", "syslogDrainUrl"})
        private String syslogDrainUrl;
        @Nullable
        @JsonAlias(value={"route_service_url", "routeServiceUrl"})
        private String routeServiceUrl;
        @Nullable
        private Set<String> tags;
        @Nullable
        @JsonAlias(value={"credentials_map", "credentialsMap"})
        @JsonDeserialize(using=OptionallySerializedMapDeserializer.class)
        private Map<String, Object> credentials;

        @Generated
        public UserProvidedServiceManifest() {
        }

        @Generated
        public boolean isUpdatable() {
            return this.updatable;
        }

        @Generated
        public boolean isVersioned() {
            return this.versioned;
        }

        @Generated
        public String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        @Nullable
        @Generated
        public String getSyslogDrainUrl() {
            return this.syslogDrainUrl;
        }

        @Nullable
        @Generated
        public String getRouteServiceUrl() {
            return this.routeServiceUrl;
        }

        @Nullable
        @Generated
        public Set<String> getTags() {
            return this.tags;
        }

        @Nullable
        @Generated
        public Map<String, Object> getCredentials() {
            return this.credentials;
        }

        @Generated
        public UserProvidedServiceManifest setUpdatable(boolean updatable) {
            this.updatable = updatable;
            return this;
        }

        @Generated
        public UserProvidedServiceManifest setVersioned(boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        @Generated
        public UserProvidedServiceManifest setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        @Generated
        public UserProvidedServiceManifest setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        @Generated
        public UserProvidedServiceManifest setRouteServiceUrl(@Nullable String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        @Generated
        public UserProvidedServiceManifest setTags(@Nullable Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public UserProvidedServiceManifest setCredentials(@Nullable Map<String, Object> credentials) {
            this.credentials = credentials;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserProvidedServiceManifest)) {
                return false;
            }
            UserProvidedServiceManifest other = (UserProvidedServiceManifest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUpdatable() != other.isUpdatable()) {
                return false;
            }
            if (this.isVersioned() != other.isVersioned()) {
                return false;
            }
            String this$serviceInstanceName = this.getServiceInstanceName();
            String other$serviceInstanceName = other.getServiceInstanceName();
            if (this$serviceInstanceName == null ? other$serviceInstanceName != null : !this$serviceInstanceName.equals(other$serviceInstanceName)) {
                return false;
            }
            String this$syslogDrainUrl = this.getSyslogDrainUrl();
            String other$syslogDrainUrl = other.getSyslogDrainUrl();
            if (this$syslogDrainUrl == null ? other$syslogDrainUrl != null : !this$syslogDrainUrl.equals(other$syslogDrainUrl)) {
                return false;
            }
            String this$routeServiceUrl = this.getRouteServiceUrl();
            String other$routeServiceUrl = other.getRouteServiceUrl();
            if (this$routeServiceUrl == null ? other$routeServiceUrl != null : !this$routeServiceUrl.equals(other$routeServiceUrl)) {
                return false;
            }
            Set<String> this$tags = this.getTags();
            Set<String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            Map<String, Object> this$credentials = this.getCredentials();
            Map<String, Object> other$credentials = other.getCredentials();
            return !(this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UserProvidedServiceManifest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUpdatable() ? 79 : 97);
            result = result * 59 + (this.isVersioned() ? 79 : 97);
            String $serviceInstanceName = this.getServiceInstanceName();
            result = result * 59 + ($serviceInstanceName == null ? 43 : $serviceInstanceName.hashCode());
            String $syslogDrainUrl = this.getSyslogDrainUrl();
            result = result * 59 + ($syslogDrainUrl == null ? 43 : $syslogDrainUrl.hashCode());
            String $routeServiceUrl = this.getRouteServiceUrl();
            result = result * 59 + ($routeServiceUrl == null ? 43 : $routeServiceUrl.hashCode());
            Set<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            Map<String, Object> $credentials = this.getCredentials();
            result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DeployCloudFoundryServiceAtomicOperationConverter.UserProvidedServiceManifest(updatable=" + this.isUpdatable() + ", versioned=" + this.isVersioned() + ", serviceInstanceName=" + this.getServiceInstanceName() + ", syslogDrainUrl=" + this.getSyslogDrainUrl() + ", routeServiceUrl=" + this.getRouteServiceUrl() + ", tags=" + this.getTags() + ", credentials=" + this.getCredentials() + ")";
        }
    }

    private static class ServiceManifest {
        private String service;
        private boolean updatable = true;
        private boolean versioned = false;
        @JsonAlias(value={"service_instance_name", "serviceInstanceName"})
        private String serviceInstanceName;
        @JsonAlias(value={"service_plan", "servicePlan"})
        private String servicePlan;
        @Nullable
        private Set<String> tags;
        @Nullable
        @JsonDeserialize(using=OptionallySerializedMapDeserializer.class)
        private Map<String, Object> parameters;

        @Generated
        public ServiceManifest() {
        }

        @Generated
        public String getService() {
            return this.service;
        }

        @Generated
        public boolean isUpdatable() {
            return this.updatable;
        }

        @Generated
        public boolean isVersioned() {
            return this.versioned;
        }

        @Generated
        public String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        @Generated
        public String getServicePlan() {
            return this.servicePlan;
        }

        @Nullable
        @Generated
        public Set<String> getTags() {
            return this.tags;
        }

        @Nullable
        @Generated
        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        @Generated
        public ServiceManifest setService(String service) {
            this.service = service;
            return this;
        }

        @Generated
        public ServiceManifest setUpdatable(boolean updatable) {
            this.updatable = updatable;
            return this;
        }

        @Generated
        public ServiceManifest setVersioned(boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        @Generated
        public ServiceManifest setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        @Generated
        public ServiceManifest setServicePlan(String servicePlan) {
            this.servicePlan = servicePlan;
            return this;
        }

        @Generated
        public ServiceManifest setTags(@Nullable Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public ServiceManifest setParameters(@Nullable Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceManifest)) {
                return false;
            }
            ServiceManifest other = (ServiceManifest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$service = this.getService();
            String other$service = other.getService();
            if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
                return false;
            }
            if (this.isUpdatable() != other.isUpdatable()) {
                return false;
            }
            if (this.isVersioned() != other.isVersioned()) {
                return false;
            }
            String this$serviceInstanceName = this.getServiceInstanceName();
            String other$serviceInstanceName = other.getServiceInstanceName();
            if (this$serviceInstanceName == null ? other$serviceInstanceName != null : !this$serviceInstanceName.equals(other$serviceInstanceName)) {
                return false;
            }
            String this$servicePlan = this.getServicePlan();
            String other$servicePlan = other.getServicePlan();
            if (this$servicePlan == null ? other$servicePlan != null : !this$servicePlan.equals(other$servicePlan)) {
                return false;
            }
            Set<String> this$tags = this.getTags();
            Set<String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            Map<String, Object> this$parameters = this.getParameters();
            Map<String, Object> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServiceManifest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $service = this.getService();
            result = result * 59 + ($service == null ? 43 : $service.hashCode());
            result = result * 59 + (this.isUpdatable() ? 79 : 97);
            result = result * 59 + (this.isVersioned() ? 79 : 97);
            String $serviceInstanceName = this.getServiceInstanceName();
            result = result * 59 + ($serviceInstanceName == null ? 43 : $serviceInstanceName.hashCode());
            String $servicePlan = this.getServicePlan();
            result = result * 59 + ($servicePlan == null ? 43 : $servicePlan.hashCode());
            Set<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            Map<String, Object> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DeployCloudFoundryServiceAtomicOperationConverter.ServiceManifest(service=" + this.getService() + ", updatable=" + this.isUpdatable() + ", versioned=" + this.isVersioned() + ", serviceInstanceName=" + this.getServiceInstanceName() + ", servicePlan=" + this.getServicePlan() + ", tags=" + this.getTags() + ", parameters=" + this.getParameters() + ")";
        }
    }
}

