/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryModel;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.Views;
import com.netflix.spinnaker.clouddriver.model.Cluster;
import com.netflix.spinnaker.clouddriver.model.LoadBalancer;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;

@JsonDeserialize(builder=CloudFoundryClusterBuilder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class CloudFoundryCluster
extends CloudFoundryModel
implements Cluster {
    @JsonView(value={Views.Cache.class})
    private final String accountName;
    @JsonView(value={Views.Cache.class})
    private final String name;
    @JsonView(value={Views.Relationship.class})
    private final Set<CloudFoundryServerGroup> serverGroups;

    public Set<? extends LoadBalancer> getLoadBalancers() {
        return Collections.emptySet();
    }

    public String getStack() {
        return Names.parseName((String)this.name).getStack();
    }

    public String getDetail() {
        return Names.parseName((String)this.name).getDetail();
    }

    public String getType() {
        return CloudFoundryCloudProvider.ID;
    }

    @Generated
    CloudFoundryCluster(String accountName, String name, Set<CloudFoundryServerGroup> serverGroups) {
        this.accountName = accountName;
        this.name = name;
        this.serverGroups = serverGroups;
    }

    @Generated
    public static CloudFoundryClusterBuilder builder() {
        return new CloudFoundryClusterBuilder();
    }

    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Set<CloudFoundryServerGroup> getServerGroups() {
        return this.serverGroups;
    }

    @Generated
    public String toString() {
        return "CloudFoundryCluster(accountName=" + this.getAccountName() + ", name=" + this.getName() + ", serverGroups=" + this.getServerGroups() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudFoundryCluster)) {
            return false;
        }
        CloudFoundryCluster other = (CloudFoundryCluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudFoundryCluster;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public CloudFoundryCluster withServerGroups(Set<CloudFoundryServerGroup> serverGroups) {
        return this.serverGroups == serverGroups ? this : new CloudFoundryCluster(this.accountName, this.name, serverGroups);
    }

    @Generated
    public static class CloudFoundryClusterBuilder {
        @Generated
        private String accountName;
        @Generated
        private String name;
        @Generated
        private Set<CloudFoundryServerGroup> serverGroups;

        @Generated
        CloudFoundryClusterBuilder() {
        }

        @Generated
        public CloudFoundryClusterBuilder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Generated
        public CloudFoundryClusterBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public CloudFoundryClusterBuilder serverGroups(Set<CloudFoundryServerGroup> serverGroups) {
            this.serverGroups = serverGroups;
            return this;
        }

        @Generated
        public CloudFoundryCluster build() {
            return new CloudFoundryCluster(this.accountName, this.name, this.serverGroups);
        }

        @Generated
        public String toString() {
            return "CloudFoundryCluster.CloudFoundryClusterBuilder(accountName=" + this.accountName + ", name=" + this.name + ", serverGroups=" + this.serverGroups + ")";
        }
    }
}

