/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryOrganization;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.Views;
import lombok.Generated;

@JsonDeserialize(builder=CloudFoundrySpaceBuilder.class)
@JsonIgnoreProperties(value={"region"})
public final class CloudFoundrySpace {
    @JsonView(value={Views.Cache.class})
    private final String id;
    @JsonView(value={Views.Cache.class})
    private final String name;
    @JsonView(value={Views.Cache.class})
    private final CloudFoundryOrganization organization;

    public static CloudFoundrySpace fromRegion(String region) {
        String[] parts = region.split(">");
        String orgName = parts[0].trim();
        String spaceName = parts[1].trim();
        return new CloudFoundrySpace(null, spaceName, new CloudFoundryOrganization(null, orgName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudFoundrySpace that = (CloudFoundrySpace)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.organization != null ? this.organization.getName().equals(that.organization.getName()) : that.organization == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.organization.getName() != null ? this.organization.getName().hashCode() : 0);
        return result;
    }

    public String getRegion() {
        return this.organization.getName() + " > " + this.name;
    }

    @Generated
    CloudFoundrySpace(String id, String name, CloudFoundryOrganization organization) {
        this.id = id;
        this.name = name;
        this.organization = organization;
    }

    @Generated
    public static CloudFoundrySpaceBuilder builder() {
        return new CloudFoundrySpaceBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public CloudFoundryOrganization getOrganization() {
        return this.organization;
    }

    @Generated
    public String toString() {
        return "CloudFoundrySpace(id=" + this.getId() + ", name=" + this.getName() + ", organization=" + this.getOrganization() + ")";
    }

    @Generated
    public static class CloudFoundrySpaceBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private CloudFoundryOrganization organization;

        @Generated
        CloudFoundrySpaceBuilder() {
        }

        @Generated
        public CloudFoundrySpaceBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public CloudFoundrySpaceBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public CloudFoundrySpaceBuilder organization(CloudFoundryOrganization organization) {
            this.organization = organization;
            return this;
        }

        @Generated
        public CloudFoundrySpace build() {
            return new CloudFoundrySpace(this.id, this.name, this.organization);
        }

        @Generated
        public String toString() {
            return "CloudFoundrySpace.CloudFoundrySpaceBuilder(id=" + this.id + ", name=" + this.name + ", organization=" + this.organization + ")";
        }
    }
}

