/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.config;

import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.CacheRepository;
import com.netflix.spinnaker.clouddriver.cloudfoundry.config.CloudFoundryConfigurationProperties;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.CloudFoundryProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.security.CredentialsInitializerSynchronizable;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.MapBackedCredentialsRepository;
import com.netflix.spinnaker.credentials.definition.AbstractCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.BasicCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.credentials.poller.Poller;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpMetricsEventListener;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CloudFoundryProviderConfig {
    @Bean
    public CloudFoundryProvider cloudFoundryProvider() {
        return new CloudFoundryProvider();
    }

    @Bean
    public ForkJoinPool cloudFoundryThreadPool(CloudFoundryConfigurationProperties cloudFoundryConfigurationProperties) {
        return new ForkJoinPool(cloudFoundryConfigurationProperties.getApiRequestParallelism());
    }

    @Bean
    public OkHttpClient cloudFoundryOkHttpClient(CloudFoundryConfigurationProperties configurationProperties, MeterRegistry meterRegistry) {
        return new OkHttpClient.Builder().connectTimeout((long)configurationProperties.getClient().getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)configurationProperties.getClient().getConnectionTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)configurationProperties.getClient().getReadTimeout(), TimeUnit.MILLISECONDS).eventListener((EventListener)OkHttpMetricsEventListener.builder((MeterRegistry)meterRegistry, (String)"cf.okhttp.requests").build()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={CloudFoundryCredentials.class}, parameterizedContainer={AbstractCredentialsLoader.class})
    public AbstractCredentialsLoader<CloudFoundryCredentials> cloudFoundryCredentialsLoader(@Nullable CredentialsDefinitionSource<CloudFoundryConfigurationProperties.ManagedAccount> cloudFoundryCredentialSource, CloudFoundryConfigurationProperties configurationProperties, CacheRepository cacheRepository, CredentialsRepository<CloudFoundryCredentials> cloudFoundryCredentialsRepository, ForkJoinPool cloudFoundryThreadPool, @Qualifier(value="cloudFoundryOkHttpClient") OkHttpClient okHttpClient) {
        if (cloudFoundryCredentialSource == null) {
            cloudFoundryCredentialSource = configurationProperties::getAccounts;
        }
        return new BasicCredentialsLoader(cloudFoundryCredentialSource, a -> new CloudFoundryCredentials(a.getName(), a.getAppsManagerUri(), a.getMetricsUri(), a.getApi(), a.getUser(), a.getPassword(), a.getEnvironment(), a.isSkipSslValidation(), a.isOnlySpinnakerManaged(), a.getResultsPerPage(), cacheRepository, a.getPermissions().build(), cloudFoundryThreadPool, a.getSpaceFilter(), okHttpClient, configurationProperties.getClient()), cloudFoundryCredentialsRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={CloudFoundryCredentials.class}, parameterizedContainer={CredentialsRepository.class})
    public CredentialsRepository<CloudFoundryCredentials> cloudFoundryCredentialsRepository(CredentialsLifecycleHandler<CloudFoundryCredentials> eventHandler) {
        return new MapBackedCredentialsRepository("cloudfoundry", eventHandler);
    }

    @Bean
    @ConditionalOnMissingBean(value={CloudFoundryConfigurationProperties.ManagedAccount.class}, parameterizedContainer={CredentialsDefinitionSource.class})
    public CredentialsInitializerSynchronizable cloudFoundryCredentialsInitializerSynchronizable(AbstractCredentialsLoader<CloudFoundryCredentials> loader) {
        final Poller poller = new Poller(loader);
        return new CredentialsInitializerSynchronizable(){

            public void synchronize() {
                poller.run();
            }
        };
    }
}

