/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.view;

import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.model.ServiceInstance;
import com.netflix.spinnaker.clouddriver.model.ServiceProvider;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CloudFoundryServiceProvider
implements ServiceProvider {
    private final CredentialsRepository<CloudFoundryCredentials> credentialsRepository;

    @Autowired
    public CloudFoundryServiceProvider(CredentialsRepository<CloudFoundryCredentials> credentialsRepository) {
        this.credentialsRepository = credentialsRepository;
    }

    public Collection<CloudFoundryService> getServices(String account, String region) {
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.credentialsRepository.getOne(account);
        if (credentials == null) {
            return Collections.emptyList();
        }
        return credentials.getCredentials().getServiceInstances().findAllServicesByRegion(region);
    }

    public ServiceInstance getServiceInstance(String account, String region, String serviceInstanceName) {
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.credentialsRepository.getOne(account);
        if (credentials == null) {
            return null;
        }
        return credentials.getCredentials().getServiceInstances().getServiceInstance(region, serviceInstanceName);
    }

    public String getCloudProvider() {
        return CloudFoundryCloudProvider.ID;
    }
}

