/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.artifacts;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.InputStream;
import javax.annotation.Nonnull;
import lombok.Generated;

public class CloudFoundryArtifactCredentials
implements ArtifactCredentials {
    public static final String ARTIFACTS_TYPE = "artifacts/cloudfoundry";
    public static final String TYPE = "cloudfoundry/app";
    private final String name = "cloudfoundry";
    private final CloudFoundryClient client;

    @Nonnull
    public ImmutableList<String> getTypes() {
        return ImmutableList.of((Object)TYPE);
    }

    @Nonnull
    public InputStream download(@Nonnull Artifact artifact) {
        String packageId = this.client.getApplications().findCurrentPackageIdByAppId(artifact.getUuid());
        return this.client.getApplications().downloadPackageBits(packageId);
    }

    public String getType() {
        return ARTIFACTS_TYPE;
    }

    @Generated
    public CloudFoundryArtifactCredentials(CloudFoundryClient client) {
        this.client = client;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public CloudFoundryClient getClient() {
        return this.client;
    }
}

