/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Spaces;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ConfigService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ServiceInstanceService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ServiceInstanceResponse;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.AbstractCreateServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.AbstractServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ConfigFeatureFlag;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateUserProvidedServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.LastOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Page;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Service;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServicePlan;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.SharedTo;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.UserProvidedServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreateSharedServiceInstances;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServicePlan;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.springframework.util.StringUtils;
import retrofit2.Call;

public class ServiceInstances {
    private final ServiceInstanceService api;
    private final ConfigService configApi;
    private final Spaces spaces;

    public List<Resource<ServiceBinding>> findAllServiceBindingsByServiceName(String region, String serviceName) {
        CloudFoundryServiceInstance serviceInstance = this.getServiceInstance(region, serviceName);
        if (serviceInstance == null) {
            return Collections.emptyList();
        }
        return this.findAllServiceBindingsByService(serviceInstance.getId());
    }

    public void createServiceBinding(CreateServiceBinding createServiceBinding) {
        try {
            CloudFoundryClientUtils.safelyCall(() -> this.api.createServiceBinding(createServiceBinding));
        }
        catch (CloudFoundryApiException e) {
            if (e.getErrorCode() == null) {
                throw e;
            }
            switch (e.getErrorCode()) {
                case SERVICE_INSTANCE_ALREADY_BOUND: {
                    return;
                }
            }
            throw e;
        }
    }

    public List<Resource<ServiceBinding>> findAllServiceBindingsByApp(String appGuid) {
        String bindingsQuery = "app_guid:" + appGuid;
        return CloudFoundryClientUtils.collectPageResources("service bindings", pg -> this.api.getAllServiceBindings(Collections.singletonList(bindingsQuery)));
    }

    public List<Resource<ServiceBinding>> findAllServiceBindingsByService(String serviceGuid) {
        String bindingsQuery = "service_instance_guid:" + serviceGuid;
        return CloudFoundryClientUtils.collectPageResources("service bindings", pg -> this.api.getAllServiceBindings(Collections.singletonList(bindingsQuery)));
    }

    public void deleteServiceBinding(String serviceBindingGuid) {
        CloudFoundryClientUtils.safelyCall(() -> this.api.deleteServiceBinding(serviceBindingGuid));
    }

    private Resource<Service> findServiceByServiceName(String serviceName) {
        List services = CloudFoundryClientUtils.collectPageResources("services by name", pg -> this.api.findService((Integer)pg, (List<String>)Collections.singletonList("label:" + serviceName)));
        return Optional.ofNullable(services.get(0)).orElse(null);
    }

    private List<CloudFoundryServicePlan> findAllServicePlansByServiceName(String serviceName) {
        Resource<Service> service = this.findServiceByServiceName(serviceName);
        List services = CloudFoundryClientUtils.collectPageResources("service plans by id", pg -> this.api.findServicePlans((Integer)pg, (List<String>)Collections.singletonList("service_guid:" + service.getMetadata().getGuid())));
        return services.stream().map(resource -> CloudFoundryServicePlan.builder().name(((ServicePlan)resource.getEntity()).getName()).id(resource.getMetadata().getGuid()).build()).collect(Collectors.toList());
    }

    public List<CloudFoundryService> findAllServicesByRegion(String region) {
        return this.spaces.findSpaceByRegion(region).map(space -> {
            List services = CloudFoundryClientUtils.collectPageResources("all service", pg -> this.api.findServiceBySpaceId(space.getId(), (Integer)pg, null));
            return services.stream().map(serviceResource -> CloudFoundryService.builder().name(((Service)serviceResource.getEntity()).getLabel()).servicePlans(this.findAllServicePlansByServiceName(((Service)serviceResource.getEntity()).getLabel())).build()).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }

    public List<Resource<? extends AbstractServiceInstance>> findAllServicesBySpaceAndNames(CloudFoundrySpace space, List<String> serviceInstanceNames) {
        if (serviceInstanceNames == null || serviceInstanceNames.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> serviceInstanceQuery = ServiceInstances.getServiceQueryParams(serviceInstanceNames, space);
        ArrayList<Resource<? extends AbstractServiceInstance>> serviceInstances = new ArrayList<Resource<? extends AbstractServiceInstance>>();
        serviceInstances.addAll(CloudFoundryClientUtils.collectPageResources("service instances", pg -> this.api.all((Integer)pg, serviceInstanceQuery)));
        serviceInstances.addAll(CloudFoundryClientUtils.collectPageResources("service instances", pg -> this.api.allUserProvided((Integer)pg, serviceInstanceQuery)));
        return serviceInstances;
    }

    public List<Resource<? extends AbstractServiceInstance>> findAllVersionedServiceInstancesBySpaceAndName(CloudFoundrySpace space, String serviceInstanceName) {
        List<String> serviceInstanceQuery = Arrays.asList("name>=" + serviceInstanceName, "organization_guid:" + space.getOrganization().getId(), "space_guid:" + space.getId());
        ArrayList<Resource<? extends AbstractServiceInstance>> serviceInstances = new ArrayList<Resource<? extends AbstractServiceInstance>>();
        serviceInstances.addAll(CloudFoundryClientUtils.collectPageResources("service instances", pg -> this.api.all((Integer)pg, serviceInstanceQuery)));
        serviceInstances.addAll(CloudFoundryClientUtils.collectPageResources("service instances", pg -> this.api.allUserProvided((Integer)pg, serviceInstanceQuery)));
        return serviceInstances;
    }

    CloudFoundryServiceInstance getOsbServiceInstanceByRegion(String region, String serviceInstanceName) {
        CloudFoundrySpace space = this.spaces.findSpaceByRegion(region).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cannot find region '" + region + "'"}));
        return Optional.ofNullable(this.getOsbServiceInstance(space, serviceInstanceName)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cannot find service '" + serviceInstanceName + "' in region '" + space.getRegion() + "'"}));
    }

    private Set<CloudFoundrySpace> vetSharingOfServicesArgumentsAndGetSharingSpaces(String sharedFromRegion, @Nullable String serviceInstanceName, @Nullable Set<String> sharingRegions, String gerund) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)serviceInstanceName)) {
            throw new CloudFoundryApiException(new String[]{"Please specify a name for the " + gerund + " service instance"});
        }
        if ((sharingRegions = Optional.ofNullable(sharingRegions).orElse(Collections.emptySet())).size() == 0) {
            throw new CloudFoundryApiException(new String[]{"Please specify a list of regions for " + gerund + " '" + serviceInstanceName + "'"});
        }
        return sharingRegions.stream().map(r -> {
            if (sharedFromRegion.equals(r)) {
                throw new CloudFoundryApiException(new String[]{"Cannot specify 'org > space' as any of the " + gerund + " regions"});
            }
            return this.spaces.findSpaceByRegion((String)r).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cannot find region '" + r + "' for " + gerund}));
        }).collect(Collectors.toSet());
    }

    Set<CloudFoundrySpace> vetUnshareServiceArgumentsAndGetSharingSpaces(@Nullable String serviceInstanceName, @Nullable Set<String> sharingRegions) {
        return this.vetSharingOfServicesArgumentsAndGetSharingSpaces("", serviceInstanceName, sharingRegions, "unsharing");
    }

    Set<CloudFoundrySpace> vetShareServiceArgumentsAndGetSharingSpaces(@Nullable String sharedFromRegion, @Nullable String serviceInstanceName, @Nullable Set<String> sharingRegions) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sharedFromRegion)) {
            throw new CloudFoundryApiException(new String[]{"Please specify a region for the sharing service instance"});
        }
        return this.vetSharingOfServicesArgumentsAndGetSharingSpaces(sharedFromRegion, serviceInstanceName, sharingRegions, "sharing");
    }

    Void checkServiceShareable(String serviceInstanceName, CloudFoundryServiceInstance serviceInstance) {
        boolean isShareable;
        ConfigFeatureFlag featureFlag = CloudFoundryClientUtils.safelyCall(this.configApi::getConfigFeatureFlags).orElse(Collections.emptySet()).stream().filter(it -> it.getName() == ConfigFeatureFlag.ConfigFlag.SERVICE_INSTANCE_SHARING).findFirst().orElseThrow(() -> new CloudFoundryApiException(new String[]{"'service_instance_sharing' flag must be enabled in order to share services"}));
        if (!featureFlag.isEnabled()) {
            throw new CloudFoundryApiException(new String[]{"'service_instance_sharing' flag must be enabled in order to share services"});
        }
        ServicePlan plan = CloudFoundryClientUtils.safelyCall(() -> this.api.findServicePlanByServicePlanId(serviceInstance.getPlanId())).map(Resource::getEntity).orElseThrow(() -> new CloudFoundryApiException(new String[]{"The service plan for 'new-service-plan-name' was not found"}));
        String extraString = CloudFoundryClientUtils.safelyCall(() -> this.api.findServiceByServiceId(plan.getServiceGuid())).map(Resource::getEntity).map(s -> Optional.ofNullable(s.getExtra()).orElseThrow(() -> new CloudFoundryApiException(new String[]{"The service broker must be configured as 'shareable' in order to share services"}))).orElseThrow(() -> new CloudFoundryApiException(new String[]{"The service broker for '" + serviceInstanceName + "' was not found"}));
        try {
            isShareable = !StringUtils.isEmpty((Object)extraString) && ((Map)new ObjectMapper().readValue(extraString, Map.class)).get("shareable") == Boolean.TRUE;
        }
        catch (IOException e) {
            throw new CloudFoundryApiException(e, new String[0]);
        }
        if (!isShareable) {
            throw new CloudFoundryApiException(new String[]{"The service broker must be configured as 'shareable' in order to share services"});
        }
        return null;
    }

    public ServiceInstanceResponse shareServiceInstance(@Nullable String region, @Nullable String serviceInstanceName, @Nullable Set<String> shareToRegions) {
        Set<CloudFoundrySpace> shareToSpaces = this.vetShareServiceArgumentsAndGetSharingSpaces(region, serviceInstanceName, shareToRegions);
        CloudFoundryServiceInstance serviceInstance = this.getOsbServiceInstanceByRegion(region, serviceInstanceName);
        if (ServiceInstance.Type.MANAGED_SERVICE_INSTANCE.name().equalsIgnoreCase(serviceInstance.getType())) {
            this.checkServiceShareable(serviceInstanceName, serviceInstance);
        }
        String serviceInstanceId = serviceInstance.getId();
        SharedTo sharedTo = (SharedTo)CloudFoundryClientUtils.safelyCall(() -> this.api.getShareServiceInstanceSpaceIdsByServiceInstanceId(serviceInstanceId)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Could not fetch spaces to which '" + serviceInstanceName + "' has been shared"}));
        Set shareToIdsBody = shareToSpaces.stream().map(space -> Collections.singletonMap("guid", space.getId())).filter(idMap -> !sharedTo.getData().contains(idMap)).collect(Collectors.toSet());
        if (shareToIdsBody.size() > 0) {
            CloudFoundryClientUtils.safelyCall(() -> this.api.shareServiceInstanceToSpaceIds(serviceInstanceId, new CreateSharedServiceInstances().setData(shareToIdsBody)));
        }
        return new ServiceInstanceResponse().setServiceInstanceName(serviceInstanceName).setType(LastOperation.Type.SHARE).setState(LastOperation.State.SUCCEEDED);
    }

    public ServiceInstanceResponse unshareServiceInstance(@Nullable String serviceInstanceName, @Nullable Set<String> unshareFromRegions) {
        Set<CloudFoundrySpace> unshareFromSpaces = this.vetUnshareServiceArgumentsAndGetSharingSpaces(serviceInstanceName, unshareFromRegions);
        unshareFromSpaces.forEach(space -> Optional.ofNullable(this.spaces.getServiceInstanceByNameAndSpace(serviceInstanceName, (CloudFoundrySpace)space)).map(si -> CloudFoundryClientUtils.safelyCall(() -> this.api.unshareServiceInstanceFromSpaceId(si.getId(), space.getId()))));
        return new ServiceInstanceResponse().setServiceInstanceName(serviceInstanceName).setType(LastOperation.Type.UNSHARE).setState(LastOperation.State.SUCCEEDED);
    }

    @Nullable
    public CloudFoundryServiceInstance getServiceInstance(String region, String serviceInstanceName) {
        CloudFoundrySpace space = this.spaces.findSpaceByRegion(region).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cannot find region '" + region + "'"}));
        Supplier<CloudFoundryServiceInstance> si = () -> Optional.ofNullable(this.getOsbServiceInstance(space, serviceInstanceName)).orElse(null);
        Supplier<CloudFoundryServiceInstance> up = () -> Optional.ofNullable(this.getUserProvidedServiceInstance(space, serviceInstanceName)).orElse(null);
        return Optional.ofNullable(si.get()).orElseGet(up);
    }

    @Nullable
    @VisibleForTesting
    CloudFoundryServiceInstance getOsbServiceInstance(CloudFoundrySpace space, @Nullable String serviceInstanceName) {
        return Optional.ofNullable(this.getServiceInstance(this.api::all, space, serviceInstanceName)).map(r -> CloudFoundryServiceInstance.builder().serviceInstanceName(((ServiceInstance)r.getEntity()).getName()).planId(((ServiceInstance)r.getEntity()).getServicePlanGuid()).type(((ServiceInstance)r.getEntity()).getType().toString()).status(((ServiceInstance)r.getEntity()).getLastOperation().getState().toString()).lastOperationDescription(((ServiceInstance)r.getEntity()).getLastOperation().getDescription()).id(r.getMetadata().getGuid()).build()).orElse(null);
    }

    @Nullable
    @VisibleForTesting
    CloudFoundryServiceInstance getUserProvidedServiceInstance(CloudFoundrySpace space, @Nullable String serviceInstanceName) {
        return Optional.ofNullable(this.getServiceInstance(this.api::allUserProvided, space, serviceInstanceName)).map(r -> CloudFoundryServiceInstance.builder().serviceInstanceName(((UserProvidedServiceInstance)r.getEntity()).getName()).type(ServiceInstance.Type.USER_PROVIDED_SERVICE_INSTANCE.toString()).status(LastOperation.State.SUCCEEDED.toString()).id(r.getMetadata().getGuid()).build()).orElse(null);
    }

    @Nullable
    private <T> Resource<T> getServiceInstance(BiFunction<Integer, List<String>, Call<Page<T>>> func, CloudFoundrySpace space, @Nullable String serviceInstanceName) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)serviceInstanceName)) {
            throw new CloudFoundryApiException(new String[]{"Please specify a name for the service being sought"});
        }
        List serviceInstances = CloudFoundryClientUtils.collectPageResources("service instances by space and name", pg -> (Call)func.apply((Integer)pg, ServiceInstances.getServiceQueryParams(Collections.singletonList(serviceInstanceName), space)));
        if (serviceInstances.isEmpty()) {
            return null;
        }
        if (serviceInstances.size() > 1) {
            throw new CloudFoundryApiException(new String[]{serviceInstances.size() + " service instances found with name '" + serviceInstanceName + "' in space '" + space.getName() + "', but expected only 1"});
        }
        return serviceInstances.get(0);
    }

    public ServiceInstanceResponse destroyServiceInstance(CloudFoundrySpace space, String serviceInstanceName) {
        CloudFoundryServiceInstance managedServiceInstance = this.getOsbServiceInstance(space, serviceInstanceName);
        if (managedServiceInstance != null) {
            String serviceInstanceId = managedServiceInstance.getId();
            this.destroyServiceInstance((Integer pg) -> this.api.getBindingsForServiceInstance(serviceInstanceId, (Integer)pg, null), () -> this.api.destroyServiceInstance(serviceInstanceId));
            return new ServiceInstanceResponse().setServiceInstanceName(serviceInstanceName).setType(LastOperation.Type.DELETE).setState(LastOperation.State.IN_PROGRESS);
        }
        CloudFoundryServiceInstance userProvidedServiceInstance = this.getUserProvidedServiceInstance(space, serviceInstanceName);
        if (userProvidedServiceInstance != null) {
            String serviceInstanceId = userProvidedServiceInstance.getId();
            this.destroyServiceInstance((Integer pg) -> this.api.getBindingsForUserProvidedServiceInstance(serviceInstanceId, (Integer)pg, null), () -> this.api.destroyUserProvidedServiceInstance(serviceInstanceId));
            return new ServiceInstanceResponse().setServiceInstanceName(serviceInstanceName).setType(LastOperation.Type.DELETE).setState(LastOperation.State.IN_PROGRESS);
        }
        return new ServiceInstanceResponse().setServiceInstanceName(serviceInstanceName).setType(LastOperation.Type.DELETE).setState(LastOperation.State.NOT_FOUND);
    }

    private void destroyServiceInstance(Function<Integer, Call<Page<ServiceBinding>>> fetchPage, Supplier<Call<ResponseBody>> delete) {
        List serviceBindings = CloudFoundryClientUtils.collectPageResources("service bindings", fetchPage);
        if (!serviceBindings.isEmpty()) {
            throw new CloudFoundryApiException(new String[]{"Unable to destroy service instance while " + serviceBindings.size() + " service binding(s) exist"});
        }
        CloudFoundryClientUtils.safelyCall(delete);
    }

    public ServiceInstanceResponse createServiceInstance(String newServiceInstanceName, String serviceName, String servicePlanName, Set<String> tags, Map<String, Object> parameters, boolean updatable, CloudFoundrySpace space) {
        List<CloudFoundryServicePlan> cloudFoundryServicePlans = this.findAllServicePlansByServiceName(serviceName);
        if (cloudFoundryServicePlans.isEmpty()) {
            throw new ResourceNotFoundException("No plans available for service name '" + serviceName + "'");
        }
        String servicePlanId = cloudFoundryServicePlans.stream().filter(plan -> plan.getName().equals(servicePlanName)).findAny().orElseThrow(() -> new ResourceNotFoundException("Service '" + serviceName + "' does not have a matching plan '" + servicePlanName + "'")).getId();
        CreateServiceInstance command = new CreateServiceInstance();
        command.setName(newServiceInstanceName);
        command.setSpaceGuid(space.getId());
        command.setServicePlanGuid(servicePlanId);
        command.setTags(tags);
        command.setParameters(parameters);
        ServiceInstanceResponse response = this.createServiceInstance(command, this.api::createServiceInstance, this.api::updateServiceInstance, this.api::all, c -> this.getOsbServiceInstance(space, c.getName()), (createServiceInstance, r) -> {
            if (!r.getPlanId().equals(createServiceInstance.getServicePlanGuid())) {
                throw new CloudFoundryApiException(new String[]{"A service with name '" + createServiceInstance.getName() + "' exists but has a different plan"});
            }
        }, updatable, space);
        response.setState(updatable ? LastOperation.State.IN_PROGRESS : LastOperation.State.SUCCEEDED);
        return response;
    }

    public ServiceInstanceResponse createUserProvidedServiceInstance(String newUserProvidedServiceInstanceName, String syslogDrainUrl, Set<String> tags, Map<String, Object> credentials, String routeServiceUrl, boolean updatable, CloudFoundrySpace space) {
        CreateUserProvidedServiceInstance command = new CreateUserProvidedServiceInstance();
        command.setName(newUserProvidedServiceInstanceName);
        command.setSyslogDrainUrl(syslogDrainUrl);
        command.setTags(tags);
        command.setCredentials(credentials);
        command.setRouteServiceUrl(routeServiceUrl);
        command.setSpaceGuid(space.getId());
        ServiceInstanceResponse response = this.createServiceInstance(command, this.api::createUserProvidedServiceInstance, this.api::updateUserProvidedServiceInstance, this.api::allUserProvided, c -> this.getUserProvidedServiceInstance(space, c.getName()), (c, r) -> {}, updatable, space);
        response.setState(LastOperation.State.SUCCEEDED);
        return response;
    }

    private <T extends AbstractCreateServiceInstance, S extends AbstractServiceInstance> ServiceInstanceResponse createServiceInstance(T command, Function<T, Call<Resource<S>>> create, BiFunction<String, T, Call<Resource<S>>> update, BiFunction<Integer, List<String>, Call<Page<S>>> getAllServices, Function<T, CloudFoundryServiceInstance> getServiceInstance, BiConsumer<T, CloudFoundryServiceInstance> updateValidation, boolean updatable, CloudFoundrySpace space) {
        List<String> serviceInstanceQuery = ServiceInstances.getServiceQueryParams(Collections.singletonList(command.getName()), space);
        ArrayList serviceInstances = new ArrayList();
        serviceInstances.addAll(CloudFoundryClientUtils.collectPageResources("service instances", pg -> (Call)getAllServices.apply((Integer)pg, serviceInstanceQuery)));
        LastOperation.Type operationType = LastOperation.Type.CREATE;
        if (serviceInstances.size() == 0) {
            CloudFoundryClientUtils.safelyCall(() -> (Call)create.apply(command)).map(res -> res.getMetadata().getGuid()).orElseThrow(() -> new CloudFoundryApiException(new String[]{"service instance '" + command.getName() + "' could not be created"}));
        } else if (updatable) {
            operationType = LastOperation.Type.UPDATE;
            serviceInstances.stream().findFirst().map(r -> r.getMetadata().getGuid()).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Service instance '" + command.getName() + "' not found"}));
            CloudFoundryServiceInstance serviceInstance = getServiceInstance.apply(command);
            if (serviceInstance == null) {
                throw new CloudFoundryApiException(new String[]{"No service instances with name '" + command.getName() + "' found in space " + space.getName()});
            }
            updateValidation.accept(command, serviceInstance);
            CloudFoundryClientUtils.safelyCall(() -> (Call)update.apply(serviceInstance.getId(), command));
        }
        return new ServiceInstanceResponse().setServiceInstanceName(command.getName()).setType(operationType);
    }

    private static List<String> getServiceQueryParams(List<String> serviceNames, CloudFoundrySpace space) {
        return Arrays.asList(serviceNames.size() == 1 ? "name:" + serviceNames.get(0) : "name IN " + String.join((CharSequence)",", serviceNames), "organization_guid:" + space.getOrganization().getId(), "space_guid:" + space.getId());
    }

    @Generated
    public ServiceInstances(ServiceInstanceService api, ConfigService configApi, Spaces spaces) {
        this.api = api;
        this.configApi = configApi;
        this.spaces = spaces;
    }
}

