/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.AbstractServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessStats;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.CreateCloudFoundryServiceBindingDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.CloudFoundryOperationUtils;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class CreateCloudFoundryServiceBindingAtomicOperation
implements AtomicOperation<Void> {
    private static final String PHASE = "CREATE_SERVICE_BINDINGS";
    private final OperationPoller operationPoller;
    private final CreateCloudFoundryServiceBindingDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List<Void> priorOutputs) {
        List<String> serviceInstanceNames = this.description.getServiceBindingRequests().stream().map(s -> s.getServiceInstanceName()).collect(Collectors.toList());
        CreateCloudFoundryServiceBindingAtomicOperation.getTask().updateStatus(PHASE, "Creating Cloud Foundry service bindings between application '" + this.description.getServerGroupName() + "' and services: " + serviceInstanceNames);
        HashMap serviceInstanceGuids = new HashMap();
        this.description.getClient().getServiceInstances().findAllServicesBySpaceAndNames(this.description.getSpace(), serviceInstanceNames).forEach(s -> serviceInstanceGuids.put(((AbstractServiceInstance)s.getEntity()).getName(), s.getMetadata().getGuid()));
        List<CreateServiceBinding> bindings = this.description.getServiceBindingRequests().stream().map(s -> {
            String serviceGuid = (String)serviceInstanceGuids.get(s.getServiceInstanceName());
            if (serviceGuid == null || serviceGuid.isEmpty()) {
                throw new CloudFoundryApiException(new String[]{"Unable to find service with the name: '" + s.getServiceInstanceName() + "'"});
            }
            if (s.isUpdatable()) {
                this.removeBindings(serviceGuid, this.description.getServerGroupId());
            }
            return new CreateServiceBinding(serviceGuid, this.description.getServerGroupId(), s.getServiceInstanceName(), s.getParameters());
        }).collect(Collectors.toList());
        bindings.forEach(b -> this.description.getClient().getServiceInstances().createServiceBinding((CreateServiceBinding)b));
        if (this.description.isRestageRequired()) {
            CreateCloudFoundryServiceBindingAtomicOperation.getTask().updateStatus(PHASE, "Restaging application '" + this.description.getServerGroupName());
            this.description.getClient().getApplications().restageApplication(this.description.getServerGroupId());
        } else {
            CreateCloudFoundryServiceBindingAtomicOperation.getTask().updateStatus(PHASE, "Restarting application '" + this.description.getServerGroupName());
            this.description.getClient().getApplications().stopApplication(this.description.getServerGroupId());
            this.operationPoller.waitForOperation(() -> this.description.getClient().getApplications().getAppState(this.description.getServerGroupId()), inProgressState -> inProgressState == ProcessStats.State.DOWN || inProgressState == ProcessStats.State.CRASHED, null, CreateCloudFoundryServiceBindingAtomicOperation.getTask(), this.description.getServerGroupName(), PHASE);
            this.description.getClient().getApplications().startApplication(this.description.getServerGroupId());
        }
        ProcessStats.State state = (ProcessStats.State)((Object)this.operationPoller.waitForOperation(() -> this.description.getClient().getApplications().getAppState(this.description.getServerGroupId()), inProgressState -> inProgressState == ProcessStats.State.RUNNING || inProgressState == ProcessStats.State.CRASHED, null, CreateCloudFoundryServiceBindingAtomicOperation.getTask(), this.description.getServerGroupName(), PHASE));
        if (state != ProcessStats.State.RUNNING) {
            CreateCloudFoundryServiceBindingAtomicOperation.getTask().updateStatus(PHASE, "Failed to create Cloud Foundry service bindings between application '" + this.description.getServerGroupName() + "' and services: " + serviceInstanceNames);
            throw new CloudFoundryApiException(new String[]{"Failed to start '" + this.description.getServerGroupName() + "' which instead " + CloudFoundryOperationUtils.describeProcessState(state)});
        }
        CreateCloudFoundryServiceBindingAtomicOperation.getTask().updateStatus(PHASE, "Created Cloud Foundry service bindings between application '" + this.description.getServerGroupName() + "' and services: " + serviceInstanceNames);
        return null;
    }

    private void removeBindings(String serviceGuid, String appGuid) {
        this.description.getClient().getApplications().getServiceBindingsByApp(appGuid).stream().filter(s -> serviceGuid.equalsIgnoreCase(((ServiceBinding)s.getEntity()).getServiceInstanceGuid())).findAny().ifPresent(s -> this.description.getClient().getServiceInstances().deleteServiceBinding(s.getMetadata().getGuid()));
    }

    @Generated
    public CreateCloudFoundryServiceBindingAtomicOperation(OperationPoller operationPoller, CreateCloudFoundryServiceBindingDescription description) {
        this.operationPoller = operationPoller;
        this.description = description;
    }
}

