/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ServiceInstanceResponse;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.UnshareCloudFoundryServiceDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class UnshareCloudFoundryServiceAtomicOperation
implements AtomicOperation<ServiceInstanceResponse> {
    private static final String PHASE = "UNSHARE_SERVICE";
    private final UnshareCloudFoundryServiceDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public ServiceInstanceResponse operate(List priorOutputs) {
        Task task = UnshareCloudFoundryServiceAtomicOperation.getTask();
        String serviceInstanceName = this.description.getServiceInstanceName();
        Set<String> unshareFromRegions = this.description.getUnshareFromRegions();
        task.updateStatus(PHASE, "Unsharing service instance '" + serviceInstanceName + "' from '" + String.join((CharSequence)", ", unshareFromRegions.stream().map(s -> "'" + s + "'").collect(Collectors.toSet())));
        ServiceInstanceResponse results = this.description.getClient().getServiceInstances().unshareServiceInstance(serviceInstanceName, unshareFromRegions);
        task.updateStatus(PHASE, "Finished unsharing service instance '" + serviceInstanceName + "'");
        return results;
    }

    @Generated
    public UnshareCloudFoundryServiceAtomicOperation(UnshareCloudFoundryServiceDescription description) {
        this.description = description;
    }
}

