/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.model;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryModel;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.Views;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Instance;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(builder=CloudFoundryInstanceBuilder.class)
public final class CloudFoundryInstance
extends CloudFoundryModel
implements Instance {
    @JsonView(value={Views.Cache.class})
    private final String appGuid;
    @JsonView(value={Views.Cache.class})
    private final String key;
    @JsonView(value={Views.Cache.class})
    private final HealthState healthState;
    @JsonView(value={Views.Cache.class})
    private final String details;
    @JsonView(value={Views.Cache.class})
    private final Long launchTime;
    @JsonView(value={Views.Cache.class})
    private final String zone;

    public List<Map<String, Object>> getHealth() {
        HashMap<String, String> health = new HashMap<String, String>();
        health.put("healthClass", "platform");
        health.put("type", "TargetGroup");
        health.put("state", (this.healthState == null ? HealthState.Unknown : this.healthState).toString());
        return Collections.singletonList(health);
    }

    @Deprecated
    public String getProviderType() {
        return CloudFoundryCloudProvider.ID;
    }

    public String getId() {
        return this.appGuid + "-" + this.key;
    }

    public String getName() {
        return this.appGuid + "-" + this.key;
    }

    @Generated
    CloudFoundryInstance(String appGuid, String key, HealthState healthState, String details, Long launchTime, String zone) {
        this.appGuid = appGuid;
        this.key = key;
        this.healthState = healthState;
        this.details = details;
        this.launchTime = launchTime;
        this.zone = zone;
    }

    @Generated
    public static CloudFoundryInstanceBuilder builder() {
        return new CloudFoundryInstanceBuilder();
    }

    @Generated
    public String getAppGuid() {
        return this.appGuid;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public HealthState getHealthState() {
        return this.healthState;
    }

    @Generated
    public String getDetails() {
        return this.details;
    }

    @Generated
    public Long getLaunchTime() {
        return this.launchTime;
    }

    @Generated
    public String getZone() {
        return this.zone;
    }

    @Generated
    public String toString() {
        return "CloudFoundryInstance(appGuid=" + this.getAppGuid() + ", key=" + this.getKey() + ", healthState=" + this.getHealthState() + ", details=" + this.getDetails() + ", launchTime=" + this.getLaunchTime() + ", zone=" + this.getZone() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudFoundryInstance)) {
            return false;
        }
        CloudFoundryInstance other = (CloudFoundryInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appGuid = this.getAppGuid();
        String other$appGuid = other.getAppGuid();
        if (this$appGuid == null ? other$appGuid != null : !this$appGuid.equals(other$appGuid)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudFoundryInstance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appGuid = this.getAppGuid();
        result = result * 59 + ($appGuid == null ? 43 : $appGuid.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public static class CloudFoundryInstanceBuilder {
        @Generated
        private String appGuid;
        @Generated
        private String key;
        @Generated
        private HealthState healthState;
        @Generated
        private String details;
        @Generated
        private Long launchTime;
        @Generated
        private String zone;

        @Generated
        CloudFoundryInstanceBuilder() {
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryInstanceBuilder appGuid(String appGuid) {
            this.appGuid = appGuid;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryInstanceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryInstanceBuilder healthState(HealthState healthState) {
            this.healthState = healthState;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryInstanceBuilder details(String details) {
            this.details = details;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryInstanceBuilder launchTime(Long launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryInstanceBuilder zone(String zone) {
            this.zone = zone;
            return this;
        }

        @Generated
        public CloudFoundryInstance build() {
            return new CloudFoundryInstance(this.appGuid, this.key, this.healthState, this.details, this.launchTime, this.zone);
        }

        @Generated
        public String toString() {
            return "CloudFoundryInstance.CloudFoundryInstanceBuilder(appGuid=" + this.appGuid + ", key=" + this.key + ", healthState=" + this.healthState + ", details=" + this.details + ", launchTime=" + this.launchTime + ", zone=" + this.zone + ")";
        }
    }
}

